#include "GDDRAW.h"

#define _CLASS_NAME "GDDRAW_CLASS"

//////////////////////////////
// GDDRAW
//////////////////////////////
GDDRAW::GDDRAW()
{
	hWnd = NULL;
	
	PrimarySurface = NULL;
	BackSurface = NULL;
	DDraw = NULL;

	m_ActiveFlag = TRUE;
};

//////////////////////////////
// ~GDDRAW
//////////////////////////////
GDDRAW::~GDDRAW()
{
	End();
};

//////////////////////////////
// GDDProc
//////////////////////////////
void GDDRAW::GDDProc( UINT Msg, WPARAM wParam, LPARAM lParam)
{
	switch( Msg )
	{
    case WM_ACTIVATEAPP :
         m_ActiveFlag = wParam;
         return;
	}
};

//////////////////////////////
// Init
//////////////////////////////
BOOL GDDRAW::Init( HINSTANCE hInstance, char *caption, WNDPROC lpWinProc, long Frame, int w, int h, HICON AppIcon )
{
	/////////////////////////////////////////////////////
	// QueryPerFormanceCounter()  ϴ ˾ƺ
	//  Ű  غ ۾ Ѵ.
	/////////////////////////////////////////////////////

	LARGE_INTEGER time ;
	if( QueryPerformanceCounter( &time ) == FALSE )
	{
		MessageBox( NULL, "ýۿ QueryPerformanceCounter   ʽϴ.", "ERROR", MB_ICONERROR );
		return FALSE;
	}
	m_Tick = 250000L / Frame ;

	///////////////////////////////////
	// 츦 ʱȭ Ѵ.
	///////////////////////////////////

    WNDCLASS    wc = {
        CS_HREDRAW|CS_VREDRAW, lpWinProc, 0, 0, hInstance,
        AppIcon, NULL, NULL, NULL, _CLASS_NAME
    } ;

    if( RegisterClass(&wc) == 0 )
	{
		MessageBox( NULL, "  Դϴ.", "ERROR", MB_ICONERROR );
		return FALSE;
	}

    hWnd = CreateWindowEx( WS_EX_TOPMOST,_CLASS_NAME, caption, WS_POPUP, 0, 0,
        GetSystemMetrics(SM_CXSCREEN), GetSystemMetrics(SM_CYSCREEN),
        NULL, NULL, hInstance, NULL );

	if( hWnd == NULL )
	{
		MessageBox( NULL, "  Դϴ.", "ERROR", MB_ICONERROR );
		return FALSE;
	}

    ShowWindow(hWnd,SW_SHOW);
    UpdateWindow(hWnd);

	/////////////////////////////////////
	// ̷Ʈ  ʱȭ Ѵ.
	//////////////////////////////////////

	HRESULT				ddrval;

    ddrval = DirectDrawCreate(NULL, &DDraw, NULL);
	if(ddrval != DD_OK)  
	{
		MessageBox( hWnd, "̷Ʈ ʱȭ ߽ϴ.", "ERROR", MB_ICONERROR );
		End();
		return FALSE;
	}

    ddrval = DDraw->SetCooperativeLevel(hWnd, DDSCL_ALLOWREBOOT|DDSCL_EXCLUSIVE|DDSCL_FULLSCREEN);
    if(ddrval != DD_OK)
	{
		MessageBox( hWnd, "̷Ʈ ʱȭ ߽ϴ.", "ERROR", MB_ICONERROR );
		End();
		return FALSE;
	}

	ddrval = DDraw->SetDisplayMode( w, h, 8);
	if(ddrval != DD_OK)
	{
		MessageBox( hWnd, "ȭ  ߽ϴ.", "ERROR", MB_ICONERROR );
		End();
		return FALSE;
	}

    DDSURFACEDESC   ddsd;

    memset( &ddsd, 0, sizeof( ddsd ));
    ddsd.dwSize = sizeof(ddsd);
    ddsd.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
    ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE | DDSCAPS_FLIP | DDSCAPS_COMPLEX | DDSCAPS_3DDEVICE;
    ddsd.dwBackBufferCount = 1;

    ddrval = DDraw->CreateSurface(&ddsd,&PrimarySurface,NULL);
	if(ddrval != DD_OK)
	{
		MessageBox( hWnd, "  ߽ϴ.", "ERROR", MB_ICONERROR );
		End();
		return FALSE;
	}


    DDSCAPS         ddscaps;
    ddscaps.dwCaps = DDSCAPS_BACKBUFFER | DDSCAPS_3DDEVICE;
    ddrval = PrimarySurface->GetAttachedSurface( &ddscaps, &BackSurface);
	if(ddrval != DD_OK)
	{
		MessageBox( hWnd, "ĸ  ߽ϴ.", "ERROR", MB_ICONERROR );
		End();
		return FALSE;
	}

	SetColorKey( 0, 0 );

	ShowCursor(FALSE);

	return TRUE;
};


////////////////////
// End
////////////////////
void GDDRAW::End()
{
    if( PrimarySurface != NULL ) PrimarySurface->Release();
    if( DDraw != NULL ) DDraw->Release();
	PrimarySurface = NULL;
	BackSurface = NULL;
	DDraw = NULL;
};

////////////////////
// BeginPaint
////////////////////
LPBYTE GDDRAW::BeginPaint()
{
	while( PrimarySurface->GetFlipStatus(DDGFS_ISFLIPDONE) == DDERR_WASSTILLDRAWING );

    DDSURFACEDESC ddsd;
    memset(&ddsd, 0, sizeof(ddsd));
	ddsd.dwSize = sizeof(ddsd);
	
	HRESULT	ddrval;

	ddrval = BackSurface->Lock( NULL, &ddsd, DDLOCK_SURFACEMEMORYPTR, NULL);

	if( ddrval == DDERR_SURFACELOST )
	{
		if( PrimarySurface->Restore() != DD_OK ) return NULL;
		ddrval = BackSurface->Lock( NULL, &ddsd, DDLOCK_SURFACEMEMORYPTR, NULL);
	};
	
	if( ddrval != DD_OK ) return NULL;

	return (LPBYTE)ddsd.lpSurface;
};

////////////////////
// EndPaint
////////////////////
void   GDDRAW::EndPaint()
{
    BackSurface->Unlock(NULL);
	Flip();
};	

////////////////////
// Flip
////////////////////
void GDDRAW::Flip()
{
	HRESULT ddrval;
    
	while( ( ddrval = PrimarySurface->Flip(NULL, 0)) == DDERR_WASSTILLDRAWING );
	if( ddrval != DD_OK ) return;
};

////////////////////
// GetCurTime
////////////////////
long GDDRAW::GetCurTime()
{
	LARGE_INTEGER time ;
	
	QueryPerformanceCounter( &time );

	return (long)((DWORD)time.LowPart>>2);
};

////////////////////
// SetTimer
////////////////////
void GDDRAW::SetTimer()
{
	m_TIME = 0;
	m_newTime = 0;
	m_oldTime = GetCurTime();
};

////////////////////
// FrameSkip
////////////////////
BOOL GDDRAW::FrameSkip()
{
	long dt ;
	
	m_newTime = GetCurTime();
	
	dt = m_newTime - m_oldTime;
	if( dt < 0 ) dt += 0x40000000;
	
	m_TIME += dt;

    while(m_TIME<0)
	{
		m_newTime = GetCurTime();
	
		dt = m_newTime - m_oldTime;
		if( dt < 0 ) dt += 0x40000000;

		m_TIME += dt;

		m_oldTime = m_newTime ;
	};
    
	m_TIME -= m_Tick;
   
	m_oldTime = m_newTime ;

	return (m_TIME<0)? TRUE: FALSE;
};

////////////////////
// GetDC
////////////////////
HRESULT GDDRAW::GetDC( HDC* hDC )
{
	while( PrimarySurface->GetFlipStatus(DDGFS_ISFLIPDONE) == DDERR_WASSTILLDRAWING );
	
	HRESULT	ddrval;

	ddrval = BackSurface->GetDC(hDC);            
	if( ddrval == DDERR_SURFACELOST )
	{
		ddrval = PrimarySurface->Restore();
		if( ddrval != DD_OK ) return ddrval;
		ddrval = BackSurface->GetDC(hDC);            		
	};
	return ddrval;
};

////////////////////
// ReleaseDC
////////////////////
void GDDRAW::ReleaseDC( HDC hDC )
{
	BackSurface->ReleaseDC(hDC);
};

//////////////////////////////
// SetColorKey
//////////////////////////////
HRESULT GDDRAW::SetColorKey( DWORD low, DWORD high, LPDIRECTDRAWSURFACE lpSurface )
{
	DDCOLORKEY ddck;
	ddck.dwColorSpaceLowValue = low;
	ddck.dwColorSpaceHighValue = high;

	if( lpSurface == NULL ) return BackSurface->SetColorKey( DDCKEY_SRCBLT, &ddck );
	return lpSurface->SetColorKey( DDCKEY_SRCBLT, &ddck );
};

////////////////////////
// CreatePalette
////////////////////////
LPDIRECTDRAWPALETTE GDDRAW::CreatePalette( LPRGBQUAD rq )
{
	return CreatePalette( (PALETTEENTRY*)rq );
};

LPDIRECTDRAWPALETTE GDDRAW::CreatePalette( PALETTEENTRY* pe )
{
	LPDIRECTDRAWPALETTE DDrawPal;
	
	if( DDraw->CreatePalette(DDPCAPS_8BIT, pe, &DDrawPal, NULL) != DD_OK ) return NULL;    	

	return DDrawPal;
};

LPDIRECTDRAWPALETTE GDDRAW::CreatePalette( LPBYTE palette )
{
    PALETTEENTRY        pe[256];

    for(int i = 0; i < 256; i++, palette+=3) {
        pe[i].peRed = palette[0]<<2;
        pe[i].peGreen = palette[1]<<2;
        pe[i].peBlue  = palette[2]<<2;
        pe[i].peFlags = 0;
    }

    return CreatePalette( pe );	
};

//////////////////////////////
// SetPalette 
//////////////////////////////
HRESULT GDDRAW::SetPalette( LPDIRECTDRAWPALETTE palette )
{
    return PrimarySurface->SetPalette( palette );
};

HRESULT GDDRAW::SetPalette( LPRGBQUAD rq )
{
    return SetPalette( CreatePalette( rq ) );
};

HRESULT GDDRAW::SetPalette( PALETTEENTRY* pe )
{
    return SetPalette( CreatePalette( pe ) );
};

HRESULT GDDRAW::SetPalette( LPBYTE palette )
{
    return SetPalette( CreatePalette( palette ) );
};

