#include "GObject.h"

//////////////////////////
// GObject
//////////////////////////
GObject::GObject()
{
	m_ObjectID = 0 ;
};

GObject::~GObject()
{
};

//////////////////////////
// GObjectManager
//////////////////////////
GObjectManager::GObjectManager()
{
	m_MaxObject = 0 ;
	m_ObjectCount = 0 ;
	m_ObjectArray = NULL;
};

//////////////////////////
// ~GObjectManager
//////////////////////////
GObjectManager::~GObjectManager()
{
	if( m_ObjectArray != NULL ) delete m_ObjectArray;
	m_MaxObject = 0 ;
	m_ObjectCount = 0 ;
	m_ObjectArray = NULL;
};

//////////////////////////
// Init
//////////////////////////
BOOL GObjectManager::Init( DWORD MaxObject )
{
	if( m_ObjectArray != NULL ) delete m_ObjectArray;
	m_MaxObject = 0 ;
	m_ObjectCount = 0 ;

	m_ObjectArray = new LPGObject[ MaxObject ];
	if( m_ObjectArray == NULL ) return FALSE;
	
	for( DWORD i=0; i<MaxObject ; i++)	m_ObjectArray[i] = NULL ;

	m_MaxObject = MaxObject ;
	return TRUE;
};

//////////////////////////
// AddObject
//////////////////////////
BOOL GObjectManager::AddObject( LPGObject obj )
{
	if( m_ObjectCount >= m_MaxObject ) return FALSE;

	DWORD i;
	for( i=0; m_ObjectArray[i] != NULL && i<m_MaxObject ; i++ );
	if( i >= m_MaxObject ) return FALSE;
	
	obj->m_ObjectID = i;
	m_ObjectArray[i] = obj;

	m_ObjectCount++;

	return TRUE;
};

//////////////////////////
// DeleteObject
//////////////////////////
BOOL GObjectManager::DeleteObject( DWORD ObjectID )
{
	if( m_MaxObject <= ObjectID || m_ObjectCount == 0 ) return FALSE;
	if( m_ObjectArray[ObjectID] == NULL ) return FALSE;
	
	m_ObjectArray[ObjectID] = NULL ;
	m_ObjectCount--;

	return TRUE;
};

//////////////////////////
// GetObject
//////////////////////////
LPGObject GObjectManager::GetObject( DWORD ObjectID )
{
	if( m_MaxObject <= ObjectID || m_ObjectCount == 0 ) return NULL;
	
	return m_ObjectArray[ObjectID] ;	
};

//////////////////////////
// SendMessage
//////////////////////////
void GObjectManager::SendMessage( DWORD ObjectID, DWORD Param1, DWORD Param2, DWORD Param3 )
{
	if( m_MaxObject <= ObjectID || m_ObjectCount <= 0 ) return ;
	
	if( m_ObjectArray[ObjectID] == NULL ) return;	

	m_ObjectArray[ObjectID]->Message( Param1, Param2, Param3 );	
};	

//////////////////////////
// SendMessageAll
//////////////////////////
void GObjectManager::SendMessageAll( DWORD Param1, DWORD Param2, DWORD Param3 )
{
	if( m_MaxObject <= 0 || m_ObjectCount <= 0 ) return ;

	for( DWORD i=0; i<m_MaxObject ; i++ )
	{
		if( m_ObjectArray[i] != NULL ) 	
			m_ObjectArray[i]->Message( Param1, Param2, Param3 );	
	};
};	

