#include    <string.h>
#include    <stdio.h>
#include    "lsp.h"

LSP::LSP()
{
	SCREEN_XSIZE = 0 ;
	SCREEN_YSIZE = 0 ;

	linenode = NULL ;
	prenode = NULL ;
	alloced = 0 ;
};

LSP::~LSP()
{
	End();
};

BOOL LSP::Init( int xs, int ys, char  BackColor )
{
	End();

	SCREEN_XSIZE = xs;
	SCREEN_YSIZE = ys;

	DefBackColor = BackColor;

    prenode = new Node* [64];
	if( prenode == NULL ) return FALSE;

    for(int i=0; i<64; i++)
        prenode[i] = NULL;

    linenode = new Node* [SCREEN_YSIZE];
	if( linenode == NULL ) return FALSE;

    alloced = 0;

    for(i=0; i<SCREEN_YSIZE; i++) {
        linenode[i] = AllocNode();
        linenode[i]->length = SCREEN_XSIZE;
		linenode[i]->address = NULL;
    }
	
	return TRUE;
}

void LSP::End()
{
	if( prenode == NULL ) return;
    for(int i=0; i<64 && prenode[i]!=NULL; i++) delete  prenode[i];
    delete prenode;
}

Node* LSP::AllocNode()
{
    if((alloced&1023)==0)
        if (prenode[alloced>>10]==NULL)
            prenode[alloced>>10] = new Node [1024];

    Node   *result = prenode[alloced>>10];
    return  result + ((alloced++)&1023);
}

void LSP::ResetLsp()
{
    alloced = 0;

    for(int i=0; i<SCREEN_YSIZE; i++) {
        linenode[i] = AllocNode();
        linenode[i]->length = SCREEN_XSIZE;
		linenode[i]->address = NULL;
    }
}

void LSP::ResetLsp(char *buffer, int offset, int BUF_SIZE, int BUF_XSIZE )
{
    alloced = 0;
    offset%=BUF_SIZE;

    for(int i=0; i<SCREEN_YSIZE; i++, offset+=BUF_XSIZE) {
        Node   *empty = linenode[i] = AllocNode();
        if(offset >= BUF_SIZE) offset-=BUF_SIZE;
        if(offset <= BUF_SIZE-SCREEN_XSIZE) {
            empty->length = SCREEN_XSIZE;
            empty->address = buffer + offset;
        } else {
            empty->length = BUF_SIZE - offset;
            empty->address = buffer+offset;
            Node    *next = AllocNode();
            empty->next= next;
            next->length = SCREEN_XSIZE - ( BUF_SIZE - offset) ;
            next->address = buffer;
        }
    }
}

void LSP::AddLsp(int x, int y, int short length, char *address)
{
    Node   *search = linenode[y];
    Node   *insert = AllocNode();
    int     loop=0;

    if (x<=0) {
        address -= x ;
        length += x ;
        x=0;
        linenode[y]=insert;
    }

    if (x+length >= SCREEN_XSIZE) {
        length = SCREEN_XSIZE - x ;
    }

    int short x2=x+length;

    while(1) {
        loop += search->length ;
        if ( loop >= x ) break ;
        search = search->next ;
    }

    insert->length = length;
    insert->address = address;

    int short reserve=search->length-(loop-x);

    if(x2>=SCREEN_XSIZE) {
        search->length = reserve;
        search->next = insert;
        return;
    }

    Node    *save = search;

    while(loop<=x2) {
        search = search->next ;
        loop += search->length ;
    }

    Node    *insert2=AllocNode();
    insert2->length = loop - x2;
    if( search->address == NULL )
		insert2->address = NULL;
	else
		insert2->address = search->address + search->length - insert2->length;
    insert2->next = search -> next;

    save->length = reserve;
    save->next = insert;
    insert->next = insert2;

}

void LSP::PutImage(int x, int y, char *address, int xs, int ys)
{
    int     loop, y2;

    if (x+xs<0 || x>=SCREEN_XSIZE)
        return;
    if (y<0) {
        address += -y*xs;
        ys+=y;
        y = 0;
    }
    if (y+ys>=SCREEN_YSIZE)
        y2=SCREEN_YSIZE;
    else
        y2 = y+ys;

    for (loop=y; loop<y2; loop++, address+=xs)
        AddLsp(x, loop, xs, address);
}

void LSP::PutSprite(int x, int y, char *address)
{
    int     length, loop;
    int     putbyte;
    int     tmp2;
    char    index;

    if (x>=SCREEN_XSIZE)
        return;
    if (y>=SCREEN_YSIZE)
        return;
    length=*(int short*)address + y;
    address+=2;
    if (length>SCREEN_YSIZE)
        length = SCREEN_YSIZE;
    for (loop=y; loop<length; loop++) {
        index = *address++;
        if (loop<0) {
            while (index--) {
                putbyte =*(int short*)(address+2);
                address+=4+putbyte;
            }
        } else {
            tmp2 = x;
            putbyte = 0;
            while (index--) {
                tmp2+=*(int short*)address + putbyte;
                putbyte =*(int short*)(address+2);
                address+=4;
                if (tmp2+putbyte>=0 && tmp2<SCREEN_XSIZE && putbyte > 0)
                    AddLsp(tmp2, loop, putbyte, address);
                address+=putbyte;
            }
        }
    }
}

void LSP::PutScreen( LPBYTE buffer )
{
    for (int y=0; y<SCREEN_YSIZE; y++, buffer+=SCREEN_XSIZE) 
	{
        Node    *source = linenode[y];
        for(int x=0; x<SCREEN_XSIZE; ) 
		{
			if( source->address == NULL )
				memset(buffer+x, DefBackColor, source->length);
            else
				memcpy(buffer+x, source->address, source->length);
            x += source->length;
            source = source->next;
        }
    }
}
