#include <windows.h>  
#include <windowsx.h>
#include <ddraw.h>
#include <direct.h>
#include <d3drmwin.h>
#include <direct.h>
#include "airplane.h"
#include "object.h"
#include "view.h"

LRESULT APIENTRY MainProc (HWND hwnd,UINT message,UINT wParam,LONG lParam);

int PASCAL WinMain (HANDLE hModule,HANDLE hPrevInst,LPSTR lpszCmdLine,int nCmdShow)
{
	MSG msg;
	HWND hwnd;
	WNDCLASS wc;
	LPDIRECT3DRM p3DRM;

	wc.lpszClassName= "MAIN";
	wc.hInstance	= hModule;
	wc.lpfnWndProc	= MainProc;
	wc.style		= 0;
	wc.cbClsExtra	= 0;
	wc.cbWndExtra	= 0;
	wc.hIcon		= LoadIcon (NULL,IDI_APPLICATION);
	wc.hCursor		= LoadCursor (NULL,IDC_ARROW);
	wc.hbrBackground= GetStockObject (WHITE_BRUSH);
	wc.lpszMenuName = NULL;
	RegisterClass (&wc);

	hwnd = CreateWindow ("MAIN","",WS_POPUP,
				        0,0,GetSystemMetrics(SM_CXSCREEN),GetSystemMetrics(SM_CYSCREEN),
						NULL,(HMENU)NULL,hModule,NULL);

	ShowWindow (hwnd,nCmdShow);
	UpdateWindow (hwnd);

	// ִϸ̼  ʱȭ Ѵ.
	if (!view_Init(hwnd,16)) return 0;
	if (p3DRM=view_Init3D(hwnd),!p3DRM) return 0;
	obj_Init ();
	if (!player_Init(p3DRM)) return 0;
	if (!enemy_Init(p3DRM)) return 0;

	while (1)
    {
        if (PeekMessage(&msg,NULL,0,0,PM_NOREMOVE))
        {
            if (!GetMessage(&msg,NULL,0,0)) return msg.wParam;
            TranslateMessage(&msg); 
            DispatchMessage(&msg);
        }
        else 
        {
			// Idle time ø ִϸ̼ Ѵ.
			view_Flip ();
        }
    }
	return msg.wParam;
}

LRESULT APIENTRY MainProc (HWND hwnd,UINT message,UINT wParam,LONG lParam)
{
	HANDLE hModule = (HANDLE) GetWindowLong (hwnd,GWL_HINSTANCE);

	switch (message)
	{
		case WM_CREATE:
		{
			break;
		}
		case WM_CLOSE:
		{
			obj_Destroy ();
			break;
		}
	    case WM_KEYDOWN:
		{
			switch (wParam)
			{
				case VK_ESCAPE:
				{
					PostMessage (hwnd,WM_CLOSE,0,0);
					break;
				}
			}
	        break;
		}
		case WM_DESTROY:
		{
			PostQuitMessage (0);
			return 0;
		}
	}
	obj_Process (message,wParam,lParam);
	return DefWindowProc (hwnd,message,wParam,lParam);
}

