//	ȭ ִϸ̼ ϴ ִϸ̼ ̴.
//	 ø ִϸ̼ Ѵ.

#define INITGUID

#include <windows.h>
#include <ddraw.h>
#include <direct.h>
#include <d3drmwin.h>
#include "back.h"
#include "view.h"
#include "object.h"

LPDIRECT3DRM gp3DRM;
LPDIRECT3DRMDEVICE gp3DDev;
LPDIRECT3DRMVIEWPORT gp3DView;
LPDIRECT3DRMFRAME gp3DScene;
LPDIRECT3DRMFRAME gp3DCamera;
LPDIRECTDRAWCLIPPER gpDDClipper;
LPDIRECT3DRMANIMATION gpAnim;

LPDIRECTDRAW gpDD;
LPDIRECTDRAWSURFACE gpDDSPrimary;   
LPDIRECTDRAWSURFACE	gpDDSBack;
LPDIRECTDRAWPALETTE gpDDPal;

BOOL BuildScene (LPDIRECT3DRMDEVICE pDev,LPDIRECT3DRMVIEWPORT pView,LPDIRECT3DRMFRAME pScene,LPDIRECT3DRMFRAME pCamera);

BOOL view_Init (HWND hwnd,INT bpp)
//	ִϸ̼  ʱȭ Ѵ.
{
	DDSURFACEDESC ddsd;
	DDSCAPS ddscaps;
	DDCOLORKEY ddck;

	if (DirectDrawCreate(NULL,&gpDD,NULL)!=DD_OK) 
	{
		return 0;
	}

	//	Ÿ Ǯũ  Ѵ. (EXCLUSIVE, FULLSCREEN)
	//	 ctrl+alt+del Ű   ֵ Ѵ. (ALLOWREBOOT)
	gpDD->lpVtbl->SetCooperativeLevel (gpDD,hwnd,DDSCL_ALLOWREBOOT|DDSCL_EXCLUSIVE|DDSCL_FULLSCREEN);

	//	Bit for pixel Ѵ. 8Ʈ ÷ 16Ʈ ÷ ϵ Ѵ.
	//	ػ󵵴 640 x 480 .
	switch (bpp)
	{
		case 16:
			if (gpDD->lpVtbl->SetDisplayMode(gpDD,1280,1024,16)!=DD_OK)
			{
				view_Destroy ();
				SendMessage (hwnd,WM_CLOSE,0,0);
				return 0;
			}
			break;
		case 8:
		default:
			if (gpDD->lpVtbl->SetDisplayMode(gpDD,1280,1024,8)!=DD_OK)
			{
				view_Destroy ();
				SendMessage (hwnd,WM_CLOSE,0,0);
				bpp=8;
				return 0;
			}
	}

	//	 ø ִϸ̼  DDSURFACEDESC ü Ѵ.
	ddsd.dwSize = sizeof (ddsd);
	ddsd.dwFlags = DDSD_CAPS|DDSD_BACKBUFFERCOUNT;
	ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE|DDSCAPS_FLIP|DDSCAPS_COMPLEX|DDSCAPS_3DDEVICE;
	ddsd.dwBackBufferCount = 1;

	//	 ۸ Ѵ.
	gpDD->lpVtbl->CreateSurface (gpDD,&ddsd,&gpDDSPrimary,NULL);

	//	  ۿ ٴ ĸ ۸ Ѵ.
	ddscaps.dwCaps = DDSCAPS_BACKBUFFER|DDSCAPS_3DDEVICE;
	gpDDSPrimary->lpVtbl->GetAttachedSurface (gpDDSPrimary,&ddscaps,&gpDDSBack);

	if (bpp==8)
	{
	    LPPALETTEENTRY pPe;
		INT i;

		pPe = (LPPALETTEENTRY) malloc (sizeof(PALETTEENTRY)*256);
		if (!pPe) return 0;

		for (i=10;i<245;i++)
		{
			pPe[i].peRed = i;
			pPe[i].peGreen = i;
			pPe[i].peBlue = i;
		}
		gpDD->lpVtbl->CreatePalette (gpDD,DDPCAPS_8BIT,pPe,&gpDDPal,NULL);
	    if (gpDDPal)
		{
			gpDDSPrimary->lpVtbl->SetPalette (gpDDSPrimary,gpDDPal);
			gpDDSPrimary->lpVtbl->SetPalette (gpDDSBack,gpDDPal);
		}
		free (pPe);
	}

	//	 (255)  ҽ ÷Ű Ѵ.
	ddck.dwColorSpaceLowValue = 255;
	ddck.dwColorSpaceHighValue = 255;
	gpDDSBack->lpVtbl->SetColorKey (gpDDSBack,DDCKEY_SRCBLT,&ddck);
	return 1;
}

LPDIRECT3DRM view_Init3D (HWND hwnd)
//	̷Ʈ 3D  κ ʱȭ Ѵ.
{
	// ̷Ʈ3D ü  ̹̽ Ѵ.
    if (Direct3DRMCreate(&gp3DRM)!=D3DRM_OK) return 0;
	//   Ѵ.
	if (gp3DRM->lpVtbl->CreateFrame(gp3DRM,NULL,&gp3DScene)!=D3DRM_OK) return 0;
	// ī޶   , ⺻ ġ Ѵ.
	if (gp3DRM->lpVtbl->CreateFrame(gp3DRM,gp3DScene,&gp3DCamera)!=D3DRM_OK) return 0;
	if (gp3DCamera->lpVtbl->SetPosition(gp3DCamera,gp3DScene,D3DVAL(0),D3DVAL(0),D3DVAL(0))!=D3DRM_OK) return 0;

	// ̷Ʈ ο ĸ ۷  ־ ̽ Ѵ.
	if (gp3DRM->lpVtbl->CreateDeviceFromSurface(gp3DRM,NULL,gpDD,gpDDSBack,&gp3DDev)!=D3DRM_OK) return 0;
	//  ־ ̽κ Ʈ Ѵ.
	if (gp3DRM->lpVtbl->CreateViewport(gp3DRM,gp3DDev,gp3DCamera,0,0,640,480,&gp3DView)!=D3DRM_OK) return 0;
	//   Ѵ.
	if (gp3DView->lpVtbl->SetBack(gp3DView,D3DVAL(5000))!=D3DRM_OK) return 0;

	// ⺻ Ӽ Ѵ.
	if (gp3DDev->lpVtbl->SetQuality(gp3DDev,D3DRMLIGHT_ON|D3DRMFILL_SOLID|D3DRMSHADE_GOURAUD)!=D3DRM_OK) return 0;
	if (gp3DDev->lpVtbl->SetDither(gp3DDev,TRUE)!=D3DRM_OK) return 0;
	if (gp3DDev->lpVtbl->SetTextureQuality(gp3DDev,D3DRMTEXTURE_NEAREST)!=D3DRM_OK) return 0;

	if (FAILED(gp3DDev->lpVtbl->SetShades(gp3DDev,32))) return 0;
	if (FAILED(gp3DRM->lpVtbl->SetDefaultTextureColors(gp3DRM,64))) return 0;
	if (FAILED(gp3DRM->lpVtbl->SetDefaultTextureShades(gp3DRM,32))) return 0;

	//  α׷ Ư¡  Ѵ.
	BuildScene (gp3DDev,gp3DView,gp3DScene,gp3DCamera);
	return gp3DRM;
}

BOOL view_Destroy ()
{
	return 1;
}

LPDIRECTDRAW view_GetDD ()
//	̷Ʈ ο ü ͸ Ѵ.
//	ٸ ⿡ ̷Ʈ ο ü ϱ   Լ Ѵ.
{
	return gpDD;
}

BOOL view_Flip ()
//	  ø Ͼ Ѵ.
//	 Լ  θ ִϸ̼ Ͼ.
{
	background_Render (gpDDSBack);

	// ĸ ۿ ĳ͵  䱸Ѵ.
	obj_Render (gpDDSBack);

    gp3DScene->lpVtbl->Move (gp3DScene,D3DVAL(1.0));
	gp3DView->lpVtbl->Clear (gp3DView);
	gp3DView->lpVtbl->Render (gp3DView,gp3DScene);
	gp3DDev->lpVtbl->Update (gp3DDev);

	//  ø Ѵ.
	gpDDSPrimary->lpVtbl->Flip (gpDDSPrimary,NULL,DDFLIP_WAIT);
	return 1;
}

BOOL BuildScene (LPDIRECT3DRMDEVICE pDev,LPDIRECT3DRMVIEWPORT pView,LPDIRECT3DRMFRAME pScene,LPDIRECT3DRMFRAME pCamera)
//  α׷ Ư¡  Ѵ.
{
	LPDIRECT3DRMFRAME pLight = NULL;
	LPDIRECT3DRMLIGHT pL1 = NULL;
	LPDIRECT3DRMLIGHT pL2 = NULL;

	//    ſ ߰Ѵ.
	gp3DRM->lpVtbl->CreateLightRGB (gp3DRM,D3DRMLIGHT_AMBIENT,D3DVAL(0.9),D3DVAL(0.1),D3DVAL(0.1),&pL2);
	gp3DScene->lpVtbl->AddLight (gp3DScene,pL2);

	//    .
	gp3DRM->lpVtbl->CreateFrame (gp3DRM,gp3DScene,&pLight);
	pLight->lpVtbl->SetPosition (pLight,gp3DScene,D3DVAL(2),D3DVAL(0),D3DVAL(22));

	// Ʈ     ӿ δ.
	gp3DRM->lpVtbl->CreateLightRGB (gp3DRM,D3DRMLIGHT_POINT,D3DVAL(5.9),D3DVAL(0.9),D3DVAL(0.9),&pL1);
	pLight->lpVtbl->AddLight (pLight,pL1);

	// ī޶  ʱ ġ  Ѵ.
	gp3DCamera->lpVtbl->SetPosition (gp3DCamera,gp3DScene,D3DVAL(0),D3DVAL(0),D3DVAL(-50));
	gp3DCamera->lpVtbl->SetOrientation (gp3DCamera,gp3DScene,D3DVAL(0),D3DVAL(0),D3DVAL(1),D3DVAL(0),D3DVAL(1),D3DVAL(0));

	//    Ѵ.
	gp3DScene->lpVtbl->SetSceneBackgroundRGB (gp3DScene,D3DVAL(0.5),D3DVAL(0.5),D3DVAL(1.0));

	pLight->lpVtbl->Release (pLight);
	pL1->lpVtbl->Release (pL1);
	pL2->lpVtbl->Release (pL2);
	return 1;
}

