//
// FNAME  : pcxtosou.cpp
// AUTHOR : 뿵
// CREATE : 1997.1.10
// UPDATE : 1997.2.24
// COMMENT: PCXȭ о ½Ű Դϴ.
//

#include	<windows.h>
#include	<ddraw.h>
#include	<io.h>
#include	<string.h>
#include	<stdlib.h>
#include	<stdio.h>
#include	"pcx.h"
	
long FAR PASCAL WindowProc( HWND hwnd, UINT message, WPARAM wparam, LPARAM lparam );

// Instance variables.
HINSTANCE            hInstance = NULL;
RECT                 currentRect;
HWND                 hwnd;          // window handle
LPDIRECTDRAW         lpDD;          // Direct Structure pointer
LPDIRECTDRAWSURFACE	lpDDSPrimary;		// DirectDraw PrimaryBuffer
LPDIRECTDRAWSURFACE	lpDDSOne;			// DirectDraw Back Buffer
LPDIRECTDRAWPALETTE  lpDDPal;        // DirectDraw Palette pointer
BOOL                 bIsInitialized=FALSE;
LPSTR                WorkSpace;
LPSTR                FILENAME;
PALETTEENTRY         pe[256];

BOOL                SurfaceFlag;

void	FiniObject( void );
BOOL  ReadPCX();
BOOL  UpdateFrame();
BOOL  RestoreAll();
BOOL	doInit( HINSTANCE hinst, int cmdshow );
BOOL	InitFail( HWND hwnd );

BOOL ReadPCX ()
{
    HRESULT        ddrval;
    FILE				*fp;	
    PCXHEADER      hdr;

    int x, y, i, count;
    BYTE _pal[768], d;
    BYTE *pcx_buf = NULL, *oldpcx_buf = NULL;
	 unsigned long file_size;

    fp = fopen ( FILENAME, "rb");
    if( fp == NULL ) return( 0 );

    fseek( fp, -768, SEEK_END );        
    fread( _pal, 768, 1, fp);           

    fseek( fp, 0, SEEK_SET );           
    fread( (void *)&hdr, 1, sizeof( PCXHEADER ), fp );   

    file_size = _filelength(fileno(fp)) - 897;

    if( (hdr.manufact != 10) || (hdr.x2 != (hdr.hres-1)) || (hdr.y2 != (hdr.vres-1)) )
    {
         fclose(fp);
         return( 0 );
    }
    count = 0;

    // assign to entry palette
    for( i = 0; i < 256; i ++)
    {
        pe[i].peRed=_pal[count++];
        pe[i].peGreen=_pal[count++];
        pe[i].peBlue=_pal[count++];
    }   

    // Create Palette & Set Palette
    ddrval = lpDD->CreatePalette( DDPCAPS_8BIT, pe, &lpDDPal, NULL );
    if( ddrval != DD_OK )	return FALSE;
    lpDDSPrimary->SetPalette( lpDDPal );

    DDSURFACEDESC  DDSDesc;
    DDSDesc.dwSize = sizeof( DDSDesc );
    ddrval = lpDDSOne->Lock( NULL, &DDSDesc, 0, NULL );
    if( ddrval != DD_OK )  return FALSE;

    WorkSpace = ( LPSTR )DDSDesc.lpSurface;

    pcx_buf = oldpcx_buf = (BYTE *)new BYTE[ file_size ];   
    fread( pcx_buf, file_size, 1, fp );      
    fclose( fp );

    for( y = 0; y < hdr.vres; y++ )
    {
		x = 0;
        while( x < hdr.hres )
        {
            d = *pcx_buf++;
            if( (d & 0xc0) == 0xc0 ) 
            {
                count = d & 0x3f;
                d = *pcx_buf++;
                while( count-- )
                {	
                    *WorkSpace++ = d;
                    x++;
                }
            }
            else
            {
                *WorkSpace++ = d;
                x++;
            }
        }
    }
   if( oldpcx_buf )  delete oldpcx_buf;

   lpDDSOne->Unlock(NULL);
   return TRUE;
}

BOOL	UpdateFrame( )
{
	RECT				rcrect;
	RECT				destrect;
	POINT				pt;
	HRESULT				ddrval;

	rcrect.left = 0;
	rcrect.top = 0;
	rcrect.right = 640;
	rcrect.bottom = 480;

	GetClientRect( hwnd, &destrect );
	pt.x = pt.y = 0;
	ClientToScreen( hwnd, &pt );
	OffsetRect( &destrect, pt.x, pt.y );

	while( 1 )
	{
		ddrval = lpDDSPrimary->Blt( &destrect, lpDDSOne, &rcrect, 0, NULL );

		if( ddrval == DD_OK ) break;
		if( ddrval == DDERR_SURFACELOST )
		{
			if(!RestoreAll())
			{
				return FALSE;
			}
			continue;
		}
		if( ddrval != DDERR_WASSTILLDRAWING )
			return TRUE;
	}
	return TRUE;
}

BOOL	InitFail( HWND hwnd )
{
	FiniObject();
	MessageBox( hwnd, " DirectDraw Initialization failed", "my program", MB_OK );
	DestroyWindow( hwnd );
	return FALSE;
}

void  FiniObject( void )
{
	if( lpDD != NULL )
	{
		if( lpDDSPrimary != NULL )
		{ 
			lpDDSPrimary->Release();
			lpDDSPrimary = NULL;
		}
		if( lpDDSOne != NULL )
		{
			lpDDSOne->Release();
			lpDDSOne = NULL;
		}
		lpDD->Release();
		lpDD = NULL;
	}
}

BOOL	RestoreAll( void )
{
	BOOL	bresult;

	bresult = lpDDSPrimary->Restore() == DD_OK && lpDDSOne->Restore() == DD_OK;
	ReadPCX();
	return bresult;
}

BOOL	doInit( HINSTANCE hinst, int cmdshow )
{
	WNDCLASS		wc;
	DDSURFACEDESC	ddsd;
	HRESULT			ddrval;

	wc.style = CS_HREDRAW|CS_VREDRAW;
	wc.lpfnWndProc = WindowProc;
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hInstance = hinst;
	wc.hIcon = LoadIcon( hinst, IDI_APPLICATION );
    wc.hCursor = LoadCursor(NULL, IDC_CROSS);
	wc.hbrBackground = NULL;
	wc.lpszMenuName = NULL;
	wc.lpszClassName = "myProgram";

	RegisterClass( &wc);

	hwnd = CreateWindowEx( 0, "myProgram", "myProgram", WS_POPUP, 0, 0,
		                   GetSystemMetrics( SM_CXSCREEN ),
						   GetSystemMetrics( SM_CXSCREEN ),
						   NULL, NULL, hinst, NULL );
	if( !hwnd ) return FALSE;
	ShowWindow( hwnd, cmdshow );
	UpdateWindow( hwnd );

	ddrval = DirectDrawCreate( NULL, &lpDD, NULL );
	if( ddrval != DD_OK ) return InitFail( hwnd );

	lpDD->SetCooperativeLevel( hwnd, DDSCL_EXCLUSIVE|DDSCL_FULLSCREEN );
	if( ddrval != DD_OK ) return FALSE;

	ddrval = lpDD->SetDisplayMode( 640, 480, 8 );
	if( ddrval != DD_OK ) return InitFail( hwnd );

	ddsd.dwSize = sizeof( ddsd );
	ddsd.dwFlags = DDSD_CAPS;
	ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;
    ddrval = lpDD->CreateSurface( &ddsd, &lpDDSPrimary, NULL );  // create primary surface
	if( ddrval != DD_OK ) return InitFail( hwnd );

	ddsd.dwSize = sizeof( ddsd );
	ddsd.dwFlags = DDSD_CAPS|DDSD_HEIGHT|DDSD_WIDTH;
	ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
	ddsd.dwWidth = 640;
	ddsd.dwHeight = 480;
    lpDD->CreateSurface( &ddsd, &lpDDSOne, NULL );               // create back surface
    if( lpDDSOne == NULL )
		return InitFail( hwnd );
    bIsInitialized = TRUE;
	return TRUE;
}

long FAR PASCAL WindowProc( HWND hwnd, UINT message, WPARAM wparam, LPARAM lparam )
{
	switch( message )
	{
      case WM_SETCURSOR :
            SetCursor( NULL );
				if( bIsInitialized )
					UpdateFrame( );
				break;
		case WM_KEYDOWN : 
				switch( wparam )
				{
					case VK_ESCAPE :
						PostMessage( hwnd, WM_CLOSE, 0, 0 );
						break;
            }
				break;
		case WM_DESTROY :
			     FiniObject();
				 PostQuitMessage( 0 );
				 break;
	};
	return DefWindowProc( hwnd, message, wparam, lparam );
}

int    PASCAL  WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow )
{
	MSG	msg;

	if( strcmp(lpCmdLine, "") == 0  )
	{
      MessageBox( hwnd, "Usage : \n\tPCXTOSOU Fname.PCX", "Information : LOAD PCX", MB_ICONASTERISK );
		return FALSE;
	}
   if( !doInit( hInstance, nCmdShow ) ) return FALSE;

   FILENAME = lpCmdLine;

   ReadPCX();
	if( !UpdateFrame( ) ) return FALSE;

	while( 1 )
	{
		if( PeekMessage( &msg, NULL, 0, 0, PM_NOREMOVE ) )
		{
			if( !GetMessage( &msg, NULL, 0, 0 ) )
				return msg.wParam;
			TranslateMessage( &msg );
			DispatchMessage( &msg );
		}
		else
		{
			WaitMessage();
		}
	} 
}
