UNIT HanSub;

INTERFACE

 procedure setHanColor(color : byte);
 procedure setGradationColor(last_color, color : byte);
 procedure printHangul(x,y : integer; s : string; color : byte);
 procedure printHangulGRADATION(x,y : integer; s : string; color : byte);
 procedure printHangulEXPAND(x,y : integer; s : string; color : byte);
 procedure displayStory;
 procedure displayBadEnding;
 procedure displayHappyEnding;
 procedure aboutGame;
 function  setVariable(DETECT_SOUND_CARD : boolean) : boolean;

IMPLEMENTATION

uses
   SubPro;
type
   han_font_data_T = array[0..223,0..31] of byte;
   ascii_font_data_T = array[0..95,0..15] of byte;
   THanMode = (hNormal, hGradation, hExpand);

const
   STORY_FILE : string[9] = 'Story.Dat';
   TEMP_FILE  : string[8] = 'Temp.$$$';

   ASCII_FONT_SIZE = 96*16;
   HAN_FONT_SIZE = 224*32;
   _HAN_COLOR_S : byte = 15;
   _HAN_GRADATION_COLOR : array[1..3] of byte = (63,42,21);
   SHIFT_CODE = 1000;
   SCAN_CODE = 256;

   han_table : array[0..31] of byte = (
	 $00,  $00,  $00,  $00,  $00,  $00,  $00,  $00,  $00,  $00,
	 $00,  $00,  $00,  $11,  $02,  $02,  $02,  $02,  $02,  $11,
	 $11,  $02,  $02,  $02,  $02,  $02,  $11,  $11,  $02,  $00,
	 $02,  $02 );

   gradation_han_table : array[0..15,0..15] of byte = (
                (9,9,9,9,9,8,8,8,8,8,8,9,9,9,9,9),
                (9,9,9,9,8,8,7,7,7,7,8,8,9,9,9,9),
                (9,9,9,8,8,7,7,6,6,7,7,8,8,9,9,9),
                (9,9,8,7,7,6,6,5,5,6,6,7,7,8,9,9),
                (9,8,8,7,6,5,5,4,4,5,5,6,7,8,8,9),
                (8,8,7,6,5,4,4,3,3,4,4,5,6,7,8,8),
                (8,7,7,6,5,4,3,2,2,3,4,5,6,7,7,8),
                (8,7,6,5,4,3,2,1,1,2,3,4,5,6,7,8),
                (8,7,6,5,4,3,2,1,1,2,3,4,5,6,7,8),
                (8,7,7,6,5,4,3,2,2,3,4,5,6,7,7,8),
                (8,8,7,6,5,4,4,3,3,4,4,5,6,7,8,8),
                (9,8,8,7,6,5,5,4,4,5,5,6,7,8,8,9),
                (9,9,8,7,7,6,6,5,5,6,6,7,7,8,9,9),
                (9,9,9,8,8,7,7,6,6,7,7,8,8,9,9,9),
                (9,9,9,9,8,8,7,7,7,7,8,8,9,9,9,9),
                (9,9,9,9,9,8,8,8,8,8,8,9,9,9,9,9));
var
   han_buf : array[0..31] of byte;
   ascii_font_data : ^ascii_font_data_T;
   han_font_data : ^han_font_data_T;

const
   MAX_MESSAGE = 20;
type
   TGraphicBox = object
      x1,y1,x2,y2,max_line,fore_color,back_color,hide_color : byte;
      message : array[1..MAX_MESSAGE] of string;
      enable_message : array[1..MAX_MESSAGE] of boolean;
      is_save : boolean;
      save_buffer : ^byte;
      save_x, save_y : word;
      save_buffer_size : word;

      constructor init(_x1,_y1,_x2,_y2,_fore_color,_back_color,_hide_color,_max_line : byte; save : boolean);
      destructor  done;
      procedure enableMessage(number : byte);
      procedure disableMessage(number : byte);
      procedure setMessage(number : byte; s : string);
      procedure drawTextBox;
      function  selectTextBox(y_line : byte) : integer;
   end;

procedure printString(x,y : integer; s : string; fore_color, back_color : integer);
begin
   fillScreen(x*8,y*16,(x+length(s))*8-1,y*16+15,back_color);
   printHangul(x*8,y*16,s,fore_color);
end;

constructor TGraphicBox.init;
var
   i : byte;
begin
   x1 := _x1; x2 := _x2; y1 := _y1; y2 := _y2;
   fore_color := _fore_color;
   back_color := _back_color;
   hide_color := _hide_color;
   max_line := _max_line;
   for i := 1 to max_line do begin
      message[i] := '';
      enable_message[i] := TRUE;
   end;
   if save then begin
      is_save := TRUE;
      save_x := x1*8;
      save_y := y1*16;
      save_buffer_size := getImageSize(save_x,save_y,x2*8+7,y2*16+17);
      getMem(save_buffer,save_buffer_size);
      getImage(x1*8,y1*16,x2*8+7,y2*16+17,save_buffer^);
   end else is_save := FALSE;
end;

destructor  TGraphicBox.done;
begin
   if is_save then begin
      putImage(save_x,save_y,save_buffer^);
      freeMem(save_buffer,save_buffer_size);
   end;
end;

procedure TGraphicBox.enableMessage(number : byte);
begin
   if number in [1..MAX_MESSAGE] then begin
      enable_message[number] := TRUE;
   end;
end;

procedure TGraphicBox.disableMessage(number : byte);
begin
   if number in [1..MAX_MESSAGE] then begin
      enable_message[number] := FALSE;
   end;
end;

procedure TGraphicBox.setMessage(number : byte; s : string);
begin
   if number in [1..MAX_MESSAGE] then begin
      message[number] := s;
   end;
end;

procedure TGraphicBox.drawTextBox;
var
   i : integer;
begin
   fillScreen(x1*8,y1*16,x2*8+7,y2*16+15,back_color);
   lineX(x1*8,x2*8+7,y1*16,15);
   lineX(x1*8,x2*8+7,y1*16+1,15);
   lineX(x1*8,x2*8+7,y2*16+15,15);
   lineX(x1*8,x2*8+7,y2*16+14,15);
   lineY(x1*8,y1*16,y2*16+15,15);
   lineY(x1*8+1,y1*16,y2*16+15,15);
   lineY(x2*8+7,y1*16,y2*16+15,15);
   lineY(x2*8+6,y1*16,y2*16+15,15);
   for i := 1 to max_line do begin
      if message[i] <> '' then begin
         if enable_message[i] then
            printString(x1+3,(y1+i),message[i],fore_color,back_color)
         else
            printString(x1+3,(y1+i),message[i],hide_color,back_color);
      end else begin
         lineX(x1*8,x2*8+7,(y1+i)*16+7,15);
         lineX(x1*8,x2*8+7,(y1+i)*16+8,15);
      end;
   end;
end;

function  TGraphicBox.selectTextBox(y_line : byte) : integer;
const
   UP_KEY   = 256 + 72;
   DOWN_KEY = 256 + 80;
var
   i, key_code : integer;
begin
   key_code := 0;
   while not (key_code in [13,27]) do begin
      key_code := ord(readKey);
      if key_code = 0 then key_code := 256 + ord(readKey);
      printString(x1,y1+y_line,message[y_line],fore_color,back_color);
      case key_code of
         UP_KEY   :
         if y_line > 1 then begin
            repeat
               dec(y_line);
            until ((message[y_line] <> '') and enable_message[y_line]) or (y_line = 1);
            if y_line = 1 then begin
               while ((message[y_line] = '') or not enable_message[y_line]) do inc(y_line);
            end;
         end;
         DOWN_KEY : if y_line < max_line then begin
            repeat
               inc(y_line)
            until ((message[y_line] <> '') and enable_message[y_line]) or (y_line = max_line);
            if y_line = max_line then begin
               while ((message[y_line] = '') or not enable_message[y_line]) do dec(y_line);
            end;
         end;
      end;
      printString(x1,y1+y_line,message[y_line],15,10);
   end;
   if key_code = 13 then selectTextBox := y_line else selectTextBox := 0;
end;

procedure clearKeyBuffer; assembler;
asm
@START:
      mov  ah, 1
      int  $16
      je   @EXIT
      xor  ah, ah
      int  $16
      jmp  @START
@EXIT:
end;

procedure waitVerticalRetrace(count : integer);
begin
   while count > 0 do begin
      while (port[$03DA] and 8) > 0 do clearKeyBuffer;
      while (port[$03DA] and 8) = 0 do;
      dec(count);
   end;
end;

procedure setHanColor(color : byte);
begin
   _HAN_COLOR_S := color;
end;

procedure setGradationColor(last_color, color : byte);
const
   MAX_GRADATION_COLOR = 6;
   table : array[0..MAX_GRADATION_COLOR-1,1..3] of byte = (
      (63,42,21), (63,21,42), (42,63,21), (42,21,63), (21,42,63), (63,63,21));
var
   i : integer;
begin
   if color in [0..pred(MAX_GRADATION_COLOR)] then begin
      for i := 1 to 3 do
         _HAN_GRADATION_COLOR[i] := table[color][i];
      setPalette(last_color);
      setRGB(last_color,_HAN_GRADATION_COLOR[1],_HAN_GRADATION_COLOR[2],_HAN_GRADATION_COLOR[3]);
      setHanColor(last_color);
   end;
end;

procedure initHan;
var
   f : file;
begin

   new(ascii_font_data);
   new(han_font_data);

   assign(f,'font.dat');
   {$I-}
   reset(f,1);
   {$I+}
   if IOResult <> 0 then begin
      writeLn('File not found < Font.Dat >');
      halt;
   end;
   BlockRead(f,ascii_font_data^,sizeof(ascii_font_data^));
   BlockRead(f,han_font_data^,sizeof(han_font_data^));
   close(f);

end;

procedure putHan(x,y : integer);
var
   i,j,k : integer;
begin
   for j := 0 to 15 do begin
      for i := 0 to 7 do begin
         for k := 0 to 1 do begin
            if (((han_buf[j*2+k] shr i) and 1) > 0) then begin
               putpixel(x+k*8+(7-i), y, _HAN_COLOR_S);
            end;
         end;
      end;
      inc(y);
   end;
end;

procedure putAscii(x,y : integer);
var
   i,j : integer;
begin
   for j := 0 to 15 do begin
      for i := 0 to 7 do begin
         if (((han_buf[j] shr i) and 1) > 0) then begin
            putpixel(x+(7-i), y, _HAN_COLOR_S);
         end;
      end;
      inc(y);
   end;
end;

procedure GRADATION_putHan(x,y : integer);
var
   i,j,k : integer;
begin
   for j := 0 to 15 do begin
      for i := 0 to 7 do begin
         for k := 0 to 1 do begin
            if (((han_buf[j*2+k] shr i) and 1) > 0) then begin
               putpixel(x+k*8+(7-i),y,gradation_han_table[j,k*8+7-i]);
            end;
         end;
      end;
      inc(y);
   end;
end;

procedure GRADATION_putAscii(x,y : integer);
var
   i,j : integer;
begin
   for j := 0 to 15 do begin
      for i := 0 to 7 do begin
         if (((han_buf[j] shr i) and 1) > 0) then begin
            putpixel(x+(7-i), y,gradation_han_table[j,(7-i)*2]);
         end;
      end;
      inc(y);
   end;
end;

procedure EXPAND_putHan(x,y : integer);
var
   i,j,k : integer;
begin
   for j := 0 to 15 do begin
      for i := 0 to 7 do begin
         for k := 0 to 1 do begin
            if (((han_buf[j*2+k] shr i) and 1) > 0) then begin
               putpixel((x+k*8+(7-i))*2, y*2, _HAN_COLOR_S);
               putpixel((x+k*8+(7-i))*2+1, y*2, _HAN_COLOR_S);
               putpixel((x+k*8+(7-i))*2, y*2+1, _HAN_COLOR_S);
               putpixel((x+k*8+(7-i))*2+1, y*2+1, _HAN_COLOR_S);
            end;
         end;
      end;
      inc(y);
   end;
end;

procedure EXPAND_putAscii(x,y : integer);
var
   i,j : integer;
begin
   for j := 0 to 15 do begin
      for i := 0 to 7 do begin
         if (((han_buf[j] shr i) and 1) > 0) then begin
            putpixel((x+(7-i))*2, y*2, _HAN_COLOR_S);
            putpixel((x+(7-i))*2+1, y*2, _HAN_COLOR_S);
            putpixel((x+(7-i))*2, y*2+1, _HAN_COLOR_S);
            putpixel((x+(7-i))*2+1, y*2+1, _HAN_COLOR_S);
         end;
      end;
      inc(y);
   end;
end;

procedure printHangulSub(x,y : integer; var s : string; han_mode : THanMode);
var
   c : char;
   first, second, third, data1, data2 : byte;
   font_num : array[0..2] of byte;
   order,k : integer;
begin
   order := 1;
   while order <= length(s) do begin
      data1 := ord(s[order]);
      if ((data1 and $80) > 0) then begin

         inc(order,1);
         data2 := ord(s[order]);
         first := (data1 and $7C) shr 2;
         second := ((data1 and $03) shl 3) + (data2 shr 5);
         third := (data2 and $1F);
         fillchar(font_num,sizeof(font_num),0);
         if (first > 1) then begin
            font_num[0] := han_table[second] and $0F;
            if (third > 1) then inc(font_num[0],3);
            inc(font_num[0],(6*(first-2)));
         end;
         if (second > 2) then begin
            if (third > 1) then font_num[1] := 1
                           else font_num[1] := 0;
            inc(font_num[1],(2*(second-3)+114));
         end;
         if (third > 1) then begin
            font_num[2] := han_table[second] shr 4;
            font_num[2] := (2*(third-2)+168) + font_num[2];
         end;

         move(han_font_data^[font_num[0]],han_buf,32);
         if (third > 1) then begin
            for k := 0 to 31 do begin
               han_buf[k] := han_buf[k] or
                             (han_font_data^[font_num[1],k]) or
                             (han_font_data^[font_num[2],k]);
            end;
         end
         else if (second > 2) then begin
            for k := 0 to 31 do begin
               han_buf[k] := han_buf[k] or
                             (han_font_data^[font_num[1],k]);
            end;
         end;

         case han_mode of
            hExpand    : EXPAND_putHan(x,y);
            hGradation : GRADATION_putHan(x,y);
            hNormal    : putHan(x,y);
         end;

         inc(x,16);
      end
      else begin

         if (data1 < 27) then data1 := 31;
         if (data1 >126) then data1 := 32;
         dec(data1,31);

         move(ascii_font_data^[data1],han_buf,16);

         case han_mode of
            hExpand    : EXPAND_putAscii(x,y);
            hGradation : GRADATION_putAscii(x,y);
            hNormal    : putAscii(x,y);
         end;

         inc(x,8);
      end;
      inc(order);
   end;
end;

procedure printHangul(x,y : integer; s : string; color : byte);
begin
   setHanColor(color);
   printHangulSub(x,y,s,hNormal);
end;

procedure printHangulGRADATION(x,y : integer; s : string; color : byte);
var
   i, j, k : integer;
   colors : array[1..3] of byte;
begin

   for i := 1 to 9 do begin
      setPalette(i);
      setRGB(i,0,0,0);
   end;
   printHangulSub(x,y,s,hGradation);
   j := 0;
   repeat
      for i := 1 to 9 do begin
         if ((j - i*10) > 0) and ((j - i*10) <= 63) then begin
            for k := 1 to 3 do begin
               colors[k] := j-i*10;
               if _HAN_GRADATION_COLOR[k] = 21 then colors[k] := colors[k] div 3
               else if _HAN_GRADATION_COLOR[k] = 42 then colors[k] := colors[k] * 2 div 3;
            end;
            setRGB(i,colors[1],colors[2],colors[3]);
         end;
      end;
      inc(j);
      if not pressedKey then waitVerticalRetrace(1);
   until (j = 90 + 63);
   setPalette(color);
   setRGB(color,colors[1],colors[2],colors[3]);
   setHanColor(color);
   printHangulSub(x,y,s,hNormal);

end;

procedure printHangulEXPAND(x,y : integer; s : string; color : byte);
begin
   setHanColor(color);
   printHangulSub(x,y,s,hExpand);
end;

procedure displayStorySub(start_message : string; is_grad : boolean);
var
   i, grad_color : integer;
   color : byte;
   c : char;
   s : string[80];
   f : text;
begin

   if not revertFile(STORY_FILE,TEMP_FILE) then begin
      closeGraph;
      writeLn('File not found < ',STORY_FILE,' >');
      halt;
   end;

   assign(f,TEMP_FILE);
   {$I-}
   reset(f);
   {$I+}
   if IOResult <> 0 then exit;

   if is_grad then begin
      asm mov ax, 12h; int 10h end;
   end;

   VIDEO_SEGMENT := $A000;

   i := 0; c := #0; s := '';
   while s <> start_message do readLn(f,s);
   while not eof(f) and (c <> #27) do begin
      readLn(f,s);
      inc(i);
      if s = '' then continue;
      if s = '#END' then break;

      color := ord(s[length(s)]) - ord('1');
      dec(s[0]);
      if is_grad then begin
         grad_color := 10 + color;
         setGradationColor(grad_color,color);
         printHangulGRADATION(0,pred(i)*16,s,grad_color);
         if pressedKey then begin
            c := readKey; if c = #0 then readKey;
         end;
      end else begin
         printHangul(0,pred(i)*16,s,color);
         c := readKey; if c = #0 then readKey;
      end;
   end;
   close(f);

   if is_grad then begin
      if c <> #27 then begin
         c := #0;
         while not (c in [#13,#27]) do c := readKey;
      end;
   end;

   deleteFile(TEMP_FILE);
end;

procedure displayStory;
begin
   displayStorySub('#START STORY',TRUE);
end;

procedure displayBadEnding;
begin
   displayStorySub('#BAD ENDING',FALSE);
end;

procedure displayHappyEnding;
begin
   displayStorySub('#HAPPY ENDING',TRUE);
end;

procedure aboutGame;
label
   _EXIT;
var
   i, key_code : integer;
   s : string[80];
   f : text;
   box_data : TGraphicBox;
begin

   if not revertFile(STORY_FILE,TEMP_FILE) then begin
      closeGraph;
      writeLn('File not found < ',STORY_FILE,' >');
      halt;
   end;

   assign(f,TEMP_FILE);
   {$I-}
   reset(f);
   {$I+}
   if IOResult <> 0 then exit;

   i := 0; s := '';
   while s <> '#START ABOUT' do readLn(f,s);
   box_data.init(15,10,65,14,13,1,7,3,TRUE);
   box_data.disableMessage(1);
   while not eof(f) and (key_code <> 27) do begin
      i := 0;
      repeat
         readLn(f,s);
         if s = '' then s := ' ';
         if s = '#END' then goto _EXIT;
         inc(i);
         box_data.setMessage(i,s);
      until s = ' ';
      box_data.drawTextBox;
      key_code := ord(readKey);
      if key_code = 0 then key_code := 256 + ord(readKey);
   end;
_EXIT:
   box_data.done;
   close(f);

   deleteFile(TEMP_FILE);
end;

function  setVariable(DETECT_SOUND_CARD : boolean) : boolean;
type
   TElement = (eNull0,eBGMMode,eAutoMode,eDelayMode,ePlayerMode,eNull2,ePlayer1,ePlayer2,eNull3,eScreenMode,eNull4,eSave);
const
   MAX_STRING = ord(eSave);
   string_data : array[eBGMMode..eSave] of string[9] = (
      'w qb',
      'a ia',
      'e w',
      'a Ȃ',
      '',
      '1  a',
      '2  a',
      '',
      'e a',
      '',
      ' '
   );
var
   i,j : integer;
   selected_menu, temp_element : TElement;
   s : string[50];
   box_data : TGraphicBox;
   select_mode : TPlayerMode absolute player_mode;

 procedure displayValiable(number : TElement);
 var
    color : byte;
 begin
    color := box_data.fore_color;
    s := '';
    case number of
       eBGMMode :
          if USER_SOUND   then s := ' a    w '
                          else s := '  a w ';
       eAutoMode :
          if AUTO_SHOOT   then s := ' a    w '
                          else s := '  a w ';
       eDelayMode :
          if STATIC_DELAY then s := '      '
                          else s := ' a    e ';
       ePlayerMode :
          if select_mode in [dual_mode1,dual_mode2] then begin
             s := '    ';
             box_data.enableMessage(ord(ePlayer2));
          end
          else s := ' ѥ a  ';
       ePlayer1 :
          if select_mode in [player2,dual_mode2] then s := ' NeTo     '
                                                 else s := ' SMgal    ';
       ePlayer2 :
          if select_mode in [player2,dual_mode2] then s := ' SMgal    '
                                                 else s := ' NeTo     ';
       eScreenMode :
          case safe_mode of
             0 : s := 'ew  a';
             1 : s := 'aa 1';
             2 : s := 'aa 2';
             3 : s := 'aa 3';
          end;
       eSave :
          s := ' wa ';
    end;
    if number in [eBGMMode] then begin
       if not DETECT_SOUND_CARD then color := box_data.hide_color;
    end;
    if number in [ePlayer2] then begin
       if not (select_mode in [dual_mode1,dual_mode2]) then begin
          color := box_data.hide_color;
          box_data.disableMessage(ord(number));
       end;
    end;
    box_data.setMessage(byte(number),s);
    if number = selected_menu then begin
       printString(box_data.x1,box_data.y1+ord(number),s,15,10);
    end else begin
       printString(box_data.x1,box_data.y1+ord(number),s,color,box_data.back_color);
    end;
 end;

begin
   box_data.init(24,8,53,8+1+MAX_STRING,7,1,8,MAX_STRING,TRUE);
   for temp_element := eBGMMode to eSave do begin
      box_data.setMessage(ord(temp_element),string_data[temp_element]);
   end;
   box_data.drawTextBox;
   inc(box_data.x1,17);
   selected_menu := eBGMMode;
   USER_SOUND := DETECT_SOUND_CARD;
   if not DETECT_SOUND_CARD then box_data.disableMessage(ord(eBGMMode));

   while selected_menu in [eBGMMode..pred(eSave)] do begin
      with box_data do
      while ((message[byte(selected_menu)] = '') or not enable_message[byte(selected_menu)]) do inc(selected_menu);
      for temp_element := eBGMMode to eSave do begin
         displayValiable(temp_element);
      end;
      selected_menu := TElement(box_data.selectTextBox(ord(selected_menu)));
      case TElement(selected_menu) of
         eBGMMode :
            USER_SOUND := not USER_SOUND;
         eAutoMode :
            AUTO_SHOOT := not AUTO_SHOOT;
         eDelayMode :
            STATIC_DELAY := not STATIC_DELAY;
         ePlayerMode :
         case select_mode of
            player1 : select_mode := dual_mode1;
            player2 : select_mode := dual_mode2;
            dual_mode1 : select_mode := player1;
            dual_mode2 : select_mode := player2;
         end;
         ePlayer1,ePlayer2 :
         case select_mode of
            player1 : select_mode := player2;
            player2 : select_mode := player1;
            dual_mode1 : select_mode := dual_mode2;
            dual_mode2 : select_mode := dual_mode1;
         end;
         eScreenMode :
            if safe_mode < 3 then inc(safe_mode) else safe_mode := 0;
      end;
   end;

   if selected_menu <> eNull0 then setVariable := TRUE
                              else setVariable := FALSE;

   box_data.done;
end;

begin
   initHan;
end.
