Program ShitFighter;

uses
    KeyBoard, SubPro, HanSub, TMFUnit;

const
    FULL_CODE : byte = 255;
    NULL_CODE : byte = 0;

    SCREEN_X_MAX = 640;
    SCREEN_Y_MAX : word = 400;
    MAP_X_MAX    = 400;
    MAP_Y_MAX    = 8;
    TILE_X_SIZE  = 48;
    TILE_Y_SIZE  = 48;

    BACK_GROUND_LINE = 370;
    BACK_GROUND_SIZE = BACK_GROUND_LINE * (80 - TILE_X_SIZE div 4);

    VIEWPORT_X1  = TILE_X_SIZE;
    VIEWPORT_Y1  = 0;
    VIEWPORT_X2  = pred(SCREEN_X_MAX)-TILE_X_SIZE;
    VIEWPORT_Y2 : word = 399;

    FOOT_STEP    = 6;
    Y_DOWN       = 17;
    MAX_REGISTERED_FRAME = 2;
    MAX_MESSAGE  = 10;

    OBJECTS_No   = 100;
    FRIEND_No    = 2;
    ENEMY_No     = 10;

    MIN_OBJECTS  = 1;
    MAX_OBJECTS  = MIN_OBJECTS + pred(OBJECTS_No);
    MIN_FRIEND   = succ(MAX_OBJECTS);
    MAX_FRIEND   = MIN_FRIEND + pred(FRIEND_No);
    MIN_ENEMY    = succ(MAX_FRIEND);
    MAX_ENEMY    = MIN_ENEMY + pred(ENEMY_No);

    MAX_STAGE    = 5;
    MAX_LEVEL    = 3;

    evNoEvent    = 0;
    evHPUp       = 1;
    evLevelUp    = 4;
    evLevelDown  = 8;
    evSpecial    = 16;
    evHoming     = 128;

    system_timer  : longint = 0;
    start_time    : longint = 0;
    counter       : longint = 0;

    current_stage : byte = 0;

    CONFIG_FILE    : string[6] = 'CONFIG';
    TILE_DATA_FILE : string[8] = 'TILE.DAT';

type
    TTileName = (START_OF_TILE_NAME,
       t_SMgal_chip1,t_SMgal_chip2,t_SMgal_chip3,t_NeTo_chip1,t_NeTo_chip2,t_NeTo_chip3,t_energy_chip,t_special_chip,
       t_SMgal_special,t_NeTo_special,
       t_SMgal_weapon1,t_SMgal_weapon2,t_SMgal_weapon3,t_NeTo_weapon1,t_NeTo_weapon2,t_NeTo_weapon3,
       t_screw_shit,t_spit,t_worm,t_nose_wax,t_hair_wax,t_overeat,t_gas,t_shit,
       t_SMgal1,t_SMgal2,t_NeTo1,t_NeTo2,
       t_big_shit,t_teeth,t_roach,t_fly,t_nose_wax_man,t_hair_wax_man1,t_hair_wax_man2,
       t_overeat_man,t_gas_man,t_shit_fighter,
       t_shit_field,t_shit_field_sub,t_finger,t_statue,
       t_ground,t_shit_fly,t_main_title,t_SMgal_and_NeTo,t_status_bar,
                 END_OF_TILE_NAME);

    TWeapon = (START_OF_TWEAPON,
               _wMainWeapon, _wSubWeapon, _wSpecialWeapon,
               END_OF_TWEAPON);

    TMapArray = array[1..MAP_X_MAX,0..MAP_Y_MAX] of byte;

    TMap = object
        m_map_data : ^TMapArray;
        m_map_data_buffer : array[1..5] of ^TMapArray;
        m_map_absolute_x, m_map_absolute_y : integer;
        m_map_local_x, m_map_local_y : integer;
        m_end_of_map : boolean;

        constructor init;
        destructor  done;
        function    returnMap(a_x, a_y : integer) : byte;
        procedure   moveAbsoluteXY(x, y : integer);
        function    inSpace(x, y : integer) : boolean;
        function    returnGravity(x, y : integer) : integer;
        procedure   setMap(stage : integer);
    end;

    PTile = ^Ttile;
    TTile = object
        m_x_len, m_y_len, m_size : word;
        m_sprite : PBuffer;

        constructor init(x1, y1, x2, y2 : integer);
        destructor  done; virtual;
    end;

    PCharacter = ^TCharacter;
    TCharacter = object(TTile)
        m_number : TTileName;
        m_x, m_y : integer;
        m_full_color : byte;
        m_hit_point : integer;
        m_enable_fly : boolean;
        m_jump, m_max_jump : integer;
        m_is_jumping : (_not_jump, _jump_up, _jump_down);

        constructor init(number : TTileName; hit_point : integer; enable_fly : boolean);
        destructor  done; virtual;
        function    isValid : boolean; virtual;
        function    returnX : integer;
        function    returnY : integer;
        function    returnCenterX : integer;
        function    returnCenterY : integer;
        procedure   moveXY(x1, y1 : integer);
        procedure   warpXY(x, y : integer);
        procedure   displayImage; virtual;
        function    chechCrash(x1,y1,x2,y2,power : integer) : boolean;
        function    AImoving : boolean; virtual;
        procedure   jumpAction;
    end;

    PEnemy = ^TEnemy;
    TEnemy = object(TCharacter)
        m_max_frame, m_current_frame, m_delay_frame, m_frame_count : byte;
        m_auto_shoot : integer;
        m_temp_sprite : array[1..MAX_REGISTERED_FRAME] of PBuffer;

        constructor init(number : TTileName; hit_point : integer; enable_fly : boolean; max_frame, delay_frame : byte);
        destructor  done; virtual;
        procedure   displayImage; virtual;
        function    AImoving : boolean; virtual;
        procedure   shootWeapon(vx, vy : integer); virtual;
    end;

    PFriend = ^TFriend;
    TFriend = object(TEnemy)
        m_absolute_number, m_weapon_delay, m_weapon_y, m_special_weapon : integer;
        m_weapon : record
           weapon : TWeapon;
           level  : array[succ(START_OF_TWEAPON)..pred(END_OF_TWEAPON)] of byte;
        end;

        constructor init(number : TTileName; hit_point : integer; enable_fly : boolean;
                         max_frame, delay_frame : byte; absolute_number : integer);
        destructor  done; virtual;
        function    AImoving : boolean; virtual;
        procedure   shootWeapon(vx, vy : integer); virtual;
        procedure   shootSpecialWeapon;
        procedure   setLevel(level : byte);
        function    getLevel : byte;
    end;

    TAttribute = (_no_damage,_only_friend,_only_enemy,_all_character,_all_enemy,_pierce_enemy,_no_work,_vanish);
    PObject = ^TObject;
    TObject = object(TCharacter)
        m_vx, m_vy  : integer;
        m_ax, m_ay  : integer;
        m_attribute : TAttribute;
        m_event_bit : word;
        m_destination : byte;

        constructor init(number : TTileName; x, y, vx, vy, ax, ay : integer; attribute : TAttribute;
                         power : integer; enable_fly : boolean; event_bit : word);
        function    isValid : boolean; virtual;
        function    AImoving : boolean; virtual;
        procedure   setDestination(minimum, maximum : byte);
    end;

    PSprite = ^TSprite;
    TSprite = object
        m_x, m_y, m_save_x, m_save_y : integer;
        m_x_len, m_y_len : integer;
        m_sprite, m_save_sprite : PBuffer;

        constructor init(x, y : integer; pb : PBuffer);
        destructor  done;
        procedure   restoreBack;
        procedure   moveXY(x1, y1 : integer);
    end;

    PMessage = ^TMessage;
    TMessage = object
        m_message : array[1..10] of record
           m_x, m_y, m_color, m_count : integer;
           m_string : string[50];
        end;

        procedure initialize;
        procedure registerMessage(x,y,color : integer; s : string);
        procedure displayMessage;
    end;

type
    key_type = (LEFT_KEY,RIGHT_KEY,UP_KEY,DOWN_KEY,WEAPON_KEY,SPECIAL_KEY);
const
    key_data : array[MIN_FRIEND..MAX_FRIEND,LEFT_KEY..SPECIAL_KEY] of byte = (
               (_LEFT_KEY,_RIGHT_KEY,_UP_KEY,_DOWN_KEY,_CONTROL_KEY,_ALT_KEY),
               (_A_KEY,_D_KEY,_W_KEY,_S_KEY,_SHIFT_KEY,_TAB_KEY)
    );
var
    map         : ^TMap;
    objects     : array[1..MAX_ENEMY] of PCharacter;
    tile_data   : array[succ(START_OF_TILE_NAME)..pred(END_OF_TILE_NAME)] of PTile;
    back_ground : array[0..3] of ^byte;
    message     : PMessage;
    stage_message       : string[30];
    display_stage_delay : integer;


function makeEnemy(tile_number : TTileName; max_power, x, y : integer; enable_fly : boolean) : integer;
var
   i : integer;
begin
   makeEnemy := 0;
   for i := MIN_ENEMY to MAX_ENEMY do begin
      if not assigned(objects[i]) then begin
         objects[i] := new(PEnemy,init(tile_number,max_power,enable_fly,1,0));
         objects[i]^.warpXY(x-objects[i]^.m_x_len,y-objects[i]^.m_y_len);
         makeEnemy := i;
         exit;
      end;
   end;
end;

function makeObject(number : TTileName; x, y, vx, vy, ax, ay : integer; attribute : TAttribute;
                    power : integer; enable_fly : boolean; event_bit : word) : integer;
var
    i : integer;
begin
    makeObject := 0;
    for i := MIN_OBJECTS to MAX_OBJECTS do begin
       if not assigned(objects[i]) then begin
          objects[i] := new(PObject,init(number,x,y,vx,vy,ax,ay,attribute,power,enable_fly,event_bit));
          makeObject := i;
          exit;
       end;
    end;
end;

constructor TMap.init;
var
    i, j, k, stage : integer;
    s : string;
    f : text;
    fp : file;
begin
    for i := 1 to 5 do new(m_map_data_buffer[i]);

    assign(fp,'map.dat');
    {$I-}
    reset(fp,1);
    {$I+}
    if IOResult <> 0 then begin
       closeGraph;
       writeLn('File not found < MAP.DAT >');
       endTMF;
       halt;
    end;

    for i := 1 to MAX_STAGE do begin
       BlockRead(fp,m_map_data_buffer[i]^,sizeof(TMapArray));
    end;

    close(fp);

    m_map_absolute_x := 0;
    m_map_absolute_y := 3;
    m_map_local_x := 0;
    m_map_local_y := 0;
    m_end_of_map := FALSE;
end;

destructor  TMap.done;
var
    i : integer;
begin
    for i := 1 to 5 do dispose(m_map_data_buffer[i]);
end;

procedure TMap.setMap(stage : integer);
begin
    m_map_data := @m_map_data_buffer[stage]^;
    m_map_absolute_x := 0;
    m_map_absolute_y := 1;
    m_map_local_x := 0;
    m_map_local_y := 0;
    m_end_of_map := FALSE;
end;

function  TMap.returnMap;
begin
    a_x := (a_x + m_map_local_x + 8) div TILE_X_SIZE;
    a_y := (a_y + m_map_local_y) div TILE_Y_SIZE;
    returnMap := m_map_data^[m_map_absolute_x+a_x,m_map_absolute_y+a_y+safe_mode];
end;

procedure TMap.moveAbsoluteXY(x, y : integer);
var
    i, result : integer;
begin
    if m_map_absolute_x+13 >= MAP_X_MAX then begin
       m_end_of_map := TRUE;
       exit;
    end;
    m_map_local_x := m_map_local_x + x;
    m_map_local_y := m_map_local_y + y;
    while (m_map_local_x + x) < 0 do begin
       inc(m_map_local_x,TILE_X_SIZE);
       dec(m_map_absolute_x);
    end;
    while (m_map_local_x + x) >= TILE_X_SIZE do begin
       dec(m_map_local_x,TILE_X_SIZE);
       inc(m_map_absolute_x);
       result := -1;
       if m_map_absolute_x+12 < MAP_X_MAX then
       case m_map_data^[m_map_absolute_x+12,0] of
          1 : result := makeEnemy(t_fly,5,550,50,TRUE);
          2 : result := makeEnemy(t_roach,10,550,150,FALSE);
          3 : result := makeEnemy(t_big_shit,5,550,100,FALSE);
          4 : result := makeEnemy(t_teeth,10,550,150,FALSE);
          5 :
          begin
             display_stage_delay := 100;
             str(current_stage,stage_message);
             stage_message := 'STAGE '+stage_message+' BOSS : ';
             case current_stage mod 5 of
                1 :
                begin
                   result := makeEnemy(t_gas_man,100,550,10,FALSE);
                   stage_message := stage_message + 'w ';
                end;
                2 :
                begin
                   result := makeEnemy(t_nose_wax_man,200,550,10,FALSE);
                   stage_message := stage_message + 'šb ';
                end;
                3 :
                begin
                   result := makeEnemy(t_hair_wax_man2,200,550,10,FALSE);
                   stage_message := stage_message + 'q a';
                end;
                4 :
                begin
                   result := makeEnemy(t_overeat_man,300,550,10,FALSE);
                   stage_message := stage_message + 'aa ';
                end;
                0 :
                begin
                   result := makeEnemy(t_shit_fighter,500,588,10,FALSE);
                   stage_message := stage_message + 'e a';
                end;
             end;
          end;
       end;
       if result = 0 then begin
          inc(m_map_local_x,TILE_X_SIZE);
          dec(m_map_absolute_x);
          m_map_local_x := m_map_local_x - x;
          m_map_local_y := m_map_local_y - y;
          exit;
       end else if m_map_data^[m_map_absolute_x+12,0] = 5 then begin
          if USER_SOUND then begin
             endTMF;
             playTMF('Boss');
          end;
       end;
    end;
    while (m_map_local_y + y) < 0 do begin
       inc(m_map_local_y,TILE_Y_SIZE);
       dec(m_map_absolute_y);
    end;
    while (m_map_local_y + y) >= TILE_Y_SIZE do begin
       dec(m_map_local_y,TILE_y_SIZE);
       inc(m_map_absolute_y);
    end;

    for i := MIN_ENEMY to MAX_ENEMY do begin
       if assigned(objects[i]) then begin
          objects[i]^.moveXY(x,y);
          objects[i]^.moveXY(-x,-y);
       end;
    end;

    for i := MIN_FRIEND to MAX_FRIEND do begin
       if assigned(objects[i]) then begin
          objects[i]^.moveXY(x,y);
          objects[i]^.moveXY(-x,-y);
       end;
    end;
end;

function  TMap.inSpace;
begin
    inSpace := returnMap(x,y) = 0;
end;

function  TMap.returnGravity;
var
    _x, _y : integer;
begin
    _x := x;
    _y := y;
    if returnMap(_x,_y) > 0 then begin
       while returnMap(_x,_y) > 0 do dec(_y);
       inc(_y);
       returnGravity := _y - y;
    end
    else begin
       while returnMap(_x,_y) = 0 do inc(_y);
       returnGravity := _y - y;
    end;
end;

constructor TTile.init(x1, y1, x2, y2 : integer); begin end;

destructor  TTile.done;
begin
    freeMem(m_sprite,m_size);
end;

constructor TCharacter.init;
begin
    m_number := number;
    m_x_len  := tile_data[number]^.m_x_len;
    m_y_len  := tile_data[number]^.m_y_len;
    m_size   := tile_data[number]^.m_size;
    m_sprite := @tile_data[number]^.m_sprite^;
    m_x := 0; m_y := 0;
    m_full_color := 0;
    m_hit_point := hit_point;
    m_enable_fly := enable_fly;
    m_max_jump := 100; m_is_jumping := _not_jump;
end;

destructor  TCharacter.done; begin end;

function  TCharacter.isValid;
begin
    isValid := (m_hit_point > 0);
end;

function  TCharacter.returnX;
begin
    returnX := m_x;
end;

function  TCharacter.returnY;
begin
    returnY := m_y;
end;

function  TCharacter.returnCenterX;
begin
    returnCenterX := m_x + m_x_len div 2;
end;

function  TCharacter.returnCenterY;
begin
    returnCenterY := m_y + m_y_len div 2;
end;

procedure TCharacter.moveXY;
var
    adder : integer;
begin
    if x1 > 0 then adder := m_x_len else adder := 0;
    while (x1 <> 0) and (not map^.inSpace(m_x + adder + x1,m_y + y1 + m_y_len - succ(FOOT_STEP))) do begin
       if x1 > 0 then dec(x1);
       if x1 < 0 then inc(x1);
    end;
    while (x1 <> 0) and (not map^.inSpace(m_x + adder + x1,m_y + y1)) do begin
       if x1 > 0 then dec(x1);
       if x1 < 0 then inc(x1);
    end;
    while (y1 <> 0) and (not map^.inSpace(m_x + x1,m_y + y1 + m_y_len - succ(FOOT_STEP)) or
          not map^.inSpace(m_x + m_x_len + x1,m_y + y1 + m_y_len - succ(FOOT_STEP))) do begin
       if y1 > 0 then dec(y1);
       if y1 < 0 then inc(y1);
    end;
    while (y1 <> 0) and (not map^.inSpace(m_x + x1,m_y + y1) or
          not map^.inSpace(m_x + m_x_len + x1,m_y + y1)) do begin
       if y1 > 0 then dec(y1);
       if y1 < 0 then inc(y1);
    end;

    m_y := m_y + y1;
    if m_y < VIEWPORT_Y1-Y_DOWN div 2 then m_y := VIEWPORT_Y1-Y_DOWN div 2;
    if m_y + m_y_len > VIEWPORT_Y2 then m_y := VIEWPORT_Y2 - m_y_len;
    m_x := m_x + x1;
    if m_x < VIEWPORT_X1 then begin
       m_x := VIEWPORT_X1;
       y1 := 0;
       while (m_y+y1 > VIEWPORT_Y1) and (not map^.inSpace(m_x + m_x_len,m_y + y1 + m_y_len-succ(FOOT_STEP))) do dec(y1);
       while (m_y+y1 > VIEWPORT_Y1) and (not map^.inSpace(m_x + m_x_len,m_y + y1)) do inc(y1);
       m_y := m_y + y1;
    end;
    if m_x + m_x_len + 8 > VIEWPORT_X2 then m_x := VIEWPORT_X2 - m_x_len - 8;
end;

procedure TCharacter.warpXY;
begin
    if (x >= VIEWPORT_X1) and (x + m_x_len <= VIEWPORT_X2) then m_x := x;
    if (y >= VIEWPORT_Y1) and (y + m_y_len <= VIEWPORT_Y2) then m_y := y;
end;

procedure TCharacter.displayImage;
begin
    if m_y + m_y_len + Y_DOWN < SCREEN_Y_MAX then begin
       if m_full_color = 0 then
          putSprite(m_x,m_y+Y_DOWN,m_sprite^,TRUE)
       else
          putSprite(m_x,m_y+Y_DOWN,m_sprite^,FALSE);
    end;
    if m_full_color > 0 then dec(m_full_color);
end;

function  TCharacter.chechCrash;
var
    return : boolean;
begin
    return := ((x1 >= m_x) and (x1 < m_x+m_x_len) and
              (y1 >= m_y) and (y1 < m_y+m_y_len)) or
              ((x2 >= m_x) and (x2 < m_x+m_x_len) and
              (y2 >= m_y) and (y2 < m_y+m_y_len));
    if return then begin
       m_full_color := 1;
       dec(m_hit_point,power);
    end;
    chechCrash := return;
end;

function  TCharacter.AImoving; begin AImoving := TRUE end;

procedure TCharacter.jumpAction;
var
    test1, test2 : integer;
    TEMP_FOOT_STEP : integer;
begin
    if m_enable_fly then exit;

    if typeof(Self) = typeof(TFriend) then begin
       TEMP_FOOT_STEP := FOOT_STEP;
    end else begin
       TEMP_FOOT_STEP := 0;
    end;
    if m_is_jumping <> _not_jump then begin
       case m_is_jumping of
          _jump_up   :
          begin
             m_y := m_y - m_jump * 2;
             while (not map^.inSpace(m_x,m_y) or
                not map^.inSpace(m_x + m_x_len,m_y)) do begin
                inc(m_y);
                m_is_jumping := _jump_down;
             end;
             dec(m_jump);
             if m_jump <= 0 then begin
                m_is_jumping := _jump_down;
             end;
          end;
          _jump_down :
          begin
             m_y := m_y + m_jump * 2;
             inc(m_jump);
             if m_jump > 20 then m_jump := 20;
             test1 := map^.returnGravity(m_x,m_y+m_y_len-TEMP_FOOT_STEP);
             test2 := map^.returnGravity(m_x+m_x_len,m_y+m_y_len-TEMP_FOOT_STEP);
             if (test1 <= 0) or (test2 <= 0) then begin
                m_is_jumping := _not_jump;
                if test1 <= 0 then m_y := m_y + test1
                              else m_y := m_y + test2;
             end;
             if m_y + m_y_len >= VIEWPORT_Y2 - FOOT_STEP -3 then begin
                if typeof(Self) = typeof(TFriend) then begin
                   m_y := VIEWPORT_Y1;
                end;
             end;
          end;
       end;
    end else begin
       test1 := map^.returnGravity(m_x,m_y+m_y_len-TEMP_FOOT_STEP);
       test2 := map^.returnGravity(m_x+m_x_len,m_y+m_y_len-TEMP_FOOT_STEP);
       if (test1 > 0) and (test2 > 0) then begin
          m_is_jumping := _jump_down;
          m_jump := 1;
       end;
    end;
end;

constructor TEnemy.init;
var
    i : integer;
begin
    inherited init(number, hit_point, enable_fly);
    for i := 0 to pred(max_frame) do begin
       m_temp_sprite[i+1] := @tile_data[TTileName(ord(number)+i)]^.m_sprite^;
    end;
    m_max_frame := max_frame;
    m_current_frame := 1;
    m_delay_frame := delay_frame;
    m_frame_count := 0;
    m_auto_shoot := 0;
end;

destructor TEnemy.done;
var
    number : integer;
    TN : TTileName;
begin
    if m_x <= VIEWPORT_X1 then exit;
    if random(4) = 0 then begin
       number := 0;
       case random(12) of
          0 : TN := t_SMgal_chip1;
          1 : TN := t_SMgal_chip2;
          2 : TN := t_SMgal_chip3;
          3 : TN := t_NeTo_chip1;
          4 : TN := t_NeTo_chip2;
          5 : TN := t_NeTo_chip3;
          6..9 : TN := t_energy_chip;
          10..11 : TN := t_special_chip;
       end;
       if TN = t_energy_chip then begin
          number := makeObject(TN,m_x,m_y,-8,0,0,0,_no_damage,-10,FALSE,evHPUp);
       end else if TN = t_special_chip then begin
          if random(2) = 0 then begin
             number := makeObject(t_special_chip,m_x,m_y,-8,0,0,0,_no_damage,0,FALSE,evSpecial);
          end else begin
             makeObject(t_special_chip,m_x,m_y,-8,0,0,0,_no_damage,0,TRUE,evSpecial);
          end;
       end else begin
          if TN in [t_SMgal_chip1..t_SMgal_chip3] then
             number := makeObject(TN,m_x,m_y,-8,0,0,0,_no_damage,ord(TN),FALSE,evLevelUp)
          else
             makeObject(TN,m_x,m_y,-8,0,0,0,_no_damage,ord(TN),TRUE,evLevelUp);
       end;
       if number > 0 then begin
          with objects[number]^ do begin
             m_is_jumping := _jump_up;
             m_jump := 3;
             m_max_jump := 12;
          end;
       end;
    end else begin
       makeObject(TTileName(ord(m_number)),m_x,m_y,0,-7,0,3,_no_work,0,TRUE,evNoEvent);
    end;
end;

procedure TEnemy.displayImage;
begin
    if m_max_frame > 0 then begin
       if m_delay_frame > 0 then begin
          inc(m_frame_count);
          if m_frame_count > m_delay_frame then begin
             m_frame_count := 0;
             inc(m_current_frame);
             if m_current_frame > MAX_REGISTERED_FRAME then m_current_frame := 1;
             m_sprite := m_temp_sprite[m_current_frame];
          end;
       end;
    end;
    inherited displayImage;
end;

function TEnemy.AImoving;

 procedure moveRandom;
 begin
    if m_enable_fly then begin
       moveXY((random(3)-1)*8,(random(3)-1)*8);
    end
    else begin
       moveXY((random(4)-1)*8,0);
       if random(10) = 0 then
       if m_is_jumping = _not_jump then begin
          m_is_jumping := _jump_up;
          m_jump := random(5)+6;
       end;
    end;
 end;

begin
    AImoving := TRUE;
    case m_number of
       t_big_shit, t_teeth :
       case current_stage of
          1 : begin end;
          2..5 :
          begin
             if current_stage > 3 then moveXY((random(4)-1)*8,0);
             if m_is_jumping = _not_jump then begin
                m_is_jumping := _jump_up;
                m_jump := random(current_stage*2)+6;
             end;
          end;
       end;
       t_roach :
       begin
          moveXY(-8,0);
          if current_stage > 1 then begin
             if m_is_jumping = _not_jump then begin
                m_is_jumping := _jump_up;
                m_jump := random(current_stage*2)+6;
             end;
          end;
       end;
       t_fly :
       begin
          if current_stage = 1 then begin
             moveXY(-16,0);
          end else if current_stage = 5 then begin
             moveXY(-8,0);
          end else begin
             moveXY(-2,(random(2)*2-1)*8);
          end;
       end;
       t_gas_man, t_nose_wax_man, t_overeat_man :
       begin
          if random(5) = 0 then moveRandom;
       end;
       t_hair_wax_man2 :
       begin
          if m_auto_shoot = 0 then moveRandom;
       end;
       t_shit_fighter :
       begin
          moveXY(8,0);
          if random(10) = 0 then
          if m_is_jumping = _not_jump then begin
             m_is_jumping := _jump_up;
             m_jump := random(5)+6;
          end;
       end;
    end;
    shootWeapon(0,0);
    if m_x <= VIEWPORT_X1 then AImoving := FALSE;
end;

procedure TEnemy.shootWeapon;
var
    i, j, k : integer;
    divide : real;
begin
    case m_number of
       t_big_shit :
       begin
          if random(10) = 0 then begin
             if current_stage > 3 then k := 2 else k := 1;
             while k > 0 do begin
                i := -16; j := -16;
                case current_stage of
                   2,4 : begin i := -16 + random(9) - 4 end;
                   3,5 : begin i := -16 + random(9) - 4; j := -16 + random(9) - 4 end;
                end;
                makeObject(t_screw_shit,m_x,m_y,i,j,0,2,_only_friend,1,TRUE,evNoEvent);
                dec(k);
             end;
          end;
       end;
       t_roach :
       begin
          if random((6-current_stage)*10) = 0 then
          makeObject(t_gas,m_x,m_y + 20,-16,-random(3)*8,0,0,_only_friend,1,TRUE,evNoEvent);
       end;
       t_fly :
       begin
          if random(10) = 0 then
          case current_stage of
             1..2 : makeObject(t_worm,m_x,m_y+20,-(random(3)+1)*8,8,0,0,_only_friend,1,TRUE,evNoEvent);
             3,5 :
             begin
                if random(5) = 0 then begin
                   k := makeObject(t_worm,m_x,m_y,-8,0,0,0,_no_damage,2,FALSE,evHPUp);
                   if k > 0 then begin
                      with objects[k]^ do begin
                         m_is_jumping := _jump_up;
                         m_jump := 5;
                         m_max_jump := 20;
                      end;
                   end;
                end;
                if current_stage = 5 then begin
                   makeObject(t_worm,m_x,m_y+10,-(random(3)+1)*8,8,0,0,_only_friend,1,TRUE,evNoEvent);
                   makeObject(t_worm,m_x,m_y+10,-(random(3)+1)*8,random(2)*8,0,0,_only_friend,1,TRUE,evNoEvent);
                end;
             end;
             4 :
             begin
                makeObject(t_worm,m_x,m_y+10,-(random(3)+1)*8,8,0,0,_only_friend,1,TRUE,evNoEvent);
                makeObject(t_worm,m_x,m_y+10,-(random(3)+1)*8,random(2)*8,0,0,_only_friend,1,TRUE,evNoEvent);
             end;
          end;
       end;
       t_teeth :
       begin
          if random(20) = 0 then begin
             makeObject(t_spit,m_x,m_y+5,-16,0,0,0,_only_friend,1,TRUE,evNoEvent);
             if current_stage > 2 then begin
                makeObject(t_spit,m_x,m_y+5,-16,-16,0,0,_only_friend,1,TRUE,evNoEvent);
             end;
             if current_stage > 4 then begin
                makeObject(t_spit,m_x,m_y+5,-16,-8,0,0,_only_friend,1,TRUE,evNoEvent);
             end;
          end;
       end;
       t_gas_man :
       begin
          if random(10) = 0 then begin
             for k := MIN_FRIEND to MAX_FRIEND do begin
                if assigned(objects[k]) then begin
                   i := objects[k]^.returnCenterX - returnX;
                   j := objects[k]^.returnY - returnY;
                   divide := sqrt(longint(i)*i+longint(j)*j) / 16;
                   makeObject(t_gas,m_x,m_y+20,round(i/divide),round(j/divide),0,0,_only_friend,1,TRUE,evNoEvent);
                   exit;
                end;
             end;
          end;
       end;
       t_nose_wax_man:
       begin
          if random(10) = 0 then begin
             i := -16 + random(9) - 4;
             j := -16 + random(9) - 4;
             k := random(3)+1;
             makeObject(t_nose_wax,m_x,m_y,i,j,0,k,_only_friend,1,TRUE,evNoEvent);
          end;
          if random(20) = 0 then begin
             makeObject(t_nose_wax,m_x,m_y+5,-16,-16,0,0,_only_friend,1,TRUE,evNoEvent);
             makeObject(t_nose_wax,m_x,m_y+5,-16,-8,0,0,_only_friend,1,TRUE,evNoEvent);
             makeObject(t_nose_wax,m_x,m_y+5,-16,-0,0,0,_only_friend,1,TRUE,evNoEvent);
          end;
       end;
       t_hair_wax_man2 :
       begin
          if m_auto_shoot > 0 then begin
             dec(m_auto_shoot);
             if random(7) = 0 then begin
                makeObject(t_hair_wax,m_x,m_y+5,-(random(3)+1)*8,random(33)-16,0,0,_only_friend,1,TRUE,evNoEvent);
                makeObject(t_hair_wax,m_x,m_y+5,-(random(3)+1)*8,random(33)-16,0,0,_only_friend,1,TRUE,evNoEvent);
                makeObject(t_hair_wax,m_x,m_y+5,-(random(3)+1)*8,random(33)-16,0,0,_only_friend,1,TRUE,evNoEvent);
                makeObject(t_hair_wax,m_x,m_y+5,-(random(3)+1)*8,random(33)-16,0,0,_only_friend,1,TRUE,evNoEvent);
                makeObject(t_hair_wax,m_x,m_y+5,-(random(3)+1)*8,random(33)-16,0,0,_only_friend,1,TRUE,evNoEvent);
             end;
             if m_auto_shoot = 0 then begin
                m_sprite := @tile_data[m_number]^.m_sprite^;
             end;
          end else begin
             if random(150) = 0 then begin
                m_auto_shoot := 70;
                m_sprite := @tile_data[pred(m_number)]^.m_sprite^;
             end else if random(10) = 0 then begin
                for k := MIN_FRIEND to MAX_FRIEND do begin
                   if assigned(objects[k]) then begin
                      i := objects[k]^.returnCenterX - returnX;
                      j := objects[k]^.returnY - returnY;
                      divide := sqrt(longint(i)*i+longint(j)*j) / 16;
                      makeObject(t_hair_wax,m_x,m_y+20,round(i/divide),round(j/divide),0,0,_only_friend,1,TRUE,evNoEvent);
                      exit;
                   end;
                end;
             end;
          end;
       end;
       t_overeat_man :
       begin
          if m_auto_shoot > 0 then begin
             dec(m_auto_shoot);
             makeObject(t_overeat,m_x,m_y+5,-16,-16,0,0,_only_friend,1,TRUE,evNoEvent);
             makeObject(t_overeat,m_x,m_y+5,-16,-8,0,0,_only_friend,1,TRUE,evNoEvent);
             makeObject(t_overeat,m_x,m_y+5,-16,-0,0,0,_only_friend,1,TRUE,evNoEvent);
          end else begin
             if random(200) = 0 then begin
                m_auto_shoot := 10;
             end;
             if random(7) = 0 then begin
                for k := MIN_FRIEND to MAX_FRIEND do begin
                   if assigned(objects[k]) then begin
                      i := objects[k]^.returnCenterX - returnX;
                      j := objects[k]^.returnY - returnY;
                      divide := sqrt(longint(i)*i+longint(j)*j) / 16;
                      makeObject(t_overeat,m_x,m_y+20,round(i/divide),round(j/divide),0,0,_only_friend,1,TRUE,evNoEvent);
                      exit;
                   end;
                end;
             end;
             if random(10) = 0 then begin
                k := makeObject(t_overeat,m_x,m_y,-8,0,0,0,_no_damage,2,FALSE,evHPUp);
                if k > 0 then begin
                   with objects[k]^ do begin
                      m_is_jumping := _jump_up;
                      m_jump := 5;
                      m_max_jump := 20;
                   end;
                end;
             end;
          end;
       end;
       t_shit_fighter :
       begin
          if random(10) = 0 then begin
             if random(2) = 0 then
                makeEnemy(t_big_shit,5,m_x+50,m_y+20,FALSE)
             else
                makeEnemy(t_fly,5,500,50,TRUE);
          end;
          if random(10) = 0 then begin
             makeObject(t_shit,m_x,m_y+5,-(random(3)+1)*8,random(33)-16,0,0,_only_friend,1,TRUE,evNoEvent);
             makeObject(t_shit,m_x,m_y+5,-(random(3)+1)*8,random(33)-16,0,0,_only_friend,1,TRUE,evNoEvent);
             makeObject(t_shit,m_x,m_y+5,-(random(3)+1)*8,random(33)-16,0,0,_only_friend,1,TRUE,evNoEvent);
             makeObject(t_shit,m_x,m_y+5,-(random(3)+1)*8,random(33)-16,0,0,_only_friend,1,TRUE,evNoEvent);
             makeObject(t_shit,m_x,m_y+5,-(random(3)+1)*8,random(33)-16,0,0,_only_friend,1,TRUE,evNoEvent);
          end;
          if random(30) = 0 then begin
             k := makeObject(t_worm,m_x,m_y,-8,0,0,0,_no_damage,2,FALSE,evHPUp);
             if k > 0 then begin
                with objects[k]^ do begin
                   m_is_jumping := _jump_up;
                   m_jump := 5;
                   m_max_jump := 20;
                end;
             end;
          end;
       end;
    end;
end;

constructor TFriend.init;
var
    TW : TWeapon;
begin
    inherited init(number,hit_point,enable_fly,max_frame,delay_frame);
    m_weapon_delay := 0;
    m_weapon_y := 0;
    m_weapon.weapon := _wMainWeapon;
    for TW := succ(START_OF_TWEAPON) to pred(END_OF_TWEAPON) do m_weapon.level[TW] := 1;
    m_absolute_number := absolute_number;
    m_special_weapon := 3;
end;

destructor TFriend.done; begin end;

function TFriend.AImoving;
begin
    AImoving := TRUE;
    if key_data[m_absolute_number][LEFT_KEY]   in scan_code then moveXY(-16,0);
    if key_data[m_absolute_number][RIGHT_KEY]  in scan_code then moveXY(  8,0);
    if key_data[m_absolute_number][UP_KEY]     in scan_code then begin
       if m_enable_fly then begin
          moveXY(0,-8);
       end else begin
          if m_is_jumping = _not_jump then begin
             m_is_jumping := _jump_up;
             m_jump := 10;
          end;
       end;
    end;
    if key_data[m_absolute_number][DOWN_KEY]   in scan_code then begin
       if m_enable_fly then begin
          moveXY(0,8);
       end else begin
          if m_is_jumping = _jump_up then begin
             m_is_jumping := _jump_down;
          end else moveXY(-8,0);
       end
    end;
    if m_auto_shoot > 0 then shootSpecialWeapon;
    if AUTO_SHOOT or (key_data[m_absolute_number][WEAPON_KEY] in scan_code) then shootWeapon(0,0);
    if key_data[m_absolute_number][SPECIAL_KEY] in ascii_code then begin
       if m_special_weapon > 0 then begin
          inc(m_auto_shoot,50);
          dec(m_special_weapon);
       end;
       ascii_code := ascii_code - [key_data[m_absolute_number][SPECIAL_KEY]];
    end;
    if _PLUS_KEY in ascii_code then begin
       dec(m_hit_point);
       ascii_code := ascii_code - [_PLUS_KEY];
    end;
end;

procedure TFriend.shootWeapon;
const
    table : array[0..4,1..4] of shortint = (
            (16,0,0,0), (12,-16,0,1), (12,16,0,-1), (0,-16,1,1), (0,16,1,-1)
    );
var
    i, j, k, m : integer;
    divide : real;
begin
    dec(m_weapon_delay);
    if m_weapon_delay > 0 then exit;
    if m_number = t_NeTo1 then
    case m_weapon.weapon of
       _wMainWeapon :
       begin
          for j := 0 to getLevel*2-2 do begin
             makeObject(t_NeTo_weapon2,m_x+40,m_y+32,table[j,1],table[j,2],table[j,3],table[j,4],_only_enemy,1,TRUE,evNoEvent);
          end;
          m_weapon_delay := succ(getLevel);
       end;
       _wSubWeapon :
       begin
          m := 0;
          for k := MIN_ENEMY to MAX_ENEMY do begin
             if assigned(objects[k]) then inc(m);
          end;
          if m > 0 then begin
             m := succ(random(m));
             i := 0;
             for k := MIN_ENEMY to MAX_ENEMY do begin
                if assigned(objects[k]) then inc(i);
                if i = m then break;
             end;
             if assigned(objects[k]) then begin
                i := objects[k]^.returnCenterX - returnCenterX;
                j := objects[k]^.returnCenterY - returnCenterY;
                divide := sqrt(longint(i)*i+longint(j)*j) / 16;
                i := round(i/divide);
                j := round(j/divide);
                if (abs(i) > abs(j)) and (i > 0) then begin
                   makeObject(t_NeTo_weapon1,m_x+40,m_y+32,i,j,0,0,_only_enemy,1,TRUE,evNoEvent);
                end else begin
                   makeObject(t_NeTo_weapon1,m_x+40,m_y+32,32,0,0,0,_only_enemy,1,TRUE,evNoEvent);
                end;
                m_weapon_delay := 2 + (2 - getLevel);
             end;
          end
          else begin
             makeObject(t_NeTo_weapon1,m_x+40,m_y+32,32,0,0,0,_only_enemy,1,TRUE,evNoEvent);
             m_weapon_delay := 2;
          end;
       end;
       _wSpecialWeapon :
       begin
          if key_data[m_absolute_number][UP_KEY] in scan_code then begin
             if m_weapon_y < 16 then inc(m_weapon_y,2);
          end
          else if key_data[m_absolute_number][DOWN_KEY] in scan_code then begin
             if m_weapon_y > -16 then dec(m_weapon_y,2);
          end
          else begin
             if m_weapon_y > 0 then dec(m_weapon_y,2);
             if m_weapon_y < 0 then inc(m_weapon_y,2);
          end;
          if getLevel <= 3 then begin
             makeObject(t_NeTo_weapon3,m_x+40,m_y+32,16,m_weapon_y,0,0,_pierce_enemy,1,TRUE,evNoEvent);
          end else begin
             makeObject(t_NeTo_weapon3,m_x+40,m_y+32,16,m_weapon_y+random(5)-2,0,0,_pierce_enemy,1,TRUE,evNoEvent);
          end;
          m_weapon_delay := 3 + (2 - getLevel);
       end;
    end else case m_weapon.weapon of
       _wMainWeapon :
       begin
          if m_weapon_y <> 0 then m_weapon_y := 0 else m_weapon_y := 12;
          makeObject(t_SMgal_weapon1,m_x+16,m_y+2+m_weapon_y,16,0,0,0,_only_enemy,1,TRUE,evNoEvent);
          m_weapon_delay := 2 + (2 - m_weapon.level[m_weapon.weapon]);
       end;
       _wSubWeapon  :
       begin
          for j := 1 to getLevel do begin
             k := -8 * pred(j);
             makeObject(t_SMgal_weapon2,m_x+16,m_y+10,16,k,0,0,_only_enemy,1,TRUE,evNoEvent);
          end;
          m_weapon_delay := 3;
       end;
       _wSpecialWeapon :
       begin
          makeObject(t_SMgal_weapon3,m_x+16,m_y+10,24,0,0,0,_pierce_enemy,getLevel,TRUE,evNoEvent);
          m_weapon_delay := 4;
       end;
    end;
end;

procedure TFriend.shootSpecialWeapon;
const
    data_table : array[1..4,1..2] of shortint = (
       (-8,-8), (0,-8), (8,-8), (8,0)
    );
var
    i, number : byte;
    temp_object : PObject;
begin
    dec(m_auto_shoot);
    if m_auto_shoot < 0 then begin
       m_auto_shoot := 0;
       exit;
    end;
    if m_number = t_NeTo1 then begin
       if m_auto_shoot < 50 then begin
          makeObject(t_NeTo_special,m_x+16,m_y+5,(random(3)+1)*8,random(33)-16,0,0,_only_enemy,1,TRUE,evNoEvent);
          makeObject(t_NeTo_special,m_x+16,m_y+5,(random(3)+1)*8,random(33)-16,0,0,_only_enemy,1,TRUE,evNoEvent);
       end else begin
          makeObject(t_NeTo_weapon3,m_x+40,m_y+32,succ(random(2))*16,random(11)-5,0,0,_pierce_enemy,1,TRUE,evNoEvent);
          makeObject(t_NeTo_weapon3,m_x+40,m_y+32,succ(random(2))*16,random(11)-5,0,0,_pierce_enemy,1,TRUE,evNoEvent);
       end;
    end else begin
       if m_auto_shoot mod 4 = 0 then begin
          for i := 1 to 4 do begin
             number := makeObject(t_SMgal_special,m_x+16,m_y+5,data_table[i,1],data_table[i,2],0,0,_all_enemy,1,TRUE,evHoming);
             temp_object := PObject(objects[number]);
             temp_object^.setDestination(MIN_ENEMY,MAX_ENEMY);
          end;
       end;
    end;
end;

procedure TFriend.setLevel;
begin
    if level in [1..MAX_LEVEL] then m_weapon.level[m_weapon.weapon] := level;
end;

function  TFriend.getLevel;
begin
    getLevel := m_weapon.level[m_weapon.weapon];
end;

constructor TObject.init;
begin
    inherited init(number,power,enable_fly);
    if (vx <> 0) or (vy <> 0) or (ax <> 0) or (ay <> 0) then begin
       m_x := x; m_y := y;
       m_vx := vx; m_vy := vy;
       m_ax := ax; m_ay := ay;
       m_attribute := attribute;
       m_event_bit := event_bit;
       m_destination := 0;
    end else begin
       m_x := -1;
    end;
end;

function  TObject.isValid;
begin
    if m_attribute <> _vanish then begin
       if (m_x < VIEWPORT_X1) or (m_x + m_x_len > VIEWPORT_X2) or
          (m_y < VIEWPORT_Y1) or (m_y + m_y_len > VIEWPORT_Y2) then
          isValid := FALSE
       else
          isValid := TRUE;
    end else begin
       if m_hit_point > 0 then begin
          dec(m_hit_point);
          isValid := TRUE;
       end else begin
          isValid := FALSE;
       end;
    end;
end;

function TObject.AImoving;
var
   i, j : integer;
   divide : real;
   temp_friend : PFriend;
   temp_object : PObject;

 procedure moveSub;
 begin
    m_x := m_x + m_vx;
    m_y := m_y + m_vy;
    m_vx := m_vx + m_ax;
    m_vy := m_vy + m_ay;
 end;

begin
    AImoving := TRUE;
    if m_attribute in [_no_damage,_only_friend,_all_character] then begin
       for i := MIN_FRIEND to MAX_FRIEND do begin
          temp_friend := PFriend(objects[i]);
          if assigned(temp_friend) then
          if temp_friend^.chechCrash(m_x,m_y,pred(m_x+m_x_len),pred(m_y+m_y_len),m_hit_point) then begin
             if m_attribute in [_no_damage] then begin
                if m_event_bit and evHPUp > 0 then begin
                   if m_hit_point < 0 then message^.registerMessage(m_x,m_y,11,'Aỡ wa');
                end;
                if m_event_bit and evLevelUp > 0 then begin
                   j := 0;
                   if temp_friend^.m_number = t_NeTo1 then begin
                      if TTileName(m_hit_point) in [t_NeTo_chip1..t_NeTo_chip3] then begin
                         j := succ(m_hit_point - ord(t_NeTo_chip1));
                      end;
                   end else begin
                      if TTileName(m_hit_point) in [t_SMgal_chip1..t_SMgal_chip3] then begin
                         j := succ(m_hit_point - ord(t_SMgal_chip1));
                      end;
                   end;
                   if j > 0 then begin
                      if temp_friend^.m_weapon.weapon = TWeapon(j) then begin
                         temp_friend^.setLevel(succ(temp_friend^.getLevel));
                         message^.registerMessage(m_x,m_y,11,'AI  !!');
                      end else begin
                         temp_friend^.m_weapon.weapon := TWeapon(j);
                         message^.registerMessage(m_x,m_y,11,'ae ');
                      end;
                   end;
                end;
                if m_event_bit and evSpecial > 0 then begin
                   inc(temp_friend^.m_special_weapon);
                   message^.registerMessage(m_x,m_y,11,'b  wa');
                end;
             end;
             m_x := -1;
             exit;
          end;
       end;
    end;
    if m_attribute in [_only_enemy,_all_character,_all_enemy,_pierce_enemy] then begin
       for i := MIN_ENEMY to MAX_ENEMY do begin
          if assigned(objects[i]) then
          if objects[i]^.chechCrash(m_x,m_y,pred(m_x+m_x_len),pred(m_y+m_y_len),m_hit_point) then begin
             if m_attribute in [_pierce_enemy] then moveSub else begin
                makeObject(t_SMgal_special,m_x,m_y,-(random(2)+1)*8,random(7)-2,0,0,_vanish,10,TRUE,evNoEvent);
                m_x := -1;
             end;
             exit;
          end;
       end;
    end;
    if m_attribute in [_all_enemy,_pierce_enemy] then begin
       for i := MIN_OBJECTS to MAX_OBJECTS do begin
          if assigned(objects[i]) then begin
             temp_object := PObject(objects[i]);
             if temp_object^.m_attribute in [_only_friend, _all_character] then begin
                if temp_object^.chechCrash(m_x,m_y,pred(m_x+m_x_len),pred(m_y+m_y_len),m_hit_point) then begin
                   temp_object^.m_x := -1;
                   exit;
                end;
             end;
          end;
       end;
    end;
    if m_event_bit and evHoming > 0 then begin
       if m_destination in [1..MAX_ENEMY] then begin
          if assigned(objects[m_destination]) then begin
             i := objects[m_destination]^.returnCenterX - returnX;
             j := objects[m_destination]^.returnY - returnY;
             divide := sqrt(longint(i)*i+longint(j)*j) / 4;
             if divide <> 0.0 then begin
                m_ax := round(i/divide);
                m_ay := round(j/divide);
                if m_vx + m_ax > 16 then m_ax := 16 - m_vx;
                if m_vy + m_ay > 16 then m_ay := 16 - m_vy;
                if m_vx + m_ax < -16 then m_ax := -16 - m_vx;
                if m_vy + m_ay < -16 then m_ay := -16 - m_vy;
             end;
          end else begin
             m_ax := 0; m_ay := 0;
             m_destination := 0;
             dec(m_event_bit,evHoming);
          end;
       end else begin
          m_ax := 0; m_ay := 0;
          m_destination := 0;
          dec(m_event_bit,evHoming);
       end;
    end;
    moveSub;
end;

procedure TObject.setDestination;
var
    i, number, magic : integer;
begin
    number := 0;
    for i := minimum to maximum do begin
       if assigned(objects[i]) then inc(number);
    end;
    if number > 0 then begin
       magic := succ(random(number));
       number := 0;
       for i := minimum to maximum do begin
          if assigned(objects[i]) then inc(number);
          if number = magic then begin
             m_destination := i;
             exit;
          end;
       end;
    end else m_destination := 0;
end;

constructor TSprite.init(x, y : integer; pb : PBuffer);
begin
    m_x := x; m_y := y;
    m_x_len := pb^[0] + pb^[1] * 256;
    m_y_len := pb^[2] + pb^[3] * 256;
    m_sprite := pb;
    m_save_x := (m_x div 8) * 8;
    m_save_y := m_y;
    getMem(m_save_sprite,getImageSize(m_save_x,m_y,(m_x+m_x_len+8) div 8 * 8,m_y+m_y_len));
    getImage(m_save_x,m_save_y,(m_x+m_x_len+8) div 8 * 8,m_y+m_y_len,m_save_sprite^);
    putSprite(m_x,m_y,m_sprite^,TRUE);
end;

destructor TSprite.done;
begin
    putImage(m_save_x,m_save_y,m_save_sprite^);
    freeMem(m_save_sprite,getImageSize((m_x div 8) * 8,m_y,(m_x+m_x_len+8) div 8 * 8,m_y+m_y_len));
end;

procedure TSprite.restoreBack;
begin
    putImage(m_save_x,m_save_y,m_save_sprite^);
end;

procedure TSprite.moveXY(x1, y1 : integer);
begin
    m_x := m_x + x1;
    m_y := m_y + y1;
    m_save_x := (m_x div 8) * 8;
    m_save_y := m_y;
    getImage(m_save_x,m_save_y,(m_x+m_x_len+8) div 8 * 8,m_y+m_y_len,m_save_sprite^);
    putSprite(m_x,m_y,m_sprite^,TRUE);
end;

procedure TMessage.initialize;
var
    i : integer;
begin
    for i := 1 to MAX_MESSAGE do begin
       m_message[i].m_string := '';
    end;
end;

procedure TMessage.registerMessage(x,y,color : integer; s : string);
var
    i : integer;
begin
    for i := 1 to MAX_MESSAGE do begin
       with m_message[i] do begin
          if m_string = '' then begin
             m_x := x;
             m_y := y;
             m_color := color;
             m_count := 0;
             m_string := s;
             exit;
          end;
       end;
    end;
end;

procedure TMessage.displayMessage;
var
    i : integer;
begin
    for i := 1 to MAX_MESSAGE do begin
       with m_message[i] do begin
          if m_string <> '' then begin
             inc(m_count);
             if (m_count > 40) or (m_x < VIEWPORT_X1) or (m_y < VIEWPORT_Y1) or
                (m_x + length(m_string)*8 > VIEWPORT_X2) then begin
                m_string := '';
             end else
                printHangul(m_x,m_y-m_count div 2,m_string,m_color);
          end;
       end;
    end;
end;

function getCurrentTime : longint;
var
    temp_longint : longint;
    minute, second, sec100 : word;
begin
    asm
       mov  ah, 2Ch
       int  21h
       xor  ah, ah
       mov  al, DL
       mov  sec100, ax
       mov  al, Dh
       mov  second, ax
       mov  al, CL
       mov  minute, ax
   end;
   temp_longint := longint(minute * 60 + second) * 100 + sec100;
   getCurrentTime := temp_longint;
end;

procedure loadConfig;
var
    f : file;
begin
    assign(f,CONFIG_FILE);
    {$I-}
    reset(f,1);
    {$I+}
    if IOResult = 0 then begin
       BlockRead(f,AUTO_SHOOT  ,sizeof(AUTO_SHOOT) );
       BlockRead(f,STATIC_DELAY,sizeof(STATIC_DELAY));
       BlockRead(f,player_mode ,sizeof(player_mode));
       BlockRead(f,safe_mode   ,sizeof(safe_mode));
       close(f);
    end;
end;

procedure saveConfig;
var
    f : file;
begin
    assign(f,CONFIG_FILE);
    rewrite(f,1);
    BlockWrite(f,AUTO_SHOOT  ,sizeof(AUTO_SHOOT));
    BlockWrite(f,STATIC_DELAY,sizeof(STATIC_DELAY));
    BlockWrite(f,player_mode ,sizeof(player_mode));
    BlockWrite(f,safe_mode   ,sizeof(safe_mode));
    close(f);
end;

procedure displayBadEnding;
var
    i : integer;
    c : char;
    finger : PSprite;
begin
    asm mov ax, 12h; int 10h end;
    VIDEO_SEGMENT := $A000;

    for i := 0 to 15 do begin
       setPalette(i);
       setRGB(i,palette_data[i,1],palette_data[i,2],palette_data[i,3]);
    end;
    putImage(296,353+27,tile_data[t_shit_field]^.m_sprite^);
    new(finger,init(492,351+27,tile_data[t_finger]^.m_sprite));
    finger^.restoreBack;
    finger^.moveXY(0,0);
    putSprite(480,407+27,tile_data[t_shit_field_sub]^.m_sprite^,TRUE);
    HanSub.displayBadEnding;
    for i := 1 to 60 do begin
       finger^.restoreBack;
       finger^.moveXY(0,1);
       putSprite(480,407+27,tile_data[t_shit_field_sub]^.m_sprite^,TRUE);
       waitVerticalRetrace(10);
       dec(finger^.m_sprite^[2]);
       if pressedKey then begin
          c := readKey;
          if c = #27 then break;
       end;
    end;
    dispose(finger,done);
end;

procedure displayHappyEnding;
begin
    HanSub.displayHappyEnding;
    intensifyOut(1,palette_data);
    VIDEO_SEGMENT := $A800;
    clearDevice;
    VIDEO_SEGMENT := $A000;
    clearDevice;
    putImage(268,160,tile_data[t_statue]^.m_sprite^);
    palette_data[15,1] := 64;
    palette_data[15,2] := 67;
    palette_data[15,3] := 77;
    palette_data[14,1] := 80;
    palette_data[14,2] := 81;
    palette_data[14,3] := 85;
    intensifyin(1,palette_data);
    readKey;
end;

function displayTitle : boolean;
label
    MID_POSITION;
const
    UP_KEY   = 256 + 72;
    DOWN_KEY = 256 + 80;

    MAX_MENU = 4;
    menu_data : array[1..MAX_MENU] of string[18] = (
       ' Ae  ???',
       'aɡi i ',
       'Ai bЁ a',
       'e Ё a'
    );
    selected_menu : byte = 1;

    title_table : array[1..6,0..2] of byte = (
       (13,179,79), (13,179,81), (13,181,79),
       (13,181,81), ( 7,182,82), (15,180,80)
    );

 procedure printMenu;
 var
    i, j : integer;
 begin
    for i := 1 to MAX_MENU do begin
       if i = selected_menu then j := 10 else j := 2;
       printHangul(242,301+pred(i)*18,menu_data[i],j-1);
       printHangul(240,300+pred(i)*18,menu_data[i],j);
    end;
 end;

const
    MAX_FLYS = 5;
    SHIT_X   = 371;
    SHIT_Y   = 229;
var
    i, j, k, key_code : integer;
    TN : TTileName;
    temp_byte : byte;
    flys : array[1..MAX_FLYS] of PSprite;
    fly_x, fly_y : integer;
    f : file;
begin

    playTMF('Title');

    assign(f,TILE_DATA_FILE);
    {$I-}
    reset(f,1);
    {$I+}
    if IOResult <> 0 then begin
       closeGraph;
       writeLn('File not found < ',TILE_DATA_FILE,' >');
       endTMF;
       halt;
    end;
    BlockRead(f,palette_data,sizeof(palette_data));
    for TN := succ(START_OF_TILE_NAME) to pred(END_OF_TILE_NAME) do begin
       BlockRead(f,temp_byte,1);
       if temp_byte = FULL_CODE then begin
          new(tile_data[TN],init(0,0,0,0));
          with tile_data[TN]^ do begin
             BlockRead(f,m_x_len,sizeof(m_x_len));
             BlockRead(f,m_y_len,sizeof(m_y_len));
             BlockRead(f,m_size,sizeof(m_size));
             getMem(m_sprite,m_size);
             BlockRead(f,m_sprite^,m_size);
          end;
       end;
    end;
    for i := 0 to 3 do begin
       getMem(back_ground[i],BACK_GROUND_SIZE);
       BlockRead(f,back_ground[i]^,BACK_GROUND_SIZE);
    end;
    close(f);

    asm mov ax, 12h; int 10h end;

    intensifyOut(1,palette_data);
    putImage(184,153,tile_data[t_main_title]^.m_sprite^);
    putImage(264,447,tile_data[t_SMgal_and_NeTo]^.m_sprite^);

    for i := 1 to 6 do
       printHangul(title_table[i,1],title_table[i,2],
                   ' bw / b eȁ / e a',title_table[i,0]);
    printMenu;
    intensifyIn(1,palette_data);

    i := 0; j := 1;
MID_POSITION:
    for k := 1 to MAX_FLYS do new(flys[k],init(SHIT_X,SHIT_Y,tile_data[t_shit_fly]^.m_sprite));

    key_code := 0;
    while not (key_code in [13,27]) do begin
       if pressedKey then begin
          key_code := ord(readKey);
          if key_code = 0 then key_code := 256 + ord(readKey);
          case key_code of
             UP_KEY   : if selected_menu > 1 then dec(selected_menu)
                                             else selected_menu := MAX_MENU;
             DOWN_KEY : if selected_menu < MAX_MENU then inc(selected_menu)
                                             else selected_menu := 1;
          end;
          printMenu;
       end else begin
          if i > 4 then j := -1;
          if i < -4 then j := 1;
          inc(i,j);
          waitVerticalRetrace(2);
          putImage(264,447+i,tile_data[t_SMgal_and_NeTo]^.m_sprite^);
          for k := MAX_FLYS downto 1 do begin
             flys[k]^.restoreBack;
          end;
          for k := 1 to MAX_FLYS do begin
             fly_x := random(9)-4;
             fly_y := random(9)-4;
             if abs(SHIT_X-flys[k]^.m_x) > 30 then begin
                if SHIT_X > flys[k]^.m_x then fly_x := 5 else fly_x := -5;
             end;
             if abs(SHIT_Y-flys[k]^.m_y) > 30 then begin
                if SHIT_Y > flys[k]^.m_y then fly_y := 5 else fly_y := -5;
             end;
             flys[k]^.moveXY(fly_x,fly_y);
          end;
       end;
    end;
    for k := 1 to MAX_FLYS do dispose(flys[k],done);

    if key_code <> 27 then begin
       loadConfig;
       case selected_menu of
          1 :
          begin
             aboutGame;
             goto MID_POSITION;
          end;
          2 : displayStory;
          4 :
          begin
             if setVariable(DETECT_SOUND_CARD <> NOT_FOUND) then saveConfig else loadConfig;
             goto MID_POSITION;
          end;
       end;
       displayTitle := TRUE;
    end else displayTitle := FALSE;

    endTMF;

end;

procedure READY;
var
    i, j     : integer;
    c        : char;
    s        : string[1];
    TN1, TN2 : TTileName;
    temp_fly : boolean;
    f        : file;
    pb       : ^byte;
begin

    if paramcount > 0 then begin
       s := paramstr(1);
       c := s[1];
       if c in ['1'..'5'] then begin
          current_stage := ord(c) - ord('1');
       end;
    end;

    for i   := MIN_FRIEND  to MAX_FRIEND  do objects[i] := nil;
    for i   := MIN_ENEMY   to MAX_ENEMY   do objects[i] := nil;
    for i   := MIN_OBJECTS to MAX_OBJECTS do objects[i] := nil;
    for TN1 := succ(START_OF_TILE_NAME) to pred(END_OF_TILE_NAME) do tile_data[TN1] := nil;

    if not displayTitle then begin
        closeGraph; halt;
    end;

    if safe_mode <> 0 then begin
       SCREEN_Y_MAX := 350;
       VIEWPORT_Y2 := pred(SCREEN_Y_MAX);
    end;

    randomize;

    case safe_mode of
       0 : initGraph;
       1,2,3 :
       begin
          asm
             mov  ax, 0010h
             int  10h
          end;
          if safe_mode = 2 then begin
             asm
                mov  dx, 3CCh
                in   al, dx
                and  al, 00111111b
                or   al, 01000000b
                mov  dx, 3C2h
                out  dx, al
             end;
             safe_mode := 1;
          end else if safe_mode = 3 then begin
             asm
                mov  dx, 3CCh
                in   al, dx
                and  al, 00111111b
                or   al, 11000000b
                mov  dx, 3C2h
                out  dx, al
             end;
             safe_mode := 1;
          end;
       end;
    end;

    for i := 0 to 15 do begin
       setPalette(i);
       setRGB(i,palette_data[i,1],palette_data[i,2],palette_data[i,3]);
    end;

    TN1 := START_OF_TILE_NAME; TN2 := START_OF_TILE_NAME;
    case player_mode of
       player1 : TN1 := t_SMgal1;
       player2 : TN1 := t_NeTo1;
       dual_mode1 : begin TN1 := t_SMgal1; TN2 := t_NeTo1  end;
       dual_mode2 : begin TN1 := t_NeTo1;  TN2 := t_SMgal1 end;
    end;
    if TN1 > START_OF_TILE_NAME then begin
       temp_fly := (TN1 = t_NeTo1);
       if temp_fly then i := 1 else i := 5;
       objects[MIN_FRIEND] := new(PFriend,init(TN1,104,temp_fly,2,i,MIN_FRIEND));
       objects[MIN_FRIEND]^.warpXY(50,100);
    end;
    if TN2 > START_OF_TILE_NAME then begin
       temp_fly := (TN2 = t_NeTo1);
       if temp_fly then i := 1 else i := 5;
       objects[MIN_FRIEND+1] := new(PFriend,init(TN2,104,temp_fly,2,i,MAX_FRIEND));
       objects[MIN_FRIEND+1]^.warpXY(100,10);
    end;
    clearDevice;
end;

procedure CUT;
var
    i  : integer;
    TN : TTileName;
begin
    start_time := getCurrentTime - start_time;
    system_timer := MEMAVAIL;

    for i := MIN_FRIEND to MAX_FRIEND do begin
       if assigned(objects[i]) then dispose(objects[i],done);
    end;
    for i := MIN_ENEMY to MAX_ENEMY do begin
       if assigned(objects[i]) then dispose(objects[i],done);
    end;
    for TN := succ(START_OF_TILE_NAME) to pred(END_OF_TILE_NAME) do begin
       if assigned(tile_data[TN]) then dispose(tile_data[TN],done);
    end;
    for i := 0 to 3 do begin
       freeMem(back_ground[i],BACK_GROUND_SIZE);
    end;
    closeGraph;

    writeLn('Available Memory : ',system_timer,' bytes.');
    writeLn('Average Flipping : ',counter*100 div start_time);
end;

procedure ACTION;
label
    START_POSITION;
const
    SUCCESS_MISSION : boolean = FALSE;
var
    i, j, k, y, number1, number2 : integer;
    s1, s2, s3 : string[1];
    temp_friend : PFriend;
    pb : ^byte;
    clear_stage : boolean;
    move_screen : word;
begin

    setKeyboardInterrupt;
    start_time := getCurrentTime;

    new(map,init);

START_POSITION:

    if USER_SOUND then playTMF('Field');

    display_stage_delay := 100;
    inc(current_stage);
    str(current_stage,s1);
    stage_message := 'STAGE '+s1;

    new(message); message^.initialize;
    map^.setMap(current_stage);
    clear_stage := FALSE;
    ascii_code := [];
    while not (_ESC_KEY in ascii_code) do begin

       map^.moveAbsoluteXY(8,0);

       if VIDEO_SEGMENT = $A000 then VIDEO_SEGMENT := $A800
                                else VIDEO_SEGMENT := $A000;

       if assigned(objects[MIN_FRIEND]) and assigned(objects[MAX_FRIEND]) then
          move_screen := (SCREEN_Y_MAX - (objects[MIN_FRIEND]^.m_y+objects[MAX_FRIEND]^.m_y) div 2) div 10
       else if assigned(objects[MIN_FRIEND]) then
          move_screen := (SCREEN_Y_MAX - objects[MIN_FRIEND]^.m_y) div 10
       else if assigned(objects[MAX_FRIEND]) then
          move_screen := (SCREEN_Y_MAX - objects[MAX_FRIEND]^.m_y) div 10
       else
          move_screen := 0;

       fillScreen(0,27,639,28+move_screen,1);
       for i := 0 to 3 do begin
          pb := @(back_ground[i]^);
          asm
             push ds

             mov  ax, VIDEO_SEGMENT
             mov  es, ax

             mov  ax, move_screen
             add  ax, 29
             shl  ax, 4
             mov  dx, ax
             shl  ax, 2
             add  ax, dx
             add  ax, VIEWPORT_X1 / 8
             mov  di, ax
             lds  si, pb

             mov  dx, 3C4h
             mov  al, 2
             mov  ah, 1
             mov  cl, byte ptr i
             shl  ah, cl
             out  dx, ax

             mov  bx, BACK_GROUND_LINE
             sub  bx, move_screen
             cld
          @@JUMP00:
             mov  cx, 40 - TILE_X_SIZE / 8
             rep  movsw
             add  di, TILE_X_SIZE / 4
             sub  bx, 1
             jnz  @@JUMP00

             pop  ds
          end;
       end;

       for j := safe_mode to 7 do
       for i := 1 to 12 do begin
          if map^.returnMap(i*TILE_X_SIZE-map^.m_map_local_x,
                            j*TILE_Y_SIZE-map^.m_map_local_y) > 0 then begin
             putImage(i*TILE_X_SIZE-map^.m_map_local_x-1,
                      j*TILE_Y_SIZE-map^.m_map_local_y+Y_DOWN,tile_data[t_ground]^.m_sprite^);
          end;
       end;

       fillScreen(pred(SCREEN_X_MAX)-TILE_X_SIZE,0,SCREEN_X_MAX+TILE_X_SIZE+8,pred(SCREEN_Y_MAX)-1,0);
       lineX(0,pred(SCREEN_X_MAX),pred(SCREEN_Y_MAX),0);

       for i := MAX_ENEMY downto MIN_OBJECTS do begin
          if assigned(objects[i]) then
          with objects[i]^ do begin
             if AImoving then begin
                if isValid then begin
                   jumpAction;
                   displayImage;
                end else begin
                   dispose(objects[i],done); objects[i] := nil;
                end;
             end else begin
                dispose(objects[i],done); objects[i] := nil;
             end;
          end;
       end;

       message^.displayMessage;

       putImage(0,0,tile_data[t_status_bar]^.m_sprite^);

       i := 0; j := 0; s1 := ''; s2 := ''; number1 := 0; number2 := 0;
       if assigned(objects[MIN_FRIEND]) then begin
          temp_friend := PFriend(objects[MIN_FRIEND]);
          i := temp_friend^.m_hit_point;
          number1 := temp_friend^.m_special_weapon;
          str(temp_friend^.getLevel,s1);
       end;
       if assigned(objects[MAX_FRIEND]) then begin
          temp_friend := PFriend(objects[MAX_FRIEND]);
          j := temp_friend^.m_hit_point;
          number2 := temp_friend^.m_special_weapon;
          str(temp_friend^.getLevel,s2);
       end;
       case player_mode of
          player1    : begin i := 104 + i; j := 424 end;
          player2    : begin j := 424 + i; i := 104; s2 := s1; s1 := ''; number2 := number1; number1 := 0 end;
          dual_mode1 : begin i := 104 + i; j := 424 + j end;
          dual_mode2 : begin k := i; i := 104 + j; j := 424 + k;
                             s3 := s2; s2 := s1; s1 := s3;
                             k := number1; number1 := number2; number2 := k
                       end;
       end;

       for y := 11 to 14 do begin
          if i < 208 then lineX(i,208,y,0);
          if j < 528 then lineX(j,528,y,0);
       end;

       if s1[0] > #0 then begin
          printHangul(273,7,s1,3);
          printHangul(272,6,s1,4);
       end;
       if s2[0] > #0 then begin
          printHangul(593,7,s2,3);
          printHangul(592,6,s2,4);
       end;
       if number1 > 0 then begin
          if number1 > 10 then number1 := 10;
          for i := 0 to pred(number1) do begin
             putSprite(i*24+TILE_X_SIZE,30,tile_data[t_SMgal_special]^.m_sprite^,TRUE)
          end;
       end;
       if number2 > 0 then begin
          if number2 > 10 then number2 := 10;
          for i := 0 to pred(number2) do begin
             putSprite(i*24+TILE_X_SIZE+330,36,tile_data[t_NeTo_special]^.m_sprite^,TRUE);
          end;
       end;

       if display_stage_delay > 0 then begin
          dec(display_stage_delay);
          i := 160 - length(stage_message)*4;
          printHangulEXPAND(i,85,stage_message,11);
       end;

       if STATIC_DELAY then begin
          while abs(getCurrentTime - system_timer) < 4 do;
          system_timer := getCurrentTime;
       end;

       setVisualPage(VIDEO_SEGMENT shl 4);
       inc(counter);

       if map^.m_end_of_map then begin
          k := 0;
          for i := MIN_ENEMY to MAX_ENEMY do begin
             if assigned(objects[i]) then inc(k);
          end;
          if k = 0 then begin
             clear_stage := TRUE;
             ascii_code := ascii_code + [_ESC_KEY];
          end;
       end;
    end;
    dispose(message);

    if USER_SOUND then endTMF;

    if clear_stage = TRUE then begin
       intensifyIn(1,palette_data);
       if current_stage >= MAX_STAGE then SUCCESS_MISSION := TRUE
                             else goto START_POSITION
    end;

    dispose(map,done);

    resetKeyboardInterrupt;

    if SUCCESS_MISSION then displayHappyEnding
    else if not(assigned(objects[MIN_FRIEND]) or assigned(objects[MAX_FRIEND])) then begin
       displayBadEnding;
    end;
end;

begin

    ShitFighter.READY;
    ShitFighter.ACTION;
    ShitFighter.CUT

end.
