UNIT SubPro;

INTERFACE

type
   TPlayerMode = (player1,player2,dual_mode1,dual_mode2);
   PBuffer = ^TBuffer;
   TBuffer = array[0..pred(64000)] of byte;
   TPalette = array[0..15,1..3] of byte;

const
   VIDEO_SEGMENT : word = $A000;
   AUTO_SHOOT    : boolean = FALSE;
   USER_SOUND    : boolean = TRUE;
   STATIC_DELAY  : boolean = TRUE;
   player_mode   : TPlayerMode = player1;
   safe_mode     : byte = 0;

var
   palette_data  : TPalette;

 procedure waitVerticalRetrace(count : word);
 function  pressedKey : boolean;
 function  readKey : char;
 procedure setVisualPage(page_offset : word);
 procedure initGraph;
 procedure closeGraph;
 procedure setPalette(palette_number : byte);
 procedure setRGB(Color, Red, Green, Blue : byte);
 procedure clearDevice;
 procedure fillScreen(x1, y1, x2, y2 : word; back_color : byte);
 procedure lineX(x1, x2, y : word; color : byte);
 procedure lineY(x, y1, y2 : word; color : byte);
 function  getImageSize(x1,y1,x2,y2 : word) : word;
 procedure getImage(x1,y1,x2,y2 : word; var p);
 procedure putPixel(x, y : integer; color : byte);
 procedure putImage(x, y: word; var BitMap);
 procedure putSprite(x,y : word; var BitMap; full_color : boolean);
 procedure readPcx16(file_name: string; x,y : integer; change_palette : boolean);
 procedure intensifyIn(delay : byte; var palette_data : TPalette);
 procedure intensifyOut(delay : byte; var palette_data : TPalette);
 function  revertFile(source_file_name, destination_file_name : string) : boolean;
 function  deleteFile(file_name : string) : boolean;


IMPLEMENTATION

const
   SCAN_CODE : char = #0;

procedure waitVerticalRetrace(count : word); assembler;
asm
      mov  cx, count
      jz   @@END
      mov  dx, 03DAh
@@JUMP1:
      in   al, dx
      test al, 08h
      jnz  @@JUMP1
@@JUMP2:
      in   al, dx
      test al, 08h
      jz   @@JUMP2
      loop @@JUMP1
@@END:
end;

function pressedKey : boolean; assembler;
asm
      mov  ah, 1
      int  $16
      jnz  @@KEY_PRESSED
      mov  al, FALSE
      jmp  @@END
@@KEY_PRESSED:
      mov  al, TRUE
@@END:
end;

function readKey : char; assembler;
asm
      mov  al, SCAN_CODE
      mov  SCAN_CODE, 0
      test al, $FF
      jnz  @@JUMP1
@@JUMP0:
      mov  ah, 1
      int  $16
      jz   @@JUMP0
      mov  ah, 0
      int  $16
      cmp  al, 0
      jne  @@JUMP1
      mov  SCAN_CODE, ah
@@JUMP1:
end;

procedure initGraph; assembler;
asm
      mov  ax, 0012h
      int  10h

      mov  ax, 040h
      mov  es, ax
      mov  byte ptr es:[049h], 3
      mov  dx, 3C2h
      mov  al, 63h
      out  dx, al
      mov  dx, 3D4h
      mov  ax, 0E11h
      out  dx, ax
      mov  ax, 0BF06h
      out  dx, ax
      mov  ax, 1F07h
      out  dx, ax
      mov  ax, 4009h
      out  dx, ax
      mov  ax, 9C10h
      out  dx, ax
      mov  ax, 8E11h
      out  dx, ax
      mov  ax, 8F12h
      out  dx, ax
      mov  ax, 2813h
      out  dx, ax
      mov  ax, 0F14h
      out  dx, ax
      mov  ax, 0E317h
      out  dx, ax
      mov  dx, 3CEh
      mov  ax, 106h
      out  dx, ax
      mov  ax, 0FF08h
      out  dx, ax
      xor  ax, ax
      mov  es, ax
      mov  bx, 44Ah
      mov  byte ptr es:[bx], 80
      mov  bx, 484h
      mov  byte ptr es:[bx], 24

      mov  dx, 3CCh
      in   al, dx
      and  al, 00111111b
      or   al, 11000000b
      mov  dx, 3C2h
      out  dx, al

end;

procedure closeGraph; assembler;
asm
      mov  ah, 00h
      mov  al, 03h
      int  10h
end;

procedure setPalette(palette_number : byte); assembler;
asm
      mov  ah, 10h
      mov  al, 0
      mov  bh, palette_number
      mov  bl, palette_number
      int  10h
end;

procedure setRGB(Color, Red, Green, Blue : byte); assembler;
asm
      mov  dx, 3C8h;
      mov  al, Color;
      out  dx, al;
      inc  dx;
      mov  al, Red;
      out  dx, al;
      mov  al, Green;
      out  dx, al;
      mov  al, Blue;
      out  dx, al;
end;

procedure setVisualPage(page_offset : word); assembler;
asm
      mov  bx, page_offset
      mov  dx, 3D4h
      mov  al, 0Ch
      mov  ah, bh
      out  dx, ax
      mov  al, 0Dh
      mov  ah, bl
      out  dx, ax

      mov  dx, 3DAh
@@JUMP1:
      in   al, dx
      test al, 08h
      jnz  @@JUMP1
@@JUMP2:
      in   al, dx
      test al, 8
      jz   @@JUMP2

end;

function  getImageSize(x1,y1,x2,y2 : word) : word; assembler;
asm
      mov dx, x1
      shr dx, 3
      mov ax, x2
      shr ax, 3
      sub ax, dx
      inc ax

      mov dx, y2
      sub dx, y1
      inc dx
      mul dx
      shl ax, 2
      add ax, 4
end;

procedure getImage(x1,y1,x2,y2 : word; var p); assembler;
var
   x_size : word;
asm
      push ds

      mov dx, x1
      shr dx, 3
      mov x1, dx
      mov ax, x2
      shr ax, 3
      sub ax, dx
      inc ax
      mov x_size, ax
      shl ax, 3
      dec ax
      mov x2, ax
      mov ax, y1
      sub y2, ax

      cld
      les  di, p
      mov  ax, x2
      stosw
      mov  ax, y2
      stosw
      mov  ax, VIDEO_SEGMENT
      mov  ds, ax
      mov  ax, y1
      mov  dx, 80
      mul  dx
      add  ax, x1
      mov  si, ax

      mov  dx, 3CEh
      mov  al, 4
      out  dx, al
      inc  dx
      mov  cx, y2
      inc  cx
@@JUMP00:
      push cx
      mov  bl, 4
@@JUMP01:
      dec  bl
      mov  al, bl
      out  dx, al
      mov  cx, x_size
      rep  movsb
      sub  si, x_size
      test bl, 0FFh
      jnz  @@JUMP01
      add  si, 80
      pop  cx
      loop @@JUMP00

      pop  ds
end;

procedure putPixel(x, y : integer; color : byte); assembler;
asm
      mov dx, $3CE
      mov ax, 0
      out dx, ax

      mov al, 1
      mov ah, color
      not ah
      out dx, ax

      mov ax, y
      shl ax, 2
      add ax, y
      add ax, VIDEO_SEGMENT
      mov es, ax
      mov di, x
      shr di, 3
      mov cx, x
      and cl, $07

      mov ah, $80;
      shr ah, cl
      mov al, 8
      out dx, ax

      mov al, es:[di]
      mov byte ptr es:[di], $FF

      mov al, 8
      mov ah, $FF
      out dx, ax

      mov ax, $0001
      out dx, ax
end;

procedure putImage(x, y: word; var BitMap); assembler;
var
   sour_off, dest_off, x_size, y_size : word;
   plane : byte;
asm
      push ds
      push es

      cld
      mov  plane, 8

      mov  ax, VIDEO_SEGMENT
      mov  bx, y
      shl  bx, 2
      add  bx, y
      add  ax, bx
      mov  es, ax
      mov  ax, x
      shr  ax, 3
      mov  dest_off, ax

      lds  si, BitMap

      lodsw
      inc  ax
      shr  ax, 3
      mov  x_size, ax
      lodsw
      mov  y_size, ax

      mov  sour_off, si

      mov  dx, $3C4

@MAIN_LOOP:
      mov  si, sour_off
      mov  di, dest_off
      mov  al, plane

@JUMP2:
      cmp  al, 8
      je   @JUMP3
      shl  al, 1
      add  si, x_size
      jmp  @JUMP2

@JUMP3:
      mov  al, $02
      mov  ah, plane
      out  dx, ax
      mov  cx, y_size

@JUMP4:
      push cx
      mov  cx, x_size
      shr  cx, 1
      jnc  @@TRANS_WORD
      movsb
   @@TRANS_WORD:
      rep  movsw
      pop  cx

      add  si, x_size
      add  si, x_size
      add  si, x_size
      add  di, 80
      sub  di, x_size
      loop @JUMP4

      shr  plane, 1
      cmp  plane, 0
      jne  @MAIN_LOOP

      mov  dx, $3C4
      mov  ax, $0F02
      out  dx, ax

      pop  es
      pop  ds
end;

procedure putSpriteSub(x,y,SPRITE_X_SIZE,SPRITE_Y_SIZE : word; var BitMap; full_color : boolean); assembler;
var
   plane : byte;
   read_plane : integer;
asm
      push ds

      mov  plane, 8
      mov  read_plane, 3

      mov  dx, $3C4
      mov  al, $02
      out  dx, al

      mov  dx, $3CE
      mov  al, $04
      out  dx, al

      mov  ax, y
      shl  ax, 2
      add  ax, y
      add  ax, VIDEO_SEGMENT
      mov  es, ax

      mov  dx, $3C4

@MAIN_LOOP:

      lds  si, BitMap
      mov  di, x
      shr  di, 3
      mov  al, plane

@JUMP2:
      cmp  al, 8
      je   @JUMP3
      shl  al, 1
      add  si, SPRITE_X_SIZE
      jmp  @JUMP2

@JUMP3:
      mov  dx, $3C5
      mov  al, plane
      out  dx, al

      mov  dx, $3CF
      mov  al, byte ptr read_plane
      out  dx, al

      mov  cx, SPRITE_Y_SIZE

@JUMP4:

      push cx

      mov  cx, SPRITE_X_SIZE

@JUMP5:

      mov  bx, si
      mov  ax, 3
      sub  ax, word ptr read_plane
      mul  SPRITE_X_SIZE
      sub  bx, ax

      mov  ah, ds:[bx]
      add  bx, SPRITE_X_SIZE
      and  ah, ds:[bx]
      add  bx, SPRITE_X_SIZE
      and  ah, ds:[bx]
      add  bx, SPRITE_X_SIZE
      and  ah, ds:[bx]
      not  ah

      test byte ptr full_color, 0FFh
      jz   @@1
      mov  al, ds:[si]
      jmp  @@2
   @@1:
      mov  al, ah
   @@2:
      and  al, ah
      not  ah
      mov  dl, es:[di]
      and  dl, ah
      or   al, dl
      mov  es:[di], al

      inc  si
      inc  di

      loop @JUMP5

      pop  cx

      mov  ax, SPRITE_X_SIZE;
      shl  ax, 1
      add  ax, SPRITE_X_SIZE;
      add  si, ax
      add  di, 80
      sub  di, SPRITE_X_SIZE
      loop @JUMP4

      shr  plane, 1
      dec  read_plane
      cmp  plane, 0
      jne  @MAIN_LOOP

      mov  dx, $3C4
      mov  ax, $0F02
      out  dx, ax

      pop  ds

end;

procedure putSprite(x,y : word; var BitMap; full_color : boolean); assembler;
asm
      push ds
      lds  si, BitMap
      cld
      lodsw
      inc  ax
      shr  ax, 3
      mov  bx, ax
      lodsw
      inc  ax
      mov  cx, ax
      mov  dx, ds
      pop  ds

      mov  ax, x
      push ax
      mov  ax, y
      push ax
      push bx
      push cx
      push dx
      push si
      xor  ah, ah
      mov  al, full_color
      push ax
      call putSpriteSub
end;

procedure fillScreen(x1, y1, x2, y2 : word; back_color : byte); assembler;
asm
      push es

      mov ax, x2
      sub ax, x1
      inc ax
      shr ax, 3
      mov x2, ax
      mov ax, y2
      sub ax, y1
      inc ax
      mov y2, ax

      mov ax, y1
      shl ax, 2
      add ax, y1
      add ax, VIDEO_SEGMENT
      mov es, ax
      mov ax, x1
      shr ax, 3
      mov di, ax

      mov dx, $3C4
      mov ah, back_color
      mov al, $02
      out dx, ax
      mov al, $FF

      mov cx, y2

      cld
@JUMP1:
      push cx
      mov cx, x2
      rep stosb

      add di, 80
      sub di, x2

      pop cx
      loop @JUMP1

      xor back_color, $0F

      mov ax, y1
      shl ax, 2
      add ax, y1
      add ax, VIDEO_SEGMENT
      mov es, ax
      mov ax, x1
      shr ax, 3
      mov di, ax

      mov dx, $3C4
      mov ah, back_color
      mov al, $02
      out dx, ax
      mov al, $00

      mov cx, y2

@JUMP2:
      push cx
      mov cx, x2
      rep stosb

      add di, 80
      sub di, x2

      pop cx
      loop @JUMP2

      pop es

end;

procedure lineX(x1, x2, y : word; color : byte); assembler;
asm
      mov  dx, 3CEh
      mov  ax, 0
      out  dx, ax

      mov  al, 1
      mov  ah, color
      not  ah
      out  dx, ax

      mov  ax, y
      shl  ax, 2
      add  ax, y
      add  ax, VIDEO_SEGMENT
      mov  es, ax
      mov  di, x1
      shr  di, 3

      mov  bx, x1
      and  bx, 7h

      mov  al, 0FFh
      mov  cl, bl
      shr  al, cl
      mov  bl, al

      mov  al, 8
      mov  ah, bl
      out  dx, ax

      mov  bl, es:[di]
      mov  byte ptr es:[di], 0FFh

      mov  ah, 0FFh
      out  dx, ax

      mov  cx, x2
      mov  ax, x1
      shr  cx, 3
      shr  ax, 3
      sub  cx, ax
      sub  cx, 1
      jz   @@JUMP02

   @@JUMP01:
      inc  di
      mov  bl, es:[di]
      mov  byte ptr es:[di], 0FFh
      loop @@JUMP01

   @@JUMP02:
      inc  di
      mov  ax, x2
      and  ax, 7h
      mov  bx, 7
      sub  bx, ax

      mov  al, 0FFh
      mov  cl, bl
      shl  al, cl
      mov  bl, al

      mov  al, 8
      mov  ah, bl
      out  dx, ax
      mov  bl, es:[di]
      mov  byte ptr es:[di], 0FFh

      mov  ah, 0FFh
      out  dx, ax

      mov  ax, $0001
      out  dx, ax
end;

procedure lineY(x, y1, y2 : word; color : byte); assembler;
asm
      mov dx, $3CE
      mov ax, 0
      out dx, ax

      mov al, 1
      mov ah, color
      not ah
      out dx, ax

      mov ax, y1
      shl ax, 2
      add ax, y1
      add ax, VIDEO_SEGMENT
      mov es, ax
      mov di, x
      shr di, 3
      mov cx, x
      and cl, $07

      mov ah, $80;
      shr ah, cl
      mov al, 8
      out dx, ax

      mov cx, y2
      sub cx, y1
      inc cx

   @@JUMP00:
      mov al, es:[di]
      mov byte ptr es:[di], $FF
      add di, 80
      loop @@JUMP00

      mov al, 8
      mov ah, $FF
      out dx, ax

      mov ax, $0001
      out dx, ax
end;

procedure clearDevice; assembler;
asm
      push es

      mov  ax, VIDEO_SEGMENT
      mov  es, ax
      mov  di, 0000h;
      mov  dx, 3C4h
      mov  ax, 0F02h
      out  dx, ax
      mov  ax, 0000h
      mov  cx, 80 * 400 / 2
      cld
      rep  stosw

      pop  es
end;

procedure readPcx16(file_name: string; x,y : integer; change_palette : boolean);
var
   scratch : pointer;
   RGB_palette : TPalette;
   page_addr: word;
   bytes_per_line: word;
   repeat_count: byte;
   data_length: word;
   column_count, plane, video_index: word;

const
   BUFFER_SIZE = 65521;

var
   i, entry, gun, PCX_code, mask, color_ID: byte;
   palette_buffer: array[0..66] of byte;
   f: file;
begin

   page_addr := VIDEO_SEGMENT + y * 5;

   assign(f,file_name+'.PCX');
   {$I-}
   reset(f,1);
   {$I+}
   if IOresult <> 0 then begin
      write(^G);
      exit;
   end;

   getmem(scratch,BUFFER_SIZE);
   BlockRead(f,scratch^,128);

   move(scratch^,palette_buffer,67);
   bytes_per_line := palette_buffer[66];

   video_index := x div 8;

   port[$3C4] := 2;
   plane := 1;
   port[$3C5] := plane;

   for entry := 0 to 15 do begin
      RGB_palette[entry][1] := palette_buffer[16 + entry * 3 + 0] shr 2;
      RGB_palette[entry][2] := palette_buffer[16 + entry * 3 + 1] shr 2;
      RGB_palette[entry][3] := palette_buffer[16 + entry * 3 + 2] shr 2;
   end;

   repeat_count := 0;
   column_count := 0;

   palette_data := RGB_palette;
   if change_palette then begin
      for i := 0 to 15 do begin
         setPalette(i);
         setRGB(i,palette_data[i,1],palette_data[i,2],palette_data[i,3]);
      end;
   end;

   repeat
      BlockRead(f,scratch^,BUFFER_SIZE,data_length);
    asm
      push    bp

      mov     es, page_addr
      mov     di, video_index
      mov     ah, byte ptr bytes_per_line
      mov     dx, column_count
      mov     bx, data_length
      mov     cl, repeat_count
      push    ds
      lds     si, scratch
      mov     bp, plane
      add     bx, si
      cld

@GET_BYTE:
      cmp     si, bx
      je      @EXIT
      lodsb
      cmp     cl, 0
      jg      @WRITE_BYTE
      cmp     al, 192
      jb      @ONE_DATA

      xor     al, 192
      mov     cl, al
      jmp     @GET_BYTE

@ONE_DATA:
      mov     cl, 1

@WRITE_BYTE:
      stosb
      inc     dl
      cmp     dl, ah
      je      @DONE_LINE
      loop    @WRITE_BYTE
      jmp     @GET_BYTE

@DONE_LINE:

      shl     bp, 1
      cmp     bp, 8
      jle     @SET_INDEX
      mov     bp, 1
      add     di, 80
      mov     dl, ah
      sub     di, dx
      jmp     @SET_PLANE

@SET_INDEX:
      sub     di, dx

@SET_PLANE:
      push    ax
      cli
      mov     ax, bp
      mov     dx, 3C5h
      out     dx, al
      sti
      pop     ax
      xor     dx, dx
      loop    @WRITE_BYTE

      jmp     @GET_BYTE

@EXIT:
      pop     ds
      mov     bx, bp
      pop     bp
      mov     plane, bx
      mov     repeat_count, cl
      mov     column_count, dx
      mov     video_index, di

    end;

   until eof(f);

   close(f);
   port[$3C5] := $0F;

   freeMem(scratch,BUFFER_SIZE);

end;

procedure intensifyIn(delay : byte; var palette_data : TPalette);
var
   i,j : word;
   gray_red, gray_green, gray_blue : array[0..15] of byte;
begin
   for i := 0 to 15 do begin
      gray_red[i] := 63;
      gray_green[i] := 63;
      gray_blue[i] := 63;
      setPalette(i);
   end;
   if delay > 0 then begin
      for j := 0 to 63 div 2 do begin
         waitVerticalRetrace(1);
         port[$3c8] := 0;
         for i := 0 to 15 do begin
            if (gray_red[i] > palette_data[i,1]+1) then dec(gray_red[i],2);
            if (gray_green[i] > palette_data[i,2]+1) then dec(gray_green[i],2);
            if (gray_blue[i] > palette_data[i,3]+1) then dec(gray_blue[i],2);
            port[$3c9] := gray_red[i];
            port[$3c9] := gray_green[i];
            port[$3c9] := gray_blue[i];
         end;
      end;
   end else begin
      port[$3c8] := 0;
      for i := 0 to 15 do begin
         port[$3c9] := palette_data[i,1];
         port[$3c9] := palette_data[i,2];
         port[$3c9] := palette_data[i,3];
      end;
   end;
end;

procedure intensifyOut(delay : byte; var palette_data : TPalette);
var
   i,j : word;
   gray_red, gray_green, gray_blue : array[0..15] of byte;
begin
   for i := 0 to 15 do begin
      gray_red[i] := palette_data[i,1];
      gray_green[i] := palette_data[i,2];
      gray_blue[i] := palette_data[i,3];
      setPalette(i);
   end;
   if delay > 0 then begin
      for j := 0 to 63 div 2 do begin
         waitVerticalRetrace(delay);
         port[$3c8] := 0;
         for i := 0 to 15 do begin
            if (gray_red[i] < 62) then inc(gray_red[i],2);
            if (gray_green[i] < 62) then inc(gray_green[i],2);
            if (gray_blue[i] < 62) then inc(gray_blue[i],2);
            port[$3c9] := gray_red[i];
            port[$3c9] := gray_green[i];
            port[$3c9] := gray_blue[i];
         end;
      end;
   end else begin
      port[$3c8] := 0;
      for i := 0 to 15 do begin
         port[$3c9] := 63;
         port[$3c9] := 63;
         port[$3c9] := 63;
      end;
   end;
end;

function revertFile(source_file_name, destination_file_name : string) : boolean;
var
   buffer : Pbuffer;
   size : longint;
   CX_count : word;
   temp_b : byte;
   read_f, write_f : file;
   _segment, _offset : word;
begin
   assign(read_f,source_file_name);
   {$I-}
   reset(read_f,1);
   {$I+}
   if IOResult <> 0 then begin
      revertFile := FALSE;
      exit;
   end;
   size := FileSize(read_f);
   assign(write_f,destination_file_name);
   rewrite(write_f,1);

   getMem(buffer,10000);
   _segment := seg(buffer^);
   _offset := ofs(buffer^);

   while size > 0 do begin
      if size > 10000 then begin
         BlockRead(read_f,buffer^[0],10000);
         CX_count := 10000;
      end else begin
         BlockRead(read_f,buffer^[0],size);
         CX_count := size;
      end;

      asm
            push es

            mov es, _segment
            mov di, _offset
            mov cx, CX_count

      @LOOP:
            mov al, es:[di]

            sub al,57
            ror al,2
            not al

            mov es:[di], al
            inc di
            dec cx
            jnz @LOOP

            pop es
      end;

      BlockWrite(write_f,buffer^[0],CX_count);
      dec(size,CX_count);
   end;

   freeMem(buffer,10000);
   close(read_f);
   close(write_f);
   revertFile := TRUE;
end;

function deleteFile(file_name : string) : boolean;
var
   f : file;
begin
   assign(f,file_name);
   {$I-}
   reset(f);
   {$I+}
   if IOResult = 0 then begin
      close(f);
      erase(f);
      deleteFile := TRUE;
   end else deleteFile := FALSE;
end;

end.
