UNIT TMFUnit;

{$F+}
interface

 function  playTMF(name : string) : boolean;
 procedure endTMF;

var
   DETECT_SOUND_CARD : (NOT_FOUND,ADLIB_CARD,SOUND_BLASTER);

implementation

uses
   dos;

const
   ADLIB = $388;
   TIMER_INTERRUPT = $08;
   MEMORY_BLOCK = 32768;
   MAX_BYTE_ARRAY_SIZE = 65520 div sizeof(Byte);
   MIN_REQURED_MEMORY = 25000;
   ENABLE_MUSIC : boolean = FALSE;

type
   PByteArray = ^TByteArray;
   TByteArray = array [0..MAX_BYTE_ARRAY_SIZE - 1] of Byte;

var
   byte_size, cur_byte : longint;
   tmf_data : array[0..5] of PByteArray;
   pack_data, pack_mem : PByteArray;
   pack_count : byte;
   drum_mode : byte;
   basic_tempo : integer;
   page_number, page_etc, line_count, pack_code : word;

   delay : integer;
   temp_long : longint;
   length : byte;
   data1, data2 : byte;
   rate : word;

   TimeOutFunction : function : word;
   OldInt08 : procedure;

   clock_division_high, clock_division_low, clock_mode : Word;
   sound_delay    : Word;
   user_routine_on : Boolean;


procedure ClockRate; assembler;
asm
	PUSH    AX
	MOV     AL, 00110100b
	OUT     43h, AL
	POP     AX
	OUT     40h, AL
	XCHG	AH, AL
	OUT     40h, AL
	XCHG	AH, AL
end;

procedure ClockInterrupt; interrupt; assembler;
asm
	MOV     AX, clock_division_low
	ADD     clock_mode, AX
	MOV     AX, clock_division_high
	ADC     AX, 0
	JNZ     @@ClockInterrupt8

	MOV     AL, 00100000b
	OUT     20h, AL
	JMP     @@ClockInterrupt7

@@ClockInterrupt8:
	PUSHF
	CALL	OldInt08

@@ClockInterrupt7:
	DEC     sound_delay
	JNZ     @@ClockInterruptEnd

	CMP     user_routine_on, False
	JNZ     @@ClockInterruptEnd

@@GoUser:
	INC     user_routine_on

        STI
        CALL    TimeOutFunction;
        CLI

	DEC     user_routine_on

	MOV     BX, sound_delay
	NEG     BX
	CMP     BX, AX
	JB      @@ClockDelayOk

	MOV     sound_delay, 0
	JMP     @@GoUser

@@ClockDelayOk:
	ADD     sound_delay, AX

	STI

@@ClockInterruptEnd:
end;

procedure setInterrupt(State : Integer); assembler;
asm
	CMP     State, 0
	JNE     @@SOn

	CLI
	JMP     @@SEnd

@@SOn:
	STI

@@SEnd:
	POP     BP
end;

procedure SetClockRate(Count : Word); assembler;
asm
	MOV     AX, Count
	PUSHF
	CLI
	MOV     clock_division_low, AX
	CMP     AX, 1
	MOV     clock_division_high, 0
	ADC     clock_division_high, 0
	CALL	ClockRate
	POPF
end;

procedure ClockInstall;
begin
   asm
	XOR     AX, AX
	CALL	ClockRate

	MOV     clock_division_high, 1
	MOV     clock_division_low, AX
	MOV     clock_mode, AX
        MOV     user_routine_on, False
   end;

   getIntVec(TIMER_INTERRUPT, @OldInt08);
   setIntVec(TIMER_INTERRUPT, @ClockInterrupt);
end;

procedure ClockUninstall;
begin
   asm
	XOR     AX, AX
	CALL    ClockRate
   end;

   setIntVec(TIMER_INTERRUPT, @OldInt08);
end;

procedure AdLibOut(Address, Data : byte); assembler;
asm
		mov dx, ADLIB
		mov al, Address
		out dx, al

		in  al, dx
		in  al, dx
		in  al, dx
		in  al, dx
		in  al, dx
		in  al, dx

		inc dx
		mov al, Data
		out dx, al
		dec dx

		in  al, dx
		in  al, dx
		in  al, dx
		in  al, dx
		in  al, dx
		in  al, dx
		in  al, dx
		in  al, dx
		in  al, dx
		in  al, dx

		in  al, dx
		in  al, dx
		in  al, dx
		in  al, dx
		in  al, dx
		in  al, dx
		in  al, dx
		in  al, dx
		in  al, dx
		in  al, dx

		in  al, dx
		in  al, dx
		in  al, dx
		in  al, dx
		in  al, dx
		in  al, dx
		in  al, dx
		in  al, dx
		in  al, dx
		in  al, dx

		in  al, dx
		in  al, dx
		in  al, dx
		in  al, dx
		in  al, dx
end;

function readTMFdata(cursor_byte : Longint) : Byte;
var
   page, remainder : Word;
begin
   page := cursor_byte div MEMORY_BLOCK;
   remainder := cursor_byte mod MEMORY_BLOCK;
   readTMFdata := tmf_Data[page]^[remainder];
end;

function loadTMF(name : string) : boolean;
var
   point : word;
   i : integer;
   handle : file;
   length : byte;
   comp_code : array[1..25] of char;
begin
   loadTMF := FALSE;
   if DETECT_SOUND_CARD = NOT_FOUND then exit;

   assign(handle,name+'.BGM');
   {$I-}
   reset(handle,1);
   {$I+}
   ENABLE_MUSIC := TRUE;
   if (IOResult <> 0) or
      ((MEMAVAIL - FileSize(handle)) < MIN_REQURED_MEMORY) then begin
      ENABLE_MUSIC := FALSE;
      exit;
   end;
   blockread(handle,comp_code,25);
   blockread(handle,drum_mode,1);
   blockread(handle,basic_tempo,2);
   blockread(handle,line_count,2);
   getmem(pack_data,32*line_count);
   for i := 0 to line_count-1 do begin
      Point := 32 * i;
      blockread(handle,length,1);
      pack_data^[point] := length;
      inc(point);
      blockread(handle,pack_data^[point],length);
      inc(point,length);
      blockread(handle,length,1);
      pack_data^[point] := length;
      inc(point);
      if length = $FF then begin
         blockread(handle,pack_data^[point],2);
      end;
   end;
   byte_size := FileSize(handle) - FilePos(handle);
   page_number := byte_size div MEMORY_BLOCK;
   if page_number > 0 then begin
      for i := 0 to page_number-1 do begin
         getMem(tmf_data[i],MEMORY_BLOCK);
         blockread(handle,tmf_data[i]^,MEMORY_BLOCK);
      end;
   end;
   page_etc := byte_size mod MEMORY_BLOCK;
   if page_etc > 0 then begin
      getMem(tmf_data[page_number],page_etc);
      blockread(handle,tmf_data[page_number]^,page_etc);
   end;
   close(handle);
   loadTMF := TRUE;
end;

function playTMF(name : string) : boolean;
var
   i : integer;
begin
   if DETECT_SOUND_CARD = NOT_FOUND then exit;

   playTMF := loadTMF(name);

   if not ENABLE_MUSIC then exit;
   for i := 0 to $F4 do AdLibOut(i,0);
   Clockinstall;
   AdLibOut(1,$20);
   if drum_mode <> 0 then
      AdLibOut($BD,$20)
   else
      AdLibOut($BD,$00);
   for i := $B0 to $B8 do AdLibOut(i,0);
   for i := $A0 to $A8 do AdLibOut(i,0);
   for i := $C0 to $C8 do AdLibOut(i,0);
   for i := $20 to $35 do AdLibOut(i,0);
   for i := $40 to $55 do AdLibOut(i,0);
   for i := $60 to $75 do AdLibOut(i,0);
   for i := $80 to $95 do AdLibOut(i,0);

   cur_byte := 0;
   sound_delay := 10;
   setClockRate(298295 div basic_tempo);
end;

procedure endTMF;
var
   i : integer;
begin
   if DETECT_SOUND_CARD = NOT_FOUND then exit;

   if not ENABLE_MUSIC then exit;
   if page_number > 0 then begin
      for i := 0 to page_number-1 do
         freeMem(tmf_data[i],MEMORY_BLOCK);
   end;
   if page_etc > 0 then
      freeMem(tmf_data[page_number],page_etc);
   freeMem(pack_data,32*line_count);

   for i := $A0 to $B8 do AdLibOut(i,0);
   setClockRate(0);
   ClockUninstall;
   ENABLE_MUSIC := FALSE;
end;

function TimeOut : word;
label
   TIMEOUT_2nd;
begin
   if not ENABLE_MUSIC then exit;

   length := readTMFdata(cur_byte);
   inc(cur_byte);
   if (length = $FF) and (readTMFdata(cur_byte) = $FF) then begin
      cur_byte := 0;
      exit;
   end;
   if length >= $30 then begin
      dec(length,$30);
      pack_code := length;
      pack_mem := Addr(pack_data^[pack_code * 32]);
      goto TIMEOUT_2nd;
   end;
   if length >= $20 then begin
      dec(length,$20);
      pack_code := length * 256 + readTMFdata(cur_byte);
      inc(cur_byte);
      pack_mem := Addr(pack_data^[pack_code * 32]);
      goto TIMEOUT_2nd;
   end;
   while length > 0 do begin
      data1 := readTMFdata(cur_byte);
      inc(cur_byte);
      if data1 = $E6 then begin
         data1 := readTMFdata(cur_byte);
         data2 := readTMFdata(cur_byte+1);
         inc(cur_byte,2);
         temp_long := basic_tempo;
         temp_long := temp_long * data2 div 128 + basic_tempo * data1;
         if temp_long <> 0 then
            rate := (298295 div temp_long);
         setClockRate(rate);
         dec(length);
      end
      else begin
         data2 := readTMFdata(cur_byte);
         inc(cur_byte);
         AdLibOut(data1,data2);
      end;
      dec(length,2);
   end;
   data1 := readTMFdata(cur_byte);
   inc(cur_byte);
   if data1 = $FF then begin
      data1 := readTMFdata(cur_byte);
      data2 := readTMFdata(cur_byte+1);
      inc(cur_byte,2);
      delay := data1 + data2 * 256;
      TimeOut := delay;
      exit;
   end;
   TimeOut := data1;
   exit;

TIMEOUT_2nd:
   pack_count := 0;
   length := pack_mem^[pack_count];
   inc(pack_count);
   if (length = $FF) and (readTMFdata(cur_byte+1) = $FF) then begin
      cur_byte := 0;
      exit;
   end;
   while length > 0 do begin
      data1 := pack_mem^[pack_count];
      inc(pack_count);
      if data1 = $E6 then begin
         data1 := pack_mem^[pack_count];
         data2 := pack_mem^[pack_count+1];
         inc(pack_count,2);
         temp_long := basic_tempo;
         temp_long := temp_long * data2 div 128 + basic_tempo * data1;
         if temp_long <> 0 then
            rate := (298295 div temp_long);
         setClockRate(rate);
         dec(length);
      end
      else begin
         data2 := pack_mem^[pack_count];
         inc(pack_count);
         AdLibOut(data1,data2);
      end;
      dec(length,2);
   end;
   data1 := pack_mem^[pack_count];
   inc(pack_count);
   if data1 = $FF then begin
      data1 := pack_mem^[pack_count];
      data2 := pack_mem^[pack_count+1];
      inc(pack_count,2);
      delay := data1 + data2 * 256;
      TimeOut := delay;
      exit;
   end;
   TimeOut := data1;
end;

function testAdLib : boolean;
 var
    b, test_b : byte;
    temp_b388, temp_b389: byte;
 begin
    temp_b388 := port[$388];

    port[$388] := $BD;
    test_b := port[$388];
    test_b := port[$388];
    test_b := port[$388];
    test_b := port[$388];

    temp_b389 := port[$389];
    port[$389] := 0;

    for b := 1 to 36 do
       test_b := port[$388];

    test_b := test_b and 7;

    port[$388] := temp_b388;
    port[$389] := temp_b389;

    if (test_b = 6) then begin
       testAdLib := TRUE;
    end else begin
       testAdLib := FALSE;
    end;
end;

function testSoundBlaster : boolean;
 var
    count, remember_port, temp_b : byte;
    w : word;
    temp_w : word;
    SB_port : word;
    foundSB : boolean;
    found_port : boolean;
    EQUIP : byte absolute $40:$10;
 begin

    foundSB := FALSE;
    count := 1;
    while (count < 7) and (not foundSB) do begin

       SB_port := $200 + ($10 * count);

       w := 0;
       found_port := FALSE;
       temp_w := SB_port + $0C;
       while (w < $201) and (not found_port) do begin
          if (port[temp_w] and $80) = 0 then found_port:=true;
          Inc(w)
       end;

       if found_port then begin

          remember_port := port[temp_w];
          port[temp_w] := $D3;
          for temp_w := 1 to $1000 do; { not work }
          temp_w := SB_port + 6;
          port[temp_w] := 1;
          temp_b := port[temp_w];
          temp_b := port[temp_w];
          temp_b := port[temp_w];
          temp_b := port[temp_w];
          port[temp_w] := 0;
          temp_w := SB_port + $0E;
          temp_b := 0;

          repeat
             w := 0;
             found_port := FALSE;
             while (w < $201) and (not found_port) do begin
                if (port[temp_w] and $80) = $80 then found_port := TRUE;
                Inc(w)
             end;
             if found_port then begin
                if port[SB_port + $0A] = $AA then foundSB := TRUE;
             end;
             inc(temp_b)
          until (temp_b = $10) or (found_port);

          port[temp_w]:=remember_port;

       end;

       inc(count);

    end;
    testSoundBlaster := foundSB;

end;

begin

   if testSoundBlaster then DETECT_SOUND_CARD := SOUND_BLASTER
   else if testAdLib   then DETECT_SOUND_CARD := ADLIB_CARD
   else                     DETECT_SOUND_CARD := NOT_FOUND;

   TimeOutFunction := TimeOut;
end.
