#include "BackBuff.h"

#include <windowsx.h>	// for GlobalAllocPtr

LPBYTE m_pDIB		=NULL;
DWORD  m_Image		=NULL;
DWORD	m_DataSize	=0;
HPALETTE m_hPalette = NULL;

BOOL IsValidBackBuff() { return (m_pDIB != NULL); };	

void DisPlayBackBuff( HDC hDC , int x, int y )
{
	if( IsValidBackBuff() == FALSE ) return;

	int w = BackBuffWidth();
	int h = BackBuffHeight();
	
	if( m_hPalette != NULL )
	{
		HPALETTE hOldPalette;

		hOldPalette = SelectPalette( hDC, m_hPalette, FALSE);

		RealizePalette(hDC);

		SetDIBitsToDevice( hDC, x,y,w,h, 0,h,h,h,BackBuffPtr(),(BITMAPINFO*)m_pDIB,DIB_RGB_COLORS );

		SelectPalette(hDC, hOldPalette, FALSE);
	}
	else
		SetDIBitsToDevice( hDC, x,y,w,h, 0,h,h,h,BackBuffPtr(),(BITMAPINFO*)m_pDIB,DIB_RGB_COLORS );
};

void CloseBackBuff()
{
	if( IsValidBackBuff() )
	{
		GlobalFreePtr(m_pDIB);
		if( m_hPalette != NULL ) DeleteObject( m_hPalette );
		m_hPalette = NULL;
		
		m_pDIB = NULL;
		m_Image = 0;
		m_DataSize = 0;
	}		
}

BOOL InitBackBuff( long width, long height, BOOL IsIndex )
{
	CloseBackBuff();

	if( IsIndex )
	{
		m_Image = 256L*sizeof(PALETTEENTRY)+sizeof(BITMAPINFOHEADER);
		m_DataSize = width*height + m_Image ;
	}
	else
	{
		m_Image = sizeof(BITMAPINFOHEADER);
		m_DataSize = width*height*3 + m_Image ;
	};
			
	m_pDIB = (LPBYTE) GlobalAllocPtr(GMEM_MOVEABLE,m_DataSize);
	if (m_pDIB==NULL) return FALSE;

	memset(m_pDIB,0,m_DataSize);

	((BITMAPINFOHEADER*) m_pDIB)->biSize = sizeof(BITMAPINFOHEADER);
	((BITMAPINFOHEADER*) m_pDIB)->biHeight = -height;
	((BITMAPINFOHEADER*) m_pDIB)->biWidth = width;
	((BITMAPINFOHEADER*) m_pDIB)->biPlanes = 1;
	if( IsIndex )	((BITMAPINFOHEADER*) m_pDIB)->biBitCount = 8;
	else			((BITMAPINFOHEADER*) m_pDIB)->biBitCount = 24;
	((BITMAPINFOHEADER*) m_pDIB)->biCompression = BI_RGB;
	
	return TRUE;
};

LPBYTE BackBuffPtr()
{
	if( IsValidBackBuff() == FALSE ) return 0;
	return m_pDIB + m_Image;
};

PALETTEENTRY* BackBuffPalette()
{
	if( IsValidBackBuff() == FALSE ) return NULL;
	if( BackBuffBpp() != 8 ) return NULL;
	return (PALETTEENTRY*)((LPBYTE)m_pDIB + sizeof(BITMAPINFOHEADER));
};

long BackBuffWidth()
{
	if( IsValidBackBuff() == FALSE ) return 0;
	return ((BITMAPINFOHEADER*) m_pDIB)->biWidth ;
};

long BackBuffHeight()
{
	if( IsValidBackBuff() == FALSE ) return 0;
	return -((BITMAPINFOHEADER*) m_pDIB)->biHeight ;
};

DWORD BackBuffBpp()
{
	if( IsValidBackBuff() == FALSE ) return 0;
	return ((BITMAPINFOHEADER*) m_pDIB)->biBitCount ;
};

/////////////////////////////////
//	Palette
/////////////////////////////////

HPALETTE Create256Palette( PALETTEENTRY *Palentry );

BOOL SetPalette( LPRGBQUAD rq )
{
    return SetPalette( (PALETTEENTRY*)rq );
};

BOOL SetPalette( PALETTEENTRY* pe )
{
    PALETTEENTRY* ppal = BackBuffPalette();

	if( ppal == NULL ) return FALSE;
	memcpy( (LPBYTE)ppal, (LPBYTE)pe, 256L*sizeof(PALETTEENTRY) );

	Create256Palette( ppal );

	return TRUE;
};

BOOL SetPalette( LPBYTE palette )
{
	PALETTEENTRY* ppal = BackBuffPalette();
	if( ppal == NULL ) return FALSE;

    for(int i = 0; i < 256; i++, palette+=3) 
	{
        ppal[i].peBlue   = palette[0]<<2;
        ppal[i].peGreen = palette[1]<<2;
        ppal[i].peRed  = palette[2]<<2;
        ppal[i].peFlags = 0;
    };

	Create256Palette( ppal );

	return TRUE;
};

HPALETTE Create256Palette( PALETTEENTRY *Palentry )
{
	if( m_hPalette != NULL ) DeleteObject( m_hPalette );
	m_hPalette = NULL;

	struct
	{
		WORD Version;
		WORD NumberOfEntries;
		PALETTEENTRY aEntries[256];
	}logicalPalette = {0x300, 256 };

	memcpy( logicalPalette.aEntries, Palentry, 256*4 );
	
	return m_hPalette = CreatePalette((LPLOGPALETTE)&logicalPalette);
}

