#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include "wpgraph.h"
#include "wphanin.h"
#include "wphanout.h"
#include "convert.h"
#include "ansi.h"

#define MAXLINE 26
#define _X(x) ((x)*8)
#define _Y(y) ((y)*16+16+8)

char ansiBuf[30];
int ansiStep;
int ansiMode;
int ansiNums;
int ansiNumN;
int ansiNumber[10];
char ansiNumStr[10];

typedef struct
{
    int x, y;
    int fcolor, bcolor;
    int fc, bc;
    int inv, acc;
} TansiStatus;

TansiStatus _cur, _sav;

void ansiCursor(int mode)
{
    asm     xor     ax, ax
    asm     mov     es, ax
    asm     mov     bx, 046Ch       /* 0000:046Ch */
    asm     mov     di, es:[bx]
    asm     and     di, 15

    static int CursorState = 0;

    if (mode && !CursorState) return;

    int CursorX = _X(_cur.x);
    int CursorY = _Y(_cur.y);
    int SaveOp = WPGetOp();

    if ((_DI < 5 && CursorState == 0) || (_DI >= 5 && CursorState) || mode)
    {
        CursorState = 1 - CursorState;
        SaveOp = WPGetOp();
        WPSetOp(WPOP_XOR);
        WPFillBox(CursorX, CursorY + 13, CursorState << 3, 3, 0x0F);
        WPSetOp(SaveOp);
    }
}

void hanWriteCh(char Ch)
{
    static int _hanmode = 0;
    static char prevCh;

    ansiCursor(1);
    if (_hanmode)
    {
        _hanmode = 0;
        if (_cur.x==79)
        {
            hanWriteCh('X');
            hanWriteCh('X');
            return;
        }
        char temp[3];
        sprintf(temp,"%c%c",prevCh,Ch);
        nrCodeConvStr(KS5601, SANGYONG, temp);
        WPPuts(_X(_cur.x),_Y(_cur.y),_cur.fcolor+_cur.bcolor*16,temp);
        _cur.x+=2;
        if (_cur.x<80) return;
    }
    else
    {
        if ((unsigned char) Ch>127)
        {
            _hanmode = 1;
            prevCh = Ch;
            return;
        }
        switch (Ch)
        {
            case 13 : _cur.x = 0; return;
            case 10 : goto NextLine;
            case  8 : if (--_cur.x<0)
                      {
                          _cur.x = 79;
                          if (--_cur.y<0) _cur.y = 0;
                      }
                      hanWriteCh(' ');
                      if (--_cur.x<0)
                      {
                          _cur.x = 79;
                          if (--_cur.y<0) _cur.y = 0;
                      }
                      return;
            default : gotoxy(_cur.x+1,_cur.y+1);
                      char temp[3];
                      sprintf(temp,"%c",Ch);
                      WPPuts(_X(_cur.x),_Y(_cur.y),_cur.fcolor+_cur.bcolor*16,temp);
                      _cur.x++;
                      if (_cur.x<80) return;
                      break;
            }
    }
    _cur.x = 0;
NextLine:
    _cur.y++;
    if (_cur.y==MAXLINE)
    {
        _ScrollUp(0,16+8,80,(MAXLINE)*16,16);
        WPFillBox(0,_Y(MAXLINE-1),640,16,_cur.bcolor);
        _cur.y = MAXLINE-1;
    }
}

void ansiFlushBuf(void)
{
//    for (int i=0;i<ansiStep;i++)
//        hanWriteCh(ansiBuf[i]);
    ansiStep=0;
}

void ansiMoveCursor(int dx, int dy)
{
    ansiCursor(1);
    _cur.x+=dx;
    _cur.y+=dy;
    if (_cur.x<0)  _cur.x = 0;
    if (_cur.x>79) _cur.x = 79;
    if (_cur.y<0)  _cur.y = 0;
    if (_cur.y>=MAXLINE) _cur.y = MAXLINE-1;
}

void ansiMoveCursorAbs(int x, int y)
{
    ansiCursor(1);
    _cur.x = x-1;
    _cur.y = y-1;
    if (_cur.x<0)  _cur.x = 0;
    if (_cur.x>79) _cur.x = 79;
    if (_cur.y<0)  _cur.y = 0;
    if (_cur.y>=MAXLINE) _cur.y = MAXLINE-1;
}

void ansiLoadStatus(void)
{
    _cur = _sav;
}

void ansiSaveStatus(void)
{
    _sav = _cur;
}

void ansiScreenClearDown(void)
{
    ansiLineClearDown();
    if (_cur.y+1>=MAXLINE) return;
    WPFillBox(_X(0),_Y(_cur.y+1),640,16*(MAXLINE-_cur.y-1),_cur.bcolor);
}

void ansiScreenClearUp(void)
{
    ansiLineClearUp();
    if (_cur.y-1<0) return;
    WPFillBox(_X(0),_Y(0),640,16*(_cur.y),_cur.bcolor);
}

void ansiLineClearDown(void)
{
    WPFillBox(_X(_cur.x),_Y(_cur.y),_X(80-_cur.x),16,_cur.bcolor);
}

void ansiLineClearUp(void)
{
    WPFillBox(_X(0),_Y(_cur.y),_X(_cur.x),16,_cur.bcolor);
}

void ansiDoColor(int color)
{
    const int colorTable[][8]
          = { {BLACK,RED,GREEN,BROWN,BLUE,MAGENTA,CYAN,LIGHTGRAY},
              {BLACK,LIGHTRED,LIGHTGREEN,YELLOW,LIGHTBLUE,LIGHTMAGENTA,LIGHTCYAN,WHITE}};

    if (color/10==3) _cur.fc = color%10;
    if (color/10==4) _cur.bc = color%10;
    if (color==0)
    {
//        _cur.acc = 0;
        _cur.inv = 0;
    }
    if (color==1) _cur.acc = 1;
    if (color==7) _cur.inv = 1;

    int F = colorTable[_cur.acc][_cur.fc];
    int B = colorTable[0][_cur.bc];

    if (_cur.inv)
    {
        _cur.fcolor = B;
        _cur.bcolor = F;
    }
    else
    {
        _cur.fcolor = F;
        _cur.bcolor = B;
    }
}


void ansiInit(void)
{
    _cur.x = 0;
    _cur.y = 0;
    _cur.fc = 7;
    _cur.bc = 0;
    _cur.inv = 0;
    _cur.acc = 1;
    ansiDoColor(1);
    ansiStep = 0;
    ansiMode = 0;
    ansiNums = 0;
    ansiNumN = 0;
}

int ansiDo(char c)
{
    switch (ansiStep)
    {
        case 0 : // begin
             if (c==27)
             {
                ansiBuf[0] = 27;
                ansiStep++;
                return 0;
             }
             return 1;
        case 1 : // '['
             if (c=='7' || c=='8')
             {
                ansiStep=0;
                return 0;
             }
             if (c=='[')
             {
                ansiBuf[1] = c;
                ansiStep++;
                return 0;
             }
             ansiFlushBuf();
             ansiStep=0;
             return 1;
    }
    // scan for cmd
    int i, j;

    ansiBuf[ansiStep]=c;

    if (c>='0' && c<='9')
    {
        ansiNumStr[ansiNumN++] = c;
        ansiStep++;
        return 0;
    }
    else
    {
        if (ansiNumN>0)
        {
            ansiNumStr[ansiNumN] = 0;
            ansiNumber[ansiNums++] = atoi(ansiNumStr);
            ansiNumN = 0;
        }
    }

    switch (c)
    {
        case ';' :
        case '#' :
             ansiStep++;
             break; //
        case 'A' :
        case 'B' :
        case 'C' :
        case 'D' :
             const int ansiDirPre[4][2] = {{0,-1},{0,+1},{+1,0},{-1,0}};
             if (ansiNums>1) goto error;
             if (ansiNums==0) j = 1; else j = ansiNumber[0];
             ansiMoveCursor(ansiDirPre[c-'A'][0]*j,ansiDirPre[c-'A'][1]*j);
             ansiStep=0; ansiNums = 0;
             break;
        case 'H' :
        case 'f' :
             if (ansiNums!=2)
             {
                ansiNums = 2;
                ansiNumber[0] = ansiNumber[1] = 1;
             }
             ansiMoveCursorAbs(ansiNumber[1], ansiNumber[0]);
             ansiStep=0; ansiNums = 0;
             break;
        case 's' :
             if (ansiNums>0) goto error;
             ansiSaveStatus();
             ansiStep=0; ansiNums = 0;
             break;
        case 'u' :
             if (ansiNums>0) goto error;
             ansiLoadStatus();
             ansiStep=0; ansiNums = 0;
             break;
        case 'J' :
             if (ansiNums>1) goto error;
             if (ansiNums==0 || (ansiNums>0 && ansiNumber[0]==2)) ansiScreenClearDown();
             if (ansiNums>0 && (ansiNumber[0]==1 || ansiNumber[0]==2)) ansiScreenClearUp();
             if (ansiNumber[0]==2) ansiMoveCursorAbs(0,0);
             ansiStep=0; ansiNums = 0;
             break;
        case 'K' :
             if (ansiNums>1) goto error;
             if (ansiNums==0 || (ansiNums>0 && ansiNumber[0]==2)) ansiLineClearDown();
             if (ansiNums>0 && (ansiNumber[0]==1 || ansiNumber[0]==2)) ansiLineClearUp();
             ansiStep=0; ansiNums = 0;
             break;
        case 'm' :
             if (ansiNums==0)
             {
                ansiNums=1;
                ansiNumber[0]=0;
             }
             for (i=0;i<ansiNums;i++)
                 ansiDoColor(ansiNumber[i]);
             ansiStep=0; ansiNums = 0;
             break;
        default :
        error :
             ansiFlushBuf();
             return 0;
    }
    return 0;
}

