#include <stdio.h>
#include <string.h>
#include <conio.h>

#include "vars.h"
#include "modem.h"
#include "buffer.h"
#include "user.h"
#include "question.h"
#include "usercmd.h"
#include "etcwin.h"
#include "video.h"
#include "flag.h"
#include "security.h"
#include "windat.h"
#include "wpgraph.h"
#include "game.h"

const int maxBufferLine = 50;
const int maxBufferCol = 235;
int currentBufferLine, currentBufferPos, bufferReadPointer;
char bufferData[maxBufferLine][maxBufferCol+20];
int Server;
int overflow = 0;
const char predefinedServerName[ServerNum][20] = {"  ","촩"};

void deoverflow(void)
{
    overflow=0;
}

void getServerName(char* str)
{
    strcpy(str, predefinedServerName[Server]);
}
int getServerType(void)
{
    return Server;
}

void setServerType(int i)
{
    Server = i;
}

// * FUNCTION *-------------------------------------------------------
// name ; bufferCheck
// in   ;
// out  ;
// des. ; checks the buffer.
// * FUNCTION *-------------------------------------------------------

void bufferCheckHiTEL(void)
{
	char newName[20], newID[20], q=0;

	while (bufferReadPointer!=currentBufferLine)
	{
		// current line --> CLstr
		char* CLstr = bufferData[bufferReadPointer];

        if (strlen(CLstr)<10) goto NextLine;

        if (CLstr[0]=='\r') CLstr++;
		// check for ## IN / OUT MSG
		if (CLstr[0]=='#' && CLstr[1]=='#' && CLstr[2]==' ')
		{
			// adopt name & ID
			// name ; 4----(ID...)

            q = 0;
			for (int i=3;i<80;i++)
				if (CLstr[i]=='(') break; else
                if (q>15) goto NextLine; else newName[q++]=CLstr[i];
			newName[q]=0;

			q=0;i++;
			for (;i<80;i++)
				if (CLstr[i]==')') break; else
                if (q>15) goto NextLine; else newID[q++]=CLstr[i];
			newID[q]=0;

			// IN/OUT Check
			i+=7;
//			if (CLstr[i]==192)
				// IN
//				userLogon(newName, newID);
//				else
				{
					// OUT
					int _UN = userNumber(newID);
					if (_UN>0) userLogout(_UN);
				}
			goto NextLine;
		}

        // check for Commands

		if (CLstr[0]!=' ')
        {
            if (strlen(CLstr)<16) goto NextLine;
//            _userSysopsUN = 0;
            setFlag(FLAG_SYSOPCMD,0);
		    if (CLstr[1]=='!')
            {
               CLstr+=3;
//               _userSysopsUN = 1;
               setFlag(FLAG_SYSOPCMD,1);
            }

            q=0;
			for (int i=0;i<80;i++)
				if (CLstr[i]=='(') break; else
                if (q>15) goto NextLine; else newName[q++]=CLstr[i];
			newName[q]=0;

			q=0;i++;
			for (;i<80;i++)
				if (CLstr[i]==')') break; else
                if (q>15) goto NextLine; else newID[q++]=CLstr[i];
			newID[q]=0;

			for (int j=0;j<8;j++)
				if (newID[j]==' ') newID[j]=0;

			// now pointer on ')  MSG'
			for (i++;i<80;i++)
				if (CLstr[i]!=' ') break;

			int UN = userNumber(newID);
			if (UN<0 && strlen(newID)>=4 && strlen(newID)<=8 && strlen(newName)>=4 && strlen(newName)<=20)
			{
				UN = userLogon(newName, newID);
                if (UN<0)
                {
//                    ttyOut("**   ߻ **");
                    goto NextLine;
                }
            }

			// check for Command
			if (UN>=0 && getFlag(FLAG_questionModeON) && CLstr[i]!='!')
			{
				char error = 0;
                char _questionAnswer[255];

                noIDLE(UN); // NO IDLE

                questionCopyAnswer(_questionAnswer);
				for (j=0;j<strlen(_questionAnswer);j++)
					if (CLstr[i+j]!=_questionAnswer[j]) error = 1;
				if (error) 	userMissTypingCase(UN); else userCorrectTypeCase(UN);
			};

            if (CLstr[i]==34)
               userREQquestion(UN, CLstr+i);
			if (CLstr[i]=='!')
               userCMD(UN, CLstr+i);
            if (CLstr[i]=='&')
               gameCMD(UN, CLstr+i);
		}



NoOoo:

NextLine:
		bufferReadPointer++;
		if (bufferReadPointer>=maxBufferLine) bufferReadPointer = 0;
	}
}


char _preID[20];

void bufferCheckNowNuri(void)
{
	char newName[20], newID[20], OtherPart;

	while (bufferReadPointer!=currentBufferLine)
	{
		// current line --> CLstr
		char* CLstr = bufferData[bufferReadPointer];
        char _21H = 0;

        if (strlen(CLstr)<3) goto NextLine;

        char tmp[10];
        strncpy(tmp, CLstr, 6);
        tmp[6] = 0;
        if (strcmp(tmp,"[23;2H")==0)
        {
            goto NextLine;
        } else
        if (strcmp(tmp,"[21;2H")==0)
        {
            CLstr+=7; // other's
            OtherPart = 1;
            _21H = 1;
        }
        else OtherPart = 0;

        tmp[3]=0;
        if (_preID[0]==0) setFlag(FLAG_SYSOPCMD,0);
        if (strcmp(tmp,"[7m")==0)
        {
            strncpy(_preID, CLstr+3, 8);
            _preID[8]=0;
            setFlag(FLAG_SYSOPCMD,1);
            goto NextLine; // my ID
        }

        tmp[2]=0;
        if (strcmp(tmp,"[m")==0) CLstr+=2; // my name
        else
        if (strlen(CLstr)<10) goto NextLine;

		// check for ## IN / OUT MSG
		if (CLstr[0]=='*' && CLstr[1]=='*' && CLstr[2]=='*' && _21H)
		{
            CLstr+=4;

            for (int i=0;i<10;i++)
            {
                if (CLstr[i]==0 || CLstr[i]=='(') break;
            }
            strncpy(newID,CLstr,i);
            newID[i]=0;
            CLstr+=i;
            if (CLstr[0]!='(') goto NextLine;

            for (i=0;i<10;i++)
            {
                if (CLstr[i]==')' || CLstr[i]==0) break;
            }
            strncpy(newName,CLstr,i);
            newName[i]=0;
            CLstr+=i;
            if (CLstr[0]!=')') goto NextLine;


            int _UN = userNumber(newID);
			if (_UN>0) userLogout(_UN);

			goto NextLine;
		}

        // check for Commands

//        goto NextLine;

		if (CLstr[0]!=' ')
        {
            if (strlen(CLstr)<5) goto NextLine;
//            _userSysopsUN = 0;
		    if (!OtherPart)
            {
               // get name only
//               _userSysopsUN = 1;
               strcpy(newID, _preID);
            }
            else
            {
               strncpy(newID, CLstr, 8);
               CLstr+=8;
            }

            newID[8]=0;

			for (int j=0;j<8;j++)
				if (newID[j]==' ') newID[j]=0;


            if (*CLstr!='(') goto NextLine;
            CLstr++;

            // name)
            for (int i=0;i<10;i++)
            {
                if (CLstr[i]==0) break;
                if (CLstr[i]==')') break;
            }
            strncpy(newName, CLstr, i);
            newName[i] = 0;

            CLstr+=i;
            if (*CLstr!=')') goto NextLine;
            CLstr++;

            for (;;)
            {
                if (*CLstr!=' ') break;
                CLstr++;
            }

			int UN = userNumber(newID);
			if (UN<0 && strlen(newID)>=4 && strlen(newID)<=8 && strlen(newName)>=3 && strlen(newName)<=20)
			{
				UN = userLogon(newName, newID);
                if (UN<0)
                {
//                    ttyOut("**   ߻ **");
                    goto NextLine;
                }
            }

            if (UN>=0 && strcmp(getUD(UN)->name,newName)!=0)
            {
                char tmpstr[80];
                sprintf(tmpstr,"# %s ȭ %s ٲϴ", newID, newName );
                ttyOut(tmpstr);
                strcpy(getUD(UN)->name,newName);
                setFlag(FLAG_userInfoChanged,1);
                drawInfoWindow();
            }

			// check for Command
			if (UN>=0 && getFlag(FLAG_questionModeON) && CLstr[0]!='!')
			{
				char error = 0;
                char _questionAnswer[255];

                noIDLE(UN); // NO IDLE

                questionCopyAnswer(_questionAnswer);
				for (j=0;j<strlen(_questionAnswer);j++)
					if (CLstr[j]!=_questionAnswer[j]) error = 1;
				if (error) 	userMissTypingCase(UN); else userCorrectTypeCase(UN);
			};

            if (CLstr[0]==34)
               userREQquestion(UN, CLstr);
			if (CLstr[0]=='!')
               userCMD(UN, CLstr);
            if (CLstr[0]=='&')
               gameCMD(UN, CLstr+i);
		}


        _preID[0] = 0;

NoOoo:

NextLine:
		bufferReadPointer++;
		if (bufferReadPointer>=maxBufferLine) bufferReadPointer = 0;
	}
}


// * FUNCTION *-------------------------------------------------------
// name ; bufferIn
// in   ;
// out  ;
// des. ; get data from MODEM
// * FUNCTION *-------------------------------------------------------
void bufferIn(void)
{
    char newChar;

	while (ttyReady() && !overflow)
	{
        if (currentBufferPos-1>=maxBufferCol)
           newChar = 0;
        else
           newChar = ttyIn();

		if (newChar=='\n' || newChar==27) newChar=0;
// for safety
        if (currentBufferLine>=maxBufferLine) currentBufferLine = 0;
        if (currentBufferPos>=maxBufferCol) currentBufferPos = 0;
// end of f.s
		bufferData[currentBufferLine][currentBufferPos++]=newChar;
		if (newChar==0)
		{
			currentBufferLine++;
			if (currentBufferLine>=maxBufferLine) currentBufferLine = 0;
			currentBufferPos = 0;
            int temp = currentBufferLine;
            if (++temp>=maxBufferLine) temp = 0;
            if (temp==bufferReadPointer) overflow = 1;
        }
	}
}


// * FUNCTION *-------------------------------------------------------
// name ; bufferOut
// in   ;
// out  ;
// des. ; prints buffer-data to screen
// * FUNCTION *-------------------------------------------------------

void statusLine ( void )
{
    const char prz[][8] = {"o","x"};
    static char preStr[80]="";
    char temp[80];
    setTextColor(LIGHTRED);
    setFlag(FLAG_groupAllowed, getFlag(FLAG_groupAllowed) ? 1 : 0 );
    sprintf ( temp, "BUF[%2d/%2d] 㰡[%1s/%1s/%1s/%1s]",
                    currentBufferLine,
                    bufferReadPointer,
                    prz[1-getFlag(FLAG_questionSysopAllow)],
                    prz[1-getFlag(FLAG_questionUserQOK)],
                    prz[1-getFlag(FLAG_groupAllowed)],
                    prz[1-getFlag(FLAG_gameModeOn)] );
    if (strcmp(temp,preStr)!=0)
    {
        strcpy(preStr,temp);
        drawWinTitle(getWINREC(BUFWIN)->X,getWINREC(BUFWIN)->Y,getWINREC(BUFWIN)->WIDTH,temp,BLUE,LIGHTGRAY,WHITE);
    }
}

void bufferOutHiTEL (void)
{
	// print buffer to screen
	int i = bufferReadPointer;
    char temp[80];
    int j;

	setTextColor(WHITE);
    statusLine();
    if (i!=currentBufferLine)
    {
        setTextAttr ( WHITE + BLUE*16 );
        while (i!=currentBufferLine)
        {
            statusLine();
            int length = strlen(bufferData[i]);
            if (length>0 && (bufferData[i][0]=='/' || (bufferData[i][2]=='!' && bufferData[i][4]=='[')))
            {
                i++;
                if (i>=maxBufferLine) i=0;
                continue;
            }
            int lines = length/getWINREC(BUFWIN)->WIDTH+1;
            for (int q=0;q<lines;q++)
            {
                for (int sc=0;sc<2;sc++)
                    _ScrollUp(getWINREC(BUFWIN)->X-1,2+getWINREC(BUFWIN)->Y*16-16,getWINREC(BUFWIN)->WIDTH,getWINREC(BUFWIN)->HEIGHT*16-1,8);
                WPFillBox(getWINREC(BUFWIN)->X*8-8,1+(getWINREC(BUFWIN)->Y+getWINREC(BUFWIN)->HEIGHT-2)*16,getWINREC(BUFWIN)->WIDTH*8,16,BLUE);
            }

            setTextColor(WHITE);
            char temp[255];

            int miss=0;
            for (int ii=0;ii<lines-1;ii++)
            {
                strncpy(temp,bufferData[i]+ii*getWINREC(BUFWIN)->WIDTH,getWINREC(BUFWIN)->WIDTH);
                if (miss && (unsigned char)temp[0]>127) temp[0]='X';

                for (int z=0;z<getWINREC(BUFWIN)->WIDTH;z++)
                    if ((unsigned char)temp[z]<32) temp[z]=32;
                temp[getWINREC(BUFWIN)->WIDTH]=0;
                //
                int han=0;
                for (z=0;z<getWINREC(BUFWIN)->WIDTH;z++)
                {
                    switch (han)
                    {
                        case 0 :
                             if ((unsigned char)temp[z]>127) han = 1;
                             break;
                        case 1 :
                             han = 0;
                             break;
                    }
                }
                if (han)
                {
                    temp[getWINREC(BUFWIN)->WIDTH-1]='X';
                    miss = 1;
                }


                putsG(getWINREC(BUFWIN)->X,getWINREC(BUFWIN)->Y+getWINREC(BUFWIN)->HEIGHT-(lines-ii),temp);

                // miss
            }
            strcpy(temp,bufferData[i]+ii*getWINREC(BUFWIN)->WIDTH);
            temp[getWINREC(BUFWIN)->WIDTH]=0;
            if (miss && (unsigned char)temp[0]>127) temp[0]='X';
            for (int z=0;z<strlen(temp);z++)
                if ((unsigned char)temp[z]<32) temp[z]=32;
            putsG(getWINREC(BUFWIN)->X,getWINREC(BUFWIN)->Y+getWINREC(BUFWIN)->HEIGHT-1,temp);
            i++;
            if (i>=maxBufferLine) i=0;
        };
    }
    if (getFlag(FLAG_userInfoChanged))
    {
        drawInfoWindow();
        setFlag(FLAG_userInfoChanged,0);
        setTextColor(LIGHTGREEN);
        setTextAttr(YELLOW+RED*16);
        char premode[][9] = { " ̵ ",
                              "    ",
                              " Ÿ   ",
                              "    ",
                              "¸ȸ"};

        putsG ( getWINREC(USERWIN)->X, getWINREC(USERWIN)->Y, premode[getFlag(FLAG_infoMode)] );
        for (i=0;i<12;i++)
        {
            setTextAttr(LIGHTGREEN+RED*16);
            setTextColor(getUS(i));
            if (getUD(i)->alive>=0)
            {
               switch (getFlag(FLAG_infoMode))
               {
                  case 0 : sprintf ( temp, "%-8s", getUD(i)->id ); break;
                  case 1 : sprintf ( temp, "%-8s", getUD(i)->name ); break;
                  case 2 :  int tasu;
                            if (getUD(i)->number<=0) tasu = 0;
                            else
                                tasu = getUD(i)->total / getUD(i)->number;
                            sprintf ( temp, " %4dŸ ", tasu ); break;
                  case 3 : sprintf ( temp, " %5d", getUD(i)->score); break;
                  case 4 : sprintf ( temp, " %5dȸ", getUD(i)->VicNum); break;
               }
               putsG ( getWINREC(USERWIN)->X, i+1+getWINREC(USERWIN)->Y, temp );
            }
            else
               putsG ( getWINREC(USERWIN)->X, i+1+getWINREC(USERWIN)->Y, "  none  " );
        }
    }
    return;
}

void bufferOutNowNuri (void)
{
	// print buffer to screen
	int i = bufferReadPointer;
    char temp[80];
    char curBufData[256];
    int color = WHITE;

    int j;

	setTextColor(WHITE);
    statusLine();
    if (i!=currentBufferLine)
    {
        setTextAttr ( WHITE + BLUE*16 );
        while (i!=currentBufferLine)
        {
            statusLine();
            strcpy(curBufData, bufferData[i]);

            int length = strlen(curBufData);

            char tmp[80];
            strncpy(tmp,curBufData,4);

            tmp[4] = 0;

            if (strcmp(tmp,"[21;")==0 && length>=7)
            {
                char tmpstr[256];
                strcpy(tmpstr,curBufData+6);
                strcpy(curBufData,tmpstr);
                length = strlen(curBufData);
            }
            if (length>=0
               &&
               ( curBufData[0]=='/' || strcmp(tmp,"[23;")==0

                 || (tmp[0]=='[' && tmp[1]=='7' && tmp[2]=='m')
                 || tmp[0]=='8'
                 || tmp[0]=='7' || (curBufData[11]=='<' && curBufData[12]=='<')
                 || length<5 || (curBufData[0]!=' ' && curBufData[0]!='[')))
            {
                i++;
                if (i>=maxBufferLine) i=0;
                continue;
            }

            if (tmp[0]=='[' && tmp[1]=='m')
            {
                char tmpstr[255];
                strcpy(tmpstr, curBufData+2);
                color = LIGHTCYAN;
                char _userSysopID[20];
                securityCopySysopID(_userSysopID);
                sprintf(curBufData," %-8s%s",_userSysopID,tmpstr);
            }
            else
                color = WHITE;
            int lines = length/getWINREC(BUFWIN)->WIDTH+1;
            for (int q=0;q<lines;q++)
            {
                for (int sc=0;sc<2;sc++)
                    _ScrollUp(getWINREC(BUFWIN)->X-1,2+getWINREC(BUFWIN)->Y*16-16,getWINREC(BUFWIN)->WIDTH,getWINREC(BUFWIN)->HEIGHT*16-1,8);
                WPFillBox(getWINREC(BUFWIN)->X*8-8,1+(getWINREC(BUFWIN)->Y+getWINREC(BUFWIN)->HEIGHT-2)*16,getWINREC(BUFWIN)->WIDTH*8,16,BLUE);
            }

            setTextColor(color);
            char temp[255];

            int miss=0;
            for (int ii=0;ii<lines-1;ii++)
            {
                strncpy(temp,curBufData+ii*getWINREC(BUFWIN)->WIDTH,getWINREC(BUFWIN)->WIDTH);
                if (miss && (unsigned char)temp[0]>127) temp[0]='X';

                for (int z=0;z<getWINREC(BUFWIN)->WIDTH;z++)
                    if ((unsigned char)temp[z]<32) temp[z]=32;
                temp[getWINREC(BUFWIN)->WIDTH]=0;
                //
                int han=0;
                for (z=0;z<getWINREC(BUFWIN)->WIDTH;z++)
                {
                    switch (han)
                    {
                        case 0 :
                             if ((unsigned char)temp[z]>127) han = 1;
                             break;
                        case 1 :
                             han = 0;
                             break;
                    }
                }
                if (han)
                {
                    temp[getWINREC(BUFWIN)->WIDTH-1]='X';
                    miss = 1;
                }


                putsG(getWINREC(BUFWIN)->X,getWINREC(BUFWIN)->Y+getWINREC(BUFWIN)->HEIGHT-(lines-ii),temp);

                // miss
            }
            strcpy(temp,curBufData+ii*getWINREC(BUFWIN)->WIDTH);
            temp[getWINREC(BUFWIN)->WIDTH]=0;
            if (miss && (unsigned char)temp[0]>127) temp[0]='X';
            for (int z=0;z<strlen(temp);z++)
                if ((unsigned char)temp[z]<32) temp[z]=32;
            putsG(getWINREC(BUFWIN)->X,getWINREC(BUFWIN)->Y+getWINREC(BUFWIN)->HEIGHT-1,temp);
            i++;
            if (i>=maxBufferLine) i=0;
        };
    }
    if (getFlag(FLAG_userInfoChanged))
    {
        drawInfoWindow();
        setFlag(FLAG_userInfoChanged,0);
        setTextColor(LIGHTGREEN);
        setTextAttr(YELLOW+RED*16);
        char premode[][9] = { " ̵ ",
                              "    ",
                              " Ÿ   ",
                              "    ",
                              "¸ȸ"};

        putsG ( getWINREC(USERWIN)->X, getWINREC(USERWIN)->Y, premode[getFlag(FLAG_infoMode)] );
        for (i=0;i<12;i++)
        {
            setTextAttr(LIGHTGREEN+RED*16);
            setTextColor(getUS(i));
            if (getUD(i)->alive>=0)
            {
               switch (getFlag(FLAG_infoMode))
               {
                  case 0 : sprintf ( temp, "%-8s", getUD(i)->id ); break;
                  case 1 : sprintf ( temp, "%-8s", getUD(i)->name ); break;
                  case 2 :  int tasu;
                            if (getUD(i)->number<=0) tasu = 0;
                            else
                                tasu = getUD(i)->total / getUD(i)->number;
                            sprintf ( temp, " %4dŸ ", tasu ); break;
                  case 3 : sprintf ( temp, " %5d", getUD(i)->score); break;
                  case 4 : sprintf ( temp, " %5dȸ", getUD(i)->VicNum); break;
               }
               putsG ( getWINREC(USERWIN)->X, i+1+getWINREC(USERWIN)->Y, temp );
            }
            else
               putsG ( getWINREC(USERWIN)->X, i+1+getWINREC(USERWIN)->Y, "  none  " );
        }
    }
    return;
}


// * FUNCTION *-------------------------------------------------------
// name ; bufferClear
// in   ;
// out  ;
// des. ; clears the buffer
// * FUNCTION *-------------------------------------------------------
void bufferClear(void)
{
	currentBufferPos = 0;
	currentBufferLine = 0;
	bufferReadPointer = 0;
}
