#include <stdio.h>
#include <conio.h>
#include <String.h>
#include "wpgraph.h"
#include "wphanin.h"
#include "wphanout.h"
#include "wpkeydef.h"
#include "convert.h"
#include "chat.h"

const int _chatMaxBuf = 20;
char _chatTail[100];
char _chatInternalBuffer[_chatMaxBuf][80];
int _chatCurBuf;
char *_chatInternalString;

void pasteTail(char* str)
{
    strcat(str," ");
    strcat(str,_chatTail);
}

void getChatStr(char* str)
{
    int j=0, mode=0;
    for (int i=0;i<strlen(_chatInternalString);i++)
    {
        switch (mode)
        {
            case 0 :
                 if (_chatInternalString[i]=='$') mode = 1;
                 else
                     str[j++] = _chatInternalString[i];
                 break;
            case 1 :
                 switch (_chatInternalString[i])
                 {
                    case '$' : str[j++] = '$';
                    case 'E' : str[j++] = 27;
                 }
                 mode = 0;
                 break;
        }
    }
    str[j] = 0;
}


void setTail(char* str)
{
    strcpy(_chatTail, str);
}

/* chatWin Window */
void HookKBKindToggle(int mode)
{
    int save;

    save = WPGetWMode();
    WPSetWMode(WPMODE_OVERWRITE);

    if (mode) WPPuts(0, 464, 0x7A, " 3鯢 ");
    else      WPPuts(0, 464, 0x7A, " 2鯢 ");

    WPFillBox(0,(29)*16,640,1,WHITE);
    WPFillBox(0,479,640,1,DARKGRAY);

    WPSetWMode(save);
}

void HookHanModeToggle(int mode)
{
    int save;

    save = WPGetWMode();
    WPSetWMode(WPMODE_OVERWRITE);

    if (mode) WPPuts(57, 464, 0x7A, "ei");
    else      WPPuts(57, 464, 0x7A, "w");

    WPFillBox(0,(29)*16,640,1,WHITE);
    WPFillBox(0,479,640,1,DARKGRAY);

    WPSetWMode(save);
}

void HookInsertToggle(int mode)
{
    int save;

    save = WPGetWMode();
    WPSetWMode(WPMODE_OVERWRITE);
    if (mode) WPPuts(100, 464, 0x7A, "s");
    else      WPPuts(100, 464, 0x7A, "");

    WPFillBox(0,(29)*16,640,1,WHITE);
    WPFillBox(0,479,640,1,DARKGRAY);

    WPSetWMode(save);
}


void initChatHook(void)
{
    _WPHookKBKindToggle  = HookKBKindToggle;    /* ae ew a */
    _WPHookHanModeToggle = HookHanModeToggle;   /* ew ɡi a */
    _WPHookInsertToggle  = HookInsertToggle;    /* s/ a */

}



// * FUNCTION *-------------------------------------------------------
// name ; chatWinInit
// in   ;
// out  ;
// des. ; ...
// * FUNCTION *-------------------------------------------------------
void chatWinInit(void)
{
    _chatTail[0]=0;
    _chatInternalString = (char*)(_chatInternalBuffer+_chatCurBuf);
    _chatInternalString[0]=0;
    WPFillBox(0,480-16-16-1,640,16,DARKGRAY);
    initNoWait(0,480-16-16-1,DARKGRAY*16 + WHITE,_chatInternalString,78,78);
}


// * FUNCTION *-------------------------------------------------------
// name ; chatWinDo
// in   ;
// out  ;
// des. ; ..
// * FUNCTION *-------------------------------------------------------
int chatWinDo(void)
{
    int result = (WPInpStrNoWait(0,480-16-16-1,DARKGRAY*16 + WHITE));
    if (result==25)
    {
        _chatInternalString[0]=0;
        WPFillBox(0,480-16-16-1,640,16,DARKGRAY);
        initNoWait(0,480-16-16-1,DARKGRAY*16 + WHITE,_chatInternalString,78,78);
    }
    if (result==ENTER) nrCodeConvStr(SANGYONG,KS5601,_chatInternalString);
    return result;
}


// * FUNCTION *-------------------------------------------------------
// name ; chatWinFirst
// in   ;
// out  ;
// des. ; ...
// * FUNCTION *-------------------------------------------------------
void chatWinFirst()
{
    HookKBKindToggle(0);
    HookHanModeToggle(0);
    HookInsertToggle(1);
    _chatCurBuf = 0;
    for (int i=0;i<_chatMaxBuf;i++) _chatInternalBuffer[i][0]=0;
    WPSetWMode(WPMODE_OVERWRITE);

    char temp[40];
    sprintf(temp,"[%2d/%2d]",_chatCurBuf+1,_chatMaxBuf);
    WPPuts(140, 463, 0x7A, temp);
    WPPutHLine(140,463,56,BLACK);
    WPPutHLine(140,464,56,WHITE);
}

void chatWinUpLine(void)
{
    nrCodeConvStr(SANGYONG,KS5601,_chatInternalString);
    if (--_chatCurBuf<0) _chatCurBuf = _chatMaxBuf-1;
    _chatInternalString = (char*)(_chatInternalBuffer+_chatCurBuf);
    nrCodeConvStr(KS5601,SANGYONG,_chatInternalString);

    WPFillBox(0,480-16-16-1,640,16,DARKGRAY);
    initNoWait(0,480-16-16-1,DARKGRAY*16 + WHITE,_chatInternalString,78,78);

    char temp[40];
    sprintf(temp,"[%2d/%2d]",_chatCurBuf+1,_chatMaxBuf);
    WPPuts(140, 463, 0x7A, temp);
    WPPutHLine(140,463,56,BLACK);
    WPPutHLine(140,464,56,WHITE);
}

void chatWinDownLine(void)
{
    nrCodeConvStr(SANGYONG,KS5601,_chatInternalString);
    if (++_chatCurBuf==_chatMaxBuf) _chatCurBuf = 0;
    _chatInternalString = (char*)(_chatInternalBuffer+_chatCurBuf);
    nrCodeConvStr(KS5601,SANGYONG,_chatInternalString);
    WPFillBox(0,480-16-16-1,640,16,DARKGRAY);
    initNoWait(0,480-16-16-1,DARKGRAY*16 + WHITE,_chatInternalString,78,78);

    char temp[40];
    sprintf(temp,"[%2d/%2d]",_chatCurBuf+1,_chatMaxBuf);
    WPPuts(140, 463, 0x7A, temp);
    WPPutHLine(140,463,56,BLACK);
    WPPutHLine(140,464,56,WHITE);
}

void chatWinNextLine(void)
{
    if (++_chatCurBuf==_chatMaxBuf) _chatCurBuf = 0;
    _chatInternalString = (char*)(_chatInternalBuffer+_chatCurBuf);
    _chatInternalString[0]=0;
    WPFillBox(0,480-16-16-1,640,16,DARKGRAY);
    initNoWait(0,480-16-16-1,DARKGRAY*16 + WHITE,_chatInternalString,78,78);

    char temp[40];
    sprintf(temp,"[%2d/%2d]",_chatCurBuf+1,_chatMaxBuf);
    WPPuts(140, 463, 0x7A, temp);
    WPPutHLine(140,463,56,BLACK);
    WPPutHLine(140,464,56,WHITE);
}
