#include <stdio.h>
#include <String.h>
#include <conio.h>
#include "etcwin.h"
#include "video.h"
#include "windat.h"
#include "user.h"
#include "Vars.h"
#include "wpgraph.h"
#include "wphanout.h"
#include "flag.h"
#include "main.h"
#include "buffer.h"
#include "question.h"

FILE* LOGFILE;

void openLogFile(void)
{
    LOGFILE = fopen("city.log","at");
}

void closeLogFile(void)
{
    fclose(LOGFILE);
}
// * FUNCTION *-------------------------------------------------------
// name ; LogWinWrite
// in   ;
// out  ;
// des. ; writes log-msg
// * FUNCTION *-------------------------------------------------------
void LogWinWrite(const char* stro)
{
    char str[256];
    strcpy(str,stro);
    fputs(stro,LOGFILE);
    fputc('\n',LOGFILE);
    int len = strlen(str);
    char temp[80];

    setTextAttr ( BLUE*16 + LIGHTBLUE );

//    WPSetWMode(WPMODE_OVERLAP);

    for (int i=0;i<len;i++)
        if ((unsigned char)str[i]<32) str[i]=32;


    int miss = 0;
    for (i=0;i<len/getWINREC(LOGWIN)->WIDTH;i++)
    {
        strncpy(temp,str+i*getWINREC(LOGWIN)->WIDTH,getWINREC(LOGWIN)->WIDTH);
        temp[getWINREC(LOGWIN)->WIDTH]=0;
        if (miss && (unsigned char)temp[0]>127) temp[0]='X';

        //
        int han=0;
        for (int z=0;z<getWINREC(LOGWIN)->WIDTH;z++)
        {
            switch (han)
            {
                case 0 :
                     if ((unsigned char)temp[z]>127) han = 1;
                     break;
                case 1 :
                     han = 0;
                     break;
            }
        }
        if (han)
        {
            temp[getWINREC(LOGWIN)->WIDTH-1]='X';
            miss = 1;
        }

        for (int sc=0;sc<8;sc++)
            _ScrollUp(getWINREC(LOGWIN)->X-1,(getWINREC(LOGWIN)->Y-1)*16,getWINREC(LOGWIN)->WIDTH,(getWINREC(LOGWIN)->HEIGHT)*16,2);
        WPFillBox((getWINREC(LOGWIN)->X-1)*8,(getWINREC(LOGWIN)->Y-1+getWINREC(LOGWIN)->HEIGHT-1)*16,getWINREC(LOGWIN)->WIDTH*8,16,BLUE);
        putsG(getWINREC(LOGWIN)->X,getWINREC(LOGWIN)->Y-1+getWINREC(LOGWIN)->HEIGHT,temp);
    }

    strcpy(temp,str+i*getWINREC(LOGWIN)->WIDTH);
    temp[getWINREC(LOGWIN)->WIDTH]=0;
    if (miss && (unsigned char)temp[0]>127) temp[0]='X';
    for (int sc=0;sc<8;sc++)
        _ScrollUp(getWINREC(LOGWIN)->X-1,(getWINREC(LOGWIN)->Y-1)*16,getWINREC(LOGWIN)->WIDTH,(getWINREC(LOGWIN)->HEIGHT)*16,2);
    WPFillBox((getWINREC(LOGWIN)->X-1)*8,(getWINREC(LOGWIN)->Y-1+getWINREC(LOGWIN)->HEIGHT-1)*16,getWINREC(LOGWIN)->WIDTH*8,16,BLUE);
    putsG(getWINREC(LOGWIN)->X,getWINREC(LOGWIN)->Y-1+getWINREC(LOGWIN)->HEIGHT,temp);
}

// * FUNCTION *-------------------------------------------------------
// name ; drawInfoWindow
// in   ;
// out  ;
// des. ; draws drawInfoWindow's data
// * FUNCTION *-------------------------------------------------------
void drawInfoWindow(void)
{
    setTextAttr ( YELLOW + GREEN*16 );
    Tuser* t;
    t = getUD(getFlag(FLAG_infoCurrentUser));

    char temp[80];

    sprintf(temp,"̸/%-8s ID/%-8s /%4d",t->name,t->id,t->logNum);
    putsG(getWINREC(INFOWIN)->X,getWINREC(INFOWIN)->Y,temp);
    int tasu;
    if (t->number<1) tasu = 0; else tasu = t->total/t->number;
    sprintf(temp,"/%06d Ÿ/%06dŸ /%4d",t->score,tasu,t->VicNum);
    putsG(getWINREC(INFOWIN)->X,getWINREC(INFOWIN)->Y+1,temp);
}

// * FUNCTION *-------------------------------------------------------
// name ; drawWindows
// in   ;
// out  ;
// des. ; draws windows
// * FUNCTION *-------------------------------------------------------
void drawWindows(void)
{
    drawWindow(getWINREC(USERWIN)->X,getWINREC(USERWIN)->Y,8,13,"",RED,LIGHTRED,YELLOW);
    drawWindow(getWINREC(LOGWIN)->X,getWINREC(LOGWIN)->Y,getWINREC(LOGWIN)->WIDTH,getWINREC(LOGWIN)->HEIGHT,"Log Window",BLUE,LIGHTBLUE,LIGHTCYAN);
    drawWindow(getWINREC(INFOWIN)->X,getWINREC(INFOWIN)->Y,35,2,"Info Window",GREEN,LIGHTGREEN,YELLOW);
    drawWindow(getWINREC(HELPWIN)->X,getWINREC(HELPWIN)->Y,35,2,"Help Window",GREEN,LIGHTGREEN,YELLOW);
    drawWindow(getWINREC(BUFWIN)->X,getWINREC(BUFWIN)->Y,getWINREC(BUFWIN)->WIDTH,getWINREC(BUFWIN)->HEIGHT,"BUF[  /  ] 㰡[ / / / ]",BLUE,LIGHTGRAY,WHITE);
    drawWindow(getWINREC(TIMEWIN)->X,getWINREC(TIMEWIN)->Y,8,1,"Timer",BLUE,LIGHTGRAY,WHITE);
    WPPutHLine(0,(28)*16-2,640,LIGHTGRAY);
    WPPutHLine(0,(28)*16-1,640,DARKGRAY);
    return;
}


// * FUNCTION *-------------------------------------------------------
// name ; drawTimer
// in   ;
// out  ;
// des. ; draws the timer
// * FUNCTION *-------------------------------------------------------
void drawTimer(void)
{
    char str[20];
    if (!getFlag(FLAG_questionModeON))
    {
        sprintf(str," ٸ ");
        setTextAttr ( GREEN*16 + LIGHTGREEN );
    }
    else
    {
        long Time = getTimeLongtyped() - getQuestionStartTime();
        setTextAttr ( GREEN*16 + LIGHTBLUE );
        sprintf(str," %05.2f",(float)Time/100.0);
    }
    putsG(getWINREC(TIMEWIN)->X,getWINREC(TIMEWIN)->Y,str);
}

// * FUNCTION *-------------------------------------------------------
// name ; drawWindow
// in   ;
// out  ;
// des. ; ...
// * FUNCTION *-------------------------------------------------------
void drawWindow(int x,int y,int w,int h,const char* title,int color1,int color2,int color3)
{

    int X1, Y1, X2, Y2;

    X1 = (x-1)*8; Y1 = (y-1)*16-16-BorderWidth;
    X2 = (x+w-1)*8; Y2 = (y+h-1)*16;

    WPFillBox(X1-BorderWidth,Y1-BorderWidth,X2+BorderWidth*2-X1+1,BorderWidth,LIGHTGRAY);
    WPFillBox(X1-BorderWidth,Y2+1,X2+BorderWidth*2-X1+1,BorderWidth-1,LIGHTGRAY);
    WPFillBox(X1-BorderWidth,Y1-BorderWidth,BorderWidth,Y2+BorderWidth*2-Y1+1,LIGHTGRAY);
    WPFillBox(X2,Y1-BorderWidth,BorderWidth,Y2+BorderWidth*2-Y1+1,LIGHTGRAY);

    // middle bar
    WPFillBox(X1,Y1,X2-X1,16,color2);
    WPFillBox(X1,Y1+16+BorderWidth,X2-X1,Y2-Y1-16-BorderWidth+1,color1);

    // Dark
    WPPutHLine(X1,Y1+16+BorderWidth-1,X2-X1,DARKGRAY);

    WPPutHLine(X1,Y1-1,X2-X1,DARKGRAY);
    WPPutHLine(X1-BorderWidth,Y2+BorderWidth,X2-X1+BorderWidth*2,DARKGRAY);
    WPPutVLine(X1-1,Y1-1,Y2-Y1+2,DARKGRAY);
    WPPutVLine(X2+BorderWidth,Y1-BorderWidth,Y2-Y1+BorderWidth*2+1,DARKGRAY);

    // Light
    WPPutHLine(X1,Y1+16,X2-X1+1,WHITE);

    WPPutHLine(X1,Y2+1,X2-X1,WHITE);
    WPPutHLine(X1-BorderWidth,Y1-BorderWidth,X2-X1+BorderWidth*2,WHITE);
    WPPutVLine(X1-BorderWidth,Y1-BorderWidth,Y2-Y1+BorderWidth*2,WHITE);
    WPPutVLine(X2,Y1,Y2-Y1+1,WHITE);
    WPFillBox(X1-1,Y1+17,X2-X1+2,BorderWidth-2,LIGHTGRAY);
    drawWinTitle(x,y,w,title,color1,color2,color3);
    return;
}


// * FUNCTION *-------------------------------------------------------
// name ; drawWinTitle
// in   ;
// out  ;
// des. ; ...
// * FUNCTION *-------------------------------------------------------
void drawWinTitle( int x, int y, int w, const char *title, int color1, int color2, int color3 )
{
    int Y1;

    Y1 = (y-1)*16-16-BorderWidth;

    WPFillBox((x+w/2-strlen(title)/2-1)*8,Y1,strlen(title)*8,16,color2);

    WPSetWMode(WPMODE_OVERLAP);
    if (color1!=DARKGRAY)
       setTextAttr ( color2*16 + DARKGRAY );
    else
       setTextAttr ( color2*16 + BLACK );
    putsGoffset(x+w/2-strlen(title)/2,y-1,0,BorderWidth,title);
    setTextAttr ( color2*16 + color1 );
    putsGoffset(x+w/2-strlen(title)/2,y-1,1,BorderWidth,title);
    WPSetWMode(WPMODE_OVERWRITE);
    setTextAttr ( color1*16 + color3 );
}


// * FUNCTION *-------------------------------------------------------
// name ; helpWindow
// in   ;
// out  ;
// des. ; ...
// * FUNCTION *-------------------------------------------------------
void helpWindow ( void )
{
    WPSetWMode(WPMODE_OVERLAP);
    putsG(getWINREC(HELPWIN)->X,getWINREC(HELPWIN)->Y,  "                   㰡");
    putsG(getWINREC(HELPWIN)->X,getWINREC(HELPWIN)->Y+1,"                 Ÿ/Ÿ/");

    setTextAttr ( LIGHTCYAN + GREEN*16 );
    putsG(getWINREC(HELPWIN)->X,getWINREC(HELPWIN)->Y,"F1");
    putsG(getWINREC(HELPWIN)->X+3+6,getWINREC(HELPWIN)->Y, "F11/2");
    putsG(getWINREC(HELPWIN)->X+3+20,getWINREC(HELPWIN)->Y,"F8/9/10");
    putsG(getWINREC(HELPWIN)->X,getWINREC(HELPWIN)->Y+1,"ALT-V");

    setTextAttr ( LIGHTCYAN + GREEN*16 ); putsG(getWINREC(HELPWIN)->X+21,getWINREC(HELPWIN)->Y+1,"Ÿ");
    setTextAttr ( LIGHTBLUE + GREEN*16 ); putsG(getWINREC(HELPWIN)->X+26,getWINREC(HELPWIN)->Y+1,"Ÿ");
    setTextAttr ( LIGHTGREEN+ GREEN*16 ); putsG(getWINREC(HELPWIN)->X+31,getWINREC(HELPWIN)->Y+1,"");
    WPSetWMode(WPMODE_OVERWRITE);
}

// * FUNCTION *-------------------------------------------------------
// name ; drawAboutWindow
// in   ;
// out  ;
// des. ; ...
// * FUNCTION *-------------------------------------------------------
void drawAboutWindow(void)
{
    drawWindow(11,9,58,11,"CITY 1.0 FIRST RELEASE", BLUE, LIGHTBLUE, WHITE );
    setTextColor(LIGHTCYAN);
    putsG(11,9, "              SciCom ȭ κ ù°                ");
    setTextColor(YELLOW);
    putsG(11,10,"* SciCom *  Science Computer Ӹ а ");
    putsG(11,11,"             ̸Դϴ. (^_^)");
    putsG(11,12,"                                                         ");
    setTextColor(WHITE);
    putsG(11,13,"   ȭ κ  ȭǿ Ÿ Ƿ ܷ ");
    putsG(11,14,"    ְ  ͵帳ϴ.   α׷  ");
    putsG(11,15,"̳,  ȣ ̴  Ұմϴ.   ȣ");
    putsG(11,16," ÷,  HiTEL ID : nakasan  Ź  ");
    putsG(11,17,"ּ. ^^;                                              ");
    putsG(11,18,"                                                         ");
    setTextColor(LIGHTRED);
    putsG(11,19,"   α׷  ۱  ȣ ֽϴ ");
    while (kbhit()) getch();
    while (!kbhit());
}


void drawErrorWindow(void)
{
    drawWindow(11,9,58,11,"ERROR", RED, LIGHTRED, YELLOW );
    setTextColor(LIGHTCYAN);
    putsG(11,9, "              SciCom ȭ κ ù°                ");
    setTextColor(YELLOW);
    putsG(11,10,"𵩰 ſ ̻ ϴ.     ");
    putsG(11,11,"  ֽϴ. ϳ,   ߸Ͻ Դϴ");
    putsG(11,12,"Ͻ  Ʋ 쿡,  ¿   ");
    putsG(11,13,"Էϼż  Ͻʽÿ. C:\CITY> CITY SETUP           ");
    putsG(11,14," ϳ    ִ ,   𵩿 ŵ Ͱ");
    putsG(11,15,"ִ Դϴ.  쿡 α׷ Ͻð,  ٸ ");
    putsG(11,16," α׷     ̵Ͻ  ");
    putsG(11,17,"ٽ CITY Ͻø ˴ϴ.   ȭ ");
    putsG(11,18,"κ  ش˴ϴ.                                ");
    setTextColor(LIGHTRED);
    putsG(11,19,"   α׷  ۱  ȣ ֽϴ ");
    while (kbhit()) getch();
    while (!kbhit());
}

void drawKeyInfo(void)
{
    drawWindow(2,4,78,2,"KEY ", BLACK, LIGHTGRAY, WHITE);
    switch (getServerType())
    {
        case HiTEL :
             putsG(2,4," ALT-D, ALT-1/741-0228    ALT-2/762-0228    ALT-4/014-11    ALT-5/014-10");
             break;
        case NowNuri :
             putsG(2,4," ALT-D, ALT-1/592-5100    ALT-2/3679-6000   ALT-4/014-11    ALT-5/014-10");
             break;
    }
    putsG(2,5," ALT-V/α׷                                        ALT-X/α׷ ");
}
