#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "modem.h"
#include "user.h"
#include "group.h"
#include "etcwin.h"
#include "question.h"

int whichGroup[12];
int groupProcess[maxGroup];
char groupName[maxGroup][20];
int groupAlive[maxGroup];

struct
{
    int A, B;
    int ScoreA, ScoreB;
    char nameA[20], nameB[20];
    int number;
    int alive;
} fightData[maxGroup];

int getWhichGroup(int UN)
{
    return whichGroup[UN];
}

int getGroupProcess(int UN)
{
    return groupProcess[UN];
}

void fightOff(int fn)
{
    fightData[fn].alive = -1;
}

void initFight(void)
{
    for (int i=0;i<maxGroup;i++)
    {
        groupAlive[i] = -1;
        groupProcess[i] = -1;
        fightData[i].alive = -1;
        groupName[i][0] = 0;
    }
    for (i=0;i<12;i++)
    {
        whichGroup[i] = -1;
    }
}


void tellGroup(int groupNum, const char* msg)
{
    for (int i=0;i<12;i++)
        if (getUD(i)->alive>=0)
            if (whichGroup[i]==groupNum)
                whisper(getUD(i)->id, msg);
}

void setGroup(int groupNum, int fn)
{
    for (int i=0;i<12;i++)
        if (getUD(i)->alive>=0)
            if (whichGroup[i]==groupNum)
                groupProcess[i] = fn;
}

void unsetGroup(int groupNum)
{
    for (int i=0;i<12;i++)
        if (getUD(i)->alive>=0)
            if (whichGroup[i]==groupNum)
                groupProcess[i] = -1;
}

void setFight(int un, int fn)
{
    if (un<0 || un>11) return;
    if (whichGroup[un]>=0)
       setGroup(whichGroup[un], fn);
    else
       groupProcess[un] = fn;
}

void unsetFight(int un)
{
    if (un<0 || un>11) return;
    if (whichGroup[un]>=0)
       unsetGroup(whichGroup[un]);
    else
       groupProcess[un] = -1;
}

void unsetFightCheq(int fn)
{
    for (int i=0;i<12;i++)
        if (groupProcess[i]==fn) groupProcess[i] = -1;
}

void printStatus ( int fn )
{
    char temp[80];

    sprintf ( temp, "# %s(%d) VS %s(%d) [%d ]",
                    fightData[fn].nameA, fightData[fn].ScoreA,
                    fightData[fn].nameB, fightData[fn].ScoreB,
                    fightData[fn].number );
    ttyOut ( temp );
}

void sayFight(int un, const char* msg)
{
    if (un<0 || un>11) return;
    if (whichGroup[un]>=0) tellGroup(whichGroup[un], msg);
                      else whisper(getUD(un)->id, msg);
}

void userCMDregisterFight(char* id, char* cmd)
{
    char *zid=cmd, n=0;
    while (*zid==' ') zid++;
    while ((unsigned char)zid[n]>32) n++;
    zid[n] = 0;

    if (zid[0]==0)
    {
        whisper(id,"help> ! [] [Ǽ]");
        whisper(id,"help> ڰ ׷쿡   ");
        whisper(id,"help> ׷  ˴ϴ");
    }

    char *numStr=zid+n+1;
    n=0;
    while (*numStr==' ') numStr++;
    while (numStr[n]>32) n++;
    numStr[n] = 0;

    int num = atoi(numStr);
    if (num<=2 || num>10)
    {
        whisper(id,"ּ 3, ִ 10   ˴ϴ");
        return;
    }

    for (int i=0; i<12; i++)
    {
        if (groupAlive[i]>=0 && strcmp(groupName[i], zid)==0)
        {
            for (int j=0;j<12;j++)
                if (getUD(j)->alive>=0 && whichGroup[j]==i)
                {
                    strcpy(zid,getUD(j)->id);
                    goto outside;
                }
        }
    }
outside:
    int un1, un2;
    un1 = userNumber(id); un2 = userNumber(zid);

    if (un1<0 || un2<0 || (whichGroup[un1]>=0 && whichGroup[un1]==whichGroup[un2]))
    {
        if (whichGroup[un1]>=0 && whichGroup[un1]==whichGroup[un2])
           whisper(id," ׷  ڳ   ʽϴ");
        else
           whisper(id,"߸ Դϴ");
        return;
    }

    if (groupProcess[un1]>=0 || groupProcess[un2]>=0)
    {
        whisper(id,"̹  ϰ ֽϴ");
        return;
    }

    for (i=0; i<12; i++)
        if (fightData[i].alive<0) goto FindOK;
    whisper(id, "Ҵ  ϴ");
    return;

FindOK:
    char name1[30], name2[30];
    if (whichGroup[un1]>=0) sprintf(name1, "׷(%s)", groupName[whichGroup[un1]] );
                       else sprintf(name1, "(%s)", id );
    if (whichGroup[un2]>=0) sprintf(name2, "׷(%s)", groupName[whichGroup[un2]] );
                       else sprintf(name2, "(%s)", zid );

    char temp[80];
    sprintf(temp,"%s  Ǿϴ(%d )", name2, num);
    sayFight(un1, temp);
    sprintf(temp,"%s  Ǿϴ(%d )", name1, num);
    sayFight(un2, temp);

    fightData[i].A = un1;
    fightData[i].B = un2;
    strcpy(fightData[i].nameA, name1);
    strcpy(fightData[i].nameB, name2);
    fightData[i].ScoreA = 0;
    fightData[i].ScoreB = 0;
    fightData[i].number = num;
    fightData[i].alive = 1;

    setFight(un1, i);
    setFight(un2, i);

    printStatus(i);
}

void userCMDregisterGroup(char* id, char* cmd)
{
    int un = userNumber(id);
    if (un<0 || un>11) return;
    char temp[80];
    char *zid=cmd, n=0;
    while (*zid==' ') zid++;
    while ((unsigned char)zid[n]>32) n++;
    zid[n] = 0;

    if (whichGroup[un]>=0)
    {
        whisper(id,"# ̹ ׷쿡 ԵǾֽϴ");
        whisper(id,"# !Ż  ϼ");
        return;
    }

    if (groupProcess[un]>=0)
    {
        whisper(id,"#   Ŀ Խû ϼ");
        return;
    }


    for (int i=0;i<maxGroup;i++)
        if (groupAlive[i]>=0)
            if (strcmp(zid,groupName[i]+1)==0 || strcmp(zid,groupName[i])==0) goto Find;

    whisper(id, "׷ ̸ ׷ ϴ");

    if (strlen(zid)<4 || strlen(zid)>12 || zid[0]=='[')
    {
        whisper(id, "׷ ̸ ּ 4 ִ 12Դϴ");
        return;
    }
    whisper(id, " ׷ մϴ");

    for (i=0;i<maxGroup;i++)
        if (groupAlive[i]<0) goto OK;

    whisper(id, "ִ 12 ׷츸 մϴ");
    return;
OK:
    groupName[i][0]='#';

    // for safety
    if (strlen(zid)>12) zid[12]=0;

    strcpy(groupName[i]+1, zid);
    sprintf(temp, "׷ '%s'  ϴ", zid );
    whisper(id, temp );
    sprintf(temp, "# ׷ '%s' ", zid);
    ttyOut(temp);
    sprintf(temp, "׷ '%s' ", zid );
    LogWinWrite(temp);
    groupAlive[i] = 1; // activate
Find :
    whichGroup[un] = i;
    sprintf(temp, "׷ '%s' ȸ Ǿϴ", groupName[i] );
    whisper(id, temp);
    whisper(id, "# !׷ ̶ ġø ȸ    ֽϴ");
    sprintf(temp, "׷ '%s' ο ȸ : %s(%s)", groupName[i], getUD(un)->name, id );
    sayFight(un, temp);
}

void userCMDunregisterGroup(char* id)
{
    int un = userNumber(id);
    int gn = whichGroup[un];
    if (un<0 || un>11) return;
    char temp[80];
    if (gn<0 || gn>=maxGroup)
    {
        whisper(id, "# ԵǾ  ʽϴ");
        whisper(id, "# ! [׷] ϸ  ˴ϴ");
        if (groupProcess[un]>=0 && groupProcess[un]<maxGroup)
        {
            fightData[groupProcess[un]].alive = -1;
            ttyOut("#  䱸  Ǿϴ");
            int fn = groupProcess[un];
            unsetFight(fightData[fn].A);
            unsetFight(fightData[fn].B);
            unsetFightCheq(fn);
            groupProcess[un] = -1;
        }
        return;
    }

    if (groupProcess[un]>=0 && groupProcess[un]<maxGroup)
    {
        int nextUser = -1;
        for (int j=0;j<12;j++)
            if (getUD(j)->alive>=0 && whichGroup[j]==gn)
            {
                if (j!=un)
                {
                    nextUser = j; goto out; // same as break
                }
            }
 out :
        if (nextUser>=0)
        {
            if (fightData[groupProcess[un]].A==un)
               fightData[groupProcess[un]].A = nextUser;
            if (fightData[groupProcess[un]].B==un)
               fightData[groupProcess[un]].B = nextUser;
        }
        else
        {
            fightData[groupProcess[un]].alive = -1;
            groupAlive[gn] = -1;
            sprintf(temp, "# ׷ '%s' ü", groupName[gn]);
            ttyOut(temp);
            ttyOut("# ׷ ü  Ǿϴ");
            int fn = groupProcess[un];
            unsetFight(fightData[fn].A);
            unsetFight(fightData[fn].B);
            unsetFightCheq(fn);
        }
        groupProcess[un] = -1;
    }

    int num = 0;
    for (int i=0;i<12;i++)
        if (getUD(i)->alive>=0)
        {
            if (whichGroup[i]==gn) num++;
        }
    if (num<2)
    {
        sprintf(temp, "׷ '%s' ü˴ϴ", groupName[gn]);
        whisper(id, temp );
        groupAlive[gn] = -1;
        sprintf(temp, "# ׷ '%s' ü", groupName[gn]);
        ttyOut(temp);
        sprintf(temp, "׷ '%s' ü", groupName[gn]);
        LogWinWrite(temp);
    }
    whisper(id, "ŻϿϴ");
    sprintf(temp, "׷ '%s' Ż ȸ : %s(%s)", groupName[gn], getUD(un)->name, id );
    sayFight(un, temp);
    sprintf(temp, "%s:׷ '%s' Ż", id, groupName[gn]);
    whichGroup[un] = -1;
    LogWinWrite(temp);
}

void userCMDviewGroup(char* id, char* cmd)
{
    char temp[80];
    char *zid=cmd, n=0;
    while (*zid==' ') zid++;
    while ((unsigned char)zid[n]>32) n++;
    zid[n] = 0;

    int gn;

    if (zid[0]==0)
    {
        int n=0;
        for (int i=0;i<12;i++)
            if (groupAlive[i]>=0)
            {
                n++;
                sprintf(temp,"׷ : %s", groupName[i] );
                whisper(id,temp);
            }
        if (n>0)
           whisper(id,"  , '!׷ [׷]'");
        else
           whisper(id,"ϵ ׷ ϴ");
        return;
    }
    else
    {
        for (int i=0;i<12;i++)
            if (groupAlive[i]>=0)
            {
                if (strcmp(groupName[i],zid)==0 || strcmp(groupName[i]+1,zid)==0)
                {
                    gn = i;
                    break;
                }
            }
    }

    if (gn<0 || gn>=maxGroup)
    {
        whisper(id,"׷ ׷ ϴ");
        return;
    }

    sprintf(temp,"׷ [%s]",groupName[gn]);
    whisper(id,temp);
    for (int i=0;i<12;i++)
    {
        if (getUD(i)->alive>=0 && whichGroup[i]==gn)
        {
            sprintf(temp,"׷ȸ : %s(%s)", getUD(i)->name,
                                              getUD(i)->id );
            whisper(id, temp);
        }
    }
}


int getGroupRankGN(int gn)
{
    int userN = 0;
    for (int z=0;z<12;z++)
        if (getUD(z)->alive>=0) userN++;
    int curRank = 0;
    int n=0;
    if (groupAlive[gn]<0 || gn<0 || gn>=maxGroup) return curRank*10;
    for (int i=0;i<12;i++)
        if (getUD(i)->alive>=0 && whichGroup[i]==gn)
        {
            if (getUserRank(i)==0) curRank+=userN; else curRank+= getUserRank(i);
            n++;
        }
    if (n==0) return userN*10; else return (curRank*10)/n;
}

int getGroupRank(int un)
{
    int userN = 0;
    for (int z=0;z<12;z++)
        if (getUD(z)->alive>=0) userN++;

    if (un<0 || un>11) return 10*userN;

    if (whichGroup[un]<0)
    {
       if (getUserRank(un)==0) return 10*userN;
          else                 return getUserRank(un)*10;
    }
    else
        return getGroupRankGN(whichGroup[un]);
}



void checkFight(void)
{
    // for safety
    for (int i=0; i<12; i++)
        if (getUD(i)->alive<0 && (groupProcess[i]>=0 || whichGroup[i]>=0))
        {
            groupProcess[i] = -1;
            whichGroup[i] = -1;
        }
    // end of f.s

    for (int fn=0;fn<12;fn++)
    if (fightData[fn].alive>=0)
    {
        int resA, resB;
        // find Group A,B's highest
        resA = getGroupRank(fightData[fn].A);
        resB = getGroupRank(fightData[fn].B);

        if (resA<0 || resB<0)
        {
            if (resA>=1)
               sayFight(fightData[fn].A, "#   Ǿϴ");
            if (resB>=1)
               sayFight(fightData[fn].B, "#   Ǿϴ");
            fightData[fn].alive = -1;
            continue;
        }

        if (resA<resB) // A win
        {
            fightData[fn].ScoreA++;
            if (fightData[fn].ScoreA == fightData[fn].number)
            {
                char temp[100];
                sprintf(temp, "# %s VS %s  %s ¸ϼ̽ϴ",
                              fightData[fn]. nameA, fightData[fn]. nameB,  fightData[fn]. nameA );
               ttyOut(temp);
               fightData[fn].alive = -1;
            }
        }
        if (resA>resB) // B win
        {
            fightData[fn].ScoreB++;
            if (fightData[fn].ScoreB == fightData[fn].number)
            {
                char temp[100];
                sprintf(temp, "# %s VS %s  %s ¸ϼ̽ϴ",
                              fightData[fn]. nameA, fightData[fn]. nameB,  fightData[fn]. nameB );
               ttyOut(temp);
               fightData[fn].alive = -1;
            }
        }
        printStatus(fn);
        if (fightData[fn].alive<0)
        {
            sayFight(fightData[fn].A, "#  ϴ");
            sayFight(fightData[fn].B, "#  ϴ");
            unsetFight(fightData[fn].A);
            unsetFight(fightData[fn].B);
            unsetFightCheq(fn);
        }
    }
}


void printGroup(int* userTasu)
{
    char temp[200];
    for (int i=0;i<maxGroup;i++)
        if (groupAlive[i]>=0)
        {
            int A, B, n, m, total;
            m = 0;
            total = 0;
            for (int j=0;j<12;j++)
                if (getUD(j)->alive>=0 && whichGroup[j]==i)
                {
                    total += userTasu[j];
                    if (userTasu[j]>0) m++;
                }
            if (m==0) B=0; else B=total/m;
            sprintf(temp,"׷ '%s' %4dŸ/, յ:%5.1f", groupName[i]+1, B, (float)getGroupRankGN(i)/10.0);
            ttyOut(temp);
        }
}

