#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <string.h>
#include <conio.h>
#include "main.h"
#include "convert.h"
#include "wpgraph.h"
#include "wphanout.h"
#include "video.h"
#include "modem.h"
#include "Version.h"


// * FUNCTION *-------------------------------------------------------
// name ; getTimeLongtyped
// in   ;
// out  ;
// des. ; tells current-time (long-typed)
// * FUNCTION *-------------------------------------------------------
long getTimeLongtyped(void)
{
    long start;
    struct  time t;
    gettime(&t);
    return (((long)t.ti_hour*60+(long)t.ti_min)*60+(long)t.ti_sec)*100+t.ti_hund;
}


// * FUNCTION *-------------------------------------------------------
// name ; howmanytasuHanch
// in   ;
// out  ;
// des. ; ..
// * FUNCTION *-------------------------------------------------------
int howmanytasuHanch(const unsigned char *str)
{
    char tmp[5];
    strncpy(tmp,str,2);
    tmp[2]=0;
    nrCodeConvStr(KS5601,KSJOHAP,tmp);
    int Joong = (((tmp[0]&(2+1))<<3) + (tmp[1]&(128+64+32)));
    int Jong  = (tmp[1]&(16+8+4+2+1));

    int chkJoong[7] = {200,232,48,176,240,208,120};
    int tasu = 2; // default
    for (int i=0;i<7;i++) if (Joong==chkJoong[i]) tasu++;
    if (Jong==1) return tasu;

    tasu++;

    int chkJong[4] = {7,6,11,19};
    for (i=0;i<7;i++) if (Jong==chkJong[i]) tasu++;
    return tasu;
}


// * FUNCTION *-------------------------------------------------------
// name ; howmanytasu
// in   ;
// out  ;
// des. ; ..
// * FUNCTION *-------------------------------------------------------
int howmanytasu(const char *str)
{
    int tasu = 0;
    for (int i=0;i<strlen(str);i++)
    {
        if ((unsigned char)str[i]>127)
        {
            if (i==strlen(str)-1) return tasu;
            tasu+=howmanytasuHanch(str+i);
            i++;
        }
        else
            tasu++;
    }
    return tasu;
}


// * FUNCTION *-------------------------------------------------------
// name ; drawWallPaper
// in   ;
// out  ;
// des. ; draws wall-paper
// * FUNCTION *-------------------------------------------------------
void drawWallPaper(void)
{
    char str[]="SciCom Typing Robot, CyTy, programmed by Nako, Sung SciCom Typing Robot, CyTy, programmed by Nako, Sung SciCom Typing Robot, CyTy, programmed by Nako, Sung ";
    WPSetWMode(WPMODE_OVERLAP);
    setTextAttr(DARKGRAY);
    for (int i=0;i<29;i++)
    {
        char temp[90];
        strncpy(temp,str+random(30),80);
        temp[80]=0;
        setTextAttr(DARKGRAY);
        putsG(1,i+1,temp);
        setTextAttr(LIGHTGRAY);
        putsGoffset(1,i+1,-1,-1,temp);
    }
    WPSetWMode(WPMODE_OVERWRITE);
}


// * FUNCTION *-------------------------------------------------------
// name ; drawDecoLine
// in   ;
// out  ;
// des. ; decorates a screen with lines
// * FUNCTION *-------------------------------------------------------
void drawDecoLine ( void )
{
    WPFillBox(0,(29)*16,640,16,LIGHTGRAY);
    drawWallPaper();
    setTextAttr(DARKGRAY*16+LIGHTRED);
    WPFillBox(0,0,640,16,DARKGRAY);
    putsG(1,1," SciCom / City(SCIcom TYping robot)                       SciCom presents, 1997");
    setTextAttr(LIGHTGRAY*16+WHITE);
    putsG(80-18,30,"()ȣ(nakasan)");
    WPPutHLine(0,0,640,LIGHTGRAY);
    WPPutHLine(0,16,640,BLACK);
    WPPutHLine(0,(29)*16-1,640,BLACK);
    WPPutHLine(0,(29)*16,640,WHITE);
    WPPutHLine(0,479,640,DARKGRAY);
}

// * FUNCTION *-------------------------------------------------------
// name ; sayHello
// in   ; none
// out  ; none
// des. ; hello msg.
// * FUNCTION *-------------------------------------------------------
void sayHello(void)
{
    ttyOut("-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-");
	ttyOut("<*>=New CITY       SciCom Typing Room=<*>");
    ttyOut("<*> 97. 1.11.             ȣ  <*>");
	ttyOut("-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-");
    ttyOut(getVERSION());
}


// * FUNCTION *-------------------------------------------------------
// name ; sayBye
// in   ; none
// out  ; none
// des. ; say bye..
// * FUNCTION *-------------------------------------------------------
void sayBye(void)
{
    ttyOut("-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-");
	ttyOut("<*>=New CITY       SciCom Typing Room=<*>");
	ttyOut("-=-= Bye, programmed by Nako, Sung =-=-=-");
}


