#include <stdio.h>
#include <dos.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include <dir.h>
#include <process.h>
#include "vars.h"
#include "modem.h"
#include "wphanout.h"
#include "wpgraph.h"
#include "vga.h"
#include "chat.h"
#include "video.h"
#include "security.h"
#include "buffer.h"
#include "wphanin.h"
#include "wpkeydef.h"
#include "main.h"
#include "etcwin.h"
#include "start.h"
#include "ansi.h"
#include "showfile.h"
#include "question.h"

static unsigned char *buffer;
static unsigned position,read;

unsigned char comport;
unsigned long speed;

static struct {
    unsigned base;
    unsigned char irq;
} modem;

static struct {
    unsigned char flag;
    void interrupt (*vector)(...);
    unsigned char ier;        // interrupt enable register
    unsigned char lcr;        // line control register
    unsigned char mcr;        // modem control register
    unsigned char mask;       // programmer interrupt controller mask
    unsigned char speedlow;
    unsigned char speedhigh;
} save;


// *** Modem Functions ***********************************************
//    Լ  κԴϴ.
// *******************************************************************

// * FUNCTION *-------------------------------------------------------
// name ; onlinevector
//  in  ; none
// out  ; none
// des. ; modem interrupt function
// * FUNCTION *-------------------------------------------------------

int tx_chars, tx_in, tx_out, rx_chars;
char tx_queue[16384];

void interrupt onlinevector(...)
{
  char iir;
  while (!((iir = inportb(IIR)) & 1))
  {
    switch (iir)
    {
            case 0:                             /* Modem status interrupt */
                inportb(MSR);              /* Just clear the interrupt */
                break;

            case 2:                             /* Transmit register empty */
                if (tx_chars <= 0)              /* If tx buffer empty, turn */
                    outportb(IER,          /*  off transmit interrupts */
                             inportb(IER) & ~2);
                else {                          /* Tx buffer not empty */
                    if (inportb(LSR) & 0x20 ) {
                        outportb(THR, tx_queue[tx_out++]);
                        if (tx_out == 16384)
                            tx_out = 0;
                        tx_chars--;
                        }
                    }                           /* End 'tx buffer not empty */

                break;
            case 4:                             /* Received data interrupt */
                if (rx_chars>=16384) break;
                if (position>=16384/*MAX*/) position=0;
                buffer[position++]=inportb(modem.base);
                rx_chars++;
                break;
            case 6:
                inportb(LSR);
                break;
    }
  }
  outportb(0x20,0x20);
}

// * FUNCTION *-------------------------------------------------------
// name ; ttyOn
// in   ; none
// out  ; carrier detection (integer)
// des. ; returns carrier status
// * FUNCTION *-------------------------------------------------------
int ttyOn(void)
{
    return ( (inportb(MSR)>>7)&1 );
}


// * FUNCTION *-------------------------------------------------------
// name ; ttyOpen
// in   ; ModemPort(integer), Modem BaudRate(long)
// out  ; none
// des. ; opens modem-connection
// * FUNCTION *-------------------------------------------------------

int bitmask;

void ttyOpen(int port, long baudrate)
{
  unsigned base[]={0x3f8,0x2f8,0x3e8,0x2e8,0x178 };
  unsigned char irq[]={12,11,12,11,15};
  unsigned comspeed;

  //  1 4   2 3   3 4   4 3
  bitmask = (port%2==0) ? 8 : 16;

  modem.base=base[port-1];
  modem.irq=irq[port-1];

  save.ier=inportb(IER);
  save.lcr=inportb(LCR);

  outportb(IER,0);

  disable();
  save.mask=inportb(0x21);
  outportb(0x21,save.mask|bitmask);
  enable();

  if(save.flag==0)
  {
      save.vector=getvect(modem.irq);
      setvect(modem.irq,onlinevector);
      save.flag=1;

      buffer=(unsigned char*)malloc(16384/*MAX*/);
      position=0;
      read=0;
  }

  outportb(LCR,3); // N-8-1

  disable();
  save.mcr=inportb(MCR);

  outportb(MCR,(save.mcr&1) | (0xa)); //
  enable();

  outportb(IER,1); // enable receive-int.
  disable();
  outportb(0x21,save.mask&(~bitmask));
  enable();

  // enable serial port interrupt

  comspeed=115200l/baudrate;

  disable();
  outportb(LCR,inportb(LCR) | 0x80);        // divisor latch access bit = 1
  outport(RBR,comspeed);   // divisor latch low byte
  outportb(LCR,inportb(LCR) & ~0x80);
  outportb(LCR,3);          // N-8-1
  tx_chars = 0;
  tx_in = 0;
  tx_out = 0;
  enable();

}


// * FUNCTION *-------------------------------------------------------
// name ; ttyClose
// in   ; none
// out  ; none
// des. ; closes modem-connection
// * FUNCTION *-------------------------------------------------------
void ttyClose(void)
{
  if(save.flag==0) return;

//  outportb(LCR,128);
//  outportb(RBR,save.speedlow);
//  outportb(IER,save.speedhigh);

//  outportb(LCR,save.lcr);
  outportb(MCR,save.mcr);
  outportb(IER,save.ier);


  disable();
  outportb(0x21,(inportb(0x21)&~bitmask) | (save.mask&bitmask));
  enable();
  if (save.flag!=0) setvect(modem.irq,save.vector);

  free(buffer);

  save.flag=0;
}


// * FUNCTION *-------------------------------------------------------
// name ; ttyOut
// in   ; string (const char[])
// out  ; none
// des. ; sends a string to MODEM (+\n code)
// * FUNCTION *-------------------------------------------------------
void ttyOut(const char* str)
{
    if (getFlag(FLAG_autoTypeDisable)) return;
	for (int i=0;;i++)
	{
		if (str[i]==0)
		{
			ttyOutCh('\n');
			return;
		}
		ttyOutCh(str[i]);
	}
}


void ttyOutLevel0(const char* str)
{
	for (int i=0;;i++)
	{
		if (str[i]==0)
		{
			ttyOutCh('\n');
			return;
		}
		ttyOutCh(str[i]);
	}
}


// * FUNCTION *-------------------------------------------------------
// name ; ttyOutRaw
// in   ; string (const char[])
// out  ; none
// des. ; sends a string to MODEM (without \n code)
// * FUNCTION *-------------------------------------------------------
void ttyOutRaw(const char* str)
{
    if (getFlag(FLAG_autoTypeDisable)) return;
	for (int i=0;;i++)
	{
		if (str[i]==0)
		{
			ttyOutCh('\015');
			return;
		}
		ttyOutCh(str[i]);
	}
}


// * FUNCTION *-------------------------------------------------------
// name ; ttyOutCh
// in   ; a Character
// out  ; none
// des. ; sends a char.
// * FUNCTION *-------------------------------------------------------

void ttyOutCh(char ch)
{
    while (tx_chars>=16384);
    disable();
    tx_queue[tx_in++] = ch;
    if (tx_in == 16384) tx_in = 0;  /* Wrap index if needed */
    tx_chars++;                             /* Number of char's in queue */
    outportb(IER,inportb(IER) | 0x02 );
    enable();                               /* Interrupts back on */
}


// * FUNCTION *-------------------------------------------------------
// name ; ttyReady
// in   ; none
// out  ; buffer status(integer)
// des. ; if buffer isn't empty, returns 1. else, returns 0
// * FUNCTION *-------------------------------------------------------
int ttyReady(void)
{
    return((read==position)^1);
}


// * FUNCTION *-------------------------------------------------------
// name ; ttyIn
// in   ; none
// out  ; (char)
// des. ; returns a character from buffer
// * FUNCTION *-------------------------------------------------------
char ttyIn(void)
{
  disable();
  if(read==16384/*MAX*/) read=0;
  if(read==position) return 0;
  int i = buffer[read++];
  rx_chars--;
  enable();
  return i;
}

void modemStatus ( int mode )
{
    static char str[80];
    static int preRX = -1, preTX = -1;
    if (mode) preRX = -1;

    const char gp[][3] = {"",""};
    const char cp[] = {LIGHTGRAY*16+LIGHTBLUE, LIGHTGRAY*16+LIGHTCYAN};
    if (preRX<0)
    {
        sprintf(str,"RX  TX");
        WPPuts(36*8,29*16,LIGHTGRAY*16+BLUE,str);
        WPPutHLine(36*8,29*16,10*5,WHITE);
        WPPutHLine(36*8,29*16+15,10*5,DARKGRAY);
        WPSetWMode(WPMODE_OVERLAP);
        for (int i=1;i>=0;i--)
        {
            sprintf(str,"%s",gp[i]);
            WPPuts(38*8,29*16,cp[i],str);
            sprintf(str,"%s",gp[i]);
            WPPuts(42*8,29*16,cp[i],str);
        }
        WPPutHLine(38*8,29*16,8,WHITE);WPPutHLine(38*8,29*16+15,8,DARKGRAY);
        WPPutHLine(42*8,29*16,8,WHITE);WPPutHLine(42*8,29*16+15,8,DARKGRAY);
        WPSetWMode(WPMODE_OVERWRITE);
    }
    if (preRX!=rx_chars || preTX!=tx_chars)
    {
        WPSetWMode(WPMODE_OVERLAP);
        sprintf(str,"%s",gp[rx_chars>0]);
        WPPuts(38*8,29*16,cp[rx_chars>0],str);
        sprintf(str,"%s",gp[tx_chars>0]);
        WPPuts(42*8,29*16,cp[tx_chars>0],str);
        WPPutHLine(38*8,29*16,8,WHITE);WPPutHLine(38*8,29*16+15,8,DARKGRAY);
        WPPutHLine(42*8,29*16,8,WHITE);WPPutHLine(42*8,29*16+15,8,DARKGRAY);
        WPSetWMode(WPMODE_OVERWRITE);
    }
    preRX = rx_chars;
    preTX = tx_chars;
}

// * FUNCTION *-------------------------------------------------------
// name ; ttyTerm
// in   ; none
// out  ; none
// des. ; main terminal procedure. (includes mainfunction-call-routine)
// * FUNCTION *-------------------------------------------------------

void ttyTerm(void)
{
	int ch;
    int First = 1;

    ansiInit();
    ansiDoColor(44);
    ansiDoColor(37);
    ansiDoColor(1);

    ttyOutRaw("[CT-nakasan]ATZ\015");

redo:
    vgaInit();
    WPFillBox(0,(29)*16,640,16,LIGHTGRAY);
    chatWinFirst();
    ansiMoveCursorAbs(0,5);
    ansiCursor(1);
    WPSetWMode(WPMODE_OVERWRITE);
    WPFillBox(0,16,640,480-48-2,BLUE);
    setTextAttr(DARKGRAY*16+LIGHTRED);
    WPFillBox(0,0,640,16,DARKGRAY);
    putsG(1,1," SciCom / City(SCIcom TYping robot)                       SciCom presents, 1997");
    setTextAttr(BLUE*16);
    setTextColor(LIGHTCYAN);
restart:
    drawKeyInfo();
    setTextAttr(LIGHTGRAY*16 + WHITE);
    WPPutHLine(0,0,640,LIGHTGRAY);
    WPPutHLine(0,16,640,BLACK);

    putsG(80-18,30,"()ȣ(nakasan)");
    WPPutHLine(0,(29)*16-1,640,BLACK);
    WPPutHLine(0,(29)*16,640,WHITE);
    WPPutHLine(0,479,640,DARKGRAY);
    WPPutHLine(0,(28)*16-2,640,LIGHTGRAY);

    setTextAttr(BLUE*16 + LIGHTBLUE);
    putsG(22,7," / 촩 ȯ F2 Ű Դϴ");
    setTextAttr(BLUE*16 + WHITE);
    if (getFlag(FLAG_firstRun))
    {
        for (int i=0;i<50;i++)
        {
            delay(100);
            if (ttyReady()) goto ok;
            if (i%10==9) ttyOutRaw("modem-check");
        }
        drawErrorWindow();
        vgaDone();
    }
ok:
    setFlag(FLAG_firstRun,0);

    int quit = 0;
    chatWinInit();

    setTextAttr(LIGHTGRAY * 16 + LIGHTGREEN);
    securitySetSysopIDPass();
    char ServerName[40];
    getServerName(ServerName);
    putsG(27,30,ServerName);
    WPPutHLine(0,(29)*16-1,640,BLACK);
    WPPutHLine(0,(29)*16,640,WHITE);
    WPPutHLine(0,479,640,DARKGRAY);
    setTextAttr(BLUE * 16 + WHITE);

    if (First)
    {
        First = 0;
        drawAboutWindow();
        WPFillBox(0,16*6,640,480-48*5,BLUE);
    }

    setTextAttr(BLUE*16 + LIGHTBLUE);
    putsG(22,7," / 촩 ȯ F2 Ű Դϴ");
    setTextAttr(BLUE*16 + WHITE);

    setTextColor(WHITE);

    modemStatus(1);

    int passchecklevel = 0;

	while (!quit)
	{
	    {
            modemStatus(0);
            ch = (int)chatWinDo();
            if (ch!=WPNOKEY)
            switch (passchecklevel)
            {
                case 0 : passchecklevel = (ch==ALT_R) ? 1:0; break;
                case 1 : passchecklevel = (ch==ALT_E) ? 2:0; break;
                case 2 : passchecklevel = (ch==ALT_V) ? 2:(ch==ALT_Z) ? 3:0; break;
            }
            switch (ch)
            {
                case 26    : ttyOutCh(26); break; // CtrlZ
                case F1    : showTextFile("city.txt");
                             goto redo;
                case  F2   :
                             setServerType(1-getServerType());
                             setTextAttr( LIGHTGRAY * 16 + LIGHTGREEN);
                             char SN[20];
                             getServerName(SN);
                             putsG(27,30,SN);
                             securitySetSysopIDPass();
                             WPPutHLine(0,(29)*16-1,640,BLACK);
                             WPPutHLine(0,(29)*16,640,WHITE);
                             WPPutHLine(0,479,640,DARKGRAY);
                             setTextAttr(BLUE * 16 + WHITE);
                             goto restart;
                case ALT_1 :
                case ALT_D :
                             switch (getServerType())
                             {
                                case HiTEL   : ttyOutRaw("ATDT7410228\015"); break;
                                case NowNuri : ttyOutRaw("ATDT5925100\015"); break;
                             }
                             break;
                case ALT_2 :
                             switch (getServerType())
                             {
                                case HiTEL   : ttyOutRaw("ATDT7620228\015"); break;
                                case NowNuri : ttyOutRaw("ATDT36796000\015"); break;
                             }
                             break;
                case ALT_4 : ttyOutRaw("ATDT01411\015"); break; // TAB
                case ALT_5 : ttyOutRaw("ATDT01410\015"); break; // TAB
                case ALT_X : quit = 1; break; // ^X
                case ALT_S :
                     asm     mov     ax, 03h
                     asm     int     10h
                     cprintf("enter \"exit\" to return....        - code by nakasan -\n");
                     spawnl(P_WAIT, searchpath("command.com"), NULL);
                     asm     mov     ax, 12h
                     asm     int     10h
                     goto redo;
                case ALT_V :
                     if (passchecklevel>=2) questionAutoTypeOn();
                                       else questionAutoTypeOff();
                     if (passchecklevel==2) setFlag(FLAG_autoTypeDisable, 1);

                     if (!ttyOn())
                     {
                        ttyOut("ERROR : Ǿ  ʽϴ\r");
                        break;
                     }
                     startBot();
                     passchecklevel = 0;
                     setFlag(FLAG_autoTypeDisable, 0);
                     goto redo;
                case UPARROW :
                     chatWinUpLine();
                     break;
                case DOWNARROW :
                     chatWinDownLine();
                     break;
                case ENTER:
                     char temp[255];
                     getChatStr(temp);
                     ttyOutRaw(temp);
                     chatWinNextLine();
                     break;
             }
        }
        ansiCursor(0);
        if (ttyReady())
        {
           ch = (int)ttyIn();
           if (ansiDo(ch)) hanWriteCh(ch);
        }
	}
    textcolor(LIGHTGRAY);
    vgaDone();
    cprintf("program terminated.\n\rSciCom presents, ..\n\rcode by Nako, Sung(HiTEL:nakasan)\n\r");
}
