#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include "vars.h"
#include "modem.h"
#include "question.h"
#include "game.h"
#include "user.h"
#include "group.h"
#include "etcwin.h"
#include "main.h"
#include "security.h"

char questionFileName[256];
char _questionAnswer[256], _questionAnswerEncrypted[256];
int _questionNumber;
int questionTimer;
long _questionTimeStarted;
Tresult Qresult[20];
int userRank[12];
int Qrank;

void questionAutoTypeOff(void)
{
    setFlag(FLAG_autoTypeOn, 0);
    setFlag(FLAG_autoTypeNotYet, 0);
    setFlag(FLAG_autoTypeTarget, 0);
    setFlag(FLAG_autoTypeTime, 0);
    setFlag(FLAG_autoTypeDisable, 0);
}

void questionAutoTypeOn(void)
{
    setFlag(FLAG_autoTypeOn, 1);
    setFlag(FLAG_autoTypeNotYet, 0);
    setFlag(FLAG_autoTypeTarget, 0);
    setFlag(FLAG_autoTypeTime, 0);
}

void questionSysopQ(char* str)
{
    setFlag(FLAG_questionUserReq, 1);
    setFlag(FLAG_questionSysopReq, 1);
    strcpy(_questionAnswer,str);
}

void questionRegisterQuestion(char* str)
{
    setIDLEflag();
    strcpy(_questionAnswer, str);
    setFlag(FLAG_questionMode, 1);
    setFlag(FLAG_questionModeON, 1);
    _questionTimeStarted = getTimeLongtyped();
    setFlag(FLAG_questionFlag,1);
    setFlag(FLAG_questionFlag2,1);
    securityRegistryCheck();

    if (getFlag(FLAG_autoTypeOn))
    {
        if (getFlag(FLAG_autoTypeNotYet))
        {
            LogWinWrite("CT+::there is another job");
            return;
        }

        if (getFlag(FLAG_autoTypeTarget)<=0)
        {
            LogWinWrite("CT+::Target TASU must be greater than 0");
            return;
        }

        setFlag(FLAG_autoTypeNotYet, 1);

        long tz = (long) 6000 * (long) questionTasu() / getFlag(FLAG_autoTypeTarget);
        setFlag(FLAG_autoTypeTime, tz);

        char str[80];
        sprintf(str,"CT+:: Time %d0(ms)",tz);
        LogWinWrite(str);
    }

}

int questionTasu(void)
{
    return howmanytasu(_questionAnswer);
}

void questionRegister(int UN, long tasu)
{
	strcpy ( Qresult[Qrank].id, getUD(UN)->id );
    Qresult[Qrank].number = UN;
	Qresult[Qrank].tasu = tasu;
    Qrank++;
}


int questionAlreadyOKed(int UN)
{
    for (int i=0;i<Qrank;i++)
        if (Qresult[i].number == UN) return 1;
    return 0;
}


long getQuestionStartTime(void)
{
    return _questionTimeStarted;
}

void questionCopyAnswer(char* questionAnswer)
{
    strcpy(questionAnswer, _questionAnswer);
}

int getUserRank(int i)
{
    return userRank[i];
}

// * FUNCTION *-------------------------------------------------------
// name ; questionClear
// in   ; none
// out  ; none
// des. ; init. question
// * FUNCTION *-------------------------------------------------------
void questionClear ( void )
{
	questionTimer = 0;
	setFlag(FLAG_questionModeON,0);
	Qrank = 0;
}


// * FUNCTION *-------------------------------------------------------
// name ; questionMain
// in   ; none
// out  ; none
// des. ; a routine managing questionaires.
// * FUNCTION *-------------------------------------------------------
void questionMain ( void )
{
    long Timer = getTimeLongtyped();
    if (questionTimer++==0 && getFlag(FLAG_questionMode) == 0)
	{
        // BEGIN !!
        setFlag(FLAG_questionMode,1);
        if (getFlag(FLAG_questionSysopReq))
        {
            setFlag(FLAG_questionSysopReq,0);
            _questionAnswerEncrypted[0]='"';
            for (int i=0;i<strlen(_questionAnswer);i++)
                _questionAnswerEncrypted[i+1] = (_questionAnswer[i]==' ') ? '.' : _questionAnswer[i];
            _questionAnswerEncrypted[++i]='"';
            _questionAnswerEncrypted[++i]=0;
        }
        else
            selectQuestion();

        ttyOut("<*> NewCity / SciCom / nakasan <*>");
		ttyOut("----------------------------------");

        if (getFlag(FLAG_gameModeOn))
           gameQuestionHeader();
        else
        {
		   ttyOut("....5                   count/down");
		   ttyOut("...4.  ....Problem....  count/down");
		   ttyOut("..3..                   count/down");
		   ttyOut(".2...    [15 Ŀ ˴ϴ]<!>");
		   ttyOut("1........[ 2 Ŀ  Go~! ]<!>");
        }
        setFlag(FLAG_questionFlag,0);
        setFlag(FLAG_questionFlag2,0);
        for (int i=0;i<12;i++)
            if (getUD(i)->alive>=0)
                setUS(i,LIGHTGREEN);
        _questionTimeStarted = getTimeLongtyped();
    }

    if (Timer-_questionTimeStarted > 200 && !getFlag(FLAG_questionFlag))
    {
		ttyOut(_questionAnswerEncrypted);
        setFlag(FLAG_userInfoChanged,1);
        setFlag(FLAG_questionFlag,1);
        setFlag(FLAG_questionFlag2,0);
    }

    //    Ƹϴ.

    if (Timer-_questionTimeStarted > getFlag(FLAG_autoTypeTime) && getFlag(FLAG_autoTypeOn) && getFlag(FLAG_autoTypeNotYet))
    {
        setFlag(FLAG_autoTypeNotYet, 0); // already
        ttyOutLevel0(_questionAnswer);
        LogWinWrite("CT+::AUTO TYPE");
        if (getFlag(FLAG_autoTypeDisable))
        {
            questionTimer=0;
		    setFlag(FLAG_questionModeON, 0);
		    Qrank = 0;
            setFlag(FLAG_questionFlag, 0);
            setFlag(FLAG_questionFlag2, 0);
            LogWinWrite("CT+::End of process");
        }
    }

	if ((Timer-_questionTimeStarted > 1500 && getFlag(FLAG_questionFlag2)) || (Qrank==getLoggedUserN() && getFlag(FLAG_questionModeON)))
	{
        setFlag(FLAG_userInfoChanged,1);
        for (int i=0;i<12;i++)
            if (getUD(i)->alive>=0)
                setUS(i,LIGHTRED);
		printResult();
        checkIDLE(); // IDLE check
        if (getFlag(FLAG_gameModeOn))
           gameQuestionTail();
        checkFight();
        updateRank();
		questionTimer=0;
		setFlag(FLAG_questionModeON,0);
		Qrank = 0;
        setFlag(FLAG_questionFlag, 0);
        setFlag(FLAG_questionFlag2, 0);
	}
    // fix a buggy-state
    if (Timer-_questionTimeStarted > 3000 && getFlag(FLAG_questionModeON))
	{
		questionTimer=0;
		setFlag(FLAG_questionModeON, 0);
		Qrank = 0;
        setFlag(FLAG_questionFlag, 0);
        setFlag(FLAG_questionFlag2, 0);
	}
}


// * FUNCTION *-------------------------------------------------------
// name ; printResult
// in   ; none
// out  ; none
// des. ; prints the result. (^^)
// * FUNCTION *-------------------------------------------------------
void printResult ( void )
{
	ttyOut("<*>  մϴ <*>");
    LogWinWrite(" :  ϴ");

    char temp[80];

    if (Qrank>0)
    {
        if (getFlag(FLAG_questionWinner)==Qresult[0].number)
           setFlag(FLAG_questionWinCount, getFlag(FLAG_questionWinCount)+1);
        else
        {
            setFlag(FLAG_questionWinner, Qresult[0].number);
            setFlag(FLAG_questionWinCount, 1);
        }

        if (getFlag(FLAG_questionWinCount)>1)
        sprintf( temp, "%s(%s)  %d° ̱ ʴϴ~",
                       getUD(getFlag(FLAG_questionWinner))->name,
                       getUD(getFlag(FLAG_questionWinner))->id,
                       getFlag(FLAG_questionWinCount));
        else
        sprintf( temp, "%s(%s)   ϼ̽ϴ",
                       getUD(getFlag(FLAG_questionWinner))->name,
                       getUD(getFlag(FLAG_questionWinner))->id );

        ttyOut(temp);
    }

    int userTasu[12];

    for (int i=0;i<12;i++)
    {
        userRank[i] = 0;
        userTasu[i] = 0;
    }

	for (i=0;i<Qrank;i++)
	{
        if (Qresult[i].number>=0 && Qresult[i].number<12); else continue;

        userRank[Qresult[i].number]=i+1;

        userTasu[Qresult[i].number]=Qresult[i].tasu;

        getUD(Qresult[i].number)->total+=Qresult[i].tasu;
        if (getUD(Qresult[i].number)->number<=0)
        {
           getUD(Qresult[i].number)->number = 0;
           getUD(Qresult[i].number)->total = Qresult[i].tasu;
        }
        getUD(Qresult[i].number)->number++;
        int avg;
        avg = getUD(Qresult[i].number)->total/
                  getUD(Qresult[i].number)->number;
		sprintf(temp,"%02d. %s(%-8s) ... %4dŸ/(Avg:%4d)",
                     i+1,getUD(Qresult[i].number)->name,Qresult[i].id,Qresult[i].tasu,avg);

        ttyOut(temp);

        sprintf(temp,"*%2d:%s(%-8s):%4d(%4d)",
                     i+1,getUD(Qresult[i].number)->name,Qresult[i].id,Qresult[i].tasu,avg);
        LogWinWrite(temp);
	}
    if (getFlag(FLAG_groupAllowed))
       printGroup(userTasu);

	ttyOut("<*>  ϴ~ <*>");
    if (Qrank>0)
    {
        whisper(Qresult[0].id,"(+1) (+4) ö󰬽ϴ~");
        getUD(Qresult[0].number)->VicNum++;
        getUD(Qresult[0].number)->score+=4;
    }
    if (Qrank>1)
    {
        whisper(Qresult[1].id,"(+3) ö󰬽ϴ~");
        getUD(Qresult[1].number)->score+=3;
    }
    if (Qrank>2)
    {
        whisper(Qresult[2].id,"(+2) ö󰬽ϴ~");
        getUD(Qresult[2].number)->score+=2;
    }
    for (i=3;i<Qrank;i++)
    {
        whisper(Qresult[i].id,"(+1) ö󰬽ϴ~");
        getUD(Qresult[i].number)->score+=1;
    }
    for (i=0;i<Qrank;i++)
        saveUserData(getUD(Qresult[i].number));
}

void countQnumber(const char* filename)
{
    strcpy(questionFileName, filename);
    FILE *fp = fopen(filename,"rb");
    if (fp==NULL)
    {
        _questionNumber = 0;
        return;
    }

    int n=0;
    while (!feof(fp))
        if (fgetc(fp)=='\n') n++;
    fclose(fp);

    _questionNumber = n;
}


// * FUNCTION *-------------------------------------------------------
// name ; selectQuestion
// in   ; none
// out  ; none
// des. ; selects a question from question-DB.
// * FUNCTION *-------------------------------------------------------
void selectQuestion(void)
{
	FILE* fp = fopen(questionFileName,"rt");
	if (fp==NULL)
	{
		ttyOut("system error.");
		strcpy ( _questionAnswerEncrypted, "<..ȭ..¼>" );
		strcpy ( _questionAnswer,  "  ȭ  ¼" );
		return;
	}

    char* buf = _questionAnswer;
	char* enc = _questionAnswerEncrypted;
    enc[0]='"';
    int lim = rand()%_questionNumber;
    for (int i=-1;i<lim;i++)
    {
        // get str
        unsigned char j=0;
        while (1)
        {
            if (j>200) j=0;
            char ch = fgetc(fp);
            if (ch=='\n')
            {
                if (buf[j-1]==' ') j--;
                buf[j]=0;
                enc[j+1]='"';
                enc[j+2]='\n';
                enc[j+3]=0;
                j=0;
                goto outside;
            }
            enc[j+1]=ch==' '?'.':ch;
            buf[j++]=ch=='.'?' ':ch;
        }
    outside:
    }
    fclose(fp);
}

// * FUNCTION *-------------------------------------------------------
// name ; updateRank
// in   ;
// out  ;
// des. ; updates rank-list
// * FUNCTION *-------------------------------------------------------
void updateRank(void)
{
    FILE *fp = fopen("city.usr","rb");
    if (fp==NULL) return;
    FILE *ofp = fopen("city.rnk","wb");
    char out[80];
    for (int m=0;m<80;m++) out[m]=32;
    out[79]=13;
    out[80]=0;


    Tuser temp;
    int rec;

    fseek(fp,0,SEEK_END);
    rec = ftell(fp)/sizeof(Tuser);

    int max, premax, key, rank=1;

    premax = 32000;

    int lim = rec;

    for (int i=0;i<lim;)
    {
        max = -1;

        fseek(fp,0,SEEK_SET);
        rank = i+1;
        for (int j=0;j<rec;j++)
        {
            fread(&temp,sizeof(Tuser),1,fp);
            if (temp.score>max && temp.score<premax) max = temp.score;
        }

        fseek(fp,0,SEEK_SET);
        for (j=0;j<rec;j++)
        {
            fread(&temp,sizeof(Tuser),1,fp);
            if (temp.score==max)
            {
                i++;
                sprintf(out,"%3d/%-8s[%4d]",rank,temp.id,temp.score);
                fwrite(out,80,1,ofp);
            }
        }
        premax = max;
    }
    fclose(fp);
    fclose(ofp);

    fp = fopen("city.usr","rb");
    if (fp==NULL) return;
    ofp = fopen("city-s.rnk","wb");
    for (m=0;m<80;m++) out[m]=32;
    out[79]=13;
    out[80]=0;


    fseek(fp,0,SEEK_END);
    rec = ftell(fp)/sizeof(Tuser);

    rank=1;

    premax = 32000;

    lim = rec;

    for (i=0;i<lim;)
    {
        max = -1;

        fseek(fp,0,SEEK_SET);
        rank = i+1;
        for (int j=0;j<rec;j++)
        {
            fread(&temp,sizeof(Tuser),1,fp);
            int avg = (temp.number<=0) ? 0 : (temp.total / temp.number);
            if (avg>max && avg<premax) max = avg;
        }

        fseek(fp,0,SEEK_SET);
        for (j=0;j<rec;j++)
        {
            fread(&temp,sizeof(Tuser),1,fp);
            int avg = (temp.number<=0) ? 0 : temp.total / temp.number;
            if (avg==max)
            {
                i++;
                sprintf(out,"%3d/%-8s[%4d]",rank,temp.id,avg);
                fwrite(out,80,1,ofp);
            }
        }
        premax = max;
    }
    fclose(fp);
    fclose(ofp);
}

