#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include "WPGRAPH.H"
#include "WPHANOUT.H"
#include "WPHANIN.H"
#include "WPKEYDEF.H"

void vgaInit()
{
    int ErrFlag;

    ErrFlag = WPTinyHanInit("ENG.FNT", "HAN.FNT");

    if (ErrFlag) {
        if (ErrFlag == 1) printf("Not Found VGA Card");
        else if (ErrFlag == 2) {
            WPTinyHanClose();
            printf("Not Enough memory");
        }
        else if (ErrFlag == 3) {
            WPTinyHanClose();
            printf("Can't load English font");
        }
        else if (ErrFlag == 4) {
            WPTinyHanClose();
            printf("Can't load Hangul font");
        }
        exit(0);
    }

    /* baa eai awa Ё a { ea. */
    WPLoadSpFont("SPECIAL.FNT"); /* Ae -1  */
    WPLoadHjFont("HANJA.FNT");
}


// * FUNCTION *-------------------------------------------------------
// name ; vgaDone
// in   ;
// out  ;
// des. ; ..
// * FUNCTION *-------------------------------------------------------
void vgaDone()
{
    WPTinyHanClose();
}


void getLine( FILE* fp, int i, char* str )
{
    fseek(fp,(long)i*200,SEEK_SET);
    fread(str,200,1,fp);
}

void drawWinTitle( int x, int y, int w, int h, const char *title, int color1, int color2, int color3 )
{
    int X1, Y1, X2;
    int _currentTextColor;
    int BorderWidth = 3;

    X1 = (x-1)*8; Y1 = (y-1)*16-16-BorderWidth;
    X2 = (x+w-1)*8;

    WPFillBox(X1,Y1,X2-X1,16,color2);

    WPSetWMode(WPMODE_OVERLAP);
    if (color1!=DARKGRAY)
       _currentTextColor = color2*16 + DARKGRAY;
    else
       _currentTextColor = color2*16 + BLACK;
    WPPuts((x+w/2-strlen(title)/2)*8-8,(y-1)*16-16-BorderWidth,_currentTextColor,(char*)title);
    _currentTextColor = color2*16 + color1;
    WPPuts((x+w/2-strlen(title)/2)*8-8-1,(y-1)*16-16-BorderWidth,_currentTextColor,(char*)title);
    WPSetWMode(WPMODE_OVERWRITE);
    _currentTextColor = color1*16 + color3;
}


void drawWindow(int x,int y,int w,int h,const char* title,int color1,int color2,int color3)
{

    int X1, Y1, X2, Y2;
    int BorderWidth = 3;

    X1 = (x-1)*8; Y1 = (y-1)*16-16-BorderWidth;
    X2 = (x+w-1)*8; Y2 = (y+h-1)*16;

    WPFillBox(X1-BorderWidth,Y1-BorderWidth,X2+BorderWidth*2-X1+1,BorderWidth,LIGHTGRAY);
    WPFillBox(X1-BorderWidth,Y2+1,X2+BorderWidth*2-X1+1,BorderWidth-1,LIGHTGRAY);
    WPFillBox(X1-BorderWidth,Y1-BorderWidth,BorderWidth,Y2+BorderWidth*2-Y1+1,LIGHTGRAY);
    WPFillBox(X2,Y1-BorderWidth,BorderWidth,Y2+BorderWidth*2-Y1+1,LIGHTGRAY);

    // middle bar
    WPFillBox(X1,Y1,X2-X1,16,color2);
    WPFillBox(X1,Y1+16+BorderWidth,X2-X1,Y2-Y1-16-BorderWidth+1,color1);

    // Dark
    WPPutHLine(X1,Y1+16+BorderWidth-1,X2-X1,DARKGRAY);

    WPPutHLine(X1,Y1-1,X2-X1,DARKGRAY);
    WPPutHLine(X1-BorderWidth,Y2+BorderWidth,X2-X1+BorderWidth*2,DARKGRAY);
    WPPutVLine(X1-1,Y1-1,Y2-Y1+2,DARKGRAY);
    WPPutVLine(X2+BorderWidth,Y1-BorderWidth,Y2-Y1+BorderWidth*2+1,DARKGRAY);

    // Light
    WPPutHLine(X1,Y1+16,X2-X1+1,WHITE);

    WPPutHLine(X1,Y2+1,X2-X1,WHITE);
    WPPutHLine(X1-BorderWidth,Y1-BorderWidth,X2-X1+BorderWidth*2,WHITE);
    WPPutVLine(X1-BorderWidth,Y1-BorderWidth,Y2-Y1+BorderWidth*2,WHITE);
    WPPutVLine(X2,Y1,Y2-Y1+1,WHITE);
    WPFillBox(X1-1,Y1+17,X2-X1+2,BorderWidth-2,LIGHTGRAY);
    drawWinTitle(x,y,w,h,title,color1,color2,color3);
    return;
}


void showTextFile( const char* filename )
{
    FILE* fp, *ofp;
    fp = fopen(filename,"rb");
    if (fp==NULL) return;
    ofp = fopen("temp.$$$","wb");

    char str[200];
    unsigned char i=0;
    int lines=0;
    while (!feof(fp))
    {
        unsigned char ch = fgetc(fp);
        switch (ch)
        {
            case 9 :
                 str[i++] = 32;
                 str[i++] = 32;
                 str[i++] = 32;
                 str[i++] = 32;
                 break;
            case '\n' :
                 str[i++] = 0;
                 fwrite(str,200,1,ofp);
                 lines++;
                 i=0;
                 break;
            default :
                 if (ch<32) break;
                 str[i++] = ch;
        }
    }
    fclose(fp);
    fclose(ofp);

    fp = fopen("temp.$$$","rb");

    drawWindow(2,3,78,27,"Read ME",BLUE,LIGHTBLUE,WHITE);
    int curLine = 0;

    for (i=0;i<27;i++)
    {
        getLine(fp,i,str);
        WPPuts(8,i*16+32,BLUE*16+WHITE,str);
    }

    char temp[256];
    char blank78[100];
    for (i=0;i<78;i++) blank78[i]=32;
    blank78[i]=0;

    while (1)
    {
        unsigned char ch = getch();
        switch (ch)
        {
            case 0 :
                 ch = getch();
                 switch (ch)
                 {
                     case 71 :
                          curLine = 0;
                          goto here;
                     case 79 :
                          curLine = lines-27;
                          goto here;
                     case 73 :
                          if (curLine<27) curLine = 0; else curLine-=27;
                          goto here;
                     case 81 :
                          curLine+=27;
                          if (curLine+26>=lines) curLine = lines-27;
         here:
                          for (i=0;i<27;i++)
                          {
                             getLine(fp,curLine+i,str);
                             sprintf(temp,"%s%s",str,blank78);
                             temp[78]=0;
                             WPPuts(8,i*16+32,BLUE*16+WHITE,temp);
                          }
                          break;
                     case 72 :
                          if (curLine==0) break;
                          for (int sc=0;sc<2;sc++)
                              _ScrollDn(2-1,2+3*16-16-2,78,27*16,8);
                          getLine(fp,(--curLine),str);
                          sprintf(temp,"%s%s",str,blank78);
                          temp[78]=0;
                          WPPuts(8,0*16+32,BLUE*16+WHITE,temp);
                          break;
                     case 80 :
                          if (curLine+26==lines) break;
                          for (sc=0;sc<2;sc++)
                              _ScrollUp(2-1,2+3*16-16,78,27*16-1,8);
                          getLine(fp,(++curLine)+26,str);
                          sprintf(temp,"%s%s",str,blank78);
                          temp[78]=0;
                          WPPuts(8,26*16+32,BLUE*16+WHITE,temp);
                          break;
                 };
                 break;
            case 27 : goto outside;
        }
    }
outside:

    fclose(fp);
}


void main ( void )
{
    vgaInit();
    showTextFile("city.txt");
    vgaDone();
}