#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "vars.h"
#include "modem.h"
#include "user.h"
#include "security.h"
#include "buffer.h"

int Registered;
int Active;
int _securityProblemOccured;
char _userSysopPassword[20], _userSysopID[20];
char _UIP[4][20];
char endStepPass[20], endUser, _forceMode;

void securityUIP(int i, char* str)
{
    strcpy(_UIP[i], str);
}

int securityProblemOccuredCheck(void)
{
    if (_securityProblemOccured>=6)
    {
        Active=0;
        return 1;
    }
    return 0;
}

void securityInit ( void )
{
    _forceMode = 0;
    Registered = 0;
    Active = 1;
    _securityProblemOccured = 0;
}

int securityKeepGoing(void)
{
    return Active;
}

int securityRegistered(void)
{
    return Registered;
}

void securityRegistryCheck(void)
{
     if (!Registered) _securityProblemOccured++;
}

void securitySetSysopIDPass(void)
{
    strcpy(_userSysopID, _UIP[getServerType()*2+0] );
    strcpy(_userSysopPassword, _UIP[getServerType()*2+1] );
}

void securityCopySysopID(char* userSysopID)
{
    strcpy(userSysopID, _userSysopID);
}

// * FUNCTION *-------------------------------------------------------
// name ; securityMakePassword
// in   ;
// out  ;
// des. ; calculates _userSysopPassword
// * FUNCTION *-------------------------------------------------------
void securityMakePassword(const char* id, char* _userSysopPassword)
{
    int sum = 0;
    for (int i=0;i<strlen(id);i++) sum+=(unsigned char)id[i];

    // byte 1;
    unsigned long pass;
    pass = ((sum % 23) % 9 );
    pass*=10;
    pass+= ((sum % 31) % 8 );
    pass*=10;
    pass+= ((sum % 43) % 10);
    pass*=10;
    pass+= ((sum % 47) % 9 );
    pass*=10;
    pass+= ((sum % 53) % 7 );

    sprintf(_userSysopPassword,"%ld",pass);
}


void securityMakePassword2(const char* id, const char* id2, char* _userSysopPassword)
{
    int sum = 0;
    for (int i=0;i<strlen(id);i++) sum+=id[i];

    int sum2 = 0;
    for (i=0;i<strlen(id2);i++) sum2+=id2[i];

    // byte 1;
    unsigned long pass;
    pass = ((sum % 41) % 9 ); pass*=10;
    pass+= ((sum2% 31) % 9 ); pass*=10;
    pass+= ((sum % 23) % 9 ); pass*=10;
    pass+= ((sum2% 47) % 9 ); pass*=10;
    pass+= ((sum % 43) % 9 ); pass*=10;
    pass+= ((sum % 53) % 9 ); pass*=10;
    pass+= ((sum2% 41) % 9 ); pass*=10;
    pass+= ((sum2% 31) % 9 ); pass*=10;
    pass+= ((sum % 23) % 9 ); pass*=10;
    pass+= ((sum % 47) % 9 ); pass*=10;
    pass+= ((sum2% 43) % 9 ); pass*=10;
    pass+= ((sum % 53) % 9 );


    sprintf(_userSysopPassword,"%ld",pass);
}


// * FUNCTION *-------------------------------------------------------
// name ; securityCheck
// in   ;
// out  ;
// des. ; check.
// * FUNCTION *-------------------------------------------------------

void securityCheck(char* id)
{
    // adopt ID

    if (strcmp(id,_userSysopID)!=0 && Registered)
    {
        // another bot appears ( another clone )
        ttyOut("# ٸ CITY Ÿϴ");
        ttyOut("# ڵ OFF  մϴ");
        ttyOut("!ڵ");
        _forceMode = 1;
        return;
    }

    if (strcmp(id,_userSysopID)!=0)
    {
        return;
    }

    char temp[20];
    securityMakePassword(id, temp);
    if (strcmp(_userSysopPassword,temp)!=0)
    {
        ttyOut("# verification failed");
        ttyOut("# йȣ ٸ ʽϴ.   ȸ 5ȸ ѵ˴ϴ");
        _securityProblemOccured = 1;
        return;
    }
    ttyOut("# user id verification ok");
    Registered = 1;
    strcpy(_userSysopID, id);
}

// ڵ  
void endStep1(char* id)
{
    if (strcmp(id,_userSysopID)==0) return;
    endUser = userNumber(id);

    ttyOut("# ڵ 䱸 ޾ҽϴ");
    ttyOut("#  ſ Ȯմϴ");
    char temp[100];
    sprintf( endStepPass, "%1d%1d%1d%1d%1d%1d%1d%1d",
             random(10),random(10),random(10),random(10),
             random(10),random(10),random(10),random(10) );
    sprintf( temp,"!Ȯ %s", endStepPass );

    ttyOut(temp);

    securityMakePassword2(endStepPass, id, temp);
    strcpy(endStepPass, temp);

}

void endStep2(char* id, char* cmd)
{
    if (strcmp(id,_userSysopID)==0) return;
    if (!_forceMode) return;
    ttyOut("# ڵ 䱸 ޾Ƶ鿩 ֽϴ");
    ttyOut("# 濡 ſ Ȯ û߽ϴ");
    // adopt ID
    char *zid=cmd, n=0;
    while (*zid==' ') zid++;
    while (zid[n]>32) n++;
    zid[n] = 0;

    char temp[20], temp2[20];
    securityMakePassword2(zid, _userSysopID, temp);
    sprintf( temp2, "!Ȯ %s", temp );
    ttyOut(temp2);

    _forceMode = 0;
}

void endStep3(char* id, char* cmd)
{
    if (strcmp(id,_userSysopID)==0) return;
    if (userNumber(id)!=endUser) return;
    // adopt ID
    char *zid=cmd, n=0;
    while (*zid==' ') zid++;
    while (zid[n]>32) n++;
    zid[n] = 0;

    if (strcmp(zid,endStepPass)==0)
    {
        ttyOut("#  䱸 ޾ƵԴϴ");
        Active=0;
    }
}
