#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <string.h>
#include <conio.h>
#include "main.h"
#include "modem.h"
#include "question.h"
#include "buffer.h"
#include "group.h"
#include "user.h"
#include "wpgraph.h"
#include "wpkeydef.h"
#include "etcwin.h"
#include "security.h"
#include "chat.h"
#include "video.h"

// * FUNCTION *-------------------------------------------------------
// name ; startBot
// in   ; none
// out  ; none
// des. ; main-procedure
// * FUNCTION *-------------------------------------------------------
void startBot(void)
{
    countQnumber("city.dat");
    setFlag(FLAG_groupAllowed, 0);
    setFlag(FLAG_gameModeOn, 0);
    initFight();
    
    setFlag(FLAG_questionWinner, -1);
    setFlag(FLAG_questionWinCount, 0);

    setFlag(FLAG_userSysopLoggedOn, 0);
    char localbuf[255];
    securityInit();
//    WPSetWMode(WPMODE_OVERLAP);
    setFlag(FLAG_questionSysopReq, 0);
    setFlag(FLAG_questionUserQOK, 0);
    setFlag(FLAG_userInfoChanged,1);
    setFlag(FLAG_infoMode, 0);
    setFlag(FLAG_infoCurrentUser, 0);
	// say hello
	sayHello();
    textbackground(BLACK);
    WPFillBox(0,16,640,480-48,BLACK);
//    clrscr();
    // check current users and log'em
	questionClear();
    drawWindows();
    drawInfoWindow();
    helpWindow();

    for (int i=0;i<12;i++)
    {
        getUD(i)->alive = -1;
        setUS(i,DARKGRAY);
    }

	bufferClear();

    setFlag(FLAG_questionSysopAllow, 0);
    drawTimer();
    if (!getFlag(FLAG_autoTypeOn))
    {
        LogWinWrite("SciCom Typing Room Robot");
        LogWinWrite(" : ȣ");
        LogWinWrite(" ID : nakasan");
    }
    else
    {
        LogWinWrite("CT+ enabled. set target-tasu");
        LogWinWrite("$E600 <- set tasu as 600");
        setFlag(FLAG_questionUserQOK, 1);
        LogWinWrite("User ReqQ : ON");
    }

	while ((securityKeepGoing() || getFlag(FLAG_autoTypeDisable)) && ttyOn())
	{
        modemStatus(0);
        bufferIn();
        deoverflow();
        switch (getServerType())
        {
            case HiTEL :
                 bufferOutHiTEL();
		         bufferCheckHiTEL();
                 break;
            case NowNuri :
		         bufferOutNowNuri();
		         bufferCheckNowNuri();
                 break;
        }

// FOR SAFETY
        for (i=0;i<12;i++)
            if (getUD(i)->alive>=0)
            {
                if (strlen(getUD(i)->id)<4 ||
                    strlen(getUD(i)->id)>8) getUD(i)->alive=-1;
            }

        if (securityProblemOccuredCheck())
        {
            ttyOut("#  ϴ ,  ȸ 5ȸ ѵ˴ϴ");
            goto outside;
        }
		if (getFlag(FLAG_questionModeON))
        {
            questionMain();
            drawTimer();
        }
		else
		if (getFlag(FLAG_questionUserReq))
		{
			setFlag(FLAG_questionModeON, 1);
			setFlag(FLAG_questionUserReq, 0);
            setFlag(FLAG_questionMode, 0);
		}

		{
			int ch = chatWinDo();
			switch (ch)
			{
            case  F1 : // ^A
                setFlag(FLAG_questionUserReq, 1);
                break;
            case F12 : // TAB
                setFlag(FLAG_infoMode, getFlag(FLAG_infoMode)+1);
                if (getFlag(FLAG_infoMode)>=5) setFlag(FLAG_infoMode,0);
                setFlag(FLAG_userInfoChanged,1);
                break;
            case F11 : // ^B
                int i, j;

                for (i=0,j=0;i<12;i++)
                    if (getUD(i)->alive>=0) j++;

                if (j==0) break;


                for (i=getFlag(FLAG_infoCurrentUser),j=0;j<12;j++)
                {
                    if (++i>=12) i=0;
                    if (getUD(i)->alive>=0) break;
                }
                setFlag(FLAG_infoCurrentUser, i);
                drawInfoWindow();
                break;
			case F10 : // ^Y
                toggleFlag(FLAG_questionSysopAllow);
                if (getFlag(FLAG_questionSysopAllow))
                   ttyOut("#  䱸 Ǿϴ");
                else
                   ttyOut("#  䱸 Ǿϴ");
				break;
            case F7 :
                if (!securityRegistered())
                {
                    LogWinWrite("# ǿ  ѵ˴ϴ");
                    break;
                }
                toggleFlag(FLAG_gameModeOn);
                if (getFlag(FLAG_gameModeOn))
                {
                   ttyOut("#  尡 Ǿϴ");
                   if (getFlag(FLAG_groupAllowed))
                      goto NOGROUP;
                }
                else
                   ttyOut("#  尡 Ǿϴ");
				break;
            case F8 :
                if (!securityRegistered())
                {
                    LogWinWrite("# ǿ  ѵ˴ϴ");
                    break;
                }
                else
                {
                    if (getFlag(FLAG_gameModeOn)) break;
            NOGROUP :
                    toggleFlag(FLAG_groupAllowed);
                    if (getFlag(FLAG_groupAllowed))
                       ttyOut("# ׷ 尡 Ǿϴ");
                    else
                    {
                       ttyOut("# ׷ 尡 Ǿϴ");
                       for (int i=0;i<12;i++)
                           if (getUD(i)->alive>=0 && getWhichGroup(i)>=0)
                                userCMDunregisterGroup(getUD(i)->id);
                    }
                }
				break;
            case F9 : // ^Y
                toggleFlag(FLAG_questionUserQOK);
                if (getFlag(FLAG_questionUserQOK))
                   ttyOut("# Ϲ   üũ Ǿϴ");
                else
                   ttyOut("# Ϲ   üũ Ǿϴ");
				break;
			case ALT_V : goto outside;
            case UPARROW :
                 chatWinUpLine();
                 break;
            case DOWNARROW :
                 chatWinDownLine();
                 break;
			case 13 : // ENTER
                getChatStr(localbuf);
                if (localbuf[0]=='@')
                {
                    if (getFlag(FLAG_questionModeON))
                        LogWinWrite(" : ̹  ó Դϴ.");
                    else
                        questionSysopQ(localbuf+1);
                    chatWinNextLine();
                }
                else
                {
                    if (getFlag(FLAG_autoTypeOn))
                    {
                        if (localbuf[0]==27)
                        {
                            char temp[80];
                            strcpy(temp,localbuf+1);
                            setFlag(FLAG_autoTypeTarget, atoi(temp));
                            sprintf(temp, "$ Target : %d", getFlag(FLAG_autoTypeTarget));
                            LogWinWrite(temp);
                        }
                        else
                        {
                            pasteTail(localbuf);
				            ttyOutLevel0(localbuf);
                        }
                        chatWinNextLine();
                    }
                    else
                    {
                        pasteTail(localbuf);
				        ttyOut(localbuf);
                        chatWinNextLine();
                    }
                }
                localbuf[0]=0;
				break;
			};
		}
	}
outside:
	// say bye
    if (ttyOn()) sayBye();
    setTextColor(WHITE);
}
