#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include "vars.h"
#include "user.h"
#include "modem.h"
#include "buffer.h"
#include "question.h"
#include "etcwin.h"
#include "security.h"
#include "group.h"
#include "main.h"
#include "chat.h"
#include "version.h"

char _userStatus[12];
Tuser userdataLoggedOn[12];
int userIDLEnum[12], userIDLE[12];

Tuser* getUD(int un)
{
    return (Tuser*)&(userdataLoggedOn[un]);
}

void setIDLEzero(void)
{
    for (int i=0;i<12;i++)
        setUserIDLEzero(i);
}

void setUserIDLEzero(int un)
{
    userIDLEnum[un] = 0;
}
void setIDLEflag(void)
{
    for (int i=0;i<12;i++)
        userIDLE[i] = 1;
}
void noIDLE(int un)
{
    userIDLE[un] = 0;
}
void checkIDLE(void)
{
    for (int i=0;i<12;i++)
        if (userIDLE[i]) checkUserIDLE(i);
}
void checkUserIDLE(int un)
{
    if (getUD(un)->alive<0) return;
    if (++userIDLEnum[un]>=5)
    {
        char str[80];
        sprintf(str,"IDLE-OUT : %s",getUD(un)->id);
        LogWinWrite(str);
        whisper(getUD(un)->id, "5 ̻ Ͻ ż ");
        whisper(getUD(un)->id, "˴ϴ. ٽ, ƹ Է̳ Ͻø ");
        whisper(getUD(un)->id, " մϴ");
        userLogout(un);
    }
}



void setUS(int un, int c)
{
    _userStatus[un] =c;
}

int getUS(int un)
{
    return _userStatus[un];
}

int getLoggedUserN(void)
{
    int n=0;
    for (int i=0;i<12;i++)
        if (userdataLoggedOn[i].alive>=0) n++;
    return n;
}

// * FUNCTION *-------------------------------------------------------
// name ; loadUserData
// in   ; ID(const char[]), UserDataPointer(Tuser*)
// out  ; none
// des. ; load a userdata from userdata-db.
// * FUNCTION *-------------------------------------------------------
void loadUserData(const char* id, Tuser* userData)
{
    FILE *fp = fopen("city.usr","rb");
    if (fp==NULL)
    {
        userData->alive = 100;
        return;
    }
    while (!feof(fp))
    {
        fread(userData,sizeof(Tuser),1,fp);
        if (strcmp(id,userData->id)==0)
        {
            fclose(fp);
            userData->alive = 1;
            return;
        }
    }
    fclose(fp);
    userData->alive = 100;
}


// * FUNCTION *-------------------------------------------------------
// name ; saveUserData
// in   ; userrecord(Tuser*)
// out  ; none
// des. ; ^^;
// * FUNCTION *-------------------------------------------------------
void saveUserData(Tuser* userData)
{
    FILE *f1 = fopen("city.usr","rb");
    FILE *f2 = fopen("city.us!","wb");

    Tuser userData2;
    int ok = 0, rec;

    if (f1==NULL) goto Skip;

    fseek(f1,0,SEEK_END);
    rec = ftell(f1)/sizeof(Tuser);
    fseek(f1,0,SEEK_SET);
    while (rec-->0)
    {
        fread(&userData2,sizeof(Tuser),1,f1);
        if (strcmp(userData->id,userData2.id)==0)
        {
           ok = 1;
           fwrite(userData,sizeof(Tuser),1,f2);
        }
        else
           fwrite(&userData2,sizeof(Tuser),1,f2);
    }

    fclose(f1);
Skip:
    if (!ok) fwrite(userData,sizeof(Tuser),1,f2);
    fclose(f2);
    remove("city.usr");
    rename("city.us!","city.usr");
}


void clearUserData(int mode)
{
    FILE *f1 = fopen("city.usr","rb");
    FILE *f2 = fopen("city.us!","wb");

    Tuser userData2;
    int rec;

    if (f1==NULL) goto Skip;

    fseek(f1,0,SEEK_END);
    rec = ftell(f1)/sizeof(Tuser);
    fseek(f1,0,SEEK_SET);
    while (rec-->0)
    {
        fread(&userData2,sizeof(Tuser),1,f1);
        switch (mode)
        {
            case 0 : userData2.score = 0; break;
            case 1 : userData2.total = 0; userData2.number = 0; break;
        }
        fwrite(&userData2,sizeof(Tuser),1,f2);
    }

    fclose(f1);
Skip:
    fclose(f2);
    remove("city.usr");
    rename("city.us!","city.usr");
}


// * FUNCTION *-------------------------------------------------------
// name ; whisper
// in   ; ID(const char[]), string(const char[])
// out  ; none
// des. ; whispers a msg to ID.
// * FUNCTION *-------------------------------------------------------
void whisper(const char* id, const char* str)
{
    if (strlen(id)<4)
    {
        int i;
        i = userNumber((char*)id);
        if (i>=0) userdataLoggedOn[i].alive = -1;
    }
    char sysopid[20];
    securityCopySysopID(sysopid);
    if (strcmp(sysopid,id)==0)
    {
        LogWinWrite(str);
        return;
    }
	char temp[200];
    switch (getServerType())
    {
        case HiTEL : sprintf(temp,"/to %s %s",id,str); break;
        case NowNuri : sprintf(temp,"/ear %s %s",id,str); break;
    }
	ttyOut(temp);
}


// * FUNCTION *-------------------------------------------------------
// name ; userNumber
// in   ; ID(const char[])
// out  ; none
// des. ; tells user's reg-number.
// * FUNCTION *-------------------------------------------------------
int userNumber(char* id)
{
	for (int j=0;j<8;j++)	if (id[j]==' ') id[j]=0;
	for (int i=0;i<12;i++)
        if (userdataLoggedOn[i].alive>=0)
		if (strcmp(id,userdataLoggedOn[i].id)==0)
			return i;
	return -1;
}


// * FUNCTION *-------------------------------------------------------
// name ; userLogon
// in   ;
// out  ;
// des. ; logs-on a user
// * FUNCTION *-------------------------------------------------------
int userLogon(char* name, char* id)
{
	Tuser newUser;

    int reDraw = (userdataLoggedOn[getFlag(FLAG_infoCurrentUser)].alive<0);
    setFlag(FLAG_userInfoChanged,1);
    for (int i=0;i<strlen(id);i++)
       if ((unsigned char)id[i]<33)
          return -1; // no valid
    for (i=0;i<strlen(name);i++)
       if ((unsigned char)name[i]<33)
          return -1; // no valid
    for (i=0;i<12;i++)
        if (userdataLoggedOn[i].alive>=0 && strcmp(userdataLoggedOn[i].id,id)==0) return i;

	strcpy(newUser.name,name);
	strcpy(newUser.id,id);

    if (!getFlag(FLAG_userSysopLoggedOn))
    {
        char sysopid[20];
        securityCopySysopID(sysopid);
        if (strcmp(id,sysopid)==0)
        {
            setFlag(FLAG_userSysopLoggedOn, 1);
            ttyOut("!Ȯ /  Ȯ Դϴ");
        }
    }

	newUser.total = 0;
	newUser.score = 0;
	newUser.logNum = 1;
	newUser.VicNum = 0;
    newUser.number = 0;
	newUser.missCheck = 0;
	for (int scanned=0;scanned<12;scanned++)
	{
		if (userdataLoggedOn[scanned].alive<0) break;
	}

	char temp[80];
	sprintf(temp,":%s(%s)",name,id);
    LogWinWrite(temp);

	if (scanned>=12) return -1; // BUG
	newUser.alive = scanned;
	userdataLoggedOn[scanned] = newUser;
    userdataLoggedOn[scanned].missCheck=0;

    setUserIDLEzero(scanned); // idle 0

	Tuser tempUser;
	loadUserData(id, &tempUser);

    _userStatus[scanned] = LIGHTRED;

	if (tempUser.alive>0)
	{
        if (tempUser.alive==100)
        {
            whisper(id,"CT(Ƽ)/ ! ̶ ġ ~");
            if (reDraw) drawInfoWindow();
            return scanned; // NO FILE
        }
        tempUser.alive = newUser.alive;
		userdataLoggedOn[scanned] = tempUser;
	}

    userdataLoggedOn[scanned].logNum++;
    whisper(id,"CT(Ƽ)/ ! ̶ ġ ~");
    sprintf(temp,"%s(%s)  / %4dȸ ̳׿",name,id,userdataLoggedOn[scanned].logNum);
	whisper(id,temp);


    if (userdataLoggedOn[scanned].number<0)
    {
        userdataLoggedOn[scanned].number=0;
        userdataLoggedOn[scanned].total=0;
        saveUserData(&userdataLoggedOn[scanned]);
    }
    userdataLoggedOn[scanned].missCheck=0;
    if (reDraw) drawInfoWindow();

    return scanned;
}


// * FUNCTION *-------------------------------------------------------
// name ; userLogout
// in   ;
// out  ;
// des. ; log-out a user
// * FUNCTION *-------------------------------------------------------
void userLogout(int UN)
{
    char temp[80];
    sprintf(temp,":%s(%s)", userdataLoggedOn[UN].name, userdataLoggedOn[UN].id);
    LogWinWrite(temp);
    setFlag(FLAG_userInfoChanged,1);
    if (getWhichGroup(UN)>=0)
       userCMDunregisterGroup(userdataLoggedOn[UN].id);
    else
    {
        if (getGroupProcess(UN)>=0)
        {
           ttyOut("#    Ǿϴ");
           fightOff(getGroupProcess(UN));
        }
    }
	userdataLoggedOn[UN].alive = -1;
    _userStatus[UN] = DARKGRAY;

    if (getFlag(FLAG_questionWinner)==UN)
    {
        setFlag(FLAG_questionWinner, -1);
        setFlag(FLAG_questionWinCount, 0);
    }
}


// * FUNCTION *-------------------------------------------------------
// name ; userCorrectTypeCase
// in   ;
// out  ;
// des. ; correct-typing-case
// * FUNCTION *-------------------------------------------------------
void userCorrectTypeCase(int UN)
{
	char temp[80];
    if (questionAlreadyOKed(UN)) return;
	long zt = getTimeLongtyped() - getQuestionStartTime();
    if (zt==0) return;
	sprintf(temp, "%6.2f ", (float)zt/100.0 );
	whisper(userdataLoggedOn[UN].id,temp);
    long tasu = (long)questionTasu()*6000/zt;
    questionRegister(UN,tasu);
    sprintf(temp,"> %s(%s) %6.2f/%4dŸ",userdataLoggedOn[UN].name,userdataLoggedOn[UN].id,(float)zt/100.0,tasu);
    _userStatus[UN] = LIGHTCYAN;
    LogWinWrite(temp);
    setFlag(FLAG_userInfoChanged,1);
}


// * FUNCTION *-------------------------------------------------------
// name ; userMissTypingCase
// in   ;
// out  ;
// des. ; misstyping case.
// * FUNCTION *-------------------------------------------------------
void userMissTypingCase(int UN)
{
	if (userdataLoggedOn[UN].missCheck)
		whisper(userdataLoggedOn[UN].id,"ŸԴϴ~");

    char temp[80];
    _userStatus[UN] = LIGHTBLUE;
    setFlag(FLAG_userInfoChanged,1);
}


