#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "vars.h"
#include "modem.h"
#include "usercmd.h"
#include "user.h"
#include "group.h"
#include "question.h"
#include "etcwin.h"
#include "chat.h"
#include "security.h"
#include "version.h"

// * FUNCTION *-------------------------------------------------------
// name ; userCMDhelp
// in   ;
// out  ;
// des. ; help screen
// * FUNCTION *-------------------------------------------------------
void userCMDhelp(char* id)
{
	whisper(id, "* ! [ID] : [ID] ͸..");
	whisper(id, "* !絵 [ID] # : [ID] # 絵~");
	whisper(id, "* ! :  ?   !Ÿ #");
	whisper(id, "* ! #: #  10!");
	whisper(id, "* !: !   !Ÿ:Ÿ?");
	whisper(id, "* !: ̰峪~?  !:ϴ ");
	whisper(id, "* !Ÿ:Ÿ˸   !:帲~");
    whisper(id, "* !:  ״   !Ÿ");
    whisper(id, "* ! [׷]         !Ż");
    whisper(id, "* ! [] [ȸ]  !׷ [׷]");
    whisper(id, "* (׷ ÿ տ '#'!!)");
}


// * FUNCTION *-------------------------------------------------------
// name ; userCMDshowuserrecord
// in   ;
// out  ;
// des. ; show a user's record
// * FUNCTION *-------------------------------------------------------
void userCMDshowuserrecord(char* id, char* id2)
{
    // adopt ID
    char *zid=id2, n=0;
    while (*zid==' ') zid++;
    while ((unsigned char)zid[n]>32) n++;
    zid[n] = 0;

    Tuser temp;
    loadUserData(zid,&temp);
    if (temp.alive==100)
    {
        whisper(id,"߸ Դϴ");
        return;
    }
    char str[80];
    sprintf(str, "%8s(%-8s) ȸ(%4d) Ÿ(%4d)",
                 temp.name,temp.id,temp.logNum,temp.number);
    whisper(id,str);
    int tasu;
    if (temp.number<=0) tasu = 0; else tasu = temp.total/temp.number;
    sprintf(str, "Ÿ(%4d) ¸ȸ(%4d) (%4d)",
                 tasu,temp.VicNum,temp.score);
    whisper(id,str);
}


// * FUNCTION *-------------------------------------------------------
// name ; userCMDreset
// in   ;
// out  ;
// des. ; reset user's avg.
// * FUNCTION *-------------------------------------------------------
void userCMDreset(char* id, char* id2)
{
    if (getFlag(FLAG_SYSOPCMD)==0)
    {
        whisper(id,"⸸   ֽϴ");
        return;
    }

    // adopt ID
    char *zid=id2, n=0;
    while (*zid==' ') zid++;
    while ((unsigned char)zid[n]>32) n++;
    zid[n] = 0;

    if (strcmp(zid,"")==0)
    {
        for (int i=0;i<12;i++)
            if (getUD(i)->alive>=0)
                saveUserData(getUD(i));
        clearUserData(0);
        for (i=0;i<12;i++)
            if (getUD(i)->alive>=0)
            {
                loadUserData(getUD(i)->id,getUD(i));
                getUD(i)->alive = 1;
            }
        ttyOut("#   ʱȭǾϴ");
        updateRank();
        return;
    }

    if (strcmp(zid,"Ÿ")==0)
    {
        for (int i=0;i<12;i++)
            if (getUD(i)->alive>=0)
                saveUserData(getUD(i));
        clearUserData(1);
        for (i=0;i<12;i++)
            if (getUD(i)->alive>=0)
            {
                loadUserData(getUD(i)->id,getUD(i));
                getUD(i)->alive = 1;
            }
        ttyOut("#  Ÿ ʱȭǾϴ");
        updateRank();
        return;
    }


    Tuser temp;
    loadUserData(zid,&temp);
    if (temp.alive==100)
    {
        whisper(id,"߸ Դϴ");
        return;
    }
    for (int i=0;i<12;i++)
    {
        if (getUD(i)->alive>=0)
        {
            if (strcmp(getUD(i)->id,zid)==0)
            {
                getUD(i)->total = 0;
                getUD(i)->number = 0;
                saveUserData(getUD(i));
                setFlag(FLAG_userInfoChanged,1);
                whisper(zid,"Ÿ  ʱȭǾϴ");
                drawInfoWindow();
                return;
            }
        }
    }
    temp.total = 0;
    temp.number = 0;
    saveUserData(&temp);
}


// * FUNCTION *-------------------------------------------------------
// name ; userCMDtail
// in   ;
// out  ;
// des. ; reset user's avg.
// * FUNCTION *-------------------------------------------------------
void userCMDtail(char* id, char* cmd)
{
    if (getFlag(FLAG_SYSOPCMD)==0)
    {
        whisper(id,"⸸   ֽϴ");
        return;
    }

    // adopt ID
    char *zid=cmd, n=0;
    while (*zid==' ') zid++;
    while ((unsigned char)zid[n]>32) n++;
    zid[n] = 0;

    setTail(zid);
    if (zid[0]==0) LogWinWrite(" Ǿϴ");
       else LogWinWrite(" Ǿϴ");
}


// * FUNCTION *-------------------------------------------------------
// name ; userREQquestion
// in   ;
// out  ;
// des. ; proceed a user-requested-question
// * FUNCTION *-------------------------------------------------------
void userREQquestion(int UN, char* question)
{
    if (getFlag(FLAG_questionFlag2) || (!getFlag(FLAG_questionUserQOK) && getFlag(FLAG_SYSOPCMD)==0))
        return;
    char temp[255];
    if (getFlag(FLAG_SYSOPCMD)==0)
    {
       sprintf ( temp, "%s(%s)   üũ մϴ.",
                       getUD(UN)->name,getUD(UN)->id );
       ttyOut( temp );
    }
    // question : "asdf.asdf.asdf.asdf"
    char _questionAnswer[255];
    strncpy(_questionAnswer, question+1, strlen(question)-2);
    for (int i=0;i<strlen(_questionAnswer);i++)
    {
        if (_questionAnswer[i]=='.') _questionAnswer[i]=' ';
        else
        if (_questionAnswer[i]==32) _questionAnswer[i]=' ';
        else
        if (_questionAnswer[i]==34 || (unsigned char)_questionAnswer[i]<32) _questionAnswer[i]=0;
    }
    sprintf(temp,")%s",question);
    questionRegisterQuestion(_questionAnswer);
    LogWinWrite(temp);
}


// * FUNCTION *-------------------------------------------------------
// name ; userCMDgivescore
// in   ;
// out  ;
// des. ; give id1's score to id2
// * FUNCTION *-------------------------------------------------------
void userCMDgivescore(char* id, char* id2)
{
    // adopt ID
    char *zid=id2, n=0;
    while (*zid==' ') zid++;
    while ((unsigned char)zid[n]>32) n++;
    zid[n] = 0;

    if (strcmp(id,zid)==0)
    {
        whisper(id,"ڽſ 絵 ʿ ϴ~");
        return;
    }

    char *numStr=zid+n+1;
    n=0;
    while (*numStr==' ') numStr++;
    while (numStr[n]>32) n++;
    numStr[n] = 0;

    int num = atoi(numStr);
    if (num<=0)
    {
        whisper(id,"õǾϴ");
        return;
    }

    Tuser temp;
    temp.alive = -1;
    for (int i=0;i<12;i++)
        if (getUD(i)->alive>=0 && strcmp(getUD(i)->id,zid)==0)
        {
            memcpy(&temp,getUD(i),sizeof(Tuser));
            break;
        }
    if (temp.alive<0)
    {
        loadUserData(zid,&temp);
        if (temp.alive==100)
        {
            whisper(id,"߸ Դϴ");
            return;
        }
    }

    Tuser* me;
    me = getUD(userNumber(id));
    if (me->score<num)
    {
        whisper(id," ڶϴ");
        return;
    }
    me->score = me->score - num;
    saveUserData(me);
    temp.score+=num;
    saveUserData(&temp);
    setFlag(FLAG_userInfoChanged,1);
    whisper(id," 絵Ǿϴ.    Ŀ ˴ϴ");
    for (i=0;i<12;i++)
        if (getUD(i)->alive>=0 && strcmp(getUD(i)->id,zid)==0)
        {
            memcpy(getUD(i),&temp,sizeof(Tuser));
            char str[80];
            sprintf(str,"%sκ %d",id,num);
            whisper(zid,str);
            break;
        }
}


// * FUNCTION *-------------------------------------------------------
// name ; userCMDshowscore
// in   ;
// out  ;
// des. ; shows score
// * FUNCTION *-------------------------------------------------------
void userCMDshowscore(char* id)
{
	int UN = userNumber(id);
	char temp[80];
	sprintf(temp," %dԴϴ",getUD(UN)->score);
	whisper(id,temp);
}


// * FUNCTION *-------------------------------------------------------
// name ; userCMDshowrank
// in   ;
// out  ;
// des. ; shows rank-list
// * FUNCTION *-------------------------------------------------------
void userCMDshowrank(const char* fn, char* id,char *cmd)
{
    FILE *fp = fopen(fn,"rb");
    if (fp==NULL)
    {
        whisper(id,"   Ǯ մϴ~");
        return;
    }
    fclose(fp);

    char *numStr=cmd, n=0;
    while (*numStr==' ') numStr++;
    while (numStr[n]>32) n++;
    numStr[n] = 0;

    int num = atoi(numStr);
    if (num<=0) num=1;
    int recn;

    fp = fopen("city.usr","rb");
    if (fp==NULL)
    {
        whisper(id,"system error");
        return;
    }
    fseek(fp,0,SEEK_END);
    long filesize = ftell(fp);
    recn = ftell(fp)/sizeof(Tuser);
    fclose(fp);

    if (num>recn)
    {
        whisper(id," ϴ");
        return;
    }
    fp = fopen(fn,"rb");

    char temp[80], temp1[80], temp2[80];
    int startN, endN;
    startN = num;
    endN = startN + 9;
    if (endN>recn) endN = recn;
    endN = (endN/2)*2;

    sprintf(temp,"%d %d մϴ",startN,endN);
    for (int i=startN;i<endN;i+=2)
    {

        if (80*(i)>=filesize)
        {
            fclose(fp);
            return;
        }
        fseek(fp,80*(i-1),SEEK_SET);
        fread(temp1,80,1,fp);
        fread(temp2,80,1,fp);
        sprintf(temp,"%s %s",temp1,temp2);
        whisper(id,temp);
    }
    fclose(fp);
}


// * FUNCTION *-------------------------------------------------------
// name ; userCMDshowrankbyid
// in   ;
// out  ;
// des. ; shows user's rank
// * FUNCTION *-------------------------------------------------------
void userCMDshowrankbyid(const char* fn, char* id)
{
    FILE *fp = fopen(fn, "rb");
    if (fp==NULL)
    {
        whisper(id,"   Ǯ մϴ~");
        return;
    }
    fclose(fp);

    char *zid = id;

    fp = fopen(fn,"rb");

    fseek(fp,0,SEEK_END);
    int recN=ftell(fp)/80;
    fseek(fp,0,SEEK_SET);

    char temp1[80], temp2[80];

    for (int i=0;i<recN;i+=2)
    {
        fread(temp1,80,1,fp);
        strncpy(temp2,temp1+4,8);
        for (int j=0;j<8;j++)
            if (temp2[j]==' ') temp2[j]=0;
        temp2[8]=0;
        if (strcmp(temp2,zid)==0)
        {
            whisper(id,temp1);
            fclose(fp);
            return;
        }
    }
    whisper(id," Ͽ ϴ");
    fclose(fp);
}


// * FUNCTION *-------------------------------------------------------
// name ; userCMDshowcredit
// in   ;
// out  ;
// des. ; shows credit-msg
// * FUNCTION *-------------------------------------------------------
void userCMDshowcredit(char* id)
{
	whisper(id, "ȳϼ?  ȣ(nakasan)Դϴ");
	whisper(id, " α׷ Դϴ. α׷");
	whisper(id, "ϽŴٸ, ڷǿ ż ٿε ");
	whisper(id, "ð,   ֽñ⸦~");
    whisper(id, getVERSION() );
}


// * FUNCTION *-------------------------------------------------------
// name ; userCMDshowthanx
// in   ;
// out  ;
// des. ; shows thanx to screen.
// * FUNCTION *-------------------------------------------------------
void userCMDshowthanx(char* id)
{
	whisper(id, "thanx to!");
    whisper(id, "nakuny, Image99, oSARANGo, RWS17,");
    whisper(id, "god95, carryout, HANSEI, naselin,");
    whisper(id, "chan100, parman2, ...()");
}


// * FUNCTION *-------------------------------------------------------
// name ; userCMDshowtasu
// in   ;
// out  ;
// des. ; shows tasu.
// * FUNCTION *-------------------------------------------------------
void userCMDshowtasu(char* id)
{
	int UN = userNumber(id);
	char temp[80];
    int tasu;
    if (getUD(UN)->number<=0) tasu = 0;
    else tasu = getUD(UN)->total/getUD(UN)->number;
	sprintf(temp," Ÿ %d(Ÿ/)Դϴ",tasu);
	whisper(id,temp);
}


// * FUNCTION *-------------------------------------------------------
// name ; userCMDshowVcscore
// in   ;
// out  ;
// des. ; shows Victory-Score.
// * FUNCTION *-------------------------------------------------------
void userCMDshowVcscore(char* id)
{
	int UN = userNumber(id);
	char temp[80];
	sprintf(temp,"¸ ȸ %dԴϴ",getUD(UN)->VicNum);
	whisper(id,temp);
}


// * FUNCTION *-------------------------------------------------------
// name ; userCMDtogglemiss
// in   ;
// out  ;
// des. ; toggles a miss-cheque.
// * FUNCTION *-------------------------------------------------------
void userCMDtogglemiss(char* id)
{
	int UN = userNumber(id);
	if (UN<0)
	{
		whisper(id,"system error");
		return;
	}
	int *p;
	p = &(getUD(UN)->missCheck);
	if (*p)
	{
		*p = 0;
		whisper(id,"Ÿ ˸  ϴ");
	}
	else
	{
		*p = 1;
		whisper(id,"Ÿ ˸  ϴ");
	}
}


// * FUNCTION *-------------------------------------------------------
// name ; userCMD
// in   ;
// out  ;
// des. ; proceed user's command
// * FUNCTION *-------------------------------------------------------
void userCMD(int UN, char* cmd)
{
	// main CMD;
	// !XXXXX
	const int cmdN = 24;
	char predefinedCMD[cmdN][11] =
	{
		"","","絵","","",
		"","","Ÿ","","Ÿ",
        "","Ȯ","", "", "",
        "ڵ","Ȯ","Ȯ",
        "","Ż","","׷",
        "Ÿ","Ÿ"
	};

	int result = -1;
	for (int i=0;i<cmdN;i++)
	{
		int error=0;
		for (int j=0;j<strlen(predefinedCMD[i]);j++)
			if (predefinedCMD[i][j]!=cmd[j+1]) error=1;
		if (!error)
		{
			result = i;
			break;
		}
	}

	char* id = getUD(UN)->id;

	if (result<0)
	{
		whisper(id," ! ̶ ġ");
		return;
	}

    switch (result)
	{
	case 0 : userCMDhelp(id); break;
	case 1 : userCMDshowuserrecord(id, cmd+5); break;
	case 2 : userCMDgivescore(id, cmd+5); break;
	case 3 : userCMDshowscore(id); break;
    case 5 :
         if (!getFlag(FLAG_questionSysopAllow))
            whisper(id," ʾҽϴ");
         else
         {
            if (getFlag(FLAG_questionModeON))
                whisper(id,"߿ ٽ ϼ");
            else
                setFlag(FLAG_questionUserReq, 1);
         }
         break;
	case 6 : userCMDshowcredit(id); break;
	case 7 : userCMDshowtasu(id); break;
	case 8 : userCMDshowVcscore(id); break;
	case 9 : userCMDtogglemiss(id); break;
    case 10: userCMDshowthanx(id); break;
    case 11: securityCheck(id); break;
	case 4 : userCMDshowrank("city.rnk",id, cmd+5); break;
    case 12: userCMDshowrankbyid("city.rnk",id); break;
    case 22: userCMDshowrank("city-s.rnk",id, cmd+9); break;
    case 23: userCMDshowrankbyid("city-s.rnk",id); break;
    case 13: userCMDreset(id,cmd+5); break;
    case 14: userCMDtail(id,cmd+7); break;
    case 15: endStep1(id); break;
    case 16: endStep2(id,cmd+9); break;
    case 17: endStep3(id,cmd+9); break;
    case 18: if (getFlag(FLAG_groupAllowed)) userCMDregisterGroup(id, cmd+5);
                else           whisper(id, "׷ 尡 Ǿ  ʽϴ");
             break;
    case 19: if (getFlag(FLAG_groupAllowed)) userCMDunregisterGroup(id);
                else           whisper(id, "׷ 尡 Ǿ  ʽϴ");
             break;
    case 20: if (getFlag(FLAG_groupAllowed)) userCMDregisterFight(id, cmd+5);
                else           whisper(id, "׷ 尡 Ǿ  ʽϴ");
             break;
    case 21: if (getFlag(FLAG_groupAllowed)) userCMDviewGroup(id, cmd+5);
                else           whisper(id, "׷ 尡 Ǿ  ʽϴ");
             break;
	};
}
