#include <stdio.h>
#include <string.h>
#include "Video.h"
#include "wphanout.h"
#include "convert.h"

int _currentTextColor = 0x07;

// * FUNCTION *-------------------------------------------------------
// name ; putsG
// in   ;
// out  ;
// des. ; prints str to VGA-screen
// * FUNCTION *-------------------------------------------------------
void putsG(int x, int y, const char* str)
{
    char _str[256];
    strcpy(_str,str);
    nrCodeConvStr(KS5601,SANGYONG,_str);
    WPPuts((x-1)*8,(y-1)*16, _currentTextColor, _str);
}


// * FUNCTION *-------------------------------------------------------
// name ; putsGoffset
// in   ;
// out  ;
// des. ; ...
// * FUNCTION *-------------------------------------------------------
void putsGoffset(int x, int y, int offx, int offy, const char* str)
{
    char _str[256];
    strcpy(_str,str);
    nrCodeConvStr(KS5601,SANGYONG,_str);
    WPPuts((x-1)*8-offx,(y-1)*16-offy, _currentTextColor, _str);
}


// * FUNCTION *-------------------------------------------------------
// name ; setTextColor
// in   ;
// out  ;
// des. ; set text color (^^)
// * FUNCTION *-------------------------------------------------------
void setTextColor(int c)
{
    _currentTextColor = (_currentTextColor & 0xf0) + c;
}

int getTextAttr(void)
{
    return _currentTextColor;
}

void setTextAttr(int i)
{
    _currentTextColor = i;
}