#ifndef MODEM_H
#define MODEM_H
// Modem function
#define RBR (modem.base )  // receive buffer register
#define THR (modem.base  )  // transmit holding register
#define IER (modem.base+1)  // interrupt enable register
#define IIR (modem.base+2)  // interrupt indentification register
#define LCR (modem.base+3)  // line control register
#define MCR (modem.base+4)  // modem control register
#define LSR (modem.base+5)  // line status register
#define MSR (modem.base+6)  // modem status register

#include "flag.h"

int ttyOn(void);
void ttyOpen(int port, long baudrate);
void ttyClose(void);
void ttyOutLevel0(const char* str);
void ttyOut(const char* str);
void ttyOutRaw(const char* str);
void ttyOutCh(char ch);
int ttyReady(void);
char ttyIn(void);
void ttyTerm(void);
void modemStatus ( int mode );
#endif