#ifndef __WPGRAPH
#define __WPGRAPH

#ifndef __WPCONVXY
#define __WPCONVXY

#define x2px(x)             ((x) << 3)
#define y2py(y)             ((y) << 4)
#define px2x(px)            ((px) >> 3)
#define py2y(py)            ((py) >> 4)

#endif

#define WPOP_PUT            0x00
#define WPOP_AND            0x08
#define WPOP_OR             0x10
#define WPOP_XOR            0x18

#ifndef __WPEXTTYPE
#define __WPEXTTYPE

typedef unsigned char   byte;
typedef unsigned        word;
typedef unsigned long   dword;

#endif

extern byte _WPOutputOp;
extern byte _WPOutputMode;

extern byte _WP16PltNum[];

extern byte __MaskData[];

#define WPSetOp(op)     _WPOutputOp = (op)
#define WPGetOp()       _WPOutputOp
#define WPSetWMode(mode) _WPOutputMode = (mode)
#define WPGetWMode()    _WPOutputMode

int  WPGetPixel(int px, int py); /* WPPIXEL.CPP */
void WPPutPixel(int px, int py, int color);
void WPPutHLine(int px, int py, int w, int color);  /* WPLINE.CPP */
void WPPutVLine(int px, int py, int h, int color);
void WPFillBox(int px, int py, int w, int h, int color); /* WPBOX.CPP */
void WPPutImage(int px, int py, int w, int h, int color, byte *img); /* WPIMAGE.CPP */
void WPGetScr(int px, int py, int w, int h, byte *img); /* WPSCREEN.CPP */
void WPPutScr(int px, int py, int w, int h, byte *img);
void _ScrollUp(int x, int py, int w, int h, int lines); /* WPSCROLL.CPP */
void _ScrollDn(int x, int py, int w, int h, int lines);
void WPScrollUp(int px, int py, int w, int h, int lines);
void WPScrollDn(int px, int py, int w, int h, int lines);
void WPSetPalette(int index, char rval, char gval, char bval); /* WPPLT.CPP */
void WPGetPalette(int index, char *rval, char *gval, char *bval);
void WPSetPaletteBlock(int start, int num, char *plt);
void WPGetPaletteBlock(int start, int num, char *plt);
void WPWaitVert(void);
void WPFadeOut(int time); /* WPFADE.CPP */
void WPFadeIn(int time);

#endif
