#ifndef __WPHANOUT
#define __WPHANOUT

#ifndef __WPCONVXY
#define __WPCONVXY

#define x2px(x)             ((x) << 3)
#define y2py(y)             ((y) << 4)
#define px2x(px)            ((px) >> 3)
#define py2y(py)            ((py) >> 4)

#endif

#define WPMODE_OVERLAP      0
#define WPMODE_OVERWRITE    1

#define WPATTR_NORMAL       0x0000
#define WPATTR_BOLD         0x0001
#define WPATTR_OUTLINE      0x0002
#define WPATTR_SHADOW       0x0004
#define WPATTR_VLARGE       0x0008
#define WPATTR_HLARGE       0x0010
#define WPATTR_FAINT        0x0020
#define WPATTR_SHADE        0x0040
#define WPATTR_UNDERLINE    0x0080
#define WPATTR_REVERSE      0x0100

#define WPCHKIND_ASC        1
#define WPCHKIND_HAN1       2
#define WPCHKIND_HAN2       3

#ifndef __WPEXTTYPE
#define __WPEXTTYPE

typedef unsigned char   byte;
typedef unsigned        word;
typedef unsigned long   dword;

#endif

extern byte _WPOutputMode;
extern word _WPAttrType;

extern char FSizepx;
extern char FSizex;
extern char FSizepy;
extern char FStartLine;
extern char F2StartLine;

extern void (*_SpPutch)(int px, int py, int color, word code);
extern void (*_HjPutch)(int px, int py, int color, word code);

#ifndef __SETDEFAULT
int  WPTinyHanInit(char *efile, char *hfile, int kbyte = 60); /* WPINIT.CPP */
#endif
void WPTinyHanClose(void);
void WPMemCopy(byte *dest, byte *src, int n2); /* WPMCPY.CPP */
void WPMemAnd(byte *dest, byte *src, int n2);
void WPMemOr(byte *dest, byte *src, int n2);
void WPMemXor(byte *dest, byte *src, int n2);
void WPMemNot(byte *dest, byte *src, int n2);
void WPMemSet(byte *dest, byte value, int n2);
void WPMemShl(byte *dest, byte *src, char x, char y);
void WPMemShr(byte *dest, byte *src, char x, char y);
void WPMemShup(byte *dest, byte *src, char x, char y);
void WPMemShdn(byte *dest, byte *src, char x, char y);
int  WPIsHan(word code); /* WPCHKCH.CPP */
int  WPIsSp(word code);
int  WPIsHj(word code);
int  WPCheckCharKind(byte *str, int index); /* WPCHKSTR.CPP */
void WPGetEngImg(byte code); /* WPGHFNT.CPP */
void WPGetHanImg(word code);
void WPMakeHalfSizeImg(char direct);
void WPGetSpImg(word code); /* WPGSPFNT.CPP */
void WPGetHjImg(word code); /* WPGHJFNT.CPP */
int  WPLoadEngFont(char *filename); /* WPGHFNT.CPP */
int  WPLoadHanFont(char *filename);
int  WPLoadSpFont(char *filename); /* WPGSPFNT.CPP */
int  WPLoadHjFont(char *filename); /* WPGHJFNT.CPP */
void WPModifyImg(void); /* WPATTR.CPP */
void WPModify2xImg(void);
void WPSetAttr(word attr);
void WPSetLargeSize(char hsize, char vsize);
void WPSetStartLine(char lines);
void WPEngPutch(int px, int py, int color, byte code); /* WPHPUTCH.CPP */
void WPHanPutch(int px, int py, int color, word code);
void WPEngPuts(int px, int py, int color, byte *str); /* WPHPUTS.CPP */
void WPHanPuts(int px, int py, int color, byte *str);
void WPEngPrintf(int px, int py, int color, char *fmt, ...); /* WPHPUTF.CPP */
void WPHanPrintf(int px, int py, int color, char *fmt, ...);
void WPPuts(int px, int py, int color, byte *str); /* WPPUTS.CPP */
int  WPPutsn(int px, int py, int color, int s, int n, byte *str); /* WPPUTSN.CPP */
void WPPrintf(int px, int py, int color, char *fmt, ...); /* WPPUTF.CPP */
void WPSpPutch(int px, int py, int color, word code); /* WPGSPFNT.CPP */
void WPHjPutch(int px, int py, int color, word code); /* WPGHJFNT.CPP */

/* WPGUI.CPP */

void WPPutSolidHLine(int px, int py, int wid, int color1, int color2);
void WPPutSolidVLine(int px, int py, int hgt, int color1, int color2);
void WPPutSolidBorder(int px, int py, int wid, int hgt, int color1, int color2);
void WPPutSolidBox(int px, int py, int wid, int hgt, int color, int border1, int border2);

#endif
