/*
    Tiny Hangul Library ver 1.98                Last update : 96-10-05
    Functions about attribute of letter
    (c) Kim Youngsik (WOODPARK)
*/

#include "WPHANOUT.H"

extern byte *FontBuff;

int  AttrType = WPATTR_NORMAL;
char FSizepx = 8;
char FSizepy = 16;
char FSizex  = 1;
char FStartLine;
char F2StartLine;
int  FSizeHLarge = 1;
int  FSizeVLarge = 1;

char BakStartLine;

void WPAttrBold(byte *img, char xByte, char yBit)
{
    byte temp[32];

    WPMemShr(temp, img, xByte, yBit);
    WPMemOr(img, temp, (xByte * yBit >> 1));
}

void WPAttrOutline(byte *img, char xByte, char yBit)
{
    byte temp1[32], temp2[32], temp3[32];
    word bytes = xByte * yBit >> 1;

    WPMemShr(temp1, img, xByte, yBit);
    WPMemShl(temp2, img, xByte, yBit);
    WPMemOr(temp1, temp2, bytes);
    WPMemShup(temp2, img, xByte, yBit);
    WPMemShdn(temp3, img, xByte, yBit);
    WPMemOr(temp2, temp3, bytes);
    WPMemOr(temp1, temp2, bytes);
    WPMemXor(img, temp1, bytes);
}

void WPAttrShadow(byte *img, char xByte, char yBit)
{
    byte temp1[32], temp2[32];
    word bytes = xByte * yBit >> 1;

    WPMemShr(temp1, img, xByte, yBit);
    WPMemShdn(temp2, img, xByte, yBit);
    WPMemOr(temp2, temp1, bytes);
    WPMemXor(img, temp2, bytes);
}

void WPAttrFaint(byte *img, char xByte, char yBit)
{
    asm     les     di, img
    asm     xor     dh, dh
    asm     mov     dl, yBit
    asm     xor     bh, bh
    asm     mov     bl, xByte
    asm     mov     al, 0x55

    Looping1:

    asm     not     al
    asm     mov     cx, bx

    Looping2:

    asm     and     es:[di], al
    asm     inc     di
    asm     loop    Looping2
    asm     mov     cx, dx
    asm     dec     dx
    asm     loop    Looping1
}

void WPAttrShade(byte *img, char xByte, char yBit)
{
    asm     les     di, img
    asm     xor     dh, dh
    asm     mov     dl, yBit
    asm     xor     bh, bh
    asm     mov     bl, xByte
    asm     mov     al, 0x55

    Looping1:

    asm     not     al
    asm     mov     cx, bx

    Looping2:

    asm     or      es:[di], al
    asm     inc     di
    asm     loop    Looping2
    asm     mov     cx, dx
    asm     dec     dx
    asm     loop    Looping1
}

void WPAttrUnderline(byte *img, char xByte, char yBit)
{
    asm     les     di, img
    asm     xor     ch, ch
    asm     mov     al, yBit
    asm     mov     cl, xByte
    asm     mul     cl
    asm     add     di, ax
    asm     sub     di, cx
    asm     mov     cl, xByte
    asm     mov     al, 0xff
    asm     rep     stosb
}

void WPAttrReverse(byte *img, char xByte, char yBit)
{
    asm     les     di, img
    asm     xor     dh, dh
    asm     mov     dl, yBit
    asm     xor     bh, bh
    asm     mov     bl, xByte

    Looping1:

    asm     mov     cx, bx

    Looping2:

    asm     mov     al, es:[di]
    asm     not     al
    asm     mov     es:[di], al
    asm     inc     di
    asm     loop    Looping2
    asm     mov     cx, dx
    asm     dec     dx
    asm     loop    Looping1
}

void WPAttrHLarge(byte *img, char x, char y)
{
    word bytes = x * y, i, j, k, tmp1, tmp2 = 0;
    byte temp[32];
    word mask[8] = { 0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01 };

    WPMemCopy(temp, img, bytes >> 1);

    for (i = 0; i < bytes; i++) {
        for (j = 0; j < 8; j++) {
            tmp1 = temp[i] & mask[j];
            for (k = 0; k < FSizeHLarge; k++) {
                if (tmp1) img[tmp2 >> 3] |= mask[tmp2 & 7];
                else      img[tmp2 >> 3] &= ~mask[tmp2 & 7];
                tmp2++;
            }
        }
   }
}

void WPAttrVLarge(byte *img, char x, char y)
{
    word bytes = x * y, i, j, k;
    byte temp[800], *tmp;

    tmp = temp;

    WPMemCopy(tmp, img, bytes >> 1);

    for (i = 0; i < y; i++) {
        for (j = 0; j < FSizeVLarge; j++) {
            for (k = 0; k < x; k++) {
                *img++ = tmp[k];
            }
        }
        tmp += x;
    }
}

void WPModifyImg(void)
{
    if (AttrType == WPATTR_NORMAL)  return;
    if (AttrType & WPATTR_BOLD)     WPAttrBold(FontBuff, 1, 16);
    if (AttrType & WPATTR_OUTLINE)  WPAttrOutline(FontBuff, 1, 16);
    if (AttrType & WPATTR_SHADOW)   WPAttrShadow(FontBuff, 1, 16);
    if (AttrType & WPATTR_HLARGE)   WPAttrHLarge(FontBuff, 1, 16);
    if (AttrType & WPATTR_VLARGE)   WPAttrVLarge(FontBuff, FSizex, 16);
    if (AttrType & WPATTR_FAINT)    WPAttrFaint(FontBuff, FSizex, FSizepy);
    if (AttrType & WPATTR_SHADE)    WPAttrShade(FontBuff, FSizex, FSizepy);
    if (AttrType & WPATTR_UNDERLINE)WPAttrUnderline(FontBuff, FSizex, FSizepy);
    if (AttrType & WPATTR_REVERSE)  WPAttrReverse(FontBuff, FSizex, FSizepy);
}

void WPModify2xImg(void)
{
    if (AttrType == WPATTR_NORMAL)  return;
    if (AttrType & WPATTR_BOLD)     WPAttrBold(FontBuff, 2, 16);
    if (AttrType & WPATTR_OUTLINE)  WPAttrOutline(FontBuff, 2, 16);
    if (AttrType & WPATTR_SHADOW)   WPAttrShadow(FontBuff, 2, 16);
    if (AttrType & WPATTR_HLARGE)   WPAttrHLarge(FontBuff, 2, 16);
    if (AttrType & WPATTR_VLARGE)   WPAttrVLarge(FontBuff, FSizex << 1, 16);
    if (AttrType & WPATTR_FAINT)    WPAttrFaint(FontBuff, FSizex << 1, FSizepy);
    if (AttrType & WPATTR_SHADE)    WPAttrShade(FontBuff, FSizex << 1, FSizepy);
    if (AttrType & WPATTR_UNDERLINE)WPAttrUnderline(FontBuff, FSizex << 1, FSizepy);
    if (AttrType & WPATTR_REVERSE)  WPAttrReverse(FontBuff, FSizex << 1, FSizepy);
}

void WPSetAttr(word attr)
{
    int     lines;

    AttrType = attr;
    FSizepx = 8;
    FSizepy = 16;
    FSizex  = 1;

    if (attr & WPATTR_HLARGE) {
        FSizepx = FSizeHLarge << 3;
        FSizex  = FSizeHLarge;
    }
    if (attr & WPATTR_VLARGE) FSizepy = FSizeVLarge << 4;

    if (BakStartLine >= FSizepy) lines = 0;
    else                         lines = BakStartLine;

    FStartLine = FSizex * lines;
    F2StartLine = FStartLine << 1;
    FSizepy -= lines;
}

void WPSetLargeSize(char hsize, char vsize)
{
    FSizeHLarge = (FSizeHLarge <= 5) ? hsize : 5;
    FSizeVLarge = (FSizeVLarge <= 5) ? vsize : 5;
}

void WPSetStartLine(char lines)
{
    BakStartLine = lines;
    WPSetAttr(AttrType);
}

