/*
    Tiny Hangul Library ver 1.98                 Last update : 96-10-05
    Hangul Automata II Function
    Edited by Kim Youngsik (WOODPARK)
*/

#include "WPKEYDEF.H"

enum {
    WPStateStart,
    WPStateChoSung,
    WPStateJungSung, WPStateDJungSung,
    WPStateJongSung, WPStateDJongSung,
    WPStateEnd1,     WPStateEnd2
};

enum { CONSONANT, VOWEL };

#ifndef __WPAUTOMATA
#define __WPAUTOMATA

typedef struct {
    char CurState;
    int  KeyCode;
    int  CombiCode;
} INPSTACK;

#endif

extern INPSTACK InpStack[];
extern int      InpSP;
extern int      OutStack[];
extern int      OutSP;
extern int      CurState;

static int CombiCode;
static int OldKeyCode;
static int KeyCode;

static int WPJungSungPair(void)
{
    static int DJungSungTable[7][3] = {
        { 0xAD, 0xA3, 0xAE },               /* , a,  */
        { 0xAD, 0xA4, 0xAF },               /* , ,  */
        { 0xAD, 0xBd, 0xB2 },               /* , , A */
        { 0xB4, 0xA7, 0xB5 },               /* , ,  */
        { 0xB4, 0xAA, 0xB6 },               /* , A,  */
        { 0xB4, 0xBD, 0xB7 },               /* , ,  */
        { 0xBB, 0xBD, 0xBC }                /* a, ,  */
    };

    for (int i = 0; i < 7; i++) {
        if (DJungSungTable[i][0] == OldKeyCode && DJungSungTable[i][1] == KeyCode)
            return(KeyCode = DJungSungTable[i][2]);
    }
    return(0);
}

static int WPJongSungPair(void)
{
    static int DJongSungTable[11][3] = {
        { 0x82, 0x8B, 0xC4 },               /* b,  */
        { 0x84, 0x8E, 0xC6 },               /* e, x */
        { 0x84, 0x94, 0xC7 },               /* e, ӡ} */
        { 0x87, 0x82, 0xCA },               /* i, b */
        { 0x87, 0x88, 0xCB },               /* i, q */
        { 0x87, 0x89, 0xCC },               /* i, s */
        { 0x87, 0x8B, 0xCD },               /* i,  */
        { 0x87, 0x92, 0xCE },               /* i, ˡ{ */
        { 0x87, 0x93, 0xCF },               /* i, ϡ| */
        { 0x87, 0x94, 0xD0 },               /* i, ӡ} */
        { 0x89, 0x8B, 0xD4 }                /* s,  */
    };

    for (int i = 0; i < 11; i++) {
        if (DJongSungTable[i][0] == OldKeyCode && DJongSungTable[i][1] == KeyCode)
            return(KeyCode = DJongSungTable[i][2]);
    }
    return(0);
}

int WPHanAutomata2(int key)
{
    int     Kind, CanBeJongSung = 0;
    static int ChoSungToJongSung[] = {
        0xC2,   //  b
        0xC3,   //  wb
        0xC5,   //  e
        0xC8,   //  h
        0x00,   //  wh (Ёw q)  */
        0xC9,   //  i
        0xD1,   //  q
        0xD3,   //  s
        0x00,   //  ws (Ёw q)  */
        0xD5,   //  
        0xD6,   //  w
        0xD7,   //  w
        0xD8,   //  x
        0x00,   //  wx (Ёw q)
        0xD9,   //  áy
        0xDA,   //  ǡz
        0xDB,   //  ˡ{
        0xDC,   //  ϡ|
        0xDD    //  ӡ}
    };

    if ((key & 0x60) == 0x20) Kind = VOWEL;
    else {
        Kind = CONSONANT;
       if (key != 0x86 && key != 0x8A && key != 0x8F) CanBeJongSung = 1;
    }

    if (CurState) {
        CombiCode = InpStack[InpSP - 1].CombiCode;
        OldKeyCode = InpStack[InpSP - 1].KeyCode;
    } else {
        CombiCode = 0x8441;
        OldKeyCode = 0;
    }

    KeyCode = key;

    switch (CurState) {
        case WPStateStart :
            if (Kind == CONSONANT) CurState = WPStateChoSung;
            else                   CurState = WPStateJungSung;
            break;
        case WPStateChoSung :
            if (Kind == VOWEL) CurState = WPStateJungSung;
            else               CurState = WPStateEnd1;
            break;
        case WPStateJungSung :
            if (CanBeJongSung)         CurState = WPStateJongSung;
            else if (WPJungSungPair()) CurState = WPStateDJungSung;
            else                       CurState = WPStateEnd1;
            break;
        case WPStateDJungSung :
            if (CanBeJongSung) CurState = WPStateJongSung;
            else               CurState = WPStateEnd1;
            break;
        case WPStateJongSung :
            if (Kind == CONSONANT && WPJongSungPair()) CurState = WPStateDJongSung;
            else if (Kind == VOWEL)                    CurState = WPStateEnd2;
            else                                       CurState = WPStateEnd1;
            break;
        case WPStateDJongSung :
            if (Kind == VOWEL) CurState = WPStateEnd2;
            else               CurState = WPStateEnd1;
            break;
    }

    switch (CurState) {
        case WPStateChoSung :
            CombiCode = (CombiCode & 0x83FF) | ((KeyCode - 0x80) << 10);
            break;
        case WPStateJungSung :
        case WPStateDJungSung :
            CombiCode = (CombiCode & 0xFC1F) | ((KeyCode - 0xA0) << 5);
            break;
        case WPStateJongSung :
            KeyCode = ChoSungToJongSung[KeyCode - 0x82];
        case WPStateDJongSung :
            CombiCode = (CombiCode & 0xFFE0) | (KeyCode - 0xC0);
            break;
        case WPStateEnd1 :
            OutStack[OutSP++] = key;
            return(1);
        case WPStateEnd2 :
            OutStack[OutSP++] = key;
            OutStack[OutSP++] = OldKeyCode;
            InpSP--;
            return(1);
    }

    InpStack[InpSP].CurState  = CurState;
    InpStack[InpSP].CombiCode = CombiCode;
    InpStack[InpSP++].KeyCode = key;

    return(0);
}
