/*
    Tiny Hangul Library ver 1.98                Last update : 96-10-05
    Hangul Automata III Type Function
    Edited by Kim Youngsik (WOODPARK)
*/

#include "WPKEYDEF.H"

enum {
    WPStateStart,
    WPStateChoSung,  WPStateDChoSung,
    WPStateJungSung, WPStateDJungSung,
    WPStateJongSung, WPStateDJongSung,
    WPStateEnd
};

enum {
    WPKindChoSung = 0x00,
    WPKindJungSung = 0x20,
    WPKindJongSung = 0x40
};

#ifndef __WPAUTOMATA
#define __WPAUTOMATA

typedef struct {
    char CurState;
    int  KeyCode;
    int  CombiCode;
} INPSTACK;

#endif

extern INPSTACK InpStack[];
extern int      InpSP;
extern int      OutStack[];
extern int      OutSP;
extern int      CurState;

static int CombiCode;
static int OldKeyCode;
static int KeyCode;

static int WPChoSungPair(void)
{
    static int DChoSungTable[][3] = {
        { 0x82, 0x82, 0x83 },           /* b, b, wb */
        { 0x85, 0x85, 0x86 },           /* h, h, wh */
        { 0x89, 0x89, 0x8A },           /* s, s, ws */
        { 0x8B, 0x8B, 0x8C },           /* , , w */
        { 0x8E, 0x8E, 0x8F }            /* x, x, wx */
    };

    for (int i = 0; i < 5; i++) {
        if (DChoSungTable[i][0] == OldKeyCode && DChoSungTable[i][1] == KeyCode)
            return (KeyCode = DChoSungTable[i][2]);
    }
    return(0);
}

static int WPJungSungPair(void)
{
    static int DJungSungTable[][3] = {
        { 0xAD, 0xA3, 0xAE },           /* , a,  */
        { 0xAD, 0xA4, 0xAF },           /* , ,  */
        { 0xAD, 0xBD, 0xB2 },           /* , , A */
        { 0xB4, 0xA7, 0xB5 },           /* , ,  */
        { 0xB4, 0xAA, 0xB6 },           /* , A,  */
        { 0xB4, 0xBD, 0xB7 },           /* , ,  */
        { 0xBB, 0xBD, 0xBC }            /* a, ,  */
    };

    for (int i = 0; i < 7; i++) {
        if (DJungSungTable[i][0] == OldKeyCode && DJungSungTable[i][1] == KeyCode)
            return (KeyCode = DJungSungTable[i][2]);
    }
    return(0);
}

static int WPJongSungPair(void)
{
    static int DJongSungTable[][3] = {
        { 0xC2, 0xC2, 0xC3 },           /* b, b */
        { 0xC2, 0xD5, 0xC4 },           /* b,  */
        { 0xC5, 0xD8, 0xC6 },           /* e, x */
        { 0xC5, 0xDD, 0xC7 },           /* e, ӡ} */
        { 0xC9, 0xC2, 0xCA },           /* i, b */
        { 0xC9, 0xD1, 0xCB },           /* i, q */
        { 0xC9, 0xD3, 0xCC },           /* i, s */
        { 0xC9, 0xD5, 0xCD },           /* i,  */
        { 0xC9, 0xDB, 0xCE },           /* i, ˡ{ */
        { 0xC9, 0xDC, 0xCF },           /* i, ϡ| */
        { 0xC9, 0xDD, 0xD0 },           /* i, ӡ} */
        { 0xD3, 0xD5, 0xD4 },           /* s,  */
        { 0xD5, 0xD5, 0xD6 }            /* ,  */
    };

    for (int i = 0; i < 13; i++) {
        if (DJongSungTable[i][0] == OldKeyCode && DJongSungTable[i][1] == KeyCode)
            return (KeyCode = DJongSungTable[i][2]);
    }
    return(0);
}

int WPHanAutomata3(int key)
{
    int     Kind = key & 0x60;

    if (CurState) {
        CombiCode = InpStack[InpSP - 1].CombiCode;
        OldKeyCode = InpStack[InpSP - 1].KeyCode;
    } else {
        CombiCode = 0x8441;
        OldKeyCode = 0;
    }

    KeyCode = key;

    switch(CurState) {
        case WPStateStart :
            switch(Kind) {
                case WPKindChoSung  : CurState = WPStateChoSung;
                                      break;
                case WPKindJungSung : CurState = WPStateJungSung;
                                      break;
                case WPKindJongSung : CurState = WPStateJongSung;
                                      break;
            }
            break;
        case WPStateChoSung :
            switch(Kind) {
                case WPKindChoSung  : if (WPChoSungPair()) CurState = WPStateDChoSung;
                                      else                 CurState = WPStateEnd;
                                      break;
                case WPKindJungSung : CurState = WPStateJungSung;
                                      break;
                case WPKindJongSung : CurState = WPStateJongSung;
                                      break;
            }
            break;
        case WPStateDChoSung :
            switch(Kind) {
                case WPKindChoSung  : CurState = WPStateEnd;
                                      break;
                case WPKindJungSung : CurState = WPStateJungSung;
                                      break;
                case WPKindJongSung : CurState = WPStateJongSung;
                                      break;
            }
            break;
        case WPStateJungSung :
            switch(Kind) {
                case WPKindChoSung  : CurState = WPStateEnd;
                                      break;
                case WPKindJungSung : if (WPJungSungPair()) CurState = WPStateDJungSung;
                                      else                  CurState = WPStateEnd;
                                      break;
                case WPKindJongSung : CurState = WPStateJongSung;
                                      break;
            }
            break;
        case WPStateDJungSung :
            switch(Kind) {
                case WPKindChoSung  :
                case WPKindJungSung : CurState = WPStateEnd;
                                      break;
                case WPKindJongSung : CurState = WPStateJongSung;
                                      break;
            }
            break;
        case WPStateJongSung :
            switch(Kind) {
                case WPKindChoSung  :
                case WPKindJungSung : CurState = WPStateEnd;
                                      break;
                case WPKindJongSung : if (WPJongSungPair()) CurState = WPStateDJongSung;
                                      else                  CurState = WPStateEnd;
                                      break;
            }
        case WPStateDJongSung : CurState = WPStateEnd;
                                break;
    }

    switch(CurState) {
        case WPStateChoSung   :
        case WPStateDChoSung  : CombiCode = (CombiCode & 0x83FF) | ((KeyCode - 0x80) << 10);
                                break;
        case WPStateJungSung  :
        case WPStateDJungSung : CombiCode = (CombiCode & 0xFC1F) | ((KeyCode - 0xA0) << 5);
                                break;
        case WPStateJongSung  :
        case WPStateDJongSung : CombiCode = (CombiCode & 0xFFE0) | (KeyCode - 0xC0);
                                break;
        case WPStateEnd       : OutStack[OutSP++] = key;
                                return(1);
    }

    InpStack[InpSP].CurState = CurState;
    InpStack[InpSP].CombiCode = CombiCode;
    InpStack[InpSP++].KeyCode = key;

    return(0);
}
