/*
    Tiny Hangul Library ver 1.98                Last update : 96-10-05
    Check Character Kind
    (c) Kim Youngsik (WOODPARK)
*/

char TGHanTable1[32] = {
    -1,  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14,
    15, 16, 17, 18, 19, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1
};

char TGHanTable2[32] = {
    -1, -1,  0,  1,  2,  3,  4,  5, -1, -1,  6,  7,  8,  9, 10, 11,
    -1, -1, 12, 13, 14, 15, 16, 17, -1, -1, 18, 19, 20, 21, -1, -1
};

char TGHanTable3[32] = {
    -1,  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14,
    15, 16, -1, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, -1, -1
};

int  WPIsHan(unsigned code)
{
    int first, middle, last;

    first  = (code >> 10) & 0x1F;
    middle = (code >> 5)  & 0x1F;
    last   = code         & 0x1F;

    if (code & 0x8000)
        if (TGHanTable1[first] != -1 && TGHanTable2[middle] != -1 && TGHanTable3[last] != -1) return(1);

    return(0);
}

int  WPIsSp(unsigned code)
{
    asm     mov     ax, code

    if (_AH >= 0xD9 && _AH <= 0xDE && _AL >= 0x31 && _AL <= 0xFE) return(1);
    if (_AH == 0xD4 && _AL >= 0x81 && _AL <= 0xFE) return(1);

    return(0);
}

int  WPIsHj(unsigned code)
{
    asm     mov     ax, code

    if (_AH >= 0xE0 && _AH <= 0xF9 && _AL >= 0x31&& _AL <= 0xFE) return(1);

    return(0);
}
