/*
    Tiny Hangul Library ver 1.98                 Last update : 96-10-04
    Fade Out/In For VGA Graphic card
    (c) Kim Youngsik (WOODPARK)
*/

#include <dos.h>

#include "WPGRAPH.H"

char TmpPltBuff[768];

void WPFadeOut(int time)
{
    char    Temp[768];
    int     i, j;

    WPGetPaletteBlock(0, 256, TmpPltBuff);

    for (i = 0; i < 32; i++) {
        for (j = 0; j < 768; j++) Temp[j] = (TmpPltBuff[j] * (31 - i)) >> 5;
        WPWaitVert();
        WPSetPaletteBlock(0, 256, Temp);
        for (time = time / 5; time > 0; time--) {   /* Delay */
            while(inp(0x61) & 0x10);
            while(!(inp(0x61) & 0x10));
        }
    }
}

void WPFadeIn(int time)
{
    char    Temp[768];
    int     j;

    WPGetPaletteBlock(0, 256, Temp);

    for (int i = 0; i < 32; i++) {
        for (j = 0; j < 768; j++) Temp[j] = (TmpPltBuff[j] * (i + 1)) >> 5;
        WPWaitVert();
        WPSetPaletteBlock(0, 256, Temp);
        for (time = time / 5; time > 0; time--) {   /* Delay */
            while(inp(0x61) & 0x10);
            while(!(inp(0x61) & 0x10));
        }
    }
}

