/*
    Tiny Hangul Library ver 1.98                Last update : 96-10-05
    Get Hangul/English Font Image
    (c) Kim Youngsik (WOODPARK)
*/

#include <io.h>

#include "WPHANOUT.H"

byte (*EFont)[16];
byte (*H1Font)[20][32];
byte (*H2Font)[22][32];
byte (*H3Font)[28][32];
byte (*SPFont)[32];

byte *FontBuff;

byte HanTable1[] = {
    0,  0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14,
    15, 16, 17, 18, 19, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
};

byte HanTable2[] = {
    0,  0,  0,  1,  2,  3,  4,  5,  0,  0,  6,  7,  8,  9,  10, 11,
    0,  0,  12, 13, 14, 15, 16, 17, 0,  0,  18, 19, 20, 21, 0,  0
};

byte HanTable3[] = {
    0,  0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14,
    15, 16, 0,  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 0,  0
};

byte Type1Table1[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 3, 3, 3, 1, 2, 4, 4, 4, 2, 1, 3, 0
};

byte Type1Table2[] = {
    5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 7, 7, 7, 6, 6, 7, 7, 7, 6, 6, 7, 5
};

byte Type3Table[] = {
    0, 0, 2, 0, 2, 1, 2, 1, 2, 3, 0, 2, 1, 3, 3, 1, 2, 1, 3, 3, 1, 1
};

void (*_HjPutch)(int px, int py, int color, word code);
void (*_SpPutch)(int px, int py, int color, word code);

void WPGetEngImg(byte code)
{
    WPMemCopy(FontBuff, EFont[code], 8);
}

void WPGetHanImg(word code)
{
    int  first, middle, last;
    word type1, type2 = 0, type3;

    first  = (code >> 10) & 0x1F;
    middle = (code >> 5)  & 0x1F;
    last   = code         & 0x1F;

    first  = HanTable1[first];
    middle = HanTable2[middle];
    last   = HanTable3[last];

    asm     cmp     last, 0
    asm     jz      next1

    type1 = Type1Table2[middle];

    asm     jmp     next2

    next1:

    type1 = Type1Table1[middle];

    next2:

    asm     cmp     first, 1
    asm     je      next3
    asm     cmp     first, 16
    asm     je      next3
    asm     mov     type2, 1

    next3:

    asm     cmp     last, 0
    asm     jz      next4
    asm     add     type2, 2

    next4:

    type3 = Type3Table[middle];

    if (first)  WPMemCopy(FontBuff, H1Font[type1][first], 16);
    else        WPMemSet(FontBuff, 0, 16);
    if (middle) WPMemOr(FontBuff, H2Font[type2][middle], 16);
    if (last)   WPMemOr(FontBuff, H3Font[type3][last], 16);
}

/*
    direct : 0 - Right byte
             1 - Left byte
*/
void WPMakeHalfSizeImg(char direct)
{
    for (int i = 0; i < 16; i++) FontBuff[i] = FontBuff[(i << 1) + direct];
}

int  WPLoadEngFont(char *filename)
{
    int fd;

    if ((fd = _open(filename, 0)) == -1) return(-1);

    _read(fd, EFont, 4096);
    _close(fd);

    return(0);
}

int  WPLoadHanFont(char *filename)
{
    int fd;

    if ((fd = _open(filename, 0)) == -1) return(-1);

    _read(fd, H1Font, 5120);
    _read(fd, H2Font, 2816);
    _read(fd, H3Font, 3584);
    _close(fd);

    return(0);
}

