/*
    Tiny Hangul Library ver 1.98                Last update : 96-10-05
    Get Hanja font
    (c) Kim Youngsik (WOODPARK)
*/

#include <string.h>
#include <io.h>

#include "WPGRAPH.H"
#include "WPHANOUT.H"
#include "WPHJCODE.H"

char IsLoadHjFont;
char HjFilePath[0x80];

extern byte *FontBuff;

word WPHjToHan(word pos)
{
    for (int i = 0; i < 473; i++) if (pos < HjTable[i + 1][2]) break;
    return HjTable[i][0];
}

void WPGetHjImg(word code)
{
    long pos;
    int  temp, fd;

    asm     mov     cx, code

    pos = (_CH - 0xE0) * 188;

    asm     cmp     cl, 0x7F
    asm     jb      next1
    asm     sub     cl, 0x12

    next1:

    asm     sub     cl, 0x31

    pos += _CL;

    if (IsLoadHjFont) {
        fd = _open(HjFilePath, 0);
        lseek(fd, pos << 5, 0);
        _read(fd, FontBuff, 32);
        _close(fd);
    } else {
        temp = WPHjToHan(pos);
        WPGetHanImg(temp);
    }
}

int WPLoadHjFont(char *filename)
{
    int fd;

    _HjPutch = WPHjPutch;

    if ((fd = _open(filename, 0)) == -1) {
        IsLoadHjFont = 0;
        return(-1);
    }

    _close(fd);
    IsLoadHjFont = 1;
    strcpy(HjFilePath, filename);

    return(0);
}

void WPHjPutch(int px, int py, int color, word code)
{
    WPGetHjImg(code);
    WPModify2xImg();
    WPPutImage(px, py, FSizepx << 1, FSizepy, color, FontBuff + F2StartLine);
}
