/*
    Tiny Hangul Library ver 1.98                Last update : 96-10-06
    Get special letter font
    (c) Kim Youngsik (WOODPARK)
*/

#include <io.h>
#include <alloc.h>

#include "WPGRAPH.H"
#include "WPHANOUT.H"
#include "WPKEYDEF.H"

extern byte (*SPFont)[32];
extern byte *FontBuff;

void WPGetSpImg(word code)
{
    asm     xor     cx, cx
    asm     mov     dx, code
    asm     cmp     dh, 0xd4
    asm     jne     NextPart
    asm     sub     dl, 0x81        // code1 - 0xD4, code2 - 0x81 ~ 0xFE
    asm     mov     cl, dl
    asm     jmp     Quit

    NextPart:

    asm     mov     ax, dx
    asm     mov     al, ah
    asm     xor     ah, ah
    asm     sub     al, 0xd9
    asm     mov     bl, 188
    asm     mul     bl
    asm     mov     cx, ax
    asm     add     cx, 127
    asm     xor     dh, dh
    asm     add     cx, dx
    asm     sub     cx, 0x31
    asm     cmp     dl, 0x7F
    asm     jb      Quit
    asm     sub     cx, 0x12

    Quit:

    WPMemCopy(FontBuff, SPFont[_CX], 16);
}

int  WPLoadSpFont(char *filename)
{
    int fd;

    if (SPFont == NUL) (char *)SPFont = (char *)malloc(39744);

    if ((fd = _open(filename, 0)) == -1) return(-1);

    _read(fd, SPFont, 39744);
    _close(fd);

    _SpPutch = WPSpPutch;

    return(0);
}

void WPSpPutch(int px, int py, int color, word code)
{
    WPGetSpImg(code);
    WPModify2xImg();
    WPPutImage(px, py, FSizepx << 1, FSizepy, color, FontBuff + F2StartLine);
}

