/*
    Tiny Hangul Library ver 1.98                Last update : 96-10-04
    Draw Bitmap Font Image on 640x480x16 Screen
    (c) Kim Youngsik (WOODPARK)
*/

#include "WPGRAPH.H"

void WPPutImage(int px, int py, int w, int h, int color, byte *img)
{
    int     nbyte;

    if (_WPOutputMode) WPFillBox(px, py, w, h, color >> 4);

    asm     push    ds
    asm     mov     dx, 03CEh
    asm     mov     ax, 0305h
    asm     out     dx, ax
    asm     mov     ah, _WPOutputOp /* Data rotate/function select */
    asm     mov     al, 3
    asm     out     dx, ax
    asm     mov     ah, byte ptr color  /* Set/Reset register */
    asm     xor     al, al
    asm     out     dx, ax
    asm     mov     ax, 0F01h       /* Enable set/reset register */
    asm     out     dx, ax
    asm     mov     ax, 0A000h      /* Calculate video memory address */
    asm     mov     es, ax
    asm     mov     di, px
    asm     shr     di, 3
    asm     mov     ax, py
    asm     mov     bx, 80
    asm     mul     bx
    asm     add     di, ax
    asm     mov     ax, px          /* Get mask data */
    asm     add     ax, w
    asm     and     ax, 7

    _DL = __MaskData[_AX];

    asm     mov     cx, px          /* Line width bytes number of Video memory */
    asm     and     cx, 7
    asm     add     cx, w
    asm     add     cx, 7
    asm     shr     cx, 3
    asm     mov     nbyte, cx
    asm     mov     ax, 80
    asm     sub     ax, cx
    asm     cmp     dl, 0
    asm     jz      UTailMask
    asm     dec     nbyte

    UTailMask:

    asm     lds     si, img
    asm     mov     bx, px          /* Sft1 size */
    asm     and     bx, 7
    asm     jnz     ComplexImage    /* If Image that need shift jop, go to ..*/
    asm     mov     cx, h

    NoShiftPutLine:

    asm     mov     bx, nbyte

    NoShiftPutBody:

    asm     mov     dh, es:[di]
    asm     mov     dh, ds:[si]
    asm     mov     es:[di], dh
    asm     inc     si
    asm     inc     di
    asm     dec     bx
    asm     jnz     NoShiftPutBody
    asm     cmp     dl, 0
    asm     jz      NoShiftSkipPutTail  /* Tail part masking */
    asm     mov     dh, es:[di]
    asm     mov     dh, ds:[si]
    asm     and     dh, dl
    asm     mov     es:[di], dh
    asm     inc     si
    asm     inc     di

    NoShiftSkipPutTail:

    asm     add     di, ax
    asm     loop    NoShiftPutLine
    asm     jmp     Quit            /* Exit this function */

    ComplexImage:

    asm     mov     bh, 8           /* Sft2 size */
    asm     sub     bh, bl
    asm     dec     nbyte
    asm     mov     cx, h

    PutLine:

    asm     push    cx
    asm     mov     dh, es:[di]
    asm     mov     dh, ds:[si]
    asm     inc     si
    asm     mov     ch, dh
    asm     mov     cl, bl
    asm     shr     ch, cl
    asm     mov     es:[di], ch
    asm     inc     di
    asm     xor     cx, cx

    PutBody:

    asm     cmp     cx, nbyte
    asm     jge     SkipPutBody
    asm     push    cx
    asm     mov     ch, es:[di]
    asm     mov     ch, dh
    asm     mov     cl, bh
    asm     shl     ch, cl
    asm     mov     dh, ds:[si]
    asm     mov     cl, bl
    asm     shr     dh, cl
    asm     or      dh, ch
    asm     mov     es:[di], dh
    asm     mov     dh, ds:[si]
    asm     inc     di
    asm     inc     si
    asm     pop     cx
    asm     inc     cx
    asm     jmp     PutBody

    SkipPutBody:

    asm     cmp     dl, 0
    asm     jz      SkipPutTail
    asm     mov     ch, es:[di]
    asm     mov     cl, bh
    asm     shl     dh, cl
    asm     mov     ch, ds:[si]
    asm     mov     cl, bl
    asm     shr     ch, cl
    asm     or      dh, ch
    asm     and     dh, dl
    asm     mov     es:[di], dh
    asm     inc     di

    SkipPutTail:

    asm     add     di, ax
    asm     pop     cx
    asm     loop    PutLine

    Quit:

    asm     pop     ds
}
