/*
    Tiny Hangul Library ver 1.98                Last update : 96-10-06
    Library Initialize/Close
    (c) Kim Youngsik (WOODPARK)
*/

#include <dos.h>
#include <alloc.h>
#include <string.h>

#define __SETDEFAULT

#include "WPKEYDEF.H"
#include "WPHANOUT.H"

extern byte *FontBuff;
extern byte (*EFont)[16];
extern byte (*H1Font)[][32];
extern byte (*H2Font)[][32];
extern byte (*H3Font)[][32];
extern byte (*SPFont)[][32];

/*
    Tiny Hangul Library Initialize.

    kbyte : memory size that need (default = 60, 60 * 1024 bytes)

    return: 1 - Not Found VGA Card.
            2 - Not Enough Memory.
            3 - Can't Load English Font.
            4 - Can't Load Hangul Font.
*/
int  WPTinyHanInit(char *efile, char *hfile, int kbyte = 60)
{
    unsigned far *MCB, tmp;
    char path[128];

    asm     mov     ax, 0x1a00
    asm     int     0x10

    if ((_AX & 0xFF) == 0x1A) {
        tmp = _BX & 0xFF;
        if (tmp != 7 && tmp != 8) return(1);
    }

    asm     mov     ah, 0x62
    asm     int     0x21
    asm     dec     bx
    asm     mov     word ptr MCB + 2, bx
    asm     mov     word ptr MCB, 3
    asm     mov     ah, 0x48
    asm     mov     bx, 0xFFFF
    asm     int     0x21
    asm     cmp     ax, 8
    asm     jz      succeed

    return(2);

    succeed:

    asm     mov     tmp, bx;

    if (((long)tmp << 4) + ((long)(*MCB + 1) << 4) < (long)kbyte * 1024l) return(2);

    FontBuff = new char[800];
    (char *)EFont  = new char[4096];
    (char *)H1Font = new char[5120];
    (char *)H2Font = new char[2816];
    (char *)H3Font = new char[3584];

    strcpy(path, _argv[0]);                         /* Make run path */
    *(strrchr(path, '\\') + 1) = 0;
    strcat(path, efile);
    if (WPLoadEngFont(path) != NUL) return(3);
    strcpy(path, _argv[0]);                         /* Make run path */
    *(strrchr(path, '\\') + 1) = 0;
    strcat(path, hfile);
    if (WPLoadHanFont(path) != NUL) return(4);

    _SpPutch = NUL;
    _HjPutch = NUL;

    asm     mov     ax, 12h
    asm     int     10h

    return(0);
}

void WPTinyHanClose(void)
{
    delete FontBuff;
    delete EFont;
    delete H1Font, H2Font, H3Font;
//    free(SPFont);
/*    if (FontBuff != NUL) free(FontBuff);
    if (EFont  != NUL) free(EFont);
    if (H1Font != NUL) free(H1Font);
    if (H2Font != NUL) free(H2Font);
    if (H3Font != NUL) free(H3Font);*/
    if (SPFont != NUL) free(SPFont);

    asm     mov     ax, 03h
    asm     int     10h
}

