/*
    Tiny Hangul Library ver 1.98                Last update : 96-10-04
    Draw Line on 640x480x16 Screen
    (c) Kim Youngsik (WOODPARK)
*/

#include "WPGRAPH.H"

void WPPutHLine(int px, int py, int w, int color)
{
    asm     mov     dx, 03CEh
    asm     mov     ax, 0305h
    asm     out     dx, ax
    asm     mov     ah, _WPOutputOp /* Data rotate/function select */
    asm     mov     al, 3
    asm     out     dx, ax
    asm     mov     ah, byte ptr color  /* Set/Reset register */
    asm     xor     al, al
    asm     out     dx, ax
    asm     mov     ax, 0F01h       /* Enable set/reset register */
    asm     out     dx, ax
    asm     mov     ax, 0A000h      /* Calculate video memory address */
    asm     mov     es, ax
    asm     mov     di, px
    asm     shr     di, 3
    asm     mov     ax, py
    asm     mov     bx, 80
    asm     mul     bx
    asm     add     di, ax
    asm     mov     dx, px          /* Line bytes number */
    asm     and     dx, 7
    asm     add     dx, w
    asm     add     dx, 7
    asm     shr     dx, 3
    asm     mov     cx, px          /* Head mask data */
    asm     and     cx, 7
    asm     mov     bx, 0FFFFh
    asm     shl     bl, cl
    asm     shr     bl, cl
    asm     mov     cx, px          /* Tail mask data */
    asm     add     cx, w
    asm     and     cx, 7
    asm     shl     bh, cl
    asm     shr     bh, cl
    asm     not     bh
    asm     cmp     dx, 1           /* Is this wide line?? */
    asm     jg      WideLine
    asm     cmp     bh, 0
    asm     jz      SkipMergeMaskData
    asm     and     bl, bh

    SkipMergeMaskData:

    asm     mov     al, es:[di]
    asm     mov     es:[di], bl
    asm     jmp     Quit

    WideLine:

    asm     cmp     bh, 0
    asm     jz      UTailMaskData
    asm     dec     dx

    UTailMaskData:

    asm     cmp     bl, 0FFh
    asm     je      SkipHeadMask
    asm     mov     al, es:[di]     /* Put head mask data */
    asm     mov     es:[di], bl
    asm     inc     di
    asm     dec     dx

    SkipHeadMask:

    asm     cmp     dx, 1
    asm     jl      SkipPutBody
    asm     mov     al, 0FFh

    PutBody:

    asm     mov     ah, es:[di]
    asm     mov     es:[di], al
    asm     inc     di
    asm     dec     dx
    asm     jnz     PutBody

    SkipPutBody:

    asm     cmp     bh, 0
    asm     jz      Quit
    asm     mov     al, es:[di]     /* Put tail mask data */
    asm     mov     es:[di], bh

    Quit:
}


void WPPutVLine(int px, int py, int h, int color)
{
    asm     mov     dx, 03CEh
    asm     mov     ax, 0305h
    asm     out     dx, ax
    asm     mov     ah, _WPOutputOp /* Data rotate/function select */
    asm     mov     al, 3
    asm     out     dx, ax
    asm     mov     ah, byte ptr color  /* Set/Reset register */
    asm     xor     al, al
    asm     out     dx, ax
    asm     mov     ax, 0F01h       /* Enable set/reset register */
    asm     out     dx, ax
    asm     mov     ax, 0A000h      /* Calculate video memory address */
    asm     mov     es, ax
    asm     mov     di, px
    asm     shr     di, 3
    asm     mov     ax, py
    asm     mov     bx, 80
    asm     mul     bx
    asm     add     di, ax
    asm     mov     cx, px          /* Get bit mask data */
    asm     and     cx, 7
    asm     mov     ah, 80h
    asm     shr     ah, cl
    asm     mov     cx, h

    PutBitMask:

    asm     mov     al, es:[di]
    asm     mov     es:[di], ah
    asm     add     di, 80
    asm     loop    PutBitMask
}
