/*
    Tiny Hangul Library ver 1.98                Last update : 96-10-05
    Various memory copy functions for font image
    (c) Kim Youngsik (WOODPARK)
*/

void WPMemCopy(unsigned char *dest, unsigned char *src, int n2)
{
    asm     push    ds
    asm     cld
    asm     lds     si, src
    asm     les     di, dest
    asm     mov     cx, n2
    asm     rep     movsw       /* Careful. 2 bytes copy. */
    asm     pop     ds          /* Total bytes = n * 2 */
}

void WPMemAnd(unsigned char *dest, unsigned char *src, int n2)
{
    asm     push    ds
    asm     lds     si, src
    asm     les     di, dest
    asm     mov     cx, n2

    Looping:

    asm     mov     ax, word ptr ds:[si]
    asm     and     es:[di], ax
    asm     add     si, 2
    asm     add     di, 2
    asm     loop    Looping
    asm     pop     ds
}

void WPMemOr(unsigned char *dest, unsigned char *src, int n2)
{
    asm     push    ds
    asm     lds     si, src
    asm     les     di, dest
    asm     mov     cx, n2

    Looping:

    asm     mov     ax, word ptr ds:[si]
    asm     or      es:[di], ax
    asm     add     si, 2
    asm     add     di, 2
    asm     loop    Looping
    asm     pop     ds
}

void WPMemXor(unsigned char *dest, unsigned char *src, int n2)
{
    asm     push    ds
    asm     lds     si, src
    asm     les     di, dest
    asm     mov     cx, n2

    Looping:

    asm     mov     ax, word ptr ds:[si]
    asm     xor     es:[di], ax
    asm     add     si, 2
    asm     add     di, 2
    asm     loop    Looping
    asm     pop     ds
}

void WPMemNot(unsigned char *dest, unsigned char *src, int n2)
{
    asm     push    ds
    asm     lds     si, src
    asm     les     di, dest
    asm     mov     cx, n2

    Looping:

    asm     mov     ax, word ptr ds:[si]
    asm     not     ax
    asm     mov     es:[di], ax
    asm     add     si, 2
    asm     add     di, 2
    asm     loop    Looping
    asm     pop     ds
}

void WPMemSet(unsigned char *dest, unsigned char value, int n2)
{
    asm     les     di, dest
    asm     mov     al, value
    asm     cld
    asm     mov     cx, n2
    asm     rep     stosw
}

void WPMemShl(unsigned char *dest, unsigned char *src, char x, char y)
{
    asm     push    ds
    asm     lds     si, src
    asm     les     di, dest
    asm     xor     bh, bh
    asm     mov     bl, x
    asm     add     si, bx
    asm     add     di, bx
    asm     shl     bx, 1
    asm     xor     ch, ch
    asm     mov     dl, y
    asm     mov     dh, x

    LoopingI:

    asm     mov     cl, dh
    asm     clc

    LoopingII:

    asm     dec     di
    asm     dec     si
    asm     mov     ah, ds:[si]
    asm     rcl     ah, 1
    asm     mov     es:[di], ah
    asm     loop    LoopingII

    asm     add     si, bx
    asm     add     di, bx
    asm     mov     cl, dl
    asm     dec     dl
    asm     loop    LoopingI
    asm     pop     ds
}

void WPMemShr(unsigned char *dest, unsigned char *src, char x, char y)
{
    asm     push    ds
    asm     lds     si, src
    asm     les     di, dest
    asm     xor     dh, dh
    asm     mov     dl, y
    asm     xor     bh, bh
    asm     mov     bl, x

    LoopingI:

    asm     mov     cx, bx
    asm     clc

    LoopingII:

    asm     mov     ah, ds:[si]
    asm     rcr     ah, 1
    asm     mov     es:[di], ah
    asm     inc     di
    asm     inc     si
    asm     loop    LoopingII
    asm     mov     cx, dx
    asm     dec     dx
    asm     loop    LoopingI
    asm     pop     ds
}

void WPMemShup(unsigned char *dest, unsigned char *src, char x, char y)
{
    asm     push    ds
    asm     lds     si, src
    asm     les     di, dest
    asm     xor     dh, dh
    asm     mov     dl, y
    asm     xor     bh, bh
    asm     mov     bl, x
    asm     add     si, bx
    asm     dec     dx

    LoopingI:

    asm     mov     cx, bx

    LoopingII:

    asm     mov     ah, ds:[si]
    asm     mov     es:[di], ah
    asm     inc     di
    asm     inc     si
    asm     loop    LoopingII
    asm     mov     cx, dx
    asm     dec     dx
    asm     loop    LoopingI
    asm     xor     ch, ch
    asm     mov     cl, bl
    asm     xor     al, al
    asm     rep     stosb
    asm     pop     ds
}

void WPMemShdn(unsigned char *dest, unsigned char *src, char x, char y)
{
    asm     push    ds
    asm     lds     si, src
    asm     les     di, dest
    asm     xor     dh, dh
    asm     mov     dl, y
    asm     xor     bh, bh
    asm     mov     bl, x
    asm     mov     al, dl
    asm     mul     bl
    asm     add     si, ax
    asm     add     di, ax
    asm     sub     si, bx
    asm     dec     dx

    LoopingI:

    asm     mov     cx, bx

    LoopingII:

    asm     dec     di
    asm     dec     si
    asm     mov     ah, ds:[si]
    asm     mov     es:[di], ah
    asm     loop    LoopingII
    asm     mov     cx, dx
    asm     dec     dx
    asm     loop    LoopingI
    asm     sub     di, bx
    asm     xor     ch, ch
    asm     mov     cl, bl
    asm     xor     al, al
    asm     rep     stosb
    asm     pop     ds
}
