/*
    Tiny Hangul Library ver 1.98                Last update : 96-10-04
    Put/Get a Pixel - 640x480x16(12h) mode
    (c) Kim Youngsik (WOODPARK)
*/

#include "WPGRAPH.H"

byte _WPOutputOp = WPOP_PUT;
byte _WPOutputMode;

byte __MaskData[] = { 0x00, 0x80, 0xC0, 0xE0, 0xF0, 0xF8, 0xFC, 0xFE };

int WPGetPixel(int px, int py)
{
    int     color = 0;

    asm     mov     ax, 0A000h      /* Calculate video memory address */
    asm     mov     es, ax
    asm     mov     di, px
    asm     shr     di, 3
    asm     mov     ax, py
    asm     mov     bx, 80
    asm     mul     bx
    asm     add     di, ax
    asm     mov     cx, px          /* Get bit mask data */
    asm     not     cx
    asm     and     cx, 7
    asm     mov     bx, 1
    asm     shl     bx, cl
    asm     mov     dx, 03CEh       /* Port 03CEH */
    asm     xor     cx, cx

    PixelReadLoop:

    asm     mov     ah, cl          /* Set read plane */
    asm     mov     al, 4
    asm     out     dx, ax
    asm     mov     bh, es:[di]     /* Get a pixel data from a plane */
    asm     and     bh, bl
    asm     jz      SaveSkip        /* If BH == 0, skip */
    asm     mov     ax, 1
    asm     shl     ax, cl
    asm     or      color, ax       /* Make Pixel data (or) */

    SaveSkip:

    asm     inc     cl
    asm     cmp     cl, 4
    asm     jnz     PixelReadLoop   /* Read next plane data */
    asm     mov     ax, 0004h       /* Set 0x3CE register default data */
    asm     out     dx, ax

    return(color);
}

void WPPutPixel(int px, int py, int color)
{
    asm     mov     dx, 03CEh
    asm     mov     ax, 0305h
    asm     out     dx, ax
    asm     mov     ah, _WPOutputOp /* Data rotate/function select */
    asm     mov     al, 3
    asm     out     dx, ax
    asm     mov     ah, byte ptr color  /* Set/Reset register */
    asm     xor     al, al
    asm     out     dx, ax
    asm     mov     ax, 0F01h       /* Enable set/reset register */
    asm     out     dx, ax
    asm     mov     ax, 0A000h      /* Calculate video memory address */
    asm     mov     es, ax
    asm     mov     di, px
    asm     shr     di, 3
    asm     mov     ax, py
    asm     mov     bx, 80
    asm     mul     bx
    asm     add     di, ax
    asm     mov     cx, px          /* Get bit mask data */
    asm     and     cx, 7
    asm     mov     ax, 80h
    asm     shr     ax, cl
    asm     mov     ah, es:[di]     /* Put mask data */
    asm     mov     es:[di], al
}
