/*
    Tiny Hangul Library ver 1.98                Last update : 96-10-04
    Functions about Palette for VGA Graphic card
    (c) Kim Youngsik (WOODPARK)
*/

char _WP16PltNum[16] = { 0,  1,  2,  3,  4,  5, 20,  7, 56, 57, 58, 59, 60, 61, 62, 63 };

void WPSetPalette(int index, char rval, char gval, char bval)
{
    asm     mov     ax, index
    asm     mov     dx, 3C8h
    asm     out     dx, al
    asm     inc     dx
    asm     mov     al, rval
    asm     out     dx, al
    asm     mov     al, gval
    asm     out     dx, al
    asm     mov     al, bval
    asm     out     dx, al
}

void WPGetPalette(int index, char *rval, char *gval, char *bval)
{
    asm     mov     ax, index
    asm     mov     dx, 3C7h
    asm     out     dx, al
    asm     add     dx, 2
    asm     in      al, dx
    asm     les     bx, [rval]
    asm     mov     es:[bx], al
    asm     in      al, dx
    asm     les     bx, [gval]
    asm     mov     es:[bx], al
    asm     in      al, dx
    asm     les     bx, [bval]
    asm     mov     es:[bx], al
}

void WPSetPaletteBlock(int start, int num, char *plt)
{
    _CX = num * 3;

    asm     mov     ax, start
    asm     mov     dx, 3C8h
    asm     out     dx, al
    asm     inc     dx
    asm     les     di, plt

    Looping:

    asm     mov     al, es:[di]
    asm     inc     di
    asm     out     dx, al
    asm     loop    Looping
}

void WPGetPaletteBlock(int start, int num, char *plt)
{
    _CX = num * 3;

    asm     mov     ax, start
    asm     mov     dx, 3C7h
    asm     out     dx, ax
    asm     mov     dx, 3C9h
    asm     les     di, plt

    Looping:

    asm     in      al, dx
    asm     mov     es:[di], al
    asm     inc     di
    asm     loop    Looping
}

void WPWaitVert(void)
{
    asm     mov     dx, 3DAh

    Wait:

    asm     in      al, dx
    asm     test    al, 08h
    asm     jz      Wait
}

