/*
    Tiny Hangul Library ver 1.98                Last update : 96-10-15
    Put string
    (c) Kim Youngsik (WOODPARK)
*/

#include <string.h>

#include "WPKEYDEF.H"
#include "WPGRAPH.H"
#include "WPHANOUT.H"

extern byte *FontBuff;

int  WPPutsn(int px, int py, int color, int s, int n, byte *str)
{
    char    cliphead, cliptail;
    word    len, ch;

    len = strlen(str);

    if (s >= len) return(len);
    if (s + n >= len) n = len - s;

    cliphead = (WPCheckCharKind(str, s) == WPCHKIND_HAN2) ? 1 : 0;
    cliptail = (WPCheckCharKind(str, s + n - 1) == WPCHKIND_HAN1) ? 1 : 0;

    if (cliphead) {
        ch = ((word)str[s - 1] << 8) | (word)str[s];
        if (WPIsHan(ch)) WPGetHanImg(ch);
        else if (WPIsSp(ch)) WPGetSpImg(ch);
        else WPGetHjImg(ch);
        WPMakeHalfSizeImg(1);
        WPModifyImg();
        WPPutImage(px, py, FSizepx, FSizepy, color, FontBuff + FStartLine);
        px += FSizepx;
        str++;
        n--;
    }
    if (cliptail) n--;

    while (n > 0) {
        ch = ((word)str[s] << 8) | (word)str[s + 1];
        if (WPIsHan(ch)) {
            WPHanPutch(px, py, color, ch);
            px += (FSizepx << 1); str += 2; n -= 2;
        } else if (WPIsSp(ch)) {
            if (_SpPutch != NUL) _SpPutch(px, py, color, ch);
            px += (FSizepx << 1); str += 2; n -= 2;
        } else if (WPIsHj(ch)) {
            if (_HjPutch != NUL) _HjPutch(px, py, color, ch);
            px += (FSizepx << 1); str += 2; n -= 2;
        } else {
            WPEngPutch(px, py, color, str[s]);
            px += FSizepx; str++; n--;
        }
    }

    if (cliptail) {
        ch = ((word)str[s] << 8) | (word)str[s + 1];
        if (WPIsHan(ch)) WPGetHanImg(ch);
        else if (WPIsSp(ch)) WPGetSpImg(ch);
        else WPGetHjImg(ch);
        WPMakeHalfSizeImg(0);
        WPModifyImg();
        WPPutImage(px, py, FSizepx, FSizepy, color, FontBuff + FStartLine);
    }
    return(len);
}
