/*
    Tiny Hangul Library ver 1.98                Last update : 96-10-04
    Get/Put a Part of Screen - 640x480x16(12h) mode
    (c) Kim Youngsik (WOODPARK)
*/

#include "WPGRAPH.H"

void WPGetScr(int px, int py, int w, int h, byte *img)
{
    asm     push    ds
    asm     mov     ax, 0A000h      /* Calculate video memory address */
    asm     mov     ds, ax          /* ds:[bx], ds:[si] - video memory */
    asm     mov     si, px
    asm     shr     si, 3
    asm     mov     ax, py
    asm     mov     bx, 80
    asm     mul     bx
    asm     add     si, ax
    asm     les     di, img         /* es:[di] - img */
    asm     mov     ax, px
    asm     and     ax, 7
    asm     add     ax, w
    asm     add     ax, 7
    asm     shr     ax, 3
    asm     mov     w, ax
    asm     mov     bx, si
    asm     mov     dx, 03CEh
    asm     mov     ax, 0005h
    asm     out     dx, ax
    asm     cld
    asm     mov     cx, h

    GetAllPlane:

    asm     push    cx
    asm     mov     cx, 4

    GetAPlane:

    asm     push    cx
    asm     mov     si, bx
    asm     mov     al, 4
    asm     mov     ah, 4
    asm     sub     ah, cl
    asm     out     dx, ax
    asm     mov     cx, w
    asm     rep     movsb
    asm     pop     cx
    asm     loop    GetAPlane
    asm     pop     cx
    asm     add     bx, 80
    asm     loop    GetAllPlane
    asm     pop     ds
}

void WPPutScr(int px, int py, int w, int h, byte *img)
{
    byte    mask1, mask2;

    mask1 = ~__MaskData[px & 7];          /* Head mask data */
    mask2 = __MaskData[(px + w) & 7];     /* Tail mask data */

    asm     push    ds
    asm     mov     dx, 03CEh
    asm     mov     ax, 0005h
    asm     out     dx, ax
    asm     mov     ax, 0001h
    asm     out     dx, ax
    asm     mov     ax, 0003h
    asm     out     dx, ax
    asm     mov     ax, 0A000h      /* Calculate video memory address */
    asm     mov     es, ax
    asm     mov     di, px
    asm     shr     di, 3
    asm     mov     ax, py
    asm     mov     bx, 80
    asm     mul     bx
    asm     add     di, ax
    asm     lds     si, img
    asm     mov     ax, px
    asm     and     ax, 7
    asm     add     ax, w
    asm     add     ax, 7
    asm     shr     ax, 3
    asm     cmp     mask1, 0FFh
    asm     je      NoHeadMask
    asm     dec     ax

    NoHeadMask:

    asm     cmp     mask2, 0
    asm     je      NoTailMask
    asm     dec     ax

    NoTailMask:

    asm     mov     w, ax
    asm     mov     bx, di
    asm     cld
    asm     mov     cx, h

    PutAllPlane:

    asm     push    cx
    asm     mov     cx, 4

    PutAPlane:

    asm     push    cx
    asm     mov     di, bx
    asm     mov     dx, 03C4h
    asm     mov     al, 2
    asm     mov     ah, 8
    asm     dec     cl
    asm     shr     ah, cl
    asm     out     dx, ax
    asm     mov     dx, 03CEh
    asm     cmp     mask1, 0FFh
    asm     je      SkipPutHeadMask
    asm     mov     al, 8
    asm     mov     ah, mask1
    asm     out     dx, ax
    asm     mov     al, es:[di]
    asm     mov     al, ds:[si]
    asm     mov     es:[di], al
    asm     inc     si
    asm     inc     di

    SkipPutHeadMask:

    asm     mov     ax, 0FF08h
    asm     out     dx, ax
    asm     mov     cx, w
    asm     rep     movsb
    asm     cmp     mask2, 0
    asm     je      SkipPutTailMask
    asm     mov     al, 8
    asm     mov     ah, mask2
    asm     out     dx, ax
    asm     mov     al, es:[di]
    asm     mov     al, ds:[si]
    asm     mov     es:[di], al
    asm     inc     si
    asm     inc     di

    SkipPutTailMask:

    asm     pop     cx
    asm     loop    PutAPlane
    asm     add     bx, 80
    asm     pop     cx
    asm     loop    PutAllPlane
    asm     mov     ax, 0FF08h
    asm     out     dx, ax
    asm     mov     dx, 03C4h
    asm     mov     ax, 0F02h
    asm     out     dx, ax
    asm     pop     ds
}

