/*
    Tiny Hangul Library ver 1.98                Last update : 96-10-04
    Scroll up/down - 640x480x16(12h) mode
    (c) Kim Youngsik (WOODPARK)
*/

#include "WPGRAPH.H"

void _ScrollUp(int x, int py, int w, int h, int lines)
{
    asm     push    ds
    asm     mov     dx, 03CEh
    asm     mov     ax, 0105h
    asm     out     dx, ax
    asm     mov     ax, 0F01h
    asm     out     dx, ax
    asm     mov     ax, 0003h
    asm     out     dx, ax
    asm     mov     ax, 0A000h
    asm     mov     es, ax
    asm     mov     ds, ax
    asm     mov     ax, py
    asm     mov     bx, 80
    asm     mul     bx
    asm     mov     di, ax
    asm     add     di, x
    asm     mov     ax, lines
    asm     mul     bx
    asm     mov     si, di
    asm     add     si, ax
    asm     mov     dx, 80
    asm     sub     dx, w
    asm     cld
    asm     mov     cx, h
    asm     sub     cx, lines

    NextLine:

    asm     mov     bx, cx
    asm     mov     cx, w
    asm     rep     movsb
    asm     mov     cx, bx
    asm     add     di, dx
    asm     add     si, dx
    asm     loop    NextLine
    asm     pop     ds
}

void _ScrollDn(int x, int py, int w, int h, int lines)
{
    asm     push    ds
    asm     mov     dx, 03CEh
    asm     mov     ax, 0105h
    asm     out     dx, ax
    asm     mov     ax, 0F01h
    asm     out     dx, ax
    asm     mov     ax, 0003h
    asm     out     dx, ax
    asm     mov     ax, 0A000h
    asm     mov     ds, ax
    asm     mov     es, ax
    asm     mov     cx, h
    asm     sub     cx, lines
    asm     mov     ax, py
    asm     add     ax, cx
    asm     dec     ax
    asm     mov     bx, 80
    asm     mul     bx
    asm     mov     si, ax
    asm     add     si, x
    asm     mov     ax, lines
    asm     mul     bx
    asm     mov     di, si
    asm     add     di, ax
    asm     add     bx, w
    asm     cld

    NextLine:

    asm     mov     dx, cx
    asm     mov     cx, w
    asm     rep     movsb
    asm     sub     di, bx
    asm     sub     si, bx
    asm     mov     cx, dx
    asm     loop    NextLine
    asm     pop     ds
}

void WPScrollUp(int px, int py, int w, int h, int lines)
{
    unsigned        SrcOffset, DestOffset;
    unsigned char   mask1, mask2;

    mask1 = ~__MaskData[px & 7];
    mask2 = __MaskData[(px + w) & 7];

    if (mask1 == 0xFF && mask2 == 0x00) {
        _ScrollUp(px >> 3, py, w >> 3, h, lines);
        return;
    }

    asm     push    ds
    asm     mov     ax, 0A000h
    asm     mov     ds, ax
    asm     mov     es, ax
    asm     mov     si, px
    asm     shr     si, 3
    asm     mov     di, si
    asm     mov     ax, py
    asm     mov     bx, 80
    asm     mul     bx
    asm     add     si, ax
    asm     mov     ax, py
    asm     sub     ax, lines
    asm     mov     bx, 80
    asm     mul     bx
    asm     add     di, ax
    asm     mov     SrcOffset, si
    asm     mov     DestOffset, di
    asm     mov     dx, 03CEh
    asm     mov     ax, 0005h
    asm     out     dx, ax
    asm     mov     ax, 0001h
    asm     out     dx, ax
    asm     mov     ax, 0003h
    asm     out     dx, ax
    asm     mov     ax, px
    asm     and     ax, 7
    asm     add     ax, w
    asm     add     ax, 7
    asm     shr     ax, 3
    asm     cmp     mask1, 0FFh
    asm     je      NoHeadMask
    asm     dec     ax

    NoHeadMask:

    asm     cmp     mask2, 0
    asm     jz      NoTailMask
    asm     dec     ax

    NoTailMask:

    asm     mov     w, ax
    asm     cld
    asm     mov     cx, h

    ScrollAllLine:

    asm     push    cx
    asm     mov     cx, 4

    ScrollLine:

    asm     push    cx
    asm     mov     si, SrcOffset
    asm     mov     di, DestOffset
    asm     mov     dx, 03C4h
    asm     mov     ah, 1
    asm     dec     cl
    asm     shl     ah, cl
    asm     mov     al, 2
    asm     out     dx, ax
    asm     mov     dx, 03CEh
    asm     mov     al, 4
    asm     mov     ah, cl
    asm     out     dx, ax
    asm     cmp     mask1, 0FFh
    asm     je      SkipPutHeadMask
    asm     mov     al, 8
    asm     mov     ah, mask1
    asm     out     dx, ax
    asm     mov     al, ds:[si]
    asm     mov     ah, es:[di]
    asm     mov     es:[di], al
    asm     inc     si
    asm     inc     di

    SkipPutHeadMask:

    asm     mov     ax, 0FF08h
    asm     out     dx, ax
    asm     mov     cx, w
    asm     rep     movsb
    asm     cmp     mask2, 0
    asm     je      SkipPutTailMask
    asm     mov     al, 8
    asm     mov     ah, mask2
    asm     out     dx, ax
    asm     mov     al, ds:[si]
    asm     mov     ah, es:[di]
    asm     mov     es:[di], al

    SkipPutTailMask:

    asm     pop     cx
    asm     loop    ScrollLine
    asm     add     SrcOffset, 80
    asm     add     DestOffset, 80
    asm     pop     cx
    asm     loop    ScrollAllLine
    asm     mov     ax, 0FF08h
    asm     out     dx, ax
    asm     mov     dx, 03C4h
    asm     mov     ax, 0F02h
    asm     out     dx, ax
    asm     pop     ds
}

void WPScrollDn(int px, int py, int w, int h, int lines)
{
    unsigned        SrcOffset, DestOffset;
    unsigned char   mask1, mask2;
    unsigned char   MaskData[] = { 0x00, 0x80, 0xC0, 0xE0, 0xF0, 0xF8, 0xFC, 0xFE };

    mask1 = ~MaskData[px & 7];
    mask2 = MaskData[(px + w) & 7];

    if (mask1 == 0xFF && mask2 == 0x00) {
        _ScrollDn(px >> 3, py, w >> 3, h, lines);
        return;
    }

    asm     push    ds
    asm     mov     ax, 0A000h
    asm     mov     ds, ax
    asm     mov     es, ax
    asm     mov     si, px
    asm     shr     si, 3
    asm     mov     di, si
    asm     mov     ax, py
    asm     add     ax, h
    asm     mov     bx, 80
    asm     mul     bx
    asm     add     si, ax
    asm     mov     ax, py
    asm     add     ax, h
    asm     add     ax, lines
    asm     mov     bx, 80
    asm     mul     bx
    asm     add     di, ax
    asm     mov     SrcOffset, si
    asm     mov     DestOffset, di
    asm     mov     dx, 03CEh
    asm     mov     ax, 0005h
    asm     out     dx, ax
    asm     mov     ax, 0001h
    asm     out     dx, ax
    asm     mov     ax, 0003h
    asm     out     dx, ax
    asm     mov     ax, px
    asm     and     ax, 7
    asm     add     ax, w
    asm     add     ax, 7
    asm     shr     ax, 3
    asm     cmp     mask1, 0FFh
    asm     je      NoHeadMask
    asm     dec     ax

    NoHeadMask:

    asm     cmp     mask2, 0
    asm     jz      NoTailMask
    asm     dec     ax

    NoTailMask:

    asm     mov     w, ax
    asm     cld
    asm     mov     cx, h

    ScrollAllLine:

    asm     push    cx
    asm     mov     cx, 4

    ScrollLine:

    asm     push    cx
    asm     mov     si, SrcOffset
    asm     mov     di, DestOffset
    asm     mov     dx, 03C4h
    asm     mov     ah, 1
    asm     dec     cl
    asm     shl     ah, cl
    asm     mov     al, 2
    asm     out     dx, ax
    asm     mov     dx, 03CEh
    asm     mov     al, 4
    asm     mov     ah, cl
    asm     out     dx, ax
    asm     cmp     mask1, 0FFh
    asm     je      SkipPutHeadMask
    asm     mov     al, 8
    asm     mov     ah, mask1
    asm     out     dx, ax
    asm     mov     al, ds:[si]
    asm     mov     ah, es:[di]
    asm     mov     es:[di], al
    asm     inc     si
    asm     inc     di

    SkipPutHeadMask:

    asm     mov     ax, 0FF08h
    asm     out     dx, ax
    asm     mov     cx, w
    asm     rep     movsb
    asm     cmp     mask2, 0
    asm     je      SkipPutTailMask
    asm     mov     al, 8
    asm     mov     ah, mask2
    asm     out     dx, ax
    asm     mov     al, ds:[si]
    asm     mov     ah, es:[di]
    asm     mov     es:[di], al

    SkipPutTailMask:

    asm     pop     cx
    asm     loop    ScrollLine
    asm     sub     SrcOffset, 80
    asm     sub     DestOffset, 80
    asm     pop     cx
    asm     loop    ScrollAllLine
    asm     mov     ax, 0FF08h
    asm     out     dx, ax
    asm     mov     dx, 03C4h
    asm     mov     ax, 0F02h
    asm     out     dx, ax
    asm     pop     ds
}


