#include <STDLIB.H>
#include <STDIO.H>
#include <CONIO.H>
#include <PROCESS.H>
#include <DOS.H>
#include <MEM.H>
#include <ALLOC.H>

#define  FALSE         0
#define  TRUE          !FALSE
#define  MAP_SQ_WIDE   20

typedef unsigned int  word;
typedef unsigned char byte;
typedef int           boolean;

const   _SCAN_CODE    = 256;
const   _UP_KEY       = 72 + _SCAN_CODE;
const   _DOWN_KEY     = 80 + _SCAN_CODE;
const   _LEFT_KEY     = 75 + _SCAN_CODE;
const   _RIGHT_KEY    = 77 + _SCAN_CODE;
const   _SPACE_KEY    = 32;
const   _ESC_KEY      = 27;
const   _TAB_KEY      = 9;

const   VESA_MODE     = 0x0101;
const   MAX_X_LINE    = 640;
const   MAX_Y_LINE    = 480;
const   BUFFER_LINE   = 64;
const   MAP_X_WIDE    = 4;
const   MAP_Y_WIDE    = 5;
const   MAX_MAP_X     = 100;
const   MAX_MAP_Y     = 100;
const   word BUFFER_LENGTH = MAX_X_LINE * BUFFER_LINE;
const   TILE_X_SIZE   = 60;
const   TILE_X_HALF   = 30;
const   TILE_Y_SIZE   = 51;
const   TILE_Y_HALF   = 14;
const   MAX_BUFFER    = 7;
const   MAP_X_CENTER  = (MAX_X_LINE - TILE_X_SIZE) / 2 + 310;
const   MAP_Y_CENTER  = (MAX_Y_LINE - TILE_Y_SIZE) / 2 + 80;

const   MAX_PALETTE   = 256;

const   MAX_TILE      = 6*4;
const   MAX_PERSON    = 3;
const   PERSON_FRAME  = 8;
const   MAX_CHARA     = MAX_PERSON * PERSON_FRAME;

const   MAP_X_SIZE    = (MAP_X_WIDE + MAP_Y_WIDE+ 1) * TILE_X_SIZE;

typedef char         *TVirtual[MAX_BUFFER];

struct  palette_data_T {
	   byte _RED, _GREEN, _BLUE;
	} palette_data[MAX_PALETTE];

enum    TMapAttribute {Emap_tile,Emap_height,Emap_person};

class   TMap {

	   byte m_map_data[MAX_MAP_Y][MAX_MAP_X][Emap_person+1];

	public:
	   TMap();
	   ~TMap() { ; };
	   boolean isUnvalancedMap(int x, int y, byte height);
	   byte    readMap(TMapAttribute attribute, int x, int y);
	   void    writeMap(TMapAttribute attribute, int x, int y, byte value);
	} *map;

class   TPerson {

	   int  m_number, m_x, m_y;
	   int  m_face, m_face_count;
	   char m_name[17];
	   int  m_hit_point, m_spell_point, m_level, m_experience;

	public:
	   TPerson(int number);
	   ~TPerson() { ; };
	   void   setParameter(const char *name, int HP, int SP, int level, int exp);
	   char  *returnCharaTile();
	   int    returnNumber() { return m_number; }
	   int    returnX()      { return m_x; }
	   int    returnY()      { return m_y; }
	   void   setX(int x)    { m_x = x; }
	   void   setY(int y)    { m_y = y; }
	   void   moveXY(int x1, int y1);
	   void   warpXY(int x, int y);
	   int    doAction();
	} *person[MAX_PERSON+1];

boolean pressedKey();
char    readKey();
int     getKey();
int     sign(int value);
void    occurError(const char *message);
void    initGraph();
void    closeGraph();
void    setRGB(byte color, byte red, byte green, byte blue);

void    clearDevice(byte fill);
void    bar(word x, word y, word x_len, word y_len, byte color);
void    putImage(word x, word y, char *bitmap_data);
void    flipPage();

void    drawScroll();
void    displayBankInformation();

char    SCAN_CODE = 0;
word    CURRENT_BANK = 0;
word    CURRENT_READ_BANK = 0;

word    MAIN_CHARACTER = 1;
long    start_time     = 0;
long    counter        = 0;

TVirtual virtual_buffer;
char    *tile_data[MAX_TILE];
char    *object_data[MAX_CHARA];

char    MAP_FILE_NAME[9] = "MAP.DAT";
char    GRAPHIC_DATA_FILE[10] = "_NETO.DAT";

word    write_bank, read_bank, shift_bank;


boolean  pressedKey()
{
    asm  mov  ah, 1
    asm  int  16h
    asm  jnz  PK__KEY_PRESSED
    asm  mov  al, FALSE
    asm  jmp  PK__END
PK__KEY_PRESSED:
    asm  mov  al, 1
PK__END:
    return _AL;
}

char readKey()
{
    asm  mov  al, SCAN_CODE
    asm  mov  SCAN_CODE, 0
    asm  test al, 0FFh
    asm  jnz  RK__JUMP1
RK__JUMP0:
    asm  mov  ah, 1
    asm  int  16h
    asm  jz   RK__JUMP0
    asm  mov  ah, 0
    asm  int  16h
    asm  cmp  al, 0
    asm  jne  RK__JUMP1
    asm  mov  SCAN_CODE, ah
RK__JUMP1:
    return _AL;
}

int  getKey()
{
   int key_code;

   key_code = int(readKey());
   if (key_code == 0) key_code = _SCAN_CODE + int(readKey());
   while (pressedKey()) if (readKey() == 0) readKey();
   return key_code;
}

int  sign(int value)
{
   if      (value > 0) return 1;
   else if (value < 0) return -1;
   else                return 0;
}

void occurError(const char *message)
{
   puts(message);
   exit(1);
}

void initGraph()
{
   struct {
      word  Mode_Attribute;
      byte  Window_A_Attribute;
      byte  Window_B_Attribute;
      word  Window_Granularity;
      byte  gabage[250];
   } VESAinfo, *pVESAinfo;

   word result;

   pVESAinfo = &VESAinfo;

   asm  mov  ax, 4F01h
   asm  mov  cx, VESA_MODE
   asm  les  di, pVESAinfo
   asm  int  10h
   asm  mov  result, ax

   if (result != 0x004F) occurError("VESA DRIVER not supported.");

   if ((pVESAinfo->Window_A_Attribute & 3) == 3) read_bank  = 0;
   if ((pVESAinfo->Window_A_Attribute & 5) == 5) write_bank = 0;
   if ((pVESAinfo->Window_B_Attribute & 3) == 3) read_bank  = 1;
   if ((pVESAinfo->Window_B_Attribute & 5) == 5) write_bank = 1;

   for (shift_bank = 0; shift_bank < 16; shift_bank++) {
      if ((0x40 >> shift_bank) == pVESAinfo->Window_Granularity) break;
   }

   asm  mov  ax, 4F02h
   asm  mov  bx, VESA_MODE
   asm  xor  cx, cx
   asm  xor  dx, dx
   asm  int  10h
   asm  mov  byte ptr result, ah

   if (byte(result) == 1) occurError("This mode not supported.");

}

void closeGraph()
{
    asm  mov  ax, 4F02h
    asm  mov  bx, 03h
    asm  int  10h
}

void setRGB(byte color, byte red, byte green, byte blue)
{
    asm  mov  dx, 03C8h;
    asm  mov  al, color;
    asm  out  dx, al;
    asm  inc  dx;
    asm  mov  al, red;
    asm  out  dx, al;
    asm  mov  al, green;
    asm  out  dx, al;
    asm  mov  al, blue;
    asm  out  dx, al;
}

void clearDevice(byte fill)
{
   int i;

   for (i = 0; i < MAX_BUFFER; i++)
      memset(virtual_buffer[i],fill,BUFFER_LENGTH);
}

void bar(word x, word y, word x_len, word y_len, byte color)
{
   byte bank;

   if (y >= BUFFER_LINE * MAX_BUFFER) return;
   bank = y / BUFFER_LINE;
   y = y % BUFFER_LINE;
   while (y_len > 0) {
      memset((void *)((long)virtual_buffer[bank]+y*MAX_X_LINE+x),color,x_len);
      y_len--;
      if (++y >= BUFFER_LINE) {
	 if (++bank >= MAX_BUFFER) return;
	 y = 0;
      }
   }
}

void putImage(word x, word y, char *bitmap_data)
{
   TVirtual target;
   word     _bank, _target = FP_OFF(target);

    asm  mov  ax, y
    asm  cmp  ax, BUFFER_LINE * MAX_BUFFER
    asm  jae  PI__END

    asm  mov  ax, ss
    asm  mov  es, ax
    asm  mov  di, _target
   _SI = FP_OFF(virtual_buffer);
    asm  mov  cx, MAX_BUFFER * 2
    asm  rep  movsw

    asm  push ds

    asm  mov  ax, y
    asm  shr  ax, 4
    asm  and  ax, 0FFFCh
    asm  mov  bx, _target
    asm  add  bx, ax
    asm  mov  ax, y
    asm  and  ax, BUFFER_LINE - 1
    asm  mov  y, ax

    asm  mov  di, ss:[bx]
    asm  mov  es, ss:[bx+2]
    asm  mov  _bank, bx

    asm  mov  ax, y
    asm  mov  dx, ax
    asm  shl  ax, 2
    asm  add  ax, dx
    asm  shl  ax, 7
    asm  add  ax, x
    asm  add  di, ax

    asm  lds  si, bitmap_data
    asm  inc  si
    asm  inc  si
    asm  xor  bx, bx
    asm  mov  dl, 1
    asm  cld

PI__MAIN_LOOP:
    asm  xor  dl, 01h
    asm  lodsb
    asm  and  al, al
    asm  jz   PI__MAIN_LOOP
    asm  cmp  al, 0FFh
    asm  je   PI__SPECIAL
    asm  and  dl, dl
    asm  jz   PI__SKIP_DATA
    asm  xor  ch, ch
    asm  mov  cl, al
    asm  shr  cx, 1
    asm  jz   PI__QAZ3
    asm  jnc  PI__QAZ2
    asm  mov  al, ds:[si]
    asm  mov  es:[di+bx], al
    asm  inc  si
    asm  inc  bx
   PI__QAZ2:
    asm  mov  dh, cl
    asm  add  di, bx
    asm  rep  movsw
    asm  sub  di, bx
    asm  xor  ah, ah
    asm  mov  al, dh
    asm  shl  ax, 1
    asm  sub  di, ax
    asm  add  bx, ax
    asm  jmp  PI__MAIN_LOOP

   PI__QAZ3:
    asm  mov  al, ds:[si]
    asm  mov  es:[di+bx], al
    asm  inc  si
    asm  inc  bx
    asm  jmp   PI__MAIN_LOOP

   PI__SKIP_DATA:
    asm  xor  ah, ah
    asm  add  bx, ax
    asm  jmp  PI__MAIN_LOOP

PI__SPECIAL:
    asm  mov  ah, ds:[si]
    asm  cmp  ah, 0FFh
    asm  je   PI__EXIT
    asm  mov  dl, 1
    asm  xor  bx, bx
    asm  add  di, MAX_X_LINE
    asm  mov  ax, y
    asm  inc  ax
    asm  mov  y, ax
    asm  cmp  ax, BUFFER_LINE
    asm  jne  PI__MAIN_LOOP
    asm  mov  y, bx
    asm  mov  bx, _bank
    asm  add  bx, 4
    asm  mov  ax, bx
    asm  mov  cx, _target
    asm  sub  ax, cx
    asm  cmp  ax, MAX_BUFFER * 4
    asm  jae  PI__EXIT
    asm  mov  di, ss:[bx]
    asm  mov  es, ss:[bx+2]
    asm  mov  _bank, bx
    asm  xor  bx, bx
    asm  add  di, x
    asm  jmp  PI__MAIN_LOOP

PI__EXIT:
    asm  pop  ds
PI__END:
}

void flipPage()
{
   TVirtual source;
   word     _write_bank, _shift_bank, _source = FP_OFF(source);

    asm  mov  ax, ss
    asm  mov  es, ax
    asm  mov  di, _source
   _SI = FP_OFF(virtual_buffer);
    asm  mov  cx, MAX_BUFFER * 2
    asm  rep  movsw

    asm  cld
    asm  mov  ax, write_bank
    asm  mov  _write_bank, ax
    asm  mov  ax, shift_bank
    asm  mov  _shift_bank, ax

    asm  mov  dx, CURRENT_BANK
    asm  cmp  dx, 0
    asm  je   FP__SKIP_SET_BANK

    asm  mov  ax, 4F05h
    asm  xor  dx, dx
    asm  mov  bx, _write_bank
    asm  int  10h

   FP__SKIP_SET_BANK:
    asm  push ds

    asm  mov  bx, _source
    asm  mov  ax, 0A000h
    asm  mov  es, ax
    asm  mov  di, 0
    asm  mov  si, ss:[bx]
    asm  mov  ds, ss:[bx+2]
    asm  add  bx, 4

    asm  add  si, MAX_X_LINE*32
    asm  add  di, MAX_X_LINE*32
    asm  mov  cx, 40960 / 4 - MAX_X_LINE*8
    asm  db   66h
    asm  rep  movsw
    asm  mov  si, ss:[bx]
    asm  mov  ds, ss:[bx+2]
    asm  add  bx, 4

    asm  mov  cx, 24576 / 4
    asm  db   66h
    asm  rep  movsw
    asm  mov  ax, 4F05h
    asm  mov  dx, 1
    asm  mov  cx, _shift_bank
    asm  shl  dx, cl
    asm  mov  cx, bx
    asm  mov  bx, _write_bank
    asm  int  10h
    asm  mov  bx, cx

    asm  mov  cx, 16384 / 4
    asm  db   66h
    asm  rep  movsw
    asm  mov  si, ss:[bx]
    asm  mov  ds, ss:[bx+2]
    asm  add  bx, 4

    asm  mov  cx, 40960 / 4
    asm  db   66h
    asm  rep  movsw
    asm  mov  si, ss:[bx]
    asm  mov  ds, ss:[bx+2]
    asm  add  bx, 4

    asm  mov  cx, 8192 / 4
    asm  db   66h
    asm  rep  movsw
    asm  mov  ax, 4F05h
    asm  mov  dx, 2
    asm  mov  cx, _shift_bank
    asm  shl  dx, cl
    asm  mov  cx, bx
    asm  mov  bx, _write_bank
    asm  int  10h
    asm  mov  bx, cx

    asm  mov  cx, 32768 / 4
    asm  db   66h
    asm  rep  movsw
    asm  mov  si, ss:[bx]
    asm  mov  ds, ss:[bx+2]
    asm  add  bx, 4

    asm  mov  cx, 32768 / 4
    asm  db   66h
    asm  rep  movsw
    asm  mov  ax, 4F05h
    asm  mov  dx, 3
    asm  mov  cx, _shift_bank
    asm  shl  dx, cl
    asm  mov  cx, bx
    asm  mov  bx, _write_bank
    asm  int  10h
    asm  mov  bx, cx

    asm  mov  cx, 8192 / 4
    asm  db   66h
    asm  rep  movsw
    asm  mov  si, ss:[bx]
    asm  mov  ds, ss:[bx+2]
    asm  add  bx, 4

    asm  mov  cx, 40960 / 4
    asm  db   66h
    asm  rep  movsw
    asm  mov  si, ss:[bx]
    asm  mov  ds, ss:[bx+2]
    asm  add  bx, 4

    asm  mov  cx, 16384 / 4
    asm  db   66h
    asm  rep  movsw
    asm  mov  ax, 4F05h
    asm  mov  dx, 4
    asm  mov  cx, _shift_bank
    asm  shl  dx, cl
    asm  mov  cx, bx
    asm  mov  bx, _write_bank
    asm  int  10h
    asm  mov  bx, cx

    asm  mov  cx, 24576 / 4
    asm  db   66h
    asm  rep  movsw

    asm  pop  ds
    asm  mov  CURRENT_BANK, 4
FP__EXIT:
}

/* Map Object Definition Begin */

TMap::TMap()
{
   int i, j, k;
   FILE *f;

   if ((f = fopen(MAP_FILE_NAME,"rb")) == NULL) {
      exit(1);
   }

   fread(m_map_data,sizeof(m_map_data),1,f);

   fclose(f);

   for (k = 1; k <= MAX_PERSON; k++)
   for (j = 0; j < MAX_MAP_Y; j++) {
      for (i = 0; i < MAX_MAP_X; i++) {
	 if (readMap(Emap_person,i,j) == person[k]->returnNumber()) {
	    person[k]->setX(i);
	    person[k]->setY(j);
	 }
      }
   }
}

boolean TMap::isUnvalancedMap(int x, int y, byte height)
{
   if ((x >= 0) && (y >= 0) && (x < MAX_MAP_X) && (y < MAX_MAP_Y)) {
      if (readMap(Emap_height,x,y) != height) return TRUE;
   }
   return FALSE;
}

byte  TMap::readMap(TMapAttribute attribute, int x, int y)
{
   byte tile_no;

   if ((x >= 0) && (y >= 0) && (x < MAX_MAP_X) && (y < MAX_MAP_Y)) {
      if (attribute == Emap_tile) {
	 tile_no = m_map_data[y][x][attribute] * 4;
	 if (isUnvalancedMap(x,y-1,readMap(Emap_height,x,y))) tile_no++;
	 if (isUnvalancedMap(x+1,y,readMap(Emap_height,x,y))) tile_no += 2;
      }
      else if ((attribute == Emap_height) || (attribute == Emap_person)) {
	 tile_no = m_map_data[y][x][attribute];
      }
      else tile_no = 0;
   }
   else tile_no = 0;
   return tile_no;
}

void  TMap::writeMap(TMapAttribute attribute, int x, int y, byte value)
{
   if ((x >= 0) && (y >= 0) && (x < MAX_MAP_X) && (y < MAX_MAP_Y)) {
      m_map_data[y][x][attribute] = value;
   }
}

/* Map Object Definition End */

/* Person Object Definition Begin */

TPerson::TPerson(int number)
{
   m_number = number;
   m_x = 0;
   m_y = 0;
   m_face = 0;
   m_face_count = 0;
}

void  TPerson::setParameter(const char *name, int HP, int SP, int level, int exp)
{
   *m_name = *name;
   m_hit_point = HP;
   m_spell_point = SP;
   m_level = level;
   m_experience = exp;
}

char *TPerson::returnCharaTile()
{
   return object_data[(m_number-1)*PERSON_FRAME+m_face+m_face_count*4];
}

void  TPerson::moveXY(int x1, int y1)
{
   if (y1 < 0) m_face = 2;
   if (y1 > 0) m_face = 1;
   if (x1 < 0) m_face = 0;
   if (x1 > 0) m_face = 3;
   m_face_count++;
   m_face_count %= 2;

   if ((m_x+x1 < 0) || (m_y+y1 < 0) || (m_x+x1 >= MAX_MAP_X) || (m_y+y1 >= MAX_MAP_Y)) return;

   map->writeMap(Emap_person,m_x,m_y,0);
   if (map->readMap(Emap_height,m_x,m_y) + 2 >= map->readMap(Emap_height,m_x+x1,m_y+y1)) {
      m_x += x1;
      m_y += y1;
      if ((map->readMap(Emap_person,m_x,m_y) >= 1) &&
	  (map->readMap(Emap_person,m_x,m_y) <= MAX_PERSON)) {
	 if (m_number == MAIN_CHARACTER) {
	    person[map->readMap(Emap_person,m_x,m_y)]->moveXY(-x1,-y1);
	 }
	 else {
	    m_x -= x1;
	    m_y -= y1;
	 }
      }
   }
   map->writeMap(Emap_person,m_x,m_y,m_number);
}

void  TPerson::warpXY(int x, int y)
{
   if ((x < 0) || (y < 0) || (x >= MAX_MAP_X) || (y >= MAX_MAP_Y)) return;
   if ((m_x >= 0) && (m_y >= 0) && (m_x < MAX_MAP_X) && (m_y < MAX_MAP_Y)) {
      if (map->readMap(Emap_person,m_x,m_y) == 0) {
	 map->writeMap(Emap_person,m_x,m_y,0);
      }
   }
   m_x = x; m_y = y;
   map->writeMap(Emap_person,m_x,m_y,m_number);
}

int   TPerson::doAction()
{
   int  i, j, k, x1, y1, key_code;
   FILE *f;

   if (m_number == MAIN_CHARACTER) {
      key_code = getKey();
      switch (key_code) {
	 case _UP_KEY    : moveXY(0,-1); break;
	 case _DOWN_KEY  : moveXY(0, 1); break;
	 case _LEFT_KEY  : moveXY(-1,0); break;
	 case _RIGHT_KEY : moveXY( 1,0); break;
      }
   }
   else {
      x1 = sign(person[MAIN_CHARACTER]->returnX() - returnX());
      y1 = sign(person[MAIN_CHARACTER]->returnY() - returnY());
      if ((x1 != 0) && (y1 != 0)) {
	 if (random(2) == 0) x1 = 0; else y1 = 0;
      }
      moveXY(x1,y1);
   }
   return key_code;
}

/* Person Object Definition End */

void drawScroll()
{
   const X_BOUNDARY = (MAX_X_LINE-TILE_X_HALF) - (MAX_X_LINE-TILE_X_HALF) % TILE_X_HALF;

   byte _number, _height, _person;
   int  x, y, z, wide;
   int  map_x, map_y, x_axis, y_axis;

   clearDevice(0);

   map_x = person[MAIN_CHARACTER]->returnX();
   map_y = person[MAIN_CHARACTER]->returnY();

   map_x += 3; map_y += 7;

   wide = 0;
   for (y = -MAP_SQ_WIDE; y <= MAP_SQ_WIDE; y++) {
      x_axis = (y + wide)*TILE_X_HALF + MAP_X_CENTER;
      y_axis = (y - wide)*TILE_Y_HALF + MAP_Y_CENTER;
      for (x = wide; x >= -wide; x--) {
	 if (x_axis < MAX_X_LINE-TILE_X_SIZE) {
	    _number = map->readMap(Emap_tile,map_x+x,map_y+y);
	    _height = map->readMap(Emap_height,map_x+x,map_y+y);
	    _person = map->readMap(Emap_person,map_x+x,map_y+y);
	    for (z = 0; z <= _height; z++) {
	       if (x_axis >= 0 && x_axis < X_BOUNDARY && y_axis >= (z*13) && y_axis < 440)
	       putImage(x_axis,y_axis-z*13,tile_data[_number]);
	    }
	    if ((_person > 0) && (_person <= MAX_PERSON)) {
	       putImage(x_axis+5,y_axis-z*13-35,person[_person]->returnCharaTile());
	    }
	 }
	 x_axis -= TILE_X_HALF;
	 y_axis += TILE_Y_HALF;
      }
      if (y < 0) wide++; else wide--;
   }

   memset(virtual_buffer[0],0,MAX_X_LINE*32);
   bar(0,0,TILE_X_HALF,BUFFER_LINE*MAX_BUFFER,0);
   bar(X_BOUNDARY,0,TILE_X_HALF,BUFFER_LINE*MAX_BUFFER,0);

   flipPage();

}

long getCurrentTime()
{
    long temp_longint;
    word minute, second, sec100;

     asm  mov  ah, 2Ch
     asm  int  21h
     asm  xor  ah, ah
     asm  mov  al, DL
     asm  mov  sec100, ax
     asm  mov  al, Dh
     asm  mov  second, ax
     asm  mov  al, CL
     asm  mov  minute, ax

   temp_longint = (long)minute * 60L + (long)second * 100L + (long)sec100;
   return temp_longint;
}

void initializeProgram()
{
   FILE *f;
   int  i, j, k;
   word image_size;
   char *pb;

   for (i = 0; i <    MAX_TILE; i++) tile_data[i]   = NULL;
   for (i = 0; i <   MAX_CHARA; i++) object_data[i] = NULL;
   for (i = 1; i <= MAX_PERSON; i++) person[i]      = NULL;

   for (i = 1; i <= MAX_PERSON; i++) {
      if ((person[i] = new TPerson(i)) == NULL) {
	 occurError("Person Allocation Error");
      }
   }

   person[1]->setParameter("Aaa",100,100,10,5000);
   i = 2;
   if (MAX_PERSON >= i)
      person[i]->setParameter("a", 20, 20, 3,500);
   i = 3;
   if (MAX_PERSON >= i)
      person[i]->setParameter("Aaa", 50, 80, 5,2000);

   for (i = 0; i < MAX_BUFFER; i++) {
      if ((virtual_buffer[i] = (char *)malloc(BUFFER_LENGTH)) == NULL) {
	 occurError("Virtual Buffer Allocation Error");
      }
   }
   clearDevice(0);

   if ((f = fopen(GRAPHIC_DATA_FILE,"rb")) == NULL) {
      occurError("File not found.");
   }

   fread(&palette_data,sizeof(palette_data),1,f);

   for (i = 0; i < MAX_TILE; i++) {
      fread(&j,2,1,f);
      tile_data[i] = (char *)malloc(j+2);
      memmove(tile_data[i],&j,2);
      fread(tile_data[i]+2,j,1,f);
   }
   for (i = 0; i < MAX_CHARA; i++) {
      fread(&j,2,1,f);
      object_data[i] = (char *)malloc(j+2);
      memmove(object_data[i],&j,2);
      fread(object_data[i]+2,j,1,f);
   }

   fclose(f);

   map = new TMap();

   initGraph();

   outportb(0x3C8,0);
   for (i = 0; i < 256; i++) {
      outportb(0x3C9,palette_data[i]._RED);
      outportb(0x3C9,palette_data[i]._GREEN);
      outportb(0x3C9,palette_data[i]._BLUE);
   }

}

void closeProgram()
{
   int i;

   closeGraph();
   printf("* VIDEO write bank : %d\n",write_bank);
   printf("* VIDEO read  bank : %d\n",read_bank);
   printf("* VIDEO shift bank : %d\n\n",shift_bank);
   printf("o Average Flipping : %f\n",(float)counter * 100 / (float)start_time);
   delete map;
   for (i = 0; i < MAX_BUFFER; i++) free(virtual_buffer[i]);

}

void main()
{
   int i, j, code;
   FILE *f;

   initializeProgram();

   start_time = getCurrentTime();
   do {
      drawScroll();
      if (pressedKey)
      for (i = 1; i <= MAX_PERSON; i++) {
	 if (i == MAIN_CHARACTER)
	    code = person[i]->doAction();
	 else
	    person[i]->doAction();
      }
      counter++;
   } while (code != _ESC_KEY);
   start_time = getCurrentTime() - start_time;

   closeProgram();

}
