//
//  Sample CMergeFile class
//
//  Program by LEE WON HEE (GGUMTL)
//

#include "Xrainbow.h"
#include "mfile.h"

CMergeFile::CMergeFile(char *file/* = NULL */)
{
        merge_fp           = NULL;
        dwMergeNum         = 0L;
        lCurrentStartPtr   = 0L;
        lCurrentEndPtr     = 0L;
        lFileLength        = 0L;
	if(file) OpenMergeFile(file);
}

CMergeFile::~CMergeFile()
{
	CloseMergeFile();
}

BOOL CMergeFile::OpenMergeFile(char *file)
{
	merge_fp = fopen(file,"rb");
	if(merge_fp == NULL) return FALSE;

	fread(&dwMergeNum,sizeof(dwMergeNum),1,merge_fp);
	return TRUE;
}

void CMergeFile::CloseMergeFile()
{
	if(merge_fp)
	{
		fclose(merge_fp);
		merge_fp = NULL;
	}
	dwMergeNum = 0L;
}

long CMergeFile::GetFilePtr(char *file)
{
    	DWORD start;
	DWORD length;
	char  temp[14];

	if(!dwMergeNum) return 0L;

	strlwr(file);
	fseek(merge_fp,sizeof(DWORD),SEEK_SET); // dwMergeNum

	start = ((13L + sizeof(DWORD)) * dwMergeNum) + 4L;
	DWORD ptr   = 0L;

	for(int i = 0; i<dwMergeNum;i++)
	{
		fread(temp,13,1,merge_fp);
		fread(&length,sizeof(length),1,merge_fp);
		if(!strncmp(file,temp,strlen(file)))
		{
			lCurrentStartPtr = start + ptr;
			lCurrentEndPtr   = lCurrentStartPtr + length;
			lFileLength      = length;

			return SeekStart();
		}
		ptr += length;
	}

	return 0L;
}

long CMergeFile::GetLength()
{
	return lFileLength;
}

long CMergeFile::SeekStart()
{
	fseek(merge_fp,lCurrentStartPtr,SEEK_SET);
	return lCurrentStartPtr;
}

long CMergeFile::SeekEnd()
{
	fseek(merge_fp,lCurrentEndPtr,SEEK_SET);
	return lCurrentEndPtr;
}

BOOL CMergeFile::FileOpen(char *file)
{
	if(!dwMergeNum)
	{
		merge_fp = fopen(file,"rb");
		if(merge_fp == NULL) return FALSE;

		lFileLength      = filelength(fileno(merge_fp));
		lCurrentEndPtr   = lFileLength;
		lCurrentStartPtr = 0L;
		return TRUE;
	}
	return (BOOL)GetFilePtr(file);
}

void CMergeFile::FileClose()
{
	if(dwMergeNum) return;
	fclose(merge_fp);
}

BOOL CMergeFile::LoadFile(char *file,LPSPRITE lpSpr)
{
	PCXHEAD   P;
	BYTE      count;
	WORD      c;
	char      *data;
	DWORD     size,count_size = 0L;

	// file open
	if(!FileOpen(file)) return FALSE;

	// read pcxhead
	fread(&P,sizeof(PCXHEAD),1,merge_fp);

	if(P.Version != 5)
	{
		FileClose();
		return FALSE;
	}

	// pelette
	SeekEnd();
	fseek(merge_fp,-768L,SEEK_CUR);
	for(c=0;c<256;c++)
	{
		R[c] = getc(merge_fp)>>2;
		G[c] = getc(merge_fp)>>2;
		B[c] = getc(merge_fp)>>2;
	}
	SetRgb(0,256,1);

	lpSpr->nWidth  = P.Xmax - P.Xmin+1;
	lpSpr->nHeight = P.Ymax - P.Ymin+1;
	size           = (long)lpSpr->nWidth * lpSpr->nHeight;

	lpSpr->pData   = (char *) malloc(size);
	if(lpSpr->pData==NULL)
	{
		FileClose();
		return FALSE;
	}

	data = lpSpr->pData;

	// image data
	SeekStart();
	fseek(merge_fp,sizeof(PCXHEAD),SEEK_CUR);
	do {
		count = getc(merge_fp);
		if(0xc0==(0xc0&count))
		{
			count=0x3f&count;
			c = getc(merge_fp);

		}else
		{
			c=count;
			count=1;
		}
		count_size+=count;
		if(count_size>size) break;
		while(count--) { *data++ = c;}
	}while(1);

	// file colse
	FileClose();

	return TRUE;
}

