/*

	Xrainbow Library 2.0

	Source Code : Watcom C++ 10.0 , TASM 3.1

	Compiler option : WCL386 -3r -mf -ox -w4

	Program by LEE WON HEE (GGUMTL)

*/

#ifndef __XRAINBOW_H
#define __XRAINBOW_H

#if !defined(__FLAT__) && !defined(__WATCOMC__)
	#error "This program is run in WATCOM C FLAT memory mode."
#endif

#ifndef _DOS_H_INCLUDE
	#include <dos.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*
 *	define
 */

#define RP_SEG(A)               ((unsigned)A>>4)// real mode get seg
#define RP_OFF(A)               ((unsigned)A&15)// real mode get offest

#define FALSE                   0
#define TRUE                    1

#define MAX_COLOR               256
#define MAXLIGHT                32

#define	M_EXEC                  1000
#define	M_ENTER                 2000
#define	M_ESC                   3000

#define _ESC                    1
#define _1                      2
#define _2                      3
#define _3                      4
#define _4                      5
#define _5                      6
#define _6                      7
#define _7                      8
#define _8                      9
#define _9                      10
#define _0                      11
#define _MINUS                  12
#define _EQUAL                  13
#define _BACKSP                 14
#define _Q                      16
#define _W                      17
#define _E                      18
#define _R                      19
#define _T                      20
#define _Y                      21
#define _U                      22
#define _I                      23
#define _O                      24
#define _P                      25
#define _LPAREN                 26
#define _RPAREN                 27      /* ] */
#define _A                      30
#define _S                      31
#define _D                      32
#define _F                      33
#define _G                      34
#define _H                      35
#define _J                      36
#define _K                      37
#define _L                      38
#define _SEMI                   39       /*  ; */
#define _QUATO                  40       /*  ' */
#define _BSLASH                 43       /*  \ */
#define _Z                      44
#define _X                      45
#define _C                      46
#define _V                      47
#define _B                      48
#define _N                      49
#define _M                      50
#define _COMMA                  51       /*  , */
#define _DOT                    52       /*  . */
#define _SLASH                  53       /*  / */
#define _SPACEBAR               57
#define _F1                     59
#define _F2                     60
#define _F3                     61
#define _F4                     62
#define _F5                     63
#define _F6                     64
#define _F7                     65
#define _F8                     66
#define _F9                     67
#define _F10                    68
#define _RET                    28
#define _TAB                    15
#define _LSHIFT                 42
#define _RSHIFT                 54
#define _LCTRL                  29
#define _RCTRL                  29
#define _LALT                   56
#define _RALT                   56
#define _HOME                   71
#define _PGUP                   73
#define _END                    79
#define _PGDN                   81
#define _INS                    82
#define _DEL                    83
#define _NUMLOCK                69
#define _CAPLOCK                58
#define _SCRLOCK                70
#define _UP                     72
#define _DOWN                   80
#define _LEFT                   75
#define _RIGHT                  77
#define _5_                     76
#define _PLUS                   78

#define kbhit()                 _KBHIT

#define TIMER_120HZ             0x26D7
#define TIMER_100HZ             0x2E9B
#define TIMER_60HZ              0x4DAE
#define TIMER_50HZ              0x5D37
#define TIMER_40HZ              0x7486
#define TIMER_30HZ              0x965C
#define TIMER_20HZ              0xE90B
#define TIMER_18HZ              0xFFFF

#ifndef _STDLIB_H_INCLUDED
	#include <stdlib.h>
#endif

#define inportb(A)              inp(A)
#define outportb(A,B)           outp(A,B)
#define random(num)             (int)(((long)rand()*(num))/(RAND_MAX+1))

#define FALSE                   0
#define	TRUE                    1

#define Swap(A,B) {A^=B; B^=A; A^=B; }

typedef signed int              BOOL;
typedef unsigned char           BYTE;
typedef unsigned short          WORD;
typedef unsigned int            UINT;
typedef signed long             LONG;
typedef unsigned long           DWORD;
typedef unsigned char           COLOR;

enum FONT_PATTERN
{
	NORMAL_PATTERN = 0,
	INC16_PATTERN,
	DEC16_PATTERN,
	INC8_PATTERN,
	DEC8_PATTERN,
	DECINC_PATTERN,
	INCDEC_PATTERN,
};

enum FONT_FILE_TYPE
{
	HANGUL_FNT,
	ENGLISH_FNT,
};

enum RESOLUTION_MODE
{
	R640x400 = 0,
	R640x480,
	R800x600,
	R1024x768,
	R320x200,
};

enum PUT_IMAGE_FLAG
{
	COPY_PUT = 0x01,
	SPRITE_PUT = 0x02,
	SHADOW_PUT = 0x04,
	SHADOWOBJ_PUT = 0x10,
	FREE_PUT = 0x08        // | FREE_PUT
};

enum SVGA_BANKING
{
	 AUTODETECT=-1,
	 VESA=0,      		//ax=0x4f02 bx=mode;   //10
	 TRIDENT,
	 ATI,
	 ET4000,
	 WDC,
	 VIDEO7,    		//ax=0x6f05 bx=mode;
	 CHIPS_TECH,
	 OAK,
	 AHEADA,
	 AHEADB,
	 EVEREX,    		//ax=0x70   bx=mode;
	 GENOA,
	 CIRRUS,
	 ET3000,
	 ET4000W32,  		// Extended
	 VTEXT//
};

enum SURFACE_TYPE
{
	BANK_SURFACE,
	PACK_SURFACE,
};

enum PIC_FILE_FLAG
{
	AUTO_FILE = 0,
	PAL_LOAD =  0x01,
	PAL_SET =  0x02,
	PCX_FILE = 0x80,
	GIF_FILE = 0x40,
	BMP_FILE = 0x20,
	RAW_FILE = 0x10,
};

enum MOUSE_EVENT
{
	LEFT_BUTTON = 0x01,
	RIGHT_BUTTON = 0x02,
};

typedef struct
{
	int nWidth;
	int nHeight;
	char *pData;
}SPRITE,*LPSPRITE;

typedef struct
{
	int xPos;
	int yPos;
}POINT,*LPPOINT;

typedef struct
{
	int xPos;
	int yPos;
	int xxPos;
	int yyPos;
}RECT,*LPRECT;

typedef struct {
	long  size;
	WORD  type;
	short frames;
	short width,height;
	short depth;
	short flags;
	long  speed;
	char  reservedl[18];
	short aspectx,aspecty;
	char  reserved2[38];
	long  oframel,oframe2;
	char  reserved3[40];
}FLICHEAD,*LPFLICHEAD;

typedef struct {
	FLICHEAD head;
	short handle;
	short frame;
	char  *name;
	int   xoff,yoff;
	short frame_state;
	char  *FrameBuff;
	BYTE  opt;
	WORD  tick;
}FLIC,*LPFLIC;

typedef struct tagBITMAPINFOHEADER
{
	DWORD   biSize;            // Size of the structure
	LONG    biWidth;           // Width in Pixels
	LONG    biHeight;          // Height in Pixels
	WORD    biPlanes;          // Set to 1
	WORD    biBitCount;        // Color bits per pixel
	DWORD   biCompression;     // Compression scheme
	DWORD   biSizeImage;       // Number of Bitmap bytes
	LONG    biXPelsPerMeter;   // Horizontal resolution
	LONG    biYPelsPerMeter;   // Vertical resolution
	DWORD   biClrUsed;         // Number of colors Used
	DWORD   biClrImportant;    // Important colors
} BITMAPINFOHEADER ,*LPBITMAPINFOHEADER;

typedef struct {
	short	width,height;
}GIFINFO,*LPGIFINFO;

typedef struct {
	char  Manufacturer;
	char  Version;
	char  Encode;
	char  BitPerPixel;
	short Xmin;
	short Ymin;
	short Xmax;
	short Ymax;
	short Hres;
	short Vres;
	char  RGB_Palette[48];
	char  Reserved;
	char  ColorPlanes;
	short BytePerLine;
	short PaletteType;
	char  Filler[58];
}PCXHEAD,*LPPCXHEAD;

typedef struct tagMOUSEINFO
{
	DWORD nEvent;
	int xPos,yPos;
	int nInstall;
	RECT Crash;
}MOUSEINFO,*LPMOUSEINFO;

typedef struct tagVitrualPage
{
	int   nSurface;
	int   nMaxx,nMaxy;
	DWORD dwSize;
	char  *pData;
	int   nWidth,nHeight;
	RECT  Clip;
	DWORD *dwAddrTable;
	char  *CHBANK_LINE;
	char  *OVER_FLOW;
	int   nCenterV,nCenterH;
}SURFACE, *LPSURFACE;

typedef struct
{
	int  nLevel;
	char *pTable[MAXLIGHT+1];
}LIGHTTABLE,*LPLIGHTTABLE;

/* extern variables */
extern char *SVGA_ADDR;
extern char *OVER_FLOW;
extern char *CHBANK_LINE;
extern LPSURFACE lpActSurface;

extern BYTE _KEY[128];
extern BYTE _KBHIT;
extern char R[256],G[256],B[256];
extern DWORD FRAME_RATE;

/*
 * 	Xga
 */

int  GetRandom(int nMin,int nMax);
BOOL Crash(int xPos,int xxPos,int yPos,int yyPos,int xPos2,int xxPos2,
		int yPos2,int yyPos2);
void PassXY(int xPos,int yPos,int xxPos,int yyPos,int *pXadd,
	int *pYadd, int speed);

void InitXrainbow(int nMode,int nVga,LPSURFACE lpPage);
void CloseXrainbow();
BOOL ChangeResolution(int nMode,LPSURFACE lpPage);
void SetVideoMode(WORD _ax,WORD _bx);

LPRECT GetViewPortPoint();
void GetViewPort(LPRECT lpRect);
void SetViewPort(LPRECT lpRect);
void ClearViewPort();

BOOL CreateSurface(int nWidth,int nHeight,LPSURFACE lpPage);
void DestroySurface(LPSURFACE lpPage);

void WaitVsync2();
void WaitVsync();

LPSURFACE GetActiveSurface();
void SetActiveSurface(LPSURFACE lpActPage);

int  GetMaxx();
int  GetMaxy();
int  GetClipX();
int  GetClipY();
int  GetClipXx();
int  GetClipYy();

char *GetSurfacePageAddr(LPSURFACE lpPage);
char *GetFarAddr(int xPos,int yPos);

void PgetsImage(int xPos,int yPos,char *pImg,int nWidth);
void PsetsImage(int xPos,int yPos,char *pData,int nWidth);

void PutPixel(int xPos,int yPos,COLOR color);
COLOR GetPixel(int xPos,int yPos);
void LineV (int xPos,int yPos,int yyPos,COLOR color);
void LineH (int xPos,int xxPos,int yPos,COLOR color);
void Line(int xPos,int yPos,int xxPos,int yyPos,COLOR color);
void PolyLine(POINT P[],int nNum,COLOR color);
void BoxFill(int xPos,int yPos,int xxPos,int yyPos,COLOR color);
void Box(int xPos,int yPos,int xxPos,int yyPos,COLOR color);
void Clrscr(COLOR color);
void CircleFill(int xPos,int yPos,int nR,COLOR color);
void Circle(int xPos,int yPos,int nR,COLOR color);
void Triangle(int xPos,int yPos,int xxPos,int yyPos,
		int xxxPos,int yyyPos,COLOR color);

void FullViewSurface(LPSURFACE lpPage);// No clipping
void ViewSurface(LPSURFACE lpPage);
void ViewSurfaceXy(int xPos,int yPos,LPSURFACE lpPage);
void CopySurface(LPSURFACE lpDest,LPSURFACE lpSour);

BOOL GetImage(int xPos,int yPos,int xxPos, int yyPos,LPSPRITE lpSpr);
void PutImage(int xPos,int yPos,LPSPRITE lpSpr,WORD opt);
void FreeImage(LPSPRITE lpSpr);

/* There functions were made "PACK_SURFACE" mode only can display */
void PutSpritePack(int xPos,int yPos,LPSPRITE lpSpr);// asm
void PutImagePack(int xPos,int yPos,LPSPRITE lpSpr);// asm
void PutTilePack(int xPos,int yPos,LPSPRITE lpSpr);// asm
void PutImagePackNoClip(int xPos,int yPos,LPSPRITE lpSpr);// asm

void PutOutLineSpritePack(int xPos,int yPos,COLOR color,LPSPRITE lpSpr);
void PutSpritePackNoClip(int xPos,int yPos,LPSPRITE lpSpr);
void PutShadowSpritePack(int xPos,int yPos,int nLevel,LPSPRITE lpSpr);
void PutShadowSpriteObjPack(int xPos,int yPos,LPSPRITE lpSpr);
void PutScaleImagePack(int xPos,int yPos,int xRate,int yRate,LPSPRITE lpSpr);

/*
 * Palette
 */

LPLIGHTTABLE GetActiveLightTable();
void SetActiveLightTable(LPLIGHTTABLE lpLight);
void DestroyLightTable(LPLIGHTTABLE lpLight);
BOOL CreateLightTable(int nRed,int nGreen,int nBlue,LPLIGHTTABLE lpLight);

BYTE SearchNearPal(BYTE r,BYTE g, BYTE b);
void SetPalette(char *palette);
void GetRgb();
void SetRgb(int start,int end,WORD MODE );
void Fade(int x,int y,int Ct1);
BOOL ReadPal(char *szName);
BOOL WritePal(char *szName);
BOOL WriteLightTable(char *szName,LPLIGHTTABLE lpLight);
BOOL ReadLightTable(char *szName,LPLIGHTTABLE lpLight);
void FadeIn();
void FadeOut();
void RotatePalette(int nStart,int nEnd);

/*
 * Pic ( bmp , pcx , pcx , raw ) Animation ( flc , fli)
 */

BOOL ViewPic(int xPos,int yPos,char *szName,WORD opt);
BOOL GetPicSprite(LPSPRITE lpSpr,char *szName,WORD opt);
BOOL GetPicInfo(void *lpInfoStruct,char *szName,WORD opt);
BOOL WritePicFile(LPSPRITE lpSpr,char *szName,WORD opt);// bmp , raw(No palette)

void  RepeatFlic(LPFLIC lpFlic);
short FlicNextFrame(LPFLIC lpFlic);
short FlicPlay(int xPos,int yPos,LPFLIC lpFlic,char *fname,WORD opt);
void  CloseFlic(LPFLIC lpFlic);

/*
 *	Mouse & Key & Vect
 */

BOOL InitXrainbowMouse(LPMOUSEINFO lpMouse);
LPMOUSEINFO GetMouseInfo();
void MouseMoveCursor(short xPos,short yPos);
void MouseXyRange(LPRECT lpRect);
void MouseReleased();
void ShowMouseCursor();//Only 320 * 200 pack mode
void HideMouseCursor();//Only 320 * 200 pack mode
void SetMouseCrashRect(LPRECT lpRect);
BOOL MouseCrash(int xPos,int yPos,int xxPos,int yyPos);
BOOL MouseCrashRect(LPRECT lpRect);

DWORD GetClockTick();
void SystemDelay();
int  KeyWait();
int  GetKey();
void SetSystemDelay(WORD rate);
void DelayTime(DWORD tick);
void InitializeVect();
void CloseVect();

/*
 * 	Hangul & english
 */

BOOL LoadFont(char *pFile,WORD wType);
BOOL InitXrainbowFont(char *pHan,char *pEng);
int  PutsHan(int xPos,int yPos,COLOR color,char *pStr);
void SetFontPattern(int nPattern);
void SetFontWidth(int nHangul,int nEnglish,int nSpace);

/*
	Inline assembler
*/

extern void _Memcpy(char *des,char *sur,long size);
#pragma aux _Memcpy  = "XOR   EDX,EDX"\
		   "MOV   DL,CL"\
		   "AND   DL,3"\
		   "SHR   ECX,2"\
		   "REP   MOVSD"\
		   "MOV   ECX,EDX"\
		   "REP   MOVSB"\
		   parm  [EDI] [ESI] [ECX] modify [EDX];

extern void _Memcpy4(char *des,char *sur,long size);
#pragma aux _Memcpy4  ="SHR   ECX,2"\
			"REP   MOVSD"\
			parm  [EDI] [ESI] [ECX];

extern void _Memset(char *des,DWORD set,long size);
#pragma aux _Memset  = "MOV   AH,AL"\
			"PUSH  AX"\
			"SHL   EAX,16"\
			"POP   AX"\
			"XOR   EDX,EDX"\
			"MOV   DL,CL"\
			"AND   DL,3"\
			"SHR   ECX,2"\
			"REP   STOSD"\
			"MOV   ECX,EDX"\
			"REP   STOSB"\
			parm  [EDI] [EAX] [ECX] modify [EDX];

extern void _Memset4Ex(DWORD *des,DWORD set,long size);
#pragma aux _Memset4Ex= "REP   STOSD"\
			parm  [EDI] [EAX] [ECX];

extern void _Memset4(char *des,DWORD set,long size);
#pragma aux _Memset4=	"SHR	ECX,2"\
			"REP    STOSD"\
			parm  [EDI] [EAX] [ECX];



#ifdef __cplusplus
}
#endif

#endif

