{$D-,E+,G+,L-,N+,O+,S-,X+}

Unit M13HP;

Interface

Type
  PaletteStyle = Array [ 0..255, 0..  2 ] of Byte;
  PageType     = Array [ 0..199, 0..319 ] of Byte;
  PageStyle    = ^PageType;

Var
  Screen       : PageStyle;

Procedure InitGraph;
Procedure CloseGraph;
Function  MakePage   ( Var Page : PageStyle ) : Boolean;
Function  DeletePage ( Var Page : PageStyle ) : Boolean;
Procedure ClearPage  (     Page : PageStyle; Color : Byte );
Procedure PageCopy ( Page1, Page2 : PageStyle );
Procedure PutPixel ( Page : PageStyle; X, Y : Integer; Color : Byte );
Function  GetPixel ( Page : PageStyle; X, Y : Integer ) : Byte;
Procedure DrawHLine ( Page : PageStyle; X1, X2, Y : Integer; Color : Byte );
Procedure DrawVLine ( Page : PageStyle; X, Y1, Y2 : Integer; Color : Byte );
Procedure DrawLine ( Page : PageStyle; X1, Y1, X2, Y2 : Integer; Color : Byte );
Procedure DrawBox  ( Page : PageStyle; X1, Y1, X2, Y2 : Integer; Color : Byte );
Procedure DrawFillBox ( Page : PageStyle;
                        X1, Y1, X2, Y2 : Integer; Color : Byte );
Procedure DrawCircle ( Page : PageStyle; X, Y, Radius : Integer; Color : Byte );
Procedure DrawFillCircle ( Page : PageStyle;
                           X, Y, Radius : Integer; Color : Byte );
Function  ImageSize ( X1, Y1, X2, Y2 : Integer ) : Word;
Procedure GetImage ( Page : PageStyle; X1, Y1, X2, Y2 : Integer; Var Get );
Procedure PutImage ( Page : PageStyle; X, Y : Integer; Var Put; Except : Integer );
Procedure SetAllPalette ( Var PS : PaletteStyle );
Procedure GetAllPalette ( Var PS : PaletteStyle );
Procedure SetPalette ( Number : Byte;     R, G, B : Byte );
Procedure GetPalette ( Number : Byte; Var R, G, B : Byte );

Implementation

Procedure InitGraph; Assembler;

Asm
  XOR             AH,            AH
  MOV             AL,           13H
  INT            10H
End;


Procedure CloseGraph; Assembler;

Asm
  XOR             AH,            AH
  MOV             AL,           03H
  INT            10H
End;


Function MakePage;

Begin
  IF ( MaxAvail <= Sizeof ( PageType ) )
    Then MakePage := False
    Else
      Begin
        New ( Page );
        Asm
          CLD
          LES             DI,          Page
          MOV             AX,     ES:[DI+2]
          MOV             DX,       ES:[DI]
          MOV             ES,            AX
          MOV             DI,            DX
          DB             66H
          XOR             AX,            AX
          MOV             CX,         3E80H
          REP
          DB             66H
          STOSW
        End;
        MakePage := True
      End
End;


Function DeletePage;

Begin
  IF ( Page <> Nil )
    Then
      Begin
        Dispose ( Page );
        Page := Nil;
        DeletePage := True
      End
    Else DeletePage := False
End;


Procedure PageCopy; Assembler;

Asm
  CLD
  PUSH            DS
  LDS             SI,         Page1
  LES             DI,         Page2
  MOV             CX,         3E80H
  REP
  DB             66H
  MOVSW
  POP             DS
End;


Procedure ClearPage; Assembler;

Asm
  CLD
  LES             DI,          Page
  MOV             DL,         Color
  MOV             DH,            DL
  MOV             AX,            DX
  DB             66H
  SHL             AX,           10H
  MOV             AX,            DX
  MOV             CX,         3E80H
  REP
  DB             66H
  STOSW
End;


Procedure PutPixel; Assembler;

Asm
  CMP              X,         0140H
  JNB          @Exit
  CMP              Y,         00C8H
  JNB          @Exit
  LES             DI,          Page
  MOV             AX,             Y
  XCHG            AH,            AL
  ADD             DI,            AX
  SHR             AX,           02H
  ADD             DI,            AX
  ADD             DI,             X
  MOV             AL,         Color
  STOSB
@Exit :
End;


Function GetPixel; Assembler;

Asm
  XOR             AL,            AL
  CMP              X,         0140H
  JNB          @Exit
  CMP              Y,         00C8H
  JNB          @Exit
  LES             DI,          Page
  MOV             AX,             Y
  XCHG            AH,            AL
  ADD             DI,            AX
  SHR             AX,           02H
  ADD             DI,            AX
  ADD             DI,             X
  MOV             AL,       ES:[DI]
@Exit :
End;


Procedure DrawHLine; Assembler;

Asm
  CMP              Y,         00C8H
  JNB          @Exit
  CMP             X1,         0140H
  JB           @NCX1
  MOV             X1,         013FH
@NCX1 :
  CMP             X2,         0140H
  JB           @NCX2
  MOV             X2,         013FH
@NCX2 :
  MOV             DX,            X2
  CMP             X1,            DX
  JLE          @NECX
  MOV             AX,            X1
  MOV             X1,            DX
  MOV             X2,            AX
@NECX :
  CLD
  LES             DI,          Page
  MOV             AX,             Y
  XCHG            AH,            AL
  ADD             DI,            AX
  SHR             AX,           02H
  ADD             DI,            AX
  ADD             DI,            X1
  MOV             AX,            X2
  SUB             AX,            X1
  INC             AX
  MOV             CX,            AX
  MOV             DL,         Color
  MOV             DH,            DL
  MOV             AX,            DX
  DB             66H
  SHL             AX,           10H
  MOV             AX,            DX
  SHR             CX,           01H
  JNC         @NPutB
  STOSB
@NPutB :
  SHR             CX,           01H
  JNC         @NPutW
  STOSW
@NPutW :
  REP
  DB             66H
  STOSW
@Exit :
End;


Procedure DrawVLine; Assembler;

Asm
  CMP              X,         0140H
  JNB          @Exit
  CMP             Y1,         00C8H
  JB           @NCY1
  MOV             Y1,         00C7H
@NCY1 :
  CMP             Y2,         00C8H
  JB           @NCY2
  MOV             Y2,         00C7H
@NCY2 :
  MOV             DX,            Y2
  CMP             Y1,            DX
  JLE          @NECY
  MOV             AX,            Y1
  MOV             Y1,            DX
  MOV             Y2,            AX
@NECY :
  CLD
  LES             DI,          Page
  MOV             AX,            Y1
  XCHG            AH,            AL
  ADD             DI,            AX
  SHR             AX,           02H
  ADD             DI,            AX
  ADD             DI,             X
  MOV             AX,            Y2
  SUB             AX,            Y1
  INC             AX
  MOV             CX,            AX
  MOV             AL,         Color
@Repeat :
  STOSB
  ADD             DI,         013FH
  LOOP       @Repeat
@Exit :
End;


Procedure DrawLine; Assembler;

Var
  DeltaX, DeltaY : Integer;
  INCX,   INCY   : Integer;
  Count          : Integer;

Asm
  CMP             X1,         0140H
  JNB          @Exit
  CMP             Y1,         00C8H
  JNB          @Exit
  CMP             X1,         0140H
  JNB          @Exit
  CMP             Y1,         00C8H
  JNB          @Exit
  MOV          Count,        0FFFFH
  MOV             AX,            X2
  SUB             AX,            X1
  MOV         DeltaX,            AX
  MOV             AX,            Y2
  SUB             AX,            Y1
  MOV         DeltaY,            AX
  XOR             DX,            DX
@SetDX :
  MOV           INCX,         0001H
  CMP         DeltaX,            DX
  JG          @SetDY
  MOV           INCX,            DX
  JZ          @SetDY
  MOV           INCX,        0FFFFH
  NEG         DeltaX
@SetDY :
  MOV           INCY,         0140H
  CMP         DeltaY,            DX
  JG           @SetD
  MOV           INCY,            DX
  JZ           @SetD
  MOV           INCY,        0FEC0H
  NEG         DeltaY
@SetD :
  MOV             CX,        DeltaY
  MOV             AX,        DeltaX
  CMP             AX,            CX
  JNG       @SetPage
  MOV             CX,            AX
@SetPage :
  LES             DI,          Page
  MOV             AX,            Y1
  XCHG            AH,            AL
  ADD             DI,            AX
  SHR             AX,           02H
  ADD             DI,            AX
  ADD             DI,            X1
  MOV             AL,         Color
  XOR             BX,            BX
@Repeat :
  INC          Count
  MOV        ES:[DI],            AL
  ADD             BX,        DeltaX
  ADD             DX,        DeltaY
@CXET :
  CMP             BX,            CX
  JNG          @CYET
  SUB             BX,            CX
  ADD             DI,          INCX
@CYET :
  CMP             DX,            CX
  JNG        @CRange
  SUB             DX,            CX
  ADD             DI,          INCY
@CRange :
  CMP          Count,            CX
  JNA        @Repeat
@Exit :
End;


Procedure DrawBox; Assembler;

Asm
  CMP             X1,         0140H
  JB           @NCX1
  MOV             X1,         013FH
@NCX1 :
  CMP             Y1,         00C8H
  JB           @NCY1
  MOV             Y1,         00C7H
@NCY1 :
  CMP             X2,         0140H
  JB           @NCX2
  MOV             X2,         013FH
@NCX2 :
  CMP             Y2,         00C8H
  JB           @NCY2
  MOV             Y2,         00C7H
@NCY2 :
  CLD
  MOV             DX,            X2
  CMP             X1,            DX
  JLE          @NECX
  MOV             AX,            X1
  MOV             X1,            DX
  MOV             X2,            AX
@NECX :
  MOV             DX,            Y2
  CMP             Y1,            DX
  JLE          @NECY
  MOV             AX,            Y1
  MOV             Y1,            DX
  MOV             Y2,            AX
@NECY :
  LES             DI,          Page
  MOV             AX,            Y1
  XCHG            AH,            AL
  ADD             DI,            AX
  SHR             AX,           02H
  ADD             DI,            AX
  ADD             DI,            X1
  MOV             AX,            X2
  SUB             AX,            X1
  INC             AX
  MOV             SI,         0140H
  SUB             SI,            AX
  MOV             BX,            AX
  SUB             BX,         0002H
  MOV             CX,            AX
  MOV             DL,         Color
  MOV             DH,            DL
  MOV             AX,            DX
  DB             66H
  SHL             AX,           10H
  MOV             AX,            DX
  SHR             CX,           01H
  JNC        @NPutB1
  STOSB
@NPutB1 :
  SHR             CX,           01H
  JNC        @NPutW1
  STOSW
@NPutW1 :
  REP
  DB             66H
  STOSW
  MOV             CX,            Y2
  SUB             CX,            Y1
  CMP             CX,         0000H
  JE           @Exit
  CMP             CX,         0001H
  JE        @NRepeat
  SUB             CX,         0001H
@Repeat :
  ADD             DI,            SI
  STOSB
  ADD             DI,            BX
  STOSB
  LOOP       @Repeat
@NRepeat :
  ADD             DI,            SI
  MOV             CX,            X2
  SUB             CX,            X1
  INC             CX
  SHR             CX,           01H
  JNC        @NPutB2
  STOSB
@NPutB2 :
  SHR             CX,           01H
  JNC        @NPutW2
  STOSW
@NPutW2 :
  REP
  DB             66H
  STOSW
@Exit :
End;


Procedure DrawFillBox; Assembler;

Asm
  CMP             X1,         0140H
  JB           @NCX1
  MOV             X1,         013FH
@NCX1 :
  CMP             Y1,         00C8H
  JB           @NCY1
  MOV             Y1,         00C7H
@NCY1 :
  CMP             X2,         0140H
  JB           @NCX2
  MOV             X2,         013FH
@NCX2 :
  CMP             Y2,         00C8H
  JB           @NCY2
  MOV             Y2,         00C7H
@NCY2 :
  CLD
  MOV             DX,            X2
  CMP             X1,            DX
  JLE          @NECX
  MOV             AX,            X1
  MOV             X1,            DX
  MOV             X2,            AX
@NECX :
  MOV             DX,            Y2
  CMP             Y1,            DX
  JLE          @NECY
  MOV             AX,            Y1
  MOV             Y1,            DX
  MOV             Y2,            AX
@NECY :
  LES             DI,          Page
  MOV             AX,            Y1
  XCHG            AH,            AL
  ADD             DI,            AX
  SHR             AX,           02H
  ADD             DI,            AX
  ADD             DI,            X1
  MOV             AX,            X2
  SUB             AX,            X1
  INC             AX
  MOV             SI,            AX
  MOV             DX,         0140H
  SUB             DX,            AX
  MOV             AX,            Y2
  SUB             AX,            Y1
  INC             AX
  MOV             BX,            AX
  MOV             CL,         Color
  MOV             CH,            CL
  MOV             AX,            CX
  DB             66H
  SHL             AX,           10H
  MOV             AX,            CX
@Repeat :
  MOV             CX,            SI
  SHR             CX,           01H
  JNC         @NPutB
  STOSB
@NPutB :
  SHR             CX,           01H
  JNC         @NPutW
  STOSW
@NPutW :
  REP
  DB             66H
  STOSW
  ADD             DI,            DX
  DEC             BX
  JNE        @Repeat
End;


Procedure DrawCircle; Assembler;

Var
  Delta : Integer;

Asm
  MOV             DX,        Radius
  CMP             DX,         0000H
  JZ           @Exit
  MOV             AX,             X
  ADD             AX,            DX
  CMP             AX,         0140H
  JA           @Exit
  MOV             AX,             X
  SUB             AX,            DX
  CMP             AX,         0000H
  JL           @Exit
  MOV             AX,             Y
  ADD             AX,            DX
  CMP             AX,         00C8H
  JA           @Exit
  MOV             AX,             Y
  SUB             AX,            DX
  CMP             AX,         0000H
  JL           @Exit
  LES             DI,          Page
  MOV             AX,             Y
  XCHG            AH,            AL
  ADD             DI,            AX
  SHR             AX,           02H
  ADD             DI,            AX
  ADD             DI,             X
  SHL             DX,           01H
  MOV          Delta,         0003H
  SUB          Delta,            DX
  MOV             BX,            DI
  XOR             CX,            CX
@Repeat :
  MOV             AX,         0140H
  MUL         Radius
  MOV             DX,            AX
  MOV             DI,            BX
  ADD             DI,            DX
  ADD             DI,            CX
  MOV             AL,         Color
  MOV        ES:[DI],            AL
  SUB             DI,            CX
  SUB             DI,            CX
  MOV        ES:[DI],            AL
  SUB             DI,            DX
  SUB             DI,            DX
  MOV        ES:[DI],            AL
  ADD             DI,            CX
  ADD             DI,            CX
  MOV        ES:[DI],            AL
  MOV             AX,         0140H
  MUL             CX
  MOV             DX,            AX
  MOV             DI,            BX
  ADD             DI,            DX
  ADD             DI,        Radius
  MOV             AL,         Color
  MOV        ES:[DI],            AL
  SUB             DI,        Radius
  SUB             DI,        Radius
  MOV        ES:[DI],            AL
  SUB             DI,            DX
  SUB             DI,            DX
  MOV        ES:[DI],            AL
  ADD             DI,        Radius
  ADD             DI,        Radius
  MOV        ES:[DI],            AL
  MOV             AX,            CX
  CMP          Delta,         0000H
  JL           @NDec
  SUB             AX,        Radius
  DEC         Radius
@NDec :
  SHL             AX,           02H
  ADD             AX,           08H
  ADD          Delta,            AX
  INC             CX
  CMP             CX,        Radius
  JNA        @Repeat
@Exit :
End;


Procedure DrawFillCircle; Assembler;

Var
  Count : Integer;
  Delta : Integer;
  CClr  : Word;

Asm
  CLD
  MOV             DX,        Radius
  CMP             DX,         0000H
  JZ           @Exit
  MOV             AX,             X
  ADD             AX,            DX
  CMP             AX,         0140H
  JA           @Exit
  MOV             AX,             X
  SUB             AX,            DX
  CMP             AX,         0000H
  JL           @Exit
  MOV             AX,             Y
  ADD             AX,            DX
  CMP             AX,         00C8H
  JA           @Exit
  MOV             AX,             Y
  SUB             AX,            DX
  CMP             AX,         0000H
  JL           @Exit
  LES             DI,          Page
  MOV             AX,             Y
  XCHG            AH,            AL
  ADD             DI,            AX
  SHR             AX,           02H
  ADD             DI,            AX
  ADD             DI,             X
  MOV             BX,            DI
  SHL             DX,           01H
  MOV          Delta,         0003H
  SUB          Delta,            DX
  MOV          Count,         0000H
  MOV             AL,         Color
  MOV             AH,            AL
  MOV           CClr,            AX
@Repeat :
  MOV             AX,         0140H
  MUL         Radius
  MOV             DX,            AX
  MOV             DI,            BX
  ADD             DI,            DX
  SUB             DI,         Count
  MOV             AX,          CClr
  MOV             CX,         Count
  REP          STOSW
  MOV             DI,            BX
  SUB             DI,            DX
  SUB             DI,         Count
  MOV             CX,         Count
  REP          STOSW
  MOV             AX,         0140H
  MUL          Count
  MOV             DX,            AX
  MOV             DI,            BX
  ADD             DI,            DX
  SUB             DI,        Radius
  MOV             AX,          CClr
  MOV             CX,        Radius
  REP          STOSW
  MOV             DI,            BX
  SUB             DI,            DX
  SUB             DI,        Radius
  MOV             CX,        Radius
  REP          STOSW
  MOV             AX,         Count
  CMP          Delta,         0000H
  JL           @NDec
  SUB             AX,        Radius
  DEC         Radius
@NDec :
  SHL             AX,           02H
  ADD             AX,           08H
  ADD          Delta,            AX
  MOV             AX,        Radius
  INC          Count
  CMP          Count,            AX
  JNA        @Repeat
@Exit :
End;


Function ImageSize; Assembler;

Asm
  CMP             X1,         0140H
  JB           @NCX1
  MOV             X1,         013FH
@NCX1 :
  CMP             Y1,         00C8H
  JB           @NCY1
  MOV             Y1,         00C7H
@NCY1 :
  CMP             X2,         0140H
  JB           @NCX2
  MOV             X2,         013FH
@NCX2 :
  CMP             Y2,         00C8H
  JB           @NCY2
  MOV             Y2,         00C7H
@NCY2 :
  MOV             AX,            Y2
  SUB             AX,            Y1
  TEST            AX,         8000H
  JZ            @NCY
  NEG             AX
@NCY :
  INC             AX
  MOV             DX,            X2
  SUB             DX,            X1
  TEST            DX,         8000H
  JZ            @NCX
  NEG             DX
@NCX :
  INC             DX
  MUL             DX
  ADD             AX,         0004H
End;


Procedure GetImage; Assembler;

Asm
  CLD
  PUSH            DS
  CMP             X1,         0140H
  JB           @NCX1
  MOV             X1,         013FH
@NCX1 :
  CMP             Y1,         00C8H
  JB           @NCY1
  MOV             Y1,         00C7H
@NCY1 :
  CMP             X2,         0140H
  JB           @NCX2
  MOV             X2,         013FH
@NCX2 :
  CMP             Y2,         00C8H
  JB           @NCY2
  MOV             Y2,         00C7H
@NCY2 :
  MOV             BX,            X2
  CMP             X1,            BX
  JLE          @NECX
  MOV             AX,            X1
  MOV             X1,            BX
  MOV             X2,            AX
@NECX :
  MOV             BX,            Y2
  CMP             Y1,            BX
  JLE          @NECY
  MOV             AX,            Y1
  MOV             Y1,            BX
  MOV             Y2,            AX
@NECY :
  LDS             SI,          Page
  MOV             AX,            Y1
  XCHG            AH,            AL
  ADD             SI,            AX
  SHR             AX,           02H
  ADD             SI,            AX
  ADD             SI,            X1
  LES             DI,           Get
  MOV             AX,            X2
  SUB             AX,            X1
  INC             AX
  STOSW
  MOV             DX,            AX
  MOV             AX,            Y2
  SUB             AX,            Y1
  INC             AX
  STOSW
  MOV             BX,            AX
@Repeat :
  MOV             CX,            DX
  SHR             CX,           01H
  JNC         @NMovB
  MOVSB
@NMovB :
  SHR             CX,           01H
  JNC         @NMovW
  MOVSW
@NMovW :
  REP
  DB             66H
  MOVSW
  ADD             SI,         0140H
  SUB             SI,            DX
  DEC             BX
  JNE        @Repeat
  POP             DS
End;


Procedure PutImage; Assembler;

Asm
  CMP              X,         0140H
  JNB          @Exit
  CMP              Y,         00C8H
  JNB          @Exit
  CLD
  PUSH            DS
  LDS             SI,           Put
  LES             DI,          Page
  MOV             AX,             Y
  XCHG            AH,            AL
  ADD             DI,            AX
  SHR             AX,           02H
  ADD             DI,            AX
  ADD             DI,             X
  DEC             DI
  LODSW
  MOV             BX,            AX
  LODSW
  MOV             DX,            AX
  XOR             AH,            AH
@RepeatY :
  MOV             CX,            BX
@RepeatX :
  LODSB
  INC             DI
  CMP             AX,        Except
  JE           @NPut
  MOV        ES:[DI],            AL
@NPut :
  LOOP      @RepeatX
  ADD             DI,         0140H
  SUB             DI,            BX
  DEC             DX
  JNE       @RepeatY
  POP             DS
@Exit :
End;


Procedure SetAllPalette; Assembler;

Asm
  CLI
  CLD
  PUSH            DS
  LDS             SI,            PS
  MOV             DX,         03C8H
  XOR             AL,            AL
  OUT             DX,            AL
  INC             DX
  MOV             CX,         0300H
  REP          OUTSB
  POP             DS
  STI
End;


Procedure GetAllPalette; Assembler;

Asm
  CLI
  CLD
  LES             DI,            PS
  MOV             DX,         03C7H
  XOR             AL,            AL
  OUT             DX,            AL
  INC             DX
  INC             DX
  MOV             CX,         0300H
  REP           INSB
  STI
End;


Procedure SetPalette; Assembler;

Asm
  CLI
  MOV             DX,         03C8H
  MOV             AL,        Number
  OUT             DX,            AL
  INC             DX
  MOV             AL,             R
  OUT             DX,            AL
  MOV             AL,             G
  OUT             DX,            AL
  MOV             AL,             B
  OUT             DX,            AL
  STI
End;


Procedure GetPalette; Assembler;

Asm
  CLI
  MOV             DX,         03C7H
  MOV             AL,        Number
  OUT             DX,            AL
  INC             DX
  INC             DX
  IN              AL,            DX
  LES             DI,             R
  MOV        ES:[DI],            AL
  IN              AL,            DX
  LES             DI,             G
  MOV        ES:[DI],            AL
  IN              AL,            DX
  LES             DI,             B
  MOV        ES:[DI],            AL
  STI
End;


Begin
  Screen := Ptr ( SegA000, $0000 )
End.
