{$G+}

Unit M13HPIO;

Interface

Uses
  Crt,
  M13HP;

Procedure Read13H ( Page : PageStyle; X, Y : Integer;
                    Var Msg : String; L : Byte );
Procedure Write13H ( Page : PageStyle; X, Y : Integer; Msg : String );
Procedure SetFColor ( Line, Color : Byte );
Function  GetFColor ( Line : Byte ) : Byte;
Procedure SetFColorAll ( Color : Byte );
Procedure SetBColor ( Line, Color : Byte );
Function  GetBColor ( Line : Byte ) : Byte;
Procedure SetBColorAll ( Color : Byte );
Procedure SetCColor ( Color : Byte );
Function  GetCColor ( Color : Byte ) : Byte;

Implementation

Const
  FirstTable : Array [ 0..31 ] of Byte =
          (  0,  0,  1,  2,  3,  4,  5,  6,
             7,  8,  9, 10, 11, 12, 13, 14,
            15, 16, 17, 18, 19,  0,  0,  0,
             0,  0,  0,  0,  0,  0,  0,  0 );
  MiddleTable : Array [ 0..31 ] of Byte =
          (  0,  0,  0,  1,  2,  3,  4,  5,
             0,  0,  6,  7,  8,  9, 10, 11,
             0,  0, 12, 13, 14, 15, 16, 17,
             0,  0, 18, 19, 20, 21,  0,  0 );
  LastTable : Array [ 0..31 ] of Byte =
          (  0,  0,  1,  2,  3,  4,  5,  6,
             7,  8,  9, 10, 11, 12, 13, 14,
            15, 16,  0, 17, 18, 19, 20, 21,
            22, 23, 24, 25, 26, 27,  0,  0 );
  FirstSelectTable1 : Array [ 0..21 ] of Byte =
          (  0,  0,  0,  0,  0,  0,  0,  0,
             0,  1,  3,  3,  3,  1,  2,  4,
             4,  4,  2,  1,  3,  0 );
  FirstSelectTable2 : Array [ 0..21 ] of Byte =
          (  0,  5,  5,  5,  5,  5,  5,  5,
             5,  6,  7,  7,  7,  6,  6,  7,
             7,  7,  6,  6,  7,  5 );
  MiddleSelectTable1 : Array [ 0..19 ] of Byte =
          (  0,  0,  1,  1,  1,  1,  1,  1,
             1,  1,  1,  1,  1,  1,  1,  1,
             0,  1,  1,  1 );
  MiddleSelectTable2 : Array [ 0..19 ] of Byte =
          (  0,  2,  3,  3,  3,  3,  3,  3,
             3,  3,  3,  3,  3,  3,  3,  3,
             2,  3,  3,  3 );
  LastSelectTable : Array [ 0..21 ] of Byte =
          (  0,  0,  2,  0,  2,  1,  2,  1,
             2,  3,  0,  2,  1,  3,  3,  1,
             2,  1,  3,  3,  1,  1 );

{$I M13HPIOE.INC}
{$I M13HPIOK.INC}

Type
  EFontStyle = Array [ 0..255, 1..16 ] of Byte;
  KFontStyle =
    Record
      First  : Array [ 0..7, 0..19, 1..32 ] of Byte;
      Middle : Array [ 0..3, 0..21, 1..32 ] of Byte;
      Last   : Array [ 0..3, 0..27, 1..32 ] of Byte
    End;

Var
  English     : ^EFontStyle;
  Korean      : ^KFontStyle;
  FColorTable : Array [ 1..16 ] of Byte;
  BColorTable : Array [ 1..16 ] of Byte;
  CColor      : Byte;

Procedure Read13H;

  Procedure DrawCursor ( P : Byte );

  Begin
    DrawHLine ( Page, X + ( P * 8 ), X + ( P * 8 ) + 7, Y + 13, CColor )
  End;

  Procedure EraseCursor ( P : Byte );

  Begin
    DrawHLine ( Page, X + ( P * 8 ), X + ( P * 8 ) + 7, Y + 13,
                BColorTable [ 14 ] )
  End;

Var
  Key    : Char;
  Point  : Byte;
  ToExit : Boolean;
  Loop   : Byte;

Begin
  Msg := '';
  Point := 0;
  ToExit := False;
  For Loop := 1 To 16 Do
    DrawHLine ( Page, X, X + ( L * 8 ) + 7, Y + Loop - 1,
                BColorTable [ Loop ] );
  DrawCursor ( Point );
  Repeat
    Repeat Until KeyPressed;
    Key := ReadKey;
    Case Key of
      #027 :
        Begin
          Msg := '';
          For Loop := 1 To 16 Do
            DrawHLine ( Page, X, X + ( L * 8 ) + 7, Y + Loop - 1,
                        BColorTable [ Loop ] );
          ToExit := True
        End;
      #032 .. #127 :
        Begin
          IF ( Length ( Msg ) = L )
            Then Continue;
          Msg := Msg + Key;
          EraseCursor ( Point );
          Write13H ( Page, X + ( Point * 8 ), Y, Msg [ Length ( Msg ) ] );
          INC ( Point );
          DrawCursor ( Point )
        End;
      #008 :
        Begin
          IF ( Length ( Msg ) = 0 )
            Then Continue;
          Msg := Copy ( Msg, 1, Length ( Msg ) - 1 );
          EraseCursor ( Point );
          DEC ( Point );
          Write13H ( Page, X + ( Point * 8 ), Y, ' ' );
          DrawCursor ( Point )
        End;
      #013 :
        Begin
          EraseCursor ( Point );
          ToExit := True
        End;
      #0 :
        Key := ReadKey
    End;
  Until ToExit
End;


Procedure WriteEnglish ( Page : PageStyle; X, Y : Integer; Data : Byte );

Var
  Point : Byte;
  LoopY : Byte;
  LoopZ : Byte;

Begin
  For LoopY := 1 To 16 Do
    Begin
      Point := English^ [ Data, LoopY ];
      For LoopZ := 0 To 7 Do
        IF ( Point and ( 1 shl ( 7 - LoopZ ) ) <> 0 )
          Then PutPixel ( Page, X + LoopZ, Y + LoopY - 1,
                          FColorTable [ LoopY ] )
          Else PutPixel ( Page, X + LoopZ, Y + LoopY - 1,
                          BColorTable [ LoopY ] )
    End
End;


Procedure WriteKorean ( Page : PageStyle; X, Y : Integer;
                        Data1, Data2 : Byte );

Var
  KoreanFont : Array [ 1..2, 1..16 ] of Byte;

  Procedure MixKoreanFont ( Code1, Code2, Code3 : Byte );

  Var
    FirstSelect  : Byte;
    MiddleSelect : Byte;
    LastSelect   : Byte;
    Count        : Byte;
    LoopX        : Byte;
    LoopY        : Byte;

  Begin
    Code1 := FirstTable  [ Code1 ];
    Code2 := MiddleTable [ Code2 ];
    Code3 := LastTable   [ Code3 ];
    IF ( Code3 = 0 )
      Then
        Begin
          FirstSelect := FirstSelectTable1 [ Code2 ];
          MiddleSelect := MiddleSelectTable1 [ Code1 ]
        End
      Else
        Begin
          FirstSelect := FirstSelectTable2 [ Code2 ];
          MiddleSelect := MiddleSelectTable2 [ Code1 ]
        End;
    LastSelect := LastSelectTable [ Code2 ];
    Count := 0;
    For LoopY := 1 To 16 Do
      For LoopX := 1 To 2 Do
        Begin
          Inc ( Count );
          KoreanFont [ LoopX, LoopY ] :=
            Korean^.First  [ FirstSelect , Code1, Count ] or
            Korean^.Middle [ MiddleSelect, Code2, Count ] or
            Korean^.Last   [ LastSelect  , Code3, Count ]
        End
  End;

Var
  Code1  : Byte;
  Code2  : Byte;
  Code3  : Byte;
  LoopY  : Byte;
  LoopZ  : Byte;
  Point1 : Byte;
  Point2 : Byte;

Begin
  Code1 := Data1 and 124 shr 2;
  Code2 := ( ( Data1 and 3 ) shl 3 ) or ( Data2 shr 5 );
  Code3 := Data2 and 31;
  MixKoreanFont ( Code1, Code2, Code3 );
  For LoopY := 1 To 16 Do
    Begin
      Point1 := KoreanFont [ 1, LoopY ];
      Point2 := KoreanFont [ 2, LoopY ];
      For LoopZ := 0 To 7 Do
        IF ( Point1 and ( 1 shl ( 7 - LoopZ ) ) <> 0 )
          Then PutPixel ( Page, X + LoopZ, Y + LoopY - 1,
                          FColorTable [ LoopY ] )
          Else PutPixel ( Page, X + LoopZ, Y + LoopY - 1,
                          BColorTable [ LoopY ] );
      For LoopZ := 0 To 7 Do
        IF ( Point2 and ( 1 shl ( 7 - LoopZ ) ) <> 0 )
          Then PutPixel ( Page, X + LoopZ + 8, Y + LoopY - 1,
                          FColorTable [ LoopY ] )
          Else PutPixel ( Page, X + LoopZ + 8, Y + LoopY - 1,
                          BColorTable [ LoopY ] )
    End
End;


Procedure Write13H;

Var
  Count : Byte;
  Data1 : Byte;
  Data2 : Byte;

Begin
  Count := 1;
  While ( Length ( Msg ) >= Count ) Do
    Begin
      Data1 := Ord ( Msg [ Count ] );
      Inc ( Count );
      IF ( Data1 < 128 )
        Then
          Begin
            WriteEnglish ( Page, X, Y, Data1 );
            X := X + 8
          End
        Else
          IF ( Length ( Msg ) >= Count )
            Then
              Begin
                Data2 := Ord ( Msg [ Count ] );
                Inc ( Count );
                WriteKorean ( Page, X, Y, Data1, Data2 );
                X := X + 16
              End
            Else
              Begin
                WriteEnglish ( Page, X, Y, Data1 );
                X := X + 8
              End
    End
End;


Procedure SetFColor;

Begin
  FColorTable [ Line ] := Color
End;


Function  GetFColor;

Begin
  GetFColor := FColorTable [ Line ]
End;


Procedure SetFColorAll;

Var
  Loop : Byte;

Begin
  For Loop := 1 To 16 Do
    FColorTable [ Loop ] := Color
End;


Procedure SetBColor;

Begin
  BColorTable [ Line ] := Color
End;


Function  GetBColor;

Begin
  GetBColor := BColorTable [ Line ]
End;


Procedure SetBColorAll;

Var
  Loop : Byte;

Begin
  For Loop := 1 To 16 Do
    BColorTable [ Loop ] := Color
End;


Procedure SetCColor;

Begin
  CColor := Color
End;


Function  GetCColor;

Begin
  GetCColor := CColor
End;


Var
  Loop : Byte;

Begin
  For Loop := 1 To 16 Do
    Begin
      FColorTable [ Loop ] := 15;
      BColorTable [ Loop ] := 0
    End;
  CColor := 15;
  English := @EnglishFont;
  Korean := @KoreanFont
End.
